/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.Log;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class Cursor {
    protected BufferedImage _image;
    protected int _hx;
    protected int _hy;
    protected org.lwjgl.input.Cursor _lwjglCursor;
    protected java.awt.Cursor _awtCursor;

    public Cursor(BufferedImage image, int hx, int hy) {
        this._image = image;
        this._hx = hx;
        this._hy = hy;
    }

    public org.lwjgl.input.Cursor getLWJGLCursor() {
        if (this._lwjglCursor == null) {
            this._lwjglCursor = this.createLWJGLCursor();
        }
        return this._lwjglCursor;
    }

    public java.awt.Cursor getAWTCursor(Toolkit toolkit) {
        if (this._awtCursor == null) {
            this._awtCursor = this.createAWTCursor(toolkit);
        }
        return this._awtCursor;
    }

    public void show() {
        if (!Display.isCreated()) {
            return;
        }
        if (!Mouse.isCreated()) {
            try {
                Mouse.create();
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Problem creating mouse.", new Object[]{t});
                return;
            }
        }
        org.lwjgl.input.Cursor cursor = this.getLWJGLCursor();
        if (Mouse.getNativeCursor() != cursor) {
            try {
                Mouse.setNativeCursor((org.lwjgl.input.Cursor)cursor);
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Problem updating mouse cursor.", new Object[]{t});
            }
        }
    }

    protected org.lwjgl.input.Cursor createLWJGLCursor() {
        int ww = this._image.getWidth();
        int hh = this._image.getHeight();
        IntBuffer data = ByteBuffer.allocateDirect(ww * hh * 4).asIntBuffer();
        int yy = hh - 1;
        while (yy >= 0) {
            int xx = 0;
            while (xx < ww) {
                data.put(this._image.getRGB(xx, yy));
                ++xx;
            }
            --yy;
        }
        data.flip();
        try {
            return new org.lwjgl.input.Cursor(ww, hh, this._hx, hh - this._hy - 1, 1, data, null);
        }
        catch (LWJGLException e) {
            System.err.println("Unable to create cursor: " + (Object)((Object)e));
            return null;
        }
    }

    protected java.awt.Cursor createAWTCursor(Toolkit toolkit) {
        int width = this._image.getWidth();
        int height = this._image.getHeight();
        Dimension size = toolkit.getBestCursorSize(width, height);
        Image image = this._image;
        int hx = this._hx;
        int hy = this._hy;
        if (size.width != width || size.height != height) {
            image = this._image.getScaledInstance(size.width, size.height, 4);
            hx = this._hx * size.width / width;
            hy = this._hy * size.height / height;
        }
        return toolkit.createCustomCursor(image, new Point(hx, hy), "cursor");
    }
}

