/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Color4fExpression;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.IntegerExpression;
import com.threerings.expr.MutableFloat;
import com.threerings.expr.MutableInteger;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.StringExpression;
import com.threerings.expr.Transform3DExpression;
import com.threerings.expr.Updater;
import com.threerings.util.DeepObject;
import java.util.ArrayList;

@EditorTypes(value={FloatDefinition.class, IntegerDefinition.class, Color4fDefinition.class, StringDefinition.class, Transform3DDefinition.class})
public abstract class ExpressionDefinition
extends DeepObject
implements Exportable {
    @Editable
    public String name = "";

    public abstract Object getValue(Scope var1, ArrayList<Updater> var2);

    public void invalidate() {
    }

    protected <T> Object getValue(Scope scope, ArrayList<Updater> updaters, ObjectExpression<T> expression) {
        final ObjectExpression.Evaluator<T> evaluator = expression.createEvaluator(scope);
        updaters.add(new Updater(){

            @Override
            public void update() {
                evaluator.evaluate();
            }
        });
        return evaluator.evaluate();
    }

    public static class Color4fDefinition
    extends ExpressionDefinition {
        @Editable
        public Color4fExpression expression = new Color4fExpression.Constant();

        @Override
        public Object getValue(Scope scope, ArrayList<Updater> updaters) {
            return this.getValue(scope, updaters, this.expression);
        }

        @Override
        public void invalidate() {
            this.expression.invalidate();
        }
    }

    public static class FloatDefinition
    extends ExpressionDefinition {
        @Editable
        public FloatExpression expression = new FloatExpression.Constant();

        @Override
        public Object getValue(Scope scope, ArrayList<Updater> updaters) {
            final MutableFloat mutable = new MutableFloat();
            final FloatExpression.Evaluator evaluator = this.expression.createEvaluator(scope);
            updaters.add(new Updater(){

                @Override
                public void update() {
                    mutable.value = evaluator.evaluate();
                }
            });
            return mutable;
        }

        @Override
        public void invalidate() {
            this.expression.invalidate();
        }
    }

    public static class IntegerDefinition
    extends ExpressionDefinition {
        @Editable
        public IntegerExpression expression = new IntegerExpression.Constant();

        @Override
        public Object getValue(Scope scope, ArrayList<Updater> updaters) {
            final MutableInteger mutable = new MutableInteger();
            final IntegerExpression.Evaluator evaluator = this.expression.createEvaluator(scope);
            updaters.add(new Updater(){

                @Override
                public void update() {
                    mutable.value = evaluator.evaluate();
                }
            });
            return mutable;
        }

        @Override
        public void invalidate() {
            this.expression.invalidate();
        }
    }

    public static class StringDefinition
    extends ExpressionDefinition {
        @Editable
        public StringExpression expression = new StringExpression.Constant();

        @Override
        public Object getValue(Scope scope, ArrayList<Updater> updaters) {
            final StringBuilder mutable = new StringBuilder();
            final ObjectExpression.Evaluator evaluator = this.expression.createEvaluator(scope);
            updaters.add(new Updater(){

                @Override
                public void update() {
                    mutable.replace(0, mutable.length(), (String)evaluator.evaluate());
                }
            });
            return mutable;
        }

        @Override
        public void invalidate() {
            this.expression.invalidate();
        }
    }

    public static class Transform3DDefinition
    extends ExpressionDefinition {
        @Editable
        public Transform3DExpression expression = new Transform3DExpression.Constant();

        @Override
        public Object getValue(Scope scope, ArrayList<Updater> updaters) {
            return this.getValue(scope, updaters, this.expression);
        }

        @Override
        public void invalidate() {
            this.expression.invalidate();
        }
    }
}

