/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.samskivert.util.ObserverList;
import com.samskivert.util.WeakObserverList;
import com.threerings.expr.Scope;
import com.threerings.expr.ScopeEvent;
import com.threerings.expr.ScopeUpdateListener;
import com.threerings.expr.util.ScopeUtil;
import java.util.HashMap;

public class DynamicScope
implements Scope,
ScopeUpdateListener {
    protected Object _owner;
    protected String _scopeName;
    protected Scope _parentScope = INVALID_SCOPE;
    protected int _compoundDepth;
    protected HashMap<String, Object> _symbols;
    protected WeakObserverList<ScopeUpdateListener> _listeners;
    protected static final Scope INVALID_SCOPE = new DynamicScope(null);

    public DynamicScope(String name) {
        this(name, null);
    }

    public DynamicScope(String name, Scope parent) {
        this._owner = this;
        this._scopeName = name;
        this.setParentScope(parent);
    }

    public DynamicScope(Object owner, String name) {
        this(owner, name, null);
    }

    public DynamicScope(Object owner, String name, Scope parent) {
        this._owner = owner;
        this._scopeName = name;
        this.setParentScope(parent);
    }

    public void setParentScope(Scope parent) {
        if (this._parentScope == parent) {
            return;
        }
        if (this._parentScope != null) {
            this._parentScope.removeListener(this);
        }
        if ((this._parentScope = parent) != null) {
            this._parentScope.addListener(this);
        }
        ScopeUtil.updateBound(this._owner, this._parentScope);
        this.wasUpdated();
    }

    public void put(String name, Object value) {
        if (this._symbols == null) {
            this._symbols = new HashMap(1);
        }
        this._symbols.put(name, value);
        this.wasUpdated();
    }

    public void remove(String name) {
        if (this._symbols != null) {
            this._symbols.remove(name);
            this.wasUpdated();
        }
    }

    public void startCompoundUpdate() {
        ++this._compoundDepth;
    }

    public void endCompoundUpdate() {
        if (--this._compoundDepth == 0) {
            this.wasUpdated();
        }
    }

    public void wasUpdated() {
        if (this._compoundDepth == 0 && this._listeners != null) {
            final ScopeEvent event = new ScopeEvent(this);
            this._listeners.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ScopeUpdateListener>(){

                public boolean apply(ScopeUpdateListener listener) {
                    listener.scopeUpdated(event);
                    return true;
                }
            });
        }
    }

    public void dispose() {
        if (this._parentScope != null) {
            this._parentScope.removeListener(this);
        }
        this._listeners = null;
    }

    @Override
    public String getScopeName() {
        return this._scopeName;
    }

    @Override
    public Scope getParentScope() {
        return this._parentScope;
    }

    @Override
    public <T> T get(String name, Class<T> clazz) {
        Object value = this._symbols == null ? null : this._symbols.get(name);
        return clazz.isInstance(value) ? clazz.cast(value) : ScopeUtil.get(this._owner, name, clazz);
    }

    @Override
    public void addListener(ScopeUpdateListener listener) {
        this.checkCreateListeners();
        this._listeners.add((Object)listener);
    }

    public void addListener(int index, ScopeUpdateListener listener) {
        this.checkCreateListeners();
        this._listeners.add(index, (Object)listener);
    }

    @Override
    public void removeListener(ScopeUpdateListener listener) {
        if (this._listeners != null) {
            this._listeners.remove((Object)listener);
            if (this._listeners.isEmpty()) {
                this._listeners = null;
            }
        }
    }

    @Override
    public void scopeUpdated(ScopeEvent event) {
        ScopeUtil.updateBound(this._owner, this._parentScope);
        this.wasUpdated();
    }

    protected void checkCreateListeners() {
        if (this._listeners == null) {
            this._listeners = WeakObserverList.newFastUnsafe();
            this._listeners.setCheckDuplicates(false);
        }
    }
}

