/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.StringUtil;
import com.threerings.editor.DynamicallyEditable;
import com.threerings.editor.Editable;
import com.threerings.editor.Introspector;
import com.threerings.editor.Property;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.editor.util.EditorContext;
import com.threerings.util.MessageBundle;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditorPanel
extends BaseEditorPanel
implements ChangeListener {
    protected CategoryMode _catmode;
    protected boolean _omitColumns;
    protected ArrayList<PropertyEditor> _editors = new ArrayList();
    protected JPanel _dynamic;

    public static JDialog createDialog(Component parent, EditorContext ctx, String title, Object object) {
        return EditorPanel.createDialog(parent, ctx, CategoryMode.TABS, title, object);
    }

    public static JDialog createDialog(Component parent, EditorContext ctx, CategoryMode catmode, String title, Object object) {
        Component root = SwingUtilities.getRoot(parent);
        MessageBundle msgs = ctx.getMessageManager().getBundle("editor.default");
        final JDialog dialog = root instanceof Dialog ? new JDialog((Dialog)root, title) : new JDialog((Frame)(root instanceof Frame ? root : null), title);
        EditorPanel epanel = new EditorPanel(ctx, catmode);
        dialog.add((Component)((Object)epanel), "Center");
        epanel.setObject(object);
        JPanel bpanel = new JPanel();
        dialog.add((Component)bpanel, "South");
        JButton ok = new JButton(msgs.get("m.ok"));
        bpanel.add(ok);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.setVisible(false);
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public EditorPanel(EditorContext ctx) {
        this(ctx, CategoryMode.PANELS);
    }

    public EditorPanel(EditorContext ctx, CategoryMode catmode) {
        this(ctx, catmode, null);
    }

    public EditorPanel(EditorContext ctx, CategoryMode catmode, Property[] ancestors) {
        this(ctx, catmode, ancestors, false);
    }

    public EditorPanel(EditorContext ctx, CategoryMode catmode, Property[] ancestors, boolean omitColumns) {
        super(ctx, ancestors, omitColumns);
        this._catmode = catmode;
    }

    @Override
    public void setObject(Object object) {
        int n;
        String[] stringArray;
        String cat;
        String[] stringArray2;
        JPanel inner;
        if (object == this._object) {
            return;
        }
        Class<?> oclazz = this._object == null ? null : this._object.getClass();
        Class<?> nclazz = object == null ? null : object.getClass();
        super.setObject(object);
        if (oclazz == nclazz) {
            for (PropertyEditor editor : this._editors) {
                editor.setObject(this._object);
            }
            this.updateDynamicProperties();
            return;
        }
        this.removeAll();
        this._editors.clear();
        if (this._object == null) {
            this.revalidate();
            this.repaint();
            return;
        }
        Class<?> clazz = this._object.getClass();
        Property[] props = Introspector.getProperties(clazz);
        final String[] cats = this.getFilteredCategories(clazz, props);
        MessageBundle cmsgs = this._msgmgr.getBundle(Introspector.getMessageBundle(clazz));
        if (cats.length <= 1) {
            inner = this.addScrollPanel();
            this.addEditors(props, null, inner);
        } else if (this._catmode == CategoryMode.PANELS) {
            inner = this.addScrollPanel();
            stringArray2 = cats;
            int n2 = cats.length;
            int n3 = 0;
            while (n3 < n2) {
                cat = stringArray2[n3];
                JPanel content = new JPanel();
                content = new JPanel();
                inner.add(content);
                if (cat.length() > 0) {
                    content.setBorder(BorderFactory.createTitledBorder(this.getLabel(cat, cmsgs)));
                    content.setBackground(this.getDarkerBackground((float)(this._ancestors == null ? 0 : this._ancestors.length) + 0.5f));
                } else {
                    content.setBackground(null);
                }
                content.setLayout((LayoutManager)new VGroupLayout(GroupLayout.NONE, GroupLayout.STRETCH, 5, GroupLayout.TOP));
                this.addEditors(props, cat, content);
                ++n3;
            }
        } else if (this._catmode == CategoryMode.TABS) {
            JTabbedPane tabs = new JTabbedPane();
            this.add(tabs);
            stringArray2 = cats;
            int n4 = cats.length;
            int n5 = 0;
            while (n5 < n4) {
                cat = stringArray2[n5];
                JPanel inner2 = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.TOP, (GroupLayout.Policy)GroupLayout.STRETCH);
                inner2.setBackground(null);
                tabs.addTab(this.getLabel(cat, cmsgs), this.isEmbedded() ? inner2 : EditorPanel.createScrollPane(inner2));
                this.addEditors(props, cat, inner2);
                ++n5;
            }
        } else {
            JPanel cpanel = new JPanel();
            this.add(cpanel, GroupLayout.FIXED);
            cpanel.add(new JLabel(this._msgs.get("m.category")));
            final JComboBox<String> cbox = new JComboBox<String>(this.getLabels(cats, cmsgs));
            cpanel.add(cbox);
            final CardLayout cards = new CardLayout();
            final JPanel inner3 = new JPanel(cards);
            this.add(inner3);
            stringArray = cats;
            n = cats.length;
            int n6 = 0;
            while (n6 < n) {
                String cat2 = stringArray[n6];
                JPanel panel = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.TOP, (GroupLayout.Policy)GroupLayout.STRETCH);
                panel.setBackground(null);
                inner3.add((Component)(this.isEmbedded() ? panel : EditorPanel.createScrollPane(panel)), cat2);
                this.addEditors(props, cat2, panel);
                ++n6;
            }
            cbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    cards.show(inner3, cats[cbox.getSelectedIndex()]);
                }
            });
        }
        for (final PropertyEditor editor : this._editors) {
            String[] depends = editor.getProperty().getAnnotation().depends();
            if (depends.length <= 0) continue;
            ChangeListener cl = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    editor.update();
                }
            };
            stringArray = depends;
            n = depends.length;
            int n7 = 0;
            while (n7 < n) {
                String depend = stringArray[n7];
                PropertyEditor deditor = this.getEditor(depend);
                if (deditor != null) {
                    deditor.addChangeListener(cl);
                }
                ++n7;
            }
        }
        for (final PropertyEditor editor : this._editors) {
            editor.addChangeListener(this);
        }
        this.updateDynamicProperties();
        this.revalidate();
    }

    @Override
    public Object getObject() {
        return this._object;
    }

    public PropertyEditor getPropertyEditor(String name) {
        for (PropertyEditor editor : this._editors) {
            if (!name.equals(editor.getProperty().getName())) continue;
            return editor;
        }
        return null;
    }

    @Override
    public void update() {
        for (PropertyEditor editor : this._editors) {
            editor.update();
        }
        this.updateDynamicProperties();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireStateChanged();
    }

    @Override
    public String getMousePath(Point pt) {
        Object cont = this;
        while (cont != null) {
            Component comp = ((Container)cont).getComponentAt(pt);
            if (comp == cont || !(comp instanceof Container)) {
                return "";
            }
            if (comp instanceof PropertyEditor) {
                PropertyEditor editor = (PropertyEditor)((Object)comp);
                Point npt = new Point(pt);
                return "." + editor.getProperty().getName() + editor.getMousePath(SwingUtilities.convertPoint((Component)((Object)this), npt, (Component)((Object)editor)));
            }
            cont = (Container)comp;
        }
        return "";
    }

    protected String[] getFilteredCategories(Class<?> clazz, Property[] props) {
        Object[] cats = Introspector.getCategories(clazz);
        if (!this._omitColumns) {
            return cats;
        }
        int ii = cats.length - 1;
        while (ii >= 0) {
            if (!this.isCategoryPresent(props, cats[ii])) {
                cats = (String[])ArrayUtil.splice((Object[])cats, (int)ii, (int)1);
            }
            --ii;
        }
        return cats;
    }

    protected boolean isCategoryPresent(Property[] props, String cat) {
        if (this._object instanceof DynamicallyEditable && cat.equals("")) {
            return true;
        }
        Property[] propertyArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            Editable annotation = prop.getAnnotation();
            if (!annotation.column() && annotation.category().equals(cat)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected JPanel addScrollPanel() {
        JPanel inner = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.TOP, (GroupLayout.Policy)GroupLayout.STRETCH);
        inner.setBackground(null);
        this.add(this.isEmbedded() ? inner : EditorPanel.createScrollPane(inner));
        return inner;
    }

    protected void addEditors(Property[] props, String category, JPanel panel) {
        Container hpanel = null;
        String hgroup = null;
        Property[] propertyArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            Editable annotation = prop.getAnnotation();
            if (!(category != null && !annotation.category().equals(category) || this._omitColumns && annotation.column())) {
                String ahgroup = annotation.hgroup();
                PropertyEditor editor = this.createEditor(prop);
                if (!StringUtil.isBlank((String)annotation.tooltip())) {
                    JToolTip tip = editor.createToolTip();
                    tip.setTipText(annotation.tooltip());
                }
                if (ahgroup.length() > 0) {
                    if (hpanel == null || !ahgroup.equals(hgroup)) {
                        hpanel = GroupLayout.makeHBox((GroupLayout.Policy)GroupLayout.STRETCH, (GroupLayout.Justification)GroupLayout.CENTER, (GroupLayout.Policy)GroupLayout.NONE);
                        panel.add(hpanel);
                        ((JComponent)hpanel).setBackground(null);
                        hgroup = ahgroup;
                    }
                    hpanel.add((Component)((Object)editor));
                } else {
                    panel.add((Component)((Object)editor));
                    hpanel = null;
                }
            }
            ++n2;
        }
        if (this._object instanceof DynamicallyEditable && (category == null || category.equals(""))) {
            this._dynamic = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.TOP, (GroupLayout.Policy)GroupLayout.STRETCH);
            panel.add(this._dynamic);
            this._dynamic.setBackground(null);
        }
    }

    protected PropertyEditor createEditor(Property prop) {
        PropertyEditor editor = PropertyEditor.createEditor(this._ctx, prop, this._ancestors);
        editor.setObject(this._object);
        this._editors.add(editor);
        return editor;
    }

    protected PropertyEditor getEditor(String name) {
        for (PropertyEditor editor : this._editors) {
            if (!editor.getProperty().getName().equals(name)) continue;
            return editor;
        }
        return null;
    }

    protected void updateDynamicProperties() {
        if (!(this._object instanceof DynamicallyEditable)) {
            return;
        }
        int ocount = this._dynamic.getComponentCount();
        Property[] properties = ((DynamicallyEditable)this._object).getDynamicProperties();
        int idx = 0;
        while (idx < properties.length) {
            Property property = properties[idx];
            PropertyEditor editor = null;
            if (idx < ocount) {
                PropertyEditor oeditor = (PropertyEditor)((Object)this._dynamic.getComponent(idx));
                if (oeditor.getProperty().equals(property)) {
                    editor = oeditor;
                } else {
                    this._dynamic.remove(idx);
                }
            }
            if (editor == null) {
                editor = PropertyEditor.createEditor(this._ctx, property, this._ancestors);
                editor.addChangeListener(this);
                this._dynamic.add((Component)((Object)editor), idx);
            }
            editor.setObject(this._object);
            ++idx;
        }
        while (ocount > idx) {
            this._dynamic.remove(--ocount);
        }
    }

    protected static JScrollPane createScrollPane(Component view) {
        JScrollPane pane = new JScrollPane(view, 20, 31);
        pane.getVerticalScrollBar().setUnitIncrement(32);
        return pane;
    }

    public static enum CategoryMode {
        PANELS,
        TABS,
        CHOOSER;

    }
}

