/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.samskivert.util.ObserverList;
import com.samskivert.util.QuickSort;
import com.samskivert.util.StringUtil;
import com.threerings.ClydeLog;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroupListener;
import com.threerings.config.ConfigManager;
import com.threerings.config.ManagedConfig;
import com.threerings.export.BinaryImporter;
import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import com.threerings.export.XMLExporter;
import com.threerings.export.XMLImporter;
import com.threerings.export.util.LazyFileOutputStream;
import com.threerings.util.Copyable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;

public class ConfigGroup<T extends ManagedConfig>
implements Copyable,
Exportable {
    protected ConfigManager _cfgmgr;
    protected String _name;
    protected Class<T> _cclass;
    protected HashMap<String, T> _configsByName = new HashMap();
    protected ObserverList<ConfigGroupListener<T>> _listeners;

    public static String getName(Class<?> clazz) {
        String cstr = clazz.getName();
        cstr = (cstr = cstr.substring(Math.max(cstr.lastIndexOf(46), cstr.lastIndexOf(36)) + 1)).endsWith("Config") ? cstr.substring(0, cstr.length() - 6) : cstr;
        return StringUtil.toUSLowerCase((String)StringUtil.unStudlyName((String)cstr));
    }

    public ConfigGroup(Class<T> clazz) {
        this.initConfigClass(clazz);
    }

    public ConfigGroup() {
    }

    public void init(ConfigManager cfgmgr) {
        this._cfgmgr = cfgmgr;
        if (this._configsByName.size() == 0 && this._cfgmgr.getConfigPath() != null && (this.readConfigs(true) || this.readConfigs(false))) {
            ClydeLog.log.debug((Object)("Read configurations for group " + this._name + "."), new Object[0]);
        }
        for (ManagedConfig config : this._configsByName.values()) {
            config.init(this._cfgmgr);
        }
    }

    public String getName() {
        return this._name;
    }

    public Class<T> getConfigClass() {
        return this._cclass;
    }

    public T getConfig(String name) {
        return (T)((ManagedConfig)this._configsByName.get(name));
    }

    public Collection<T> getConfigs() {
        return this._configsByName.values();
    }

    public void addListener(ConfigGroupListener<T> listener) {
        if (this._listeners == null) {
            this._listeners = ObserverList.newFastUnsafe();
        }
        this._listeners.add(listener);
    }

    public void removeListener(ConfigGroupListener<T> listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
            if (this._listeners.isEmpty()) {
                this._listeners = null;
            }
        }
    }

    public void addConfigs(Collection<T> configs) {
        for (ManagedConfig config : configs) {
            this.addConfig(config);
        }
    }

    public void addConfig(T config) {
        this._configsByName.put(((ManagedConfig)config).getName(), config);
        ((ManagedConfig)config).init(this._cfgmgr);
        this.fireConfigAdded(config);
    }

    public void removeConfig(T config) {
        this._configsByName.remove(((ManagedConfig)config).getName());
        this.fireConfigRemoved(config);
    }

    public void save() {
        this.save(this.getConfigFile(true));
    }

    public void save(File file) {
        this.save(this._configsByName.values(), file);
    }

    public void save(Collection<T> configs, File file) {
        try {
            XMLExporter out = new XMLExporter(new LazyFileOutputStream(file));
            ((Exporter)out).writeObject(this.toSortedArray(configs));
            ((Exporter)out).close();
        }
        catch (IOException e) {
            ClydeLog.log.warning((Object)("Error writing configurations [file=" + file + "]."), new Object[]{e});
        }
    }

    public void revert() {
        this.load(this.getConfigFile(true));
    }

    public void load(File file) {
        this.load(file, false);
    }

    public void load(File file, boolean merge) {
        Object array;
        try {
            XMLImporter in = new XMLImporter(new FileInputStream(file));
            array = ((Importer)in).readObject();
            ((Importer)in).close();
        }
        catch (IOException e) {
            ClydeLog.log.warning((Object)("Error reading configurations [file=" + file + "]."), new Object[]{e});
            return;
        }
        ManagedConfig[] nconfigs = (ManagedConfig[])array;
        this.validateOuters(nconfigs);
        this.load(Arrays.asList(nconfigs), merge, false);
    }

    public void writeFields(Exporter out) throws IOException {
        out.write("configs", this.toSortedArray(this._configsByName.values()), null, Object.class);
    }

    public void readFields(Importer in) throws IOException {
        ManagedConfig[] object = in.read("configs", null, Object.class);
        ManagedConfig[] configs = object == null ? new ManagedConfig[]{} : object;
        Class<?> clazz = configs.getClass().getComponentType();
        this.initConfigClass(clazz);
        this.initConfigs(configs);
    }

    @Override
    public Object copy(Object dest) {
        return this.copy(dest, null);
    }

    @Override
    public Object copy(Object dest, Object outer) {
        ConfigGroup<T> other = dest instanceof ConfigGroup ? (ConfigGroup<T>)dest : new ConfigGroup<T>(this._cclass);
        other.load(this._configsByName.values(), false, true);
        return other;
    }

    public ConfigGroup merge(ConfigGroup dest) {
        dest.load(this._configsByName.values(), true, true);
        return dest;
    }

    protected void initConfigClass(Class<T> clazz) {
        this._cclass = clazz;
        this._name = ConfigGroup.getName(clazz);
    }

    protected boolean readConfigs(boolean xml) {
        InputStream stream = this.getConfigStream(xml);
        if (stream == null) {
            return false;
        }
        try {
            Importer in = xml ? new XMLImporter(stream) : new BinaryImporter(stream);
            ManagedConfig[] configs = (ManagedConfig[])in.readObject();
            if (xml) {
                this.validateOuters(configs);
            }
            this.initConfigs(configs);
            in.close();
            return true;
        }
        catch (Exception e) {
            ClydeLog.log.warning((Object)"Error reading configurations.", new Object[]{"group", this._name, e});
            return false;
        }
    }

    protected InputStream getConfigStream(boolean xml) {
        try {
            return this._cfgmgr.getResourceManager().getResource(this.getConfigPath(xml));
        }
        catch (IOException e) {
            return null;
        }
    }

    public File getConfigFile(boolean xml) {
        return this._cfgmgr.getResourceManager().getResourceFile(this.getConfigPath(xml));
    }

    protected String getConfigPath(boolean xml) {
        return String.valueOf(this._cfgmgr.getConfigPath()) + this._name + (xml ? ".xml" : ".dat");
    }

    protected void validateOuters(T[] configs) {
        T[] TArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            T config = TArray[n2];
            ((ManagedConfig)config).validateOuters(String.valueOf(this._name) + ":" + ((ManagedConfig)config).getName());
            ++n2;
        }
    }

    protected void initConfigs(T[] configs) {
        T[] TArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            T config = TArray[n2];
            this._configsByName.put(((ManagedConfig)config).getName(), config);
            ++n2;
        }
    }

    protected void load(Collection<T> nconfigs, boolean merge, boolean clone) {
        HashSet<String> names = new HashSet<String>();
        for (ManagedConfig nconfig : nconfigs) {
            String name = nconfig.getName();
            names.add(name);
            ManagedConfig oconfig = (ManagedConfig)this._configsByName.get(name);
            if (oconfig == null) {
                this.addConfig(clone ? (ManagedConfig)this._cclass.cast(nconfig.clone()) : nconfig);
                continue;
            }
            if (nconfig.equals(oconfig)) continue;
            nconfig.copy(oconfig);
            oconfig.wasUpdated();
        }
        if (merge) {
            return;
        }
        ManagedConfig[] oconfigs = (ManagedConfig[])Array.newInstance(this._cclass, this._configsByName.size());
        this._configsByName.values().toArray(oconfigs);
        ManagedConfig[] managedConfigArray = oconfigs;
        int n = oconfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ManagedConfig oconfig = managedConfigArray[n2];
            if (!names.contains(oconfig.getName())) {
                this.removeConfig(oconfig);
            }
            ++n2;
        }
    }

    protected T[] toSortedArray(Collection<T> configs) {
        Object[] array = (ManagedConfig[])Array.newInstance(this._cclass, configs.size());
        configs.toArray(array);
        QuickSort.sort((Object[])array, (Comparator)new Comparator<T>(){

            @Override
            public int compare(T c1, T c2) {
                return ((ManagedConfig)c1).getName().compareTo(((ManagedConfig)c2).getName());
            }
        });
        return array;
    }

    protected void fireConfigAdded(T config) {
        if (this._listeners == null) {
            return;
        }
        final ConfigEvent<T> event = new ConfigEvent<T>(this, config);
        this._listeners.apply(new ObserverList.ObserverOp<ConfigGroupListener<T>>(){

            public boolean apply(ConfigGroupListener<T> listener) {
                listener.configAdded(event);
                return true;
            }
        });
    }

    protected void fireConfigRemoved(T config) {
        if (this._listeners == null) {
            return;
        }
        final ConfigEvent<T> event = new ConfigEvent<T>(this, config);
        this._listeners.apply(new ObserverList.ObserverOp<ConfigGroupListener<T>>(){

            public boolean apply(ConfigGroupListener<T> listener) {
                listener.configRemoved(event);
                return true;
            }
        });
    }

    public ConfigManager getConfigManager() {
        return this._cfgmgr;
    }
}

