/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.threerings.opengl.gui.BoundedRangeModel;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.Label;
import com.threerings.opengl.gui.LabelRenderer;
import com.threerings.opengl.gui.MenuItem;
import com.threerings.opengl.gui.PopupMenu;
import com.threerings.opengl.gui.ScrollPane;
import com.threerings.opengl.gui.Selectable;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.Event;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.util.GlContext;
import java.util.List;
import javax.annotation.Nullable;

public class ComboBox<T>
extends Label
implements Selectable<T> {
    protected int _selidx = -1;
    protected List<ComboMenuItem<T>> _items = Lists.newArrayList();
    protected ComboPopupMenu _menu;
    protected Dimension _psize;
    protected int _rows;
    protected int _columns;

    public ComboBox(GlContext ctx) {
        this(ctx, (Iterable<T>)ImmutableList.of());
    }

    public ComboBox(GlContext ctx, Iterable<? extends T> items) {
        this(ctx, items, DefaultFormatter.INSTANCE);
    }

    public ComboBox(GlContext ctx, Iterable<? extends T> items, Formatter<? super T> formatter) {
        super(ctx, "");
        this.setFit(Label.Fit.TRUNCATE);
        this.setItems(items, formatter);
    }

    public void clearItems() {
        this.clearCache();
        this._items.clear();
        this.setSelectedIndex(-1);
    }

    public void setItems(Iterable<? extends T> items) {
        this.setItems(items, DefaultFormatter.INSTANCE);
    }

    public void setItems(Iterable<? extends T> items, Formatter<? super T> formatter) {
        this.clearItems();
        for (T item : items) {
            this.addItem(item, formatter);
        }
    }

    public void addItem(T item) {
        this.addItem(item, DefaultFormatter.INSTANCE);
    }

    public void addItem(T item, Formatter<? super T> formatter) {
        this.addItem(item, formatter.getText(item), formatter.getIcon(item));
    }

    public void addItem(T item, String text) {
        this.addItem(item, text, null);
    }

    public void addItem(T item, String text, @Nullable Icon icon) {
        this.addItem(this._items.size(), item, text, icon);
    }

    public void addItem(int index, T item) {
        this.addItem(index, item, DefaultFormatter.INSTANCE);
    }

    public void addItem(int index, T item, Formatter<? super T> formatter) {
        this.addItem(index, item, formatter.getText(item), formatter.getIcon(item));
    }

    public void addItem(int index, T item, String text) {
        this.addItem(index, item, text, null);
    }

    public void addItem(int index, T item, String text, @Nullable Icon icon) {
        Preconditions.checkNotNull((Object)text);
        ComboMenuItem<T> menuItem = new ComboMenuItem<T>(this._ctx, item, text, icon);
        this._items.add(index, menuItem);
        if (index <= this._selidx) {
            ++this._selidx;
        } else if (this._items.size() == 1) {
            this.setSelectedIndex(0);
        }
        this.clearCache();
    }

    @Override
    public T getSelected() {
        return this.getItem(this._selidx);
    }

    @Override
    public void setSelected(T item) {
        this.setSelectedIndex(this.getItems().indexOf(item));
    }

    @Override
    public int getSelectedIndex() {
        return this._selidx;
    }

    @Override
    public void setSelectedIndex(int index) {
        this.selectItem(index, System.currentTimeMillis(), 0);
    }

    public int getItemCount() {
        return this._items.size();
    }

    public T getItem(int index) {
        return this.invalidIndex(index) ? null : (T)this._items.get((int)index).item;
    }

    public void setPreferredDimensions(int rows, int columns) {
        this._rows = rows;
        this._columns = columns;
        if (this._menu != null) {
            this._menu.setPreferredDimensions(rows, columns);
        }
    }

    @Override
    public boolean dispatchEvent(Event event) {
        if (event instanceof MouseEvent && this.isEnabled()) {
            MouseEvent mev = (MouseEvent)event;
            switch (mev.getType()) {
                case 0: {
                    if (this._menu == null) {
                        this._menu = new ComboPopupMenu(this._ctx, this._rows, this._columns);
                    }
                    this._menu.popup(this.getAbsoluteX(), this.getAbsoluteY(), false);
                    return true;
                }
                case 1: {
                    return true;
                }
            }
        }
        return super.dispatchEvent(event);
    }

    @Override
    protected String getDefaultStyleConfig() {
        return "Default/ComboBox";
    }

    @Override
    protected Dimension computePreferredSize(int whint, int hhint) {
        if (this._psize == null) {
            this._psize = new Dimension();
            LabelRenderer label = new LabelRenderer(this);
            for (ComboMenuItem<T> mitem : this._items) {
                label.setIcon(mitem.getIcon());
                label.setText(mitem.getText());
                Dimension lsize = label.computePreferredSize(-1, -1);
                this._psize.width = Math.max(this._psize.width, lsize.width);
                this._psize.height = Math.max(this._psize.height, lsize.height);
            }
        }
        return new Dimension(this._psize);
    }

    protected void selectItem(int index, long when, int modifiers) {
        Object selItem;
        if (this.invalidIndex(index)) {
            index = -1;
        }
        if (this._selidx == index) {
            return;
        }
        this._selidx = index;
        if (index == -1) {
            this.setIcon(null);
            this.setText("");
            selItem = null;
        } else {
            ComboMenuItem<T> selected = this._items.get(index);
            this.setIcon(selected.getIcon());
            this.setText(selected.getText());
            selItem = selected.item;
        }
        this.emitEvent(new ActionEvent(this, when, modifiers, "select", selItem));
    }

    protected void clearCache() {
        if (this._menu != null) {
            this._menu.removeAll();
            this._menu = null;
        }
        this._psize = null;
    }

    protected boolean invalidIndex(int index) {
        return index < 0 || index >= this._items.size();
    }

    protected List<T> getItems() {
        return Lists.transform(this._items, (Function)new Function<ComboMenuItem<T>, T>(){

            public T apply(ComboMenuItem<T> item) {
                return item.item;
            }
        });
    }

    protected static class ComboMenuItem<T>
    extends MenuItem {
        public T item;

        public ComboMenuItem(GlContext ctx, T item, String text, Icon icon) {
            super(ctx, text, icon, "select");
            this.item = item;
        }
    }

    protected class ComboPopupMenu
    extends PopupMenu {
        public ComboPopupMenu(GlContext ctx, int rows, int columns) {
            super(ctx, ComboBox.this.getWindow(), rows, columns);
            int ii = 0;
            while (ii < ComboBox.this._items.size()) {
                this.addMenuItem(ComboBox.this._items.get(ii));
                ++ii;
            }
        }

        @Override
        protected void itemSelected(MenuItem item, long when, int modifiers) {
            ComboBox.this.selectItem(ComboBox.this._items.indexOf(item), when, modifiers);
            this.dismiss();
        }

        @Override
        protected void packAndFit(int x, int y, boolean above) {
            super.packAndFit(x, y, above);
            if (this._rows == 0) {
                return;
            }
            ScrollPane pane = (ScrollPane)this.getComponent(0);
            Container cont = (Container)pane.getChild();
            int height = 0;
            int ii = 0;
            while (ii < ComboBox.this._selidx) {
                height += cont.getComponent((int)ii).getPreferredSize((int)-1, (int)-1).height;
                ++ii;
            }
            BoundedRangeModel model = pane.getVerticalScrollBar().getModel();
            height = Math.min(height, model.getMaximum() - model.getExtent());
            model.setRange(model.getMinimum(), height, model.getExtent(), model.getMaximum());
        }

        @Override
        protected Dimension computePreferredSize(int whint, int hhint) {
            Dimension d = super.computePreferredSize(whint, hhint);
            d.width = Math.max(d.width, ComboBox.this.getWidth() - this.getInsets().getHorizontal());
            return d;
        }
    }

    public static class DefaultFormatter<T>
    implements Formatter<T> {
        public static final DefaultFormatter<Object> INSTANCE = new DefaultFormatter();

        @Override
        public String getText(T o) {
            return o == null || o instanceof Icon ? "" : String.valueOf(o);
        }

        @Override
        public Icon getIcon(T o) {
            return o instanceof Icon ? (Icon)o : null;
        }
    }

    public static interface Formatter<T> {
        public String getText(@Nullable T var1);

        @Nullable
        public Icon getIcon(@Nullable T var1);
    }
}

