/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.samskivert.swing.VGroupLayout;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigReference;
import com.threerings.config.ManagedConfig;
import com.threerings.config.swing.ConfigTree;
import com.threerings.config.swing.ConfigTreeFilterPanel;
import com.threerings.config.swing.ConfigTreeNode;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.export.Exportable;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.EditorTool;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.util.DeepObject;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public abstract class ConfigTool<T extends ManagedConfig>
extends EditorTool
implements TreeSelectionListener,
ChangeListener {
    protected ConfigTreeFilterPanel _filterPanel;
    protected Class<T> _clazz;
    protected EditableReference<T> _eref;
    protected JScrollPane _pane;
    protected ConfigTree _tree;
    protected EditorPanel _epanel;

    public ConfigTool(SceneEditor editor, Class<T> clazz, EditableReference<T> eref) {
        super(editor);
        this._clazz = clazz;
        this._eref = eref;
        this._filterPanel = new ConfigTreeFilterPanel(editor.getMessageManager());
        this.add((Component)this._filterPanel, VGroupLayout.FIXED);
        this._pane = new JScrollPane();
        this._epanel = new EditorPanel(editor);
        JSplitPane split = new JSplitPane(0, true, this._pane, (Component)((Object)this._epanel));
        split.setResizeWeight(1.0);
        this.add(split);
        this._epanel.setMinimumSize(new Dimension(120, 120));
        this._epanel.setObject(eref);
        this._epanel.addChangeListener(this);
    }

    public void setReference(ConfigReference<T> ref) {
        this._tree.setSelectedNode(ref == null ? null : ref.getName());
        this._eref.setReference(ref);
        this._epanel.update();
        this.referenceChanged(ref);
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        ConfigTreeNode node = this._tree.getSelectedNode();
        String name = node == null || node.getConfig() == null ? null : node.getName();
        ConfigReference ref = name == null ? null : new ConfigReference(name);
        this._eref.setReference(ref);
        this._epanel.update();
        this.referenceChanged(ref);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        ConfigReference<T> ref = this._eref.getReference();
        this._tree.setSelectedNode(ref == null ? null : ref.getName());
        this.referenceChanged(ref);
    }

    @Override
    public void sceneChanged(TudeySceneModel scene) {
        super.sceneChanged(scene);
        if (this._tree != null) {
            this._tree.dispose();
        }
        this._tree = new ConfigTree((ConfigGroup[])scene.getConfigManager().getGroups(this._clazz));
        this._pane.setViewportView(this._tree);
        this._filterPanel.setTree(this._tree);
        this._tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._tree.addTreeSelectionListener(this);
    }

    protected void referenceChanged(ConfigReference<T> ref) {
    }

    protected static abstract class EditableReference<T extends ManagedConfig>
    extends DeepObject
    implements Exportable {
        protected EditableReference() {
        }

        public abstract ConfigReference<T> getReference();

        public abstract void setReference(ConfigReference<T> var1);
    }
}

