/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Light;
import com.threerings.opengl.renderer.config.LightConfig;
import com.threerings.opengl.renderer.state.LightState;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.util.List;

@EditorTypes(value={Disabled.class, Enabled.class})
public abstract class LightStateConfig
extends DeepObject
implements Exportable {
    public abstract LightState getState(GlContext var1, Scope var2, List<Updater> var3);

    public static class Disabled
    extends LightStateConfig {
        @Override
        public LightState getState(GlContext ctx, Scope scope, List<Updater> updaters) {
            return LightState.DISABLED;
        }
    }

    public static class Enabled
    extends LightStateConfig {
        @Editable
        public Color4f globalAmbient = new Color4f(0.2f, 0.2f, 0.2f, 1.0f);
        @Editable
        public LightConfig[] lights = new LightConfig[0];

        @Override
        public LightState getState(GlContext ctx, Scope scope, List<Updater> updaters) {
            Light[] slights = new Light[this.lights.length];
            int ii = 0;
            while (ii < this.lights.length) {
                slights[ii] = this.lights[ii].createLight(ctx, scope, false, updaters);
                ++ii;
            }
            return new LightState(slights, this.globalAmbient);
        }
    }
}

