/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.layout;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.layout.DimenInfo;
import com.threerings.opengl.gui.layout.GroupLayout;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.gui.util.Rectangle;

public class HGroupLayout
extends GroupLayout {
    @Override
    public Dimension computePreferredSize(Container target, int whint, int hhint) {
        DimenInfo info = this.computeDimens(target, true, whint, hhint);
        Dimension dims = new Dimension();
        dims.width = this._policy == STRETCH ? info.maxfreewid * (info.count - info.numfix) + info.fixwid : (this._policy == EQUALIZE ? info.maxwid * info.count : info.totwid);
        dims.width += (info.count - 1) * this._gap;
        dims.height = info.maxhei;
        return dims;
    }

    @Override
    public void layoutContainer(Container target) {
        int totwid;
        Rectangle b = target.getBounds();
        Insets insets = target.getInsets();
        b.width -= insets.getHorizontal();
        b.height -= insets.getVertical();
        DimenInfo info = this.computeDimens(target, true, b.width, b.height);
        int nk = target.getComponentCount();
        int totgap = this._gap * (info.count - 1);
        int freecount = info.count - info.numfix;
        int freefrac = 0;
        int defwid = 0;
        float conscale = 1.0f;
        if (this._policy == STRETCH) {
            if (freecount > 0) {
                int freewid = b.width - info.fixwid - totgap;
                defwid = freewid / freecount;
                freefrac = freewid % freecount;
                totwid = b.width;
            } else {
                totwid = info.fixwid + totgap;
            }
        } else if (this._policy == EQUALIZE) {
            defwid = info.maxwid;
            totwid = info.fixwid + defwid * freecount + totgap;
        } else if (this._policy == CONSTRAIN) {
            totwid = info.totwid + totgap;
            if (totwid > b.width) {
                conscale = (float)(b.width - totgap) / (float)info.totwid;
                totwid = b.width;
            }
        } else {
            totwid = info.totwid + totgap;
        }
        int defhei = 0;
        if (this._offpolicy == STRETCH) {
            defhei = b.height;
        } else if (this._offpolicy == EQUALIZE) {
            defhei = info.maxhei;
        }
        int sx = this._justification == LEFT || this._justification == TOP ? insets.left : (this._justification == CENTER ? insets.left + (b.width - totwid) / 2 : insets.left + b.width - totwid);
        int i = 0;
        while (i < nk) {
            if (info.dimens[i] != null) {
                int newwid;
                Component child = target.getComponent(i);
                if (this._policy == NONE || this.isFixed(child)) {
                    newwid = info.dimens[i].width;
                } else if (this._policy == CONSTRAIN) {
                    newwid = Math.max(1, (int)(conscale * (float)info.dimens[i].width));
                } else {
                    newwid = defwid + freefrac;
                    freefrac = 0;
                }
                int newhei = this._offpolicy == NONE ? info.dimens[i].height : (this._offpolicy == CONSTRAIN ? Math.min(info.dimens[i].height, b.height) : defhei);
                int sy = this._offjust == RIGHT || this._offjust == TOP ? insets.bottom + b.height - newhei : (this._offjust == LEFT || this._offjust == BOTTOM ? insets.bottom : insets.bottom + (b.height - newhei) / 2);
                child.setBounds(sx, sy, newwid, newhei);
                sx += child.getWidth() + this._gap;
            }
            ++i;
        }
    }
}

