/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.prefs;

import com.threerings.prefs.FilePreferences;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;

public class FilePreferencesFactory
implements PreferencesFactory {
    public static final String SYSTEM_PROPERTY_FILE = "FilePreferencesFactory.prefs.file";
    Preferences rootPreferences;
    private static volatile File preferencesFile;
    private static final Object lock;

    static {
        lock = new Object();
    }

    @Override
    public Preferences systemRoot() {
        return this.userRoot();
    }

    @Override
    public Preferences userRoot() {
        if (this.rootPreferences == null) {
            this.rootPreferences = new FilePreferences(null, "");
        }
        return this.rootPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getPreferencesFile() {
        if (preferencesFile == null) {
            Object object = lock;
            synchronized (object) {
                if (preferencesFile == null) {
                    String prefsFile = System.getProperty(SYSTEM_PROPERTY_FILE);
                    if (prefsFile == null || prefsFile.length() == 0) {
                        prefsFile = String.valueOf(System.getProperty("user.home")) + File.separator + ".prefs";
                    }
                    preferencesFile = new File(prefsFile).getAbsoluteFile();
                    try {
                        preferencesFile.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return preferencesFile;
    }
}

