/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.scene;

import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.Updater;
import com.threerings.math.Box;
import com.threerings.math.Transform3D;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.SceneInfluence;
import com.threerings.opengl.scene.config.SceneInfluencerConfig;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.opengl.util.GlContext;
import java.util.ArrayList;

public class SceneInfluencer
extends Model.Implementation
implements Enqueueable {
    protected GlContext _ctx;
    protected SceneInfluencerConfig _config;
    protected SceneInfluence _influence;
    protected Updater[] _updaters;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound(value="viewTransform")
    protected Transform3D _parentViewTransform;
    @Bound
    protected Transform3D _localTransform;
    @Scoped
    protected Transform3D _worldTransform = new Transform3D();
    @Scoped
    protected Transform3D _viewTransform = new Transform3D();
    protected int _influenceFlags;
    @Scoped
    protected Box _bounds = new Box();
    protected Box _nbounds = new Box();
    protected boolean _visible = true;

    public SceneInfluencer(GlContext ctx, Scope parentScope, SceneInfluencerConfig config) {
        super(parentScope);
        this.setConfig(ctx, config);
    }

    public void setConfig(GlContext ctx, SceneInfluencerConfig config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    @Override
    public void enqueue() {
        this._parentViewTransform.compose(this._localTransform, this._viewTransform);
        Updater[] updaterArray = this._updaters;
        int n = this._updaters.length;
        int n2 = 0;
        while (n2 < n) {
            Updater updater = updaterArray[n2];
            updater.update();
            ++n2;
        }
    }

    @Override
    public void reset() {
        this._influence.reset();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this._visible != visible) {
            this._visible = visible;
            Scene scene = ((Model)this._parentScope).getScene(this);
            if (scene != null && this._influence != null) {
                if (visible) {
                    scene.add(this._influence);
                } else {
                    scene.remove(this._influence);
                }
            }
        }
    }

    @Override
    public int getInfluenceFlags() {
        return this._influenceFlags;
    }

    @Override
    public Box getBounds() {
        return this._bounds;
    }

    @Override
    public void updateBounds() {
        if (this._parentWorldTransform == null) {
            this._worldTransform.set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }
        this._config.extent.transformBounds(this._worldTransform, this._nbounds);
        if (!this._bounds.equals(this._nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(this._nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
            Scene scene = ((Model)this._parentScope).getScene(this);
            if (scene != null) {
                scene.boundsWillChange(this._influence);
            }
            this._influence.getBounds().set(this._nbounds);
            if (scene != null) {
                scene.boundsDidChange(this._influence);
            }
        }
    }

    @Override
    public void drawBounds() {
        DebugBounds.draw(this._bounds, Color4f.WHITE);
    }

    @Override
    public void dumpInfo(String prefix) {
        System.out.println(String.valueOf(prefix) + "SceneInfluencer: " + this._worldTransform + " " + this._bounds);
    }

    @Override
    public void wasAdded() {
        Scene scene = ((Model)this._parentScope).getScene(this);
        if (this._visible && scene != null && this._influence != null) {
            scene.add(this._influence);
        }
    }

    @Override
    public void willBeRemoved() {
        Scene scene = ((Model)this._parentScope).getScene(this);
        if (this._visible && scene != null && this._influence != null) {
            scene.remove(this._influence);
        }
    }

    @Override
    public void composite() {
        this._ctx.getCompositor().addEnqueueable(this);
    }

    protected void updateFromConfig() {
        Scene scene = ((Model)this._parentScope).getScene(this);
        if (this._visible && scene != null && this._influence != null) {
            scene.remove(this._influence);
        }
        this._influenceFlags = this._config.influences.getFlags();
        ArrayList<Updater> updaters = new ArrayList<Updater>();
        this._influence = this._config.influence.createSceneInfluence(this._ctx, this, updaters);
        this._influence.getBounds().set(this._bounds);
        this._updaters = updaters.toArray(new Updater[updaters.size()]);
        if (this._visible && scene != null) {
            scene.add(this._influence);
        }
        this.updateBounds();
    }
}

