/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.google.common.collect.Lists;
import com.samskivert.util.StringUtil;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.UserInterface;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import com.threerings.opengl.gui.event.ComponentListener;
import com.threerings.util.DeepObject;
import java.util.ArrayList;

@EditorTypes(value={Action.class, Any.class})
public abstract class EventConfig
extends DeepObject
implements Exportable {
    public abstract UserInterface.Script addHandler(UserInterface var1, Runnable var2);

    public static class Action
    extends Targeted {
        @Editable(hgroup="t")
        public String action = "";

        @Override
        protected ComponentListener createListener(final Runnable runnable) {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (StringUtil.isBlank((String)Action.this.action) || Action.this.action.equals(event.getAction())) {
                        runnable.run();
                    }
                }
            };
        }
    }

    public static class Any
    extends EventConfig {
        @Editable
        public EventConfig[] events = new EventConfig[0];

        @Override
        public UserInterface.Script addHandler(UserInterface iface, Runnable runnable) {
            final UserInterface.Script[] scripts = new UserInterface.Script[this.events.length];
            int ii = 0;
            while (ii < this.events.length) {
                scripts[ii] = this.events[ii].addHandler(iface, runnable);
                ++ii;
            }
            UserInterface userInterface = iface;
            userInterface.getClass();
            return new UserInterface.Script(userInterface){

                @Override
                public void init() {
                    UserInterface.Script[] scriptArray = scripts;
                    int n = scripts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UserInterface.Script script = scriptArray[n2];
                        script.init();
                        ++n2;
                    }
                }

                @Override
                public void cleanup() {
                    UserInterface.Script[] scriptArray = scripts;
                    int n = scripts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UserInterface.Script script = scriptArray[n2];
                        script.cleanup();
                        ++n2;
                    }
                }
            };
        }
    }

    public static abstract class Targeted
    extends EventConfig {
        @Editable(hgroup="t")
        public String target = "";

        @Override
        public UserInterface.Script addHandler(UserInterface iface, Runnable runnable) {
            final ComponentListener listener = this.createListener(runnable);
            final ArrayList comps = Lists.newArrayList(iface.getComponents(this.target));
            UserInterface userInterface = iface;
            userInterface.getClass();
            return new UserInterface.Script(userInterface){

                @Override
                public void init() {
                    for (Component comp : comps) {
                        comp.addListener(listener);
                    }
                }

                @Override
                public void cleanup() {
                    for (Component comp : comps) {
                        comp.removeListener(listener);
                    }
                }
            };
        }

        protected abstract ComponentListener createListener(Runnable var1);
    }
}

