/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.tools;

import com.google.common.collect.Lists;
import com.threerings.config.ConfigManager;
import com.threerings.config.ManagedConfig;
import com.threerings.resource.ResourceManager;
import com.threerings.resource.file.FileResourceManager;
import com.threerings.util.MessageManager;
import java.io.File;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ConfigValidatorTask
extends Task {
    protected List<FileSet> _filesets = Lists.newArrayList();

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    public void execute() throws BuildException {
        boolean valid = true;
        FileResourceManager rsrcmgr = new FileResourceManager("rsrc/");
        MessageManager msgmgr = new MessageManager("rsrc.i18n");
        rsrcmgr.initResource("rsrc/");
        ConfigManager cfgmgr = new ConfigManager((ResourceManager)rsrcmgr, msgmgr, "config/");
        cfgmgr.init();
        valid = cfgmgr.validateReferences("", System.err) && valid;
        for (FileSet fs : this._filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            String[] stringArray = ds.getIncludedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                ManagedConfig config;
                String file = stringArray[n2];
                File source = new File(fromDir, file);
                String path = rsrcmgr.getResourcePath(source);
                ManagedConfig managedConfig = config = path == null ? null : cfgmgr.getResourceConfig(path);
                if (config != null) {
                    try {
                        valid = config.validateReferences(path, System.err) && valid;
                    }
                    catch (Exception e) {
                        throw new BuildException("Error validating '" + path + "': " + e);
                    }
                }
                ++n2;
            }
        }
        if (!valid) {
            throw new BuildException();
        }
    }
}

