/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server;

import com.google.inject.Inject;
import com.threerings.config.ConfigManager;
import com.threerings.media.image.ColorPository;
import com.threerings.presents.server.PresentsServer;
import com.threerings.resource.ResourceManager;
import com.threerings.resource.file.FileResourceManager;
import com.threerings.tudey.server.TudeySceneRegistry;
import com.threerings.tudey.server.TudeyZoneRegistry;
import com.threerings.tudey.util.TudeySceneFactory;
import com.threerings.util.MessageManager;
import com.threerings.whirled.server.SceneRegistry;
import com.threerings.whirled.server.WhirledServer;
import com.threerings.whirled.util.SceneFactory;
import com.threerings.whirled.zone.server.ZoneRegistry;

public abstract class TudeyServer
extends WhirledServer {
    @Inject
    protected SceneRegistry _scenereg;

    public static class TudeyModule
    extends WhirledServer.WhirledModule {
        protected void configure() {
            super.configure();
            this.bind(PresentsServer.class).to(TudeyServer.class);
            FileResourceManager rsrcmgr = new FileResourceManager("rsrc/");
            rsrcmgr.activateResourceProtocol();
            this.bind(ResourceManager.class).toInstance((Object)rsrcmgr);
            MessageManager msgmgr = new MessageManager("rsrc.i18n");
            this.bind(MessageManager.class).toInstance((Object)msgmgr);
            ConfigManager cfgmgr = new ConfigManager((ResourceManager)rsrcmgr, msgmgr, "config/");
            if (this.shouldInitConfigManager()) {
                cfgmgr.init();
            }
            this.bind(ConfigManager.class).toInstance((Object)cfgmgr);
            this.bind(ColorPository.class).toInstance((Object)ColorPository.loadColorPository((ResourceManager)rsrcmgr));
            this.bind(SceneFactory.class).to(TudeySceneFactory.class);
            this.bind(SceneRegistry.class).to(TudeySceneRegistry.class);
            this.bind(ZoneRegistry.class).to(TudeyZoneRegistry.class);
        }

        protected boolean shouldInitConfigManager() {
            return true;
        }
    }
}

