/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.samskivert.util.SoftCache;
import com.threerings.opengl.Log;
import com.threerings.opengl.camera.Camera;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Framebuffer;
import com.threerings.opengl.renderer.Renderbuffer;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.renderer.TextureCubeMap;
import com.threerings.opengl.util.GlContext;
import java.lang.ref.WeakReference;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.RenderTexture;

public class TextureRenderer {
    protected GlContext _ctx;
    protected Renderer _renderer;
    protected int _width;
    protected int _height;
    protected boolean _matchTextureDimensions;
    protected PixelFormat _pformat;
    protected Texture _color;
    protected Texture _depth;
    protected Framebuffer _framebuffer;
    protected int _pwidth;
    protected int _pheight;
    protected RenderTexture _rtex;
    protected Pbuffer _pbuffer;
    protected int _level;
    protected int _param;
    protected Rectangle _oviewport = new Rectangle();
    protected Framebuffer _obuffer;
    protected Renderer _orenderer;
    protected int _odraw;
    protected int _oread;
    protected static SoftCache<InstanceKey, TextureRenderer> _instances = new SoftCache();

    public static TextureRenderer getInstance(GlContext ctx, Texture color, Texture depth, PixelFormat pformat) {
        return TextureRenderer.getInstance(ctx, color, depth, -1, -1, pformat);
    }

    public static TextureRenderer getInstance(GlContext ctx, Texture color, Texture depth, int width, int height, PixelFormat pformat) {
        InstanceKey key = new InstanceKey(color, depth);
        TextureRenderer instance = (TextureRenderer)_instances.get((Object)key);
        if (instance == null) {
            instance = new TextureRenderer(ctx, color, depth, width, height, pformat);
            _instances.put((Object)key, (Object)instance);
        }
        return instance;
    }

    public TextureRenderer(GlContext ctx, Texture color, Texture depth, int width, int height, PixelFormat pformat) {
        this._ctx = ctx;
        this._renderer = ctx.getRenderer();
        this._color = color;
        this._depth = depth;
        this._pformat = pformat;
        Texture tex = color == null ? depth : color;
        int twidth = tex.getWidth();
        int theight = tex.getHeight();
        if (width == -1) {
            this._width = twidth;
            this._height = theight;
            this._matchTextureDimensions = true;
        } else {
            this._width = width;
            this._height = height;
        }
        int pcaps = 0;
        if (pcaps & true) {
            int target = TextureRenderer.getRenderTextureTarget(tex.getTarget());
            boolean rectangle = target == 8354;
            this._pwidth = this._width;
            this._pheight = this._height;
            if (!((pcaps & 2) == 0 || rectangle && (pcaps & 4) == 0 || depth != null && (pcaps & 8) == 0)) {
                boolean rgb = false;
                boolean rgba = false;
                if (color != null) {
                    rgba = color.hasAlpha();
                    rgb = !rgba;
                }
                this._rtex = new RenderTexture(rgb, rgba, depth != null, rectangle, target, 0);
                this._pwidth = twidth;
                this._pheight = theight;
            }
            this.initPbuffer();
        }
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public Texture getColor() {
        return this._color;
    }

    public Texture getDepth() {
        return this._depth;
    }

    public void startRender() {
        this.startRender(0, 0);
    }

    public void startRender(int level, int param) {
        if (this._matchTextureDimensions) {
            Texture tex = this._color == null ? this._depth : this._color;
            int twidth = tex.getWidth();
            int theight = tex.getHeight();
            if (this._width != twidth || this._height != theight) {
                this.resize(twidth, theight);
            }
        }
        this._level = level;
        this._param = param;
        if (this._framebuffer != null) {
            this._obuffer = this._renderer.getFramebuffer();
            this._renderer.setFramebuffer(this._framebuffer);
        } else if (this._pbuffer != null) {
            if (this._pbuffer.isBufferLost()) {
                this._pbuffer.destroy();
                this.initPbuffer();
            }
            if (this._rtex != null) {
                this.releaseTextures();
            }
            try {
                this._pbuffer.makeCurrent();
                this._orenderer = this._ctx.getRenderer();
                this._ctx.setRenderer(this._renderer);
            }
            catch (LWJGLException e) {
                Log.log.warning((Object)"Failed to make pbuffer context current.", new Object[]{e});
            }
        }
        if (this._color == null) {
            this._odraw = this._renderer.getDrawBuffer();
            this._oread = this._renderer.getReadBuffer();
            this._renderer.setBuffers(0, 0);
        }
        Camera camera = this._ctx.getCompositor().getCamera();
        this._oviewport.set(camera.getViewport());
        camera.getViewport().set(0, 0, this._width, this._height);
        camera.apply(this._renderer);
    }

    public void commitRender() {
        Camera camera = this._ctx.getCompositor().getCamera();
        camera.getViewport().set(this._oviewport);
        camera.apply(this._renderer);
        if (this._color == null) {
            this._renderer.setBuffers(this._odraw, this._oread);
        }
        if (this._framebuffer != null) {
            this._renderer.setFramebuffer(this._obuffer);
            this._obuffer = null;
        } else if (this._pbuffer != null) {
            if (this._rtex == null) {
                this.copyTextures();
            }
            this._ctx.setRenderer(this._orenderer);
            this._ctx.makeCurrent();
            if (this._rtex != null) {
                this.bindTextures();
            }
        } else {
            this.copyTextures();
        }
    }

    public void dispose() {
        if (this._framebuffer != null) {
            TextureRenderer.deleteFramebuffer(this._framebuffer);
            this._framebuffer = null;
        }
        if (this._pbuffer != null) {
            this._pbuffer.destroy();
            this._pbuffer = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._pbuffer != null) {
            this._renderer.pbufferFinalized(this._pbuffer);
        }
    }

    protected void resize(int width, int height) {
        this._width = width;
        this._height = height;
        if (this._framebuffer != null) {
            if (this._depth == null && this._pformat.getDepthBits() > 0) {
                Renderbuffer dbuf = new Renderbuffer(this._renderer);
                dbuf.setStorage(6402, width, height);
                this._framebuffer.setDepthAttachment(dbuf);
            }
            if (this._pformat.getStencilBits() > 0) {
                Renderbuffer sbuf = new Renderbuffer(this._renderer);
                sbuf.setStorage(6401, width, height);
                this._framebuffer.setStencilAttachment(sbuf);
            }
        } else if (this._pbuffer != null) {
            this._pwidth = width;
            this._pheight = height;
            this.initPbuffer();
        }
    }

    protected void initPbuffer() {
        block3: {
            try {
                this._pbuffer = new Pbuffer(this._pwidth, this._pheight, this._pformat, this._rtex, this._ctx.getRenderer().getDrawable());
                this._pbuffer.makeCurrent();
                this._renderer = new Renderer();
                this._renderer.init((Drawable)this._pbuffer, this._pwidth, this._pheight);
                this._ctx.makeCurrent();
                if (this._rtex != null) {
                    this.bindTextures();
                }
            }
            catch (LWJGLException e) {
                Log.log.warning((Object)"Failed to create pbuffer.", new Object[]{e});
                if (this._pbuffer == null) break block3;
                this._pbuffer.destroy();
                this._pbuffer = null;
            }
        }
    }

    protected void bindTextures() {
        if (this._color != null) {
            this._ctx.getRenderer().setTexture(this._color);
            this._pbuffer.bindTexImage(8323);
        }
        if (this._depth != null) {
            this._ctx.getRenderer().setTexture(this._depth);
            this._pbuffer.bindTexImage(8359);
        }
    }

    protected void releaseTextures() {
        if (this._color != null) {
            this._pbuffer.releaseTexImage(8323);
        }
        if (this._depth != null) {
            this._pbuffer.releaseTexImage(8359);
        }
    }

    protected void copyTextures() {
        if (this._color != null) {
            this.copyTexture(this._color);
        }
        if (this._depth != null) {
            this.copyTexture(this._depth);
        }
    }

    protected void copyTexture(Texture texture) {
        int target;
        if (texture instanceof Texture2D) {
            target = texture.getTarget();
        } else if (texture instanceof TextureCubeMap) {
            target = TextureCubeMap.FACE_TARGETS[this._param];
        } else {
            return;
        }
        this._renderer.setTexture(texture);
        GL11.glCopyTexSubImage2D((int)target, (int)this._level, (int)0, (int)0, (int)0, (int)0, (int)this._width, (int)this._height);
    }

    protected static int getDepthFormat(int bits) {
        switch (bits) {
            default: {
                return 33189;
            }
            case 24: {
                return 33190;
            }
            case 32: 
        }
        return 33191;
    }

    protected static int getStencilFormat(int bits) {
        switch (bits) {
            default: {
                return 36166;
            }
            case 4: {
                return 36167;
            }
            case 8: {
                return 36168;
            }
            case 16: 
        }
        return 36169;
    }

    protected static int getRenderTextureTarget(int target) {
        switch (target) {
            case 3552: {
                return 8313;
            }
            default: {
                return 8314;
            }
            case 34067: {
                return 8312;
            }
            case 34037: 
        }
        return 8354;
    }

    protected static void deleteFramebuffer(Framebuffer framebuffer) {
        TextureRenderer.maybeDeleteAttachment(framebuffer.getColorAttachment());
        TextureRenderer.maybeDeleteAttachment(framebuffer.getDepthAttachment());
        TextureRenderer.maybeDeleteAttachment(framebuffer.getStencilAttachment());
        framebuffer.delete();
    }

    protected static void maybeDeleteAttachment(Object attachment) {
        if (attachment instanceof Renderbuffer) {
            ((Renderbuffer)attachment).delete();
        }
    }

    protected static class InstanceKey {
        protected WeakReference<Texture> _color;
        protected WeakReference<Texture> _depth;

        public InstanceKey(Texture color, Texture depth) {
            this._color = new WeakReference<Texture>(color);
            this._depth = new WeakReference<Texture>(depth);
        }

        public int hashCode() {
            return System.identityHashCode(this._color.get()) ^ System.identityHashCode(this._depth.get());
        }

        public boolean equals(Object other) {
            InstanceKey okey = (InstanceKey)other;
            return this._color.get() == okey._color.get() && this._depth.get() == okey._depth.get();
        }
    }
}

