/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.config.ManagedConfig;
import com.threerings.expr.DynamicScope;
import com.threerings.expr.MutableBoolean;
import com.threerings.expr.MutableLong;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.opengl.gui.ComboBox;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.EditableTextComponent;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.gui.TextComponent;
import com.threerings.opengl.gui.ToggleButton;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.config.InterfaceScriptConfig;
import com.threerings.opengl.gui.config.UserInterfaceConfig;
import com.threerings.opengl.gui.event.ComponentListener;
import com.threerings.opengl.gui.layout.BorderLayout;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.GlContextWrapper;
import com.threerings.opengl.util.Tickable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UserInterface
extends Container {
    protected DynamicScope _scope = new UIScope(this, "interface");
    protected UserInterfaceConfig _config;
    protected Controller _controller;
    protected ListMultimap<String, Component> _tagged = ArrayListMultimap.create();
    protected Root _root;
    protected List<Script> _scripts = Lists.newArrayList();
    protected ScriptQueue _scriptQueue;
    @Scoped
    protected MutableLong _epoch = new MutableLong(System.currentTimeMillis());

    public UserInterface(GlContext ctx) {
        this(ctx, (UserInterfaceConfig)null);
    }

    public UserInterface(GlContext ctx, String name) {
        this(ctx, ctx.getConfigManager().getConfig(UserInterfaceConfig.class, name));
    }

    public UserInterface(GlContext ctx, String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this(ctx, ctx.getConfigManager().getConfig(UserInterfaceConfig.class, name, firstKey, firstValue, otherArgs));
    }

    public UserInterface(GlContext ctx, ConfigReference<UserInterfaceConfig> ref) {
        this(ctx, ctx.getConfigManager().getConfig(UserInterfaceConfig.class, ref));
    }

    public UserInterface(GlContext ctx, UserInterfaceConfig config) {
        this(ctx, config, ctx.getScope());
    }

    public UserInterface(GlContext ctx, UserInterfaceConfig config, Scope parentScope) {
        super(ctx, new BorderLayout());
        this._scope.setParentScope(parentScope);
        this._ctx = new GlContextWrapper(ctx){

            @Override
            public ConfigManager getConfigManager() {
                return UserInterface.this._config == null ? this._wrapped.getConfigManager() : UserInterface.this._config.getConfigManager();
            }
        };
        this.setConfig(config);
    }

    public DynamicScope getScope() {
        return this._scope;
    }

    public void setConfig(String name) {
        this.setConfig(this._ctx.getConfigManager().getConfig(UserInterfaceConfig.class, name));
    }

    public void setConfig(ConfigReference<UserInterfaceConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(UserInterfaceConfig.class, ref));
    }

    public void setConfig(String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this.setConfig(this._ctx.getConfigManager().getConfig(UserInterfaceConfig.class, name, firstKey, firstValue, otherArgs));
    }

    public void setConfig(UserInterfaceConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    public UserInterfaceConfig getConfig() {
        return this._config;
    }

    public void setEnabled(String tag, boolean enabled) {
        for (Component comp : this.getComponents(tag)) {
            comp.setEnabled(enabled);
        }
    }

    public void setVisible(String tag, boolean visible) {
        for (Component comp : this.getComponents(tag)) {
            comp.setVisible(visible);
        }
    }

    public void setHoverable(String tag, boolean hoverable) {
        for (Component comp : this.getComponents(tag)) {
            comp.setHoverable(hoverable);
        }
    }

    public void setText(String tag, String text) {
        for (TextComponent comp : this.getComponents(tag, TextComponent.class)) {
            comp.setText(text);
        }
    }

    public String getText(String tag) {
        TextComponent comp = this.getComponent(tag, EditableTextComponent.class);
        if (comp == null && (comp = this.getComponent(tag, TextComponent.class)) == null) {
            Log.log.warning((Object)"Not a text component.", new Object[]{"tag", tag, "components", this.getComponents(tag)});
            return "";
        }
        return comp.getText();
    }

    public boolean isSelected(String tag) {
        ToggleButton comp = this.getComponent(tag, ToggleButton.class);
        if (comp == null) {
            Log.log.warning((Object)"Not a toggle button.", new Object[]{"tag", tag, "component", this.getComponent(tag)});
            return false;
        }
        return comp.isSelected();
    }

    public void addListener(String tag, ComponentListener listener) {
        for (Component comp : this.getComponents(tag)) {
            comp.addListener(listener);
        }
    }

    public void removeListener(String tag, ComponentListener listener) {
        for (Component comp : this.getComponents(tag)) {
            comp.removeListener(listener);
        }
    }

    public void removeAllListeners(String tag) {
        for (Component comp : this.getComponents(tag)) {
            comp.removeAllListeners();
        }
    }

    public void setAlpha(String tag, float alpha) {
        for (Component comp : this.getComponents(tag)) {
            comp.setAlpha(alpha);
        }
    }

    public Component getComponent(String tag) {
        return (Component)Iterables.getFirst(this.getComponents(tag), null);
    }

    public <C extends Component> C getComponent(String tag, Class<C> clazz) {
        return (C)((Component)Iterables.getFirst(this.getComponents(tag, clazz), null));
    }

    public <C extends Component> Iterable<C> getComponents(String tag, Class<C> clazz) {
        return Iterables.filter(this.getComponents(tag), clazz);
    }

    public Iterable<Component> getComponents(String tag) {
        if (StringUtil.isBlank((String)tag)) {
            return Collections.singletonList(this);
        }
        int idx = tag.indexOf(47);
        if (idx == -1) {
            return this._tagged.get((Object)tag);
        }
        final String nextpath = tag.substring(idx + 1);
        tag = tag.substring(0, idx);
        return Iterables.concat((Iterable)Iterables.transform(this.getComponents(tag, UserInterface.class), (Function)new Function<UserInterface, Iterable<Component>>(){

            public Iterable<Component> apply(UserInterface comp) {
                return comp.getComponents(nextpath);
            }
        }));
    }

    public ComboBox<String> getComboBox(String tag) {
        ComboBox box = this.getComponent(tag, ComboBox.class);
        return box;
    }

    public <T> ComboBox<T> getAndClearComboBox(String tag) {
        ComboBox box = this.getComponent(tag, ComboBox.class);
        if (box != null) {
            box.clearItems();
        }
        return box;
    }

    public Map<String, Collection<Component>> getTagged() {
        return this._tagged.asMap();
    }

    public boolean replace(String tag, Component newc) {
        Component oldc;
        List list = this._tagged.get((Object)tag);
        if (!list.isEmpty() && (oldc = (Component)list.get(0)).getParent().replace(oldc, newc)) {
            list.set(0, newc);
            return true;
        }
        return false;
    }

    public Root getRoot() {
        return this._root;
    }

    public void runScript(String name) {
        this.runScript(this._ctx.getConfigManager().getConfig(InterfaceScriptConfig.class, name));
    }

    public void runScript(ConfigReference<InterfaceScriptConfig> ref) {
        this.runScript(this._ctx.getConfigManager().getConfig(InterfaceScriptConfig.class, ref));
    }

    public void runScript(String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this.runScript(this._ctx.getConfigManager().getConfig(InterfaceScriptConfig.class, name, firstKey, firstValue, otherArgs));
    }

    public void runScript(InterfaceScriptConfig config) {
        this.addScript(new ConfigScript(config));
    }

    public void runInitScript(ConfigReference<InterfaceScriptConfig> ref) {
        this.addScript(new InitScript(this._ctx.getConfigManager().getConfig(InterfaceScriptConfig.class, ref)));
    }

    public void runScriptLater(String name) {
        this.runScriptLater(this._ctx.getConfigManager().getConfig(InterfaceScriptConfig.class, name));
    }

    public void runScriptLater(String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this.runScriptLater(this._ctx.getConfigManager().getConfig(InterfaceScriptConfig.class, name, firstKey, firstValue, otherArgs));
    }

    public void runScriptLater(InterfaceScriptConfig config) {
        if (this._scriptQueue == null) {
            this._scriptQueue = new ScriptQueue();
        }
        this._scriptQueue.add(config);
    }

    public void addScript(Script script) {
        if (this._root == null && !(script instanceof InitScript)) {
            throw new IllegalStateException("Can't add script to non-added interface.");
        }
        this._scripts.add(script);
        script.init();
    }

    public void clearScripts() {
        for (Script script : this._scripts) {
            script.cleanup();
        }
        this._scripts.clear();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkController();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.checkController();
    }

    @Override
    public void configUpdated(ConfigEvent<ManagedConfig> event) {
        if (event.getConfig() instanceof UserInterfaceConfig) {
            this.updateFromConfig();
        } else {
            super.configUpdated(event);
        }
    }

    @Override
    protected void wasAdded() {
        super.wasAdded();
        Window window = this.getWindow();
        Root root = this._root = window == null ? null : window.getRoot();
        if (this._root == null) {
            return;
        }
        UserInterfaceConfig.Original original = this.getOriginal();
        if (original.addSound != null) {
            this._root.playSound(original.addSound);
        }
        this.checkController();
        if (original.addAction != null) {
            original.addAction.execute(this, null);
        }
    }

    @Override
    protected void wasRemoved() {
        super.wasRemoved();
        if (this._root == null) {
            return;
        }
        this.checkController();
        UserInterfaceConfig.Original original = this.getOriginal();
        if (original.removeSound != null) {
            this._root.playSound(original.removeSound);
        }
        if (original.removeAction != null) {
            original.removeAction.execute(this, null);
        }
        this.clearScripts();
        this._root = null;
    }

    protected void updateFromConfig() {
        this._tagged.clear();
        if (this._controller != null) {
            this._controller.setActive(false);
        }
        this._controller = null;
        Component ocomp = this.getComponentCount() == 0 ? null : this.getComponent(0);
        Component ncomp = this._config == null ? null : this._config.getComponent(this._ctx, this._scope, ocomp);
        this.removeAll();
        if (ncomp != null) {
            this.add(ncomp, BorderLayout.CENTER);
        }
        UserInterfaceConfig.Original original = this.getOriginal();
        String controller = original.controller;
        if (!"".equals(controller)) {
            try {
                Controller c = (Controller)Class.forName(controller).newInstance();
                if (c.init(this._ctx.getApp(), this)) {
                    this._controller = c;
                    this.checkController();
                }
            }
            catch (ClassNotFoundException cnfe) {
                Log.log.warning((Object)("Controller not found: " + controller + ",config=" + this.getConfig().getName()), new Object[0]);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Error initializing controller", new Object[]{"controller", controller, e});
                this._controller = null;
            }
        }
        if (original.initAction != null) {
            original.initAction.execute(this, null);
        }
    }

    protected UserInterfaceConfig.Original getOriginal() {
        UserInterfaceConfig.Original orig;
        UserInterfaceConfig.Original original = orig = this._config == null ? null : this._config.getOriginal();
        if (orig == null) {
            orig = new UserInterfaceConfig.Original();
        }
        return orig;
    }

    @Scoped
    protected void registerComponents(Map<String, Collection<Component>> tagged) {
        for (Map.Entry<String, Collection<Component>> entry : tagged.entrySet()) {
            this._tagged.get((Object)entry.getKey()).addAll(entry.getValue());
        }
    }

    @Scoped
    protected void registerComponent(String tag, Component comp) {
        this._tagged.put((Object)tag, (Object)comp);
    }

    protected void checkController() {
        if (this._controller != null) {
            this._controller.setActive(this.isShowing() && this.isEnabled());
        }
    }

    public class ConfigScript
    extends TickableScript
    implements ConfigUpdateListener<InterfaceScriptConfig> {
        protected InterfaceScriptConfig _config;
        protected InterfaceScriptConfig.Original _original;
        protected float _time;
        protected int _aidx;
        protected boolean _paused;
        protected boolean _dropTick;

        public ConfigScript(InterfaceScriptConfig config) {
            this._config = config;
            if (this._config != null) {
                this._config.addListener(this);
            }
            this.updateFromConfig();
        }

        public void setPaused(boolean paused) {
            if (this._paused == paused) {
                return;
            }
            this._paused = paused;
            if (this._paused) {
                this._scriptRoot.removeTickParticipant(this);
            } else {
                this._scriptRoot.addTickParticipant(this);
            }
        }

        @Override
        public void configUpdated(ConfigEvent<InterfaceScriptConfig> event) {
            this.updateFromConfig();
        }

        @Override
        public void tick(float elapsed) {
            if (this._dropTick) {
                this._dropTick = false;
                return;
            }
            this._time += elapsed;
            this.executeActions();
            if (this._paused) {
                return;
            }
            if (this._original.loopDuration > 0.0f) {
                if (this._time >= this._original.loopDuration) {
                    this._time %= this._original.loopDuration;
                    this._aidx = 0;
                    this.executeActions();
                }
            } else if (this._aidx >= this._original.actions.length) {
                this.remove();
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            if (this._config != null) {
                this._config.removeListener(this);
            }
        }

        @Override
        public void init() {
            super.init();
            this._dropTick = true;
        }

        protected void updateFromConfig() {
            if (this._config == null || (this._original = this._config.getOriginal(UserInterface.this._ctx.getConfigManager())) == null) {
                this._original = new InterfaceScriptConfig.Original();
            }
        }

        protected void executeActions() {
            while (this._aidx < this._original.actions.length && this._original.actions[this._aidx].time <= this._time && !this._paused) {
                this._original.actions[this._aidx].action.execute(UserInterface.this, this);
                ++this._aidx;
            }
        }
    }

    public static interface Controller {
        public boolean init(GlContext var1, UserInterface var2);

        public void setActive(boolean var1);
    }

    public class InitScript
    extends Script
    implements ConfigUpdateListener<InterfaceScriptConfig> {
        protected InterfaceScriptConfig _config;
        protected InterfaceScriptConfig.Original _original;

        public InitScript(InterfaceScriptConfig config) {
            this._config = config;
            if (this._config != null) {
                this._config.addListener(this);
            }
            this.updateFromConfig();
        }

        @Override
        public void init() {
            if (this._original == null) {
                return;
            }
            int ii = 0;
            while (ii < this._original.actions.length) {
                this._original.actions[ii].action.execute(UserInterface.this, null);
                ++ii;
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            if (this._config != null) {
                this._config.removeListener(this);
            }
        }

        @Override
        public void configUpdated(ConfigEvent<InterfaceScriptConfig> event) {
            this.updateFromConfig();
        }

        protected void updateFromConfig() {
            if (this._config != null && (this._original = this._config.getOriginal(UserInterface.this._ctx.getConfigManager())) == null) {
                this._original = new InterfaceScriptConfig.Original();
            }
        }
    }

    public abstract class Script {
        public void init() {
        }

        public void cleanup() {
        }

        public void remove() {
            UserInterface.this._scripts.remove(this);
            this.cleanup();
        }
    }

    protected class ScriptQueue {
        protected List<InterfaceScriptConfig> _queue = Lists.newArrayList();
        protected boolean _running;
        protected Runnable _runnable = new Runnable(){

            @Override
            public void run() {
                for (InterfaceScriptConfig config : ScriptQueue.this._queue) {
                    UserInterface.this.runScript(config);
                }
                ScriptQueue.this._queue.clear();
                ScriptQueue.this._running = false;
            }
        };

        protected ScriptQueue() {
        }

        public void add(InterfaceScriptConfig config) {
            this._queue.add(config);
            if (!this._running) {
                UserInterface.this._ctx.getApp().getRunQueue().postRunnable(this._runnable);
                this._running = true;
            }
        }
    }

    public abstract class TickableScript
    extends Script
    implements Tickable {
        protected transient Root _scriptRoot;

        @Override
        public void init() {
            this._scriptRoot = UserInterface.this.getRoot();
            this._scriptRoot.addTickParticipant(this);
            this.tick(0.0f);
        }

        @Override
        public void cleanup() {
            this._scriptRoot.removeTickParticipant(this);
        }
    }

    protected class UIScope
    extends DynamicScope {
        public UIScope(Object owner, String name) {
            super(owner, name, null);
        }

        @Override
        public <T> T get(String name, Class<T> clazz) {
            int dot = name.indexOf(46);
            if (dot != -1) {
                Component c = UserInterface.this.getComponent(name.substring(0, dot));
                MutableBoolean value = null;
                if (c != null) {
                    String arg = name.substring(dot + 1);
                    if (arg.equals("visible")) {
                        value = new MutableBoolean(c.isVisible());
                    } else if (arg.equals("enabled")) {
                        value = new MutableBoolean(c.isEnabled());
                    } else if (arg.equals("added")) {
                        value = new MutableBoolean(c.isAdded());
                    } else if (arg.equals("hoverable")) {
                        value = new MutableBoolean(c.isHoverable());
                    } else if (arg.equals("selected") && c instanceof ToggleButton) {
                        value = new MutableBoolean(((ToggleButton)c).isSelected());
                    }
                }
                if (clazz.isInstance(value)) {
                    return clazz.cast(value);
                }
            }
            return super.get(name, clazz);
        }
    }
}

