/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl;

import com.google.common.base.Objects;
import com.samskivert.util.RunQueue;
import com.threerings.config.ConfigManager;
import com.threerings.editor.util.EditorContext;
import com.threerings.expr.DynamicScope;
import com.threerings.expr.MutableFloat;
import com.threerings.expr.MutableLong;
import com.threerings.expr.Scoped;
import com.threerings.math.FloatMath;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.media.image.ColorPository;
import com.threerings.openal.ClipProvider;
import com.threerings.openal.Listener;
import com.threerings.openal.ResourceClipProvider;
import com.threerings.openal.SoundManager;
import com.threerings.opengl.camera.CameraHandler;
import com.threerings.opengl.camera.OrbitCameraHandler;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.compositor.Compositor;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.state.TransformState;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.ImageCache;
import com.threerings.opengl.util.ShaderCache;
import com.threerings.resource.ResourceManager;
import com.threerings.resource.file.FileResourceManager;
import com.threerings.util.MessageManager;
import com.threerings.util.ToolUtil;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;

public abstract class GlApp
extends DynamicScope
implements GlContext,
EditorContext,
Enqueueable {
    protected Renderer _renderer;
    protected Compositor _compositor;
    protected CameraHandler _camhand;
    protected ResourceManager _rsrcmgr;
    protected MessageManager _msgmgr;
    protected ConfigManager _cfgmgr;
    protected ColorPository _colorpos;
    protected ImageCache _imgcache;
    protected ShaderCache _shadcache;
    protected SoundManager _soundmgr;
    protected ClipProvider _clipprov;
    @Scoped
    protected MutableLong _now = new MutableLong(System.currentTimeMillis());
    @Scoped
    protected MutableLong _epoch = new MutableLong(System.currentTimeMillis());
    @Scoped
    protected String _renderScheme;
    @Scoped
    protected boolean _compatibilityMode;
    @Scoped
    protected boolean _renderEffects = true;
    @Scoped
    protected Transform3D _viewTransform;
    @Scoped
    protected Transform3D _worldTransform = new Transform3D();
    @Scoped
    protected TransformState _viewTransformState = new TransformState();
    @Scoped
    protected Quaternion _billboardRotation = new Quaternion();
    @Scoped
    protected MutableFloat _streamGain = new MutableFloat(1.0f);
    protected Vector3f _at = new Vector3f();
    protected Vector3f _up = new Vector3f();
    protected static final PixelFormat[] DEFAULT_PIXEL_FORMATS = new PixelFormat[]{new PixelFormat(8, 16, 8), new PixelFormat(1, 16, 8), new PixelFormat(0, 16, 8), new PixelFormat(0, 8, 0)};

    public GlApp() {
        super("app");
        this._renderer = new Renderer();
        this._compositor = new Compositor(this);
        this._msgmgr = new MessageManager("rsrc.i18n");
        this.initSharedManagers();
        this._soundmgr = SoundManager.createSoundManager((RunQueue)this.getRunQueue());
        this._clipprov = new ResourceClipProvider(this._rsrcmgr);
        this._imgcache = new ImageCache(this, this.shouldCheckTimestamps());
        this._shadcache = new ShaderCache(this, this.shouldCheckTimestamps());
        this._viewTransform = this._viewTransformState.getModelview();
    }

    public abstract RunQueue getRunQueue();

    public void setRenderScheme(String scheme) {
        if (!Objects.equal((Object)this._renderScheme, (Object)scheme)) {
            this._renderScheme = scheme;
            this.wasUpdated();
        }
    }

    public String getRenderScheme() {
        return this._renderScheme;
    }

    public void setCompatibilityMode(boolean enabled) {
        if (this._compatibilityMode != enabled) {
            this._compatibilityMode = enabled;
            this.wasUpdated();
        }
    }

    public boolean getCompatibilityMode() {
        return this._compatibilityMode;
    }

    public void setRenderEffects(boolean enabled) {
        if (this._renderEffects != enabled) {
            this._renderEffects = enabled;
            this.wasUpdated();
        }
    }

    public boolean getRenderEffects() {
        return this._renderEffects;
    }

    public MutableFloat getStreamGain() {
        return this._streamGain;
    }

    public abstract Root getRoot();

    public abstract Root createRoot();

    public abstract void startup();

    public abstract void shutdown();

    public String xlate(String bundle, String msg) {
        return this._msgmgr.getBundle(bundle).xlate(msg);
    }

    public BufferedImage createSnapshot() {
        return this.createSnapshot(false);
    }

    public BufferedImage createSnapshot(boolean alpha) {
        int width = this._renderer.getWidth();
        int height = this._renderer.getHeight();
        int comps = alpha ? 4 : 3;
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(comps * width * height));
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)(alpha ? 6408 : 6407), (int)5121, (ByteBuffer)buf);
        ComponentColorModel cmodel = new ComponentColorModel(ColorSpace.getInstance(1000), alpha, false, alpha ? 3 : 1, 0);
        BufferedImage image = new BufferedImage(cmodel, Raster.createInterleavedRaster(0, width, height, comps, null), false, null);
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int yy = height - 1;
        while (yy >= 0) {
            buf.get(data, yy * width * comps, width * comps);
            --yy;
        }
        return image;
    }

    @Override
    public GlApp getApp() {
        return this;
    }

    @Override
    public DynamicScope getScope() {
        return this;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this._rsrcmgr;
    }

    @Override
    public ConfigManager getConfigManager() {
        return this._cfgmgr;
    }

    @Override
    public SoundManager getSoundManager() {
        return this._soundmgr;
    }

    @Override
    public ClipProvider getClipProvider() {
        return this._clipprov;
    }

    @Override
    public void setRenderer(Renderer renderer) {
        this._renderer = renderer;
    }

    @Override
    public Renderer getRenderer() {
        return this._renderer;
    }

    @Override
    public Compositor getCompositor() {
        return this._compositor;
    }

    @Override
    public void setCameraHandler(CameraHandler camhand) {
        if (this._camhand != null) {
            this._camhand.wasRemoved();
        }
        if ((this._camhand = camhand) != null) {
            this._camhand.wasAdded();
        }
    }

    @Override
    public CameraHandler getCameraHandler() {
        return this._camhand;
    }

    @Override
    public MessageManager getMessageManager() {
        return this._msgmgr;
    }

    @Override
    public ColorPository getColorPository() {
        return this._colorpos;
    }

    @Override
    public ImageCache getImageCache() {
        return this._imgcache;
    }

    @Override
    public ShaderCache getShaderCache() {
        return this._shadcache;
    }

    @Override
    public void enqueue() {
        this._viewTransform.set(this._compositor.getCamera().getViewTransform());
        this._viewTransformState.setDirty(true);
        this._viewTransform.extractRotation(this._billboardRotation);
        float angle = 1.5707964f + 2.0f * FloatMath.atan2(this._billboardRotation.x, this._billboardRotation.w);
        this._billboardRotation.fromAngleAxis(angle, Vector3f.UNIT_X);
    }

    protected void initSharedManagers() {
        this._rsrcmgr = new FileResourceManager("rsrc/");
        this._rsrcmgr.activateResourceProtocol();
        this._cfgmgr = new ConfigManager(this._rsrcmgr, this._msgmgr, "config/");
        this._colorpos = ColorPository.loadColorPository((ResourceManager)this._rsrcmgr);
    }

    protected boolean shouldCheckTimestamps() {
        return false;
    }

    protected void init() {
        this.initRenderer();
        this.setCameraHandler(this.createCameraHandler());
        this._compositor.addRoot(new Compositable(){

            @Override
            public void composite() {
                GlApp.this.compositeView();
            }
        });
        ToolUtil.windowAdded();
        this.didInit();
    }

    protected abstract void initRenderer();

    protected CameraHandler createCameraHandler() {
        return new OrbitCameraHandler(this);
    }

    protected void didInit() {
    }

    protected void willShutdown() {
        this._soundmgr.shutdown();
    }

    protected void updateView() {
        long nnow = System.currentTimeMillis();
        float elapsed = Math.max(0.0f, (float)(nnow - this._now.value) / 1000.0f);
        this._now.value = nnow;
        this.updateView(elapsed);
    }

    protected void updateView(float elapsed) {
        this._camhand.updatePosition();
        if (!this._soundmgr.isInitialized()) {
            return;
        }
        Vector3f translation = this._camhand.getViewerTranslation();
        Quaternion rotation = this._camhand.getViewerRotation();
        rotation.transformUnitY(this._up);
        rotation.transformUnitZ(this._at).negateLocal();
        Listener listener = this._soundmgr.getListener();
        listener.setPosition(translation.x, translation.y, translation.z);
        listener.setOrientation(this._at.x, this._at.y, this._at.z, this._up.x, this._up.y, this._up.z);
        this._soundmgr.updateStreams(elapsed);
    }

    protected void renderView() {
        this._compositor.renderView();
    }

    protected void compositeView() {
        this._compositor.addEnqueueable(this);
    }

    protected PixelFormat[] getPixelFormats() {
        return GlApp.getPixelFormats(this.getAntialiasingLevel());
    }

    protected int getAntialiasingLevel() {
        return 0;
    }

    protected static PixelFormat[] getPixelFormats(int antialiasingLevel) {
        if (antialiasingLevel == 0) {
            return DEFAULT_PIXEL_FORMATS;
        }
        int levels = antialiasingLevel + 1;
        PixelFormat[] formats = new PixelFormat[DEFAULT_PIXEL_FORMATS.length * levels];
        int ii = 0;
        while (ii < levels) {
            int jj = 0;
            while (jj < DEFAULT_PIXEL_FORMATS.length) {
                formats[ii * GlApp.DEFAULT_PIXEL_FORMATS.length + jj] = DEFAULT_PIXEL_FORMATS[jj].withSamples(antialiasingLevel == 0 ? 0 : 1 << antialiasingLevel);
                ++jj;
            }
            ++ii;
            --antialiasingLevel;
        }
        return formats;
    }
}

