/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ClassUtil;
import com.samskivert.util.IntTuple;
import com.samskivert.util.ListUtil;
import com.threerings.editor.Introspector;
import com.threerings.editor.Property;
import com.threerings.editor.swing.ObjectPanel;
import com.threerings.editor.swing.editors.ArrayListEditor;
import com.threerings.util.DeepUtil;
import com.threerings.util.MessageBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableArrayListEditor
extends ArrayListEditor
implements TableModel,
ListSelectionListener,
ChangeListener {
    protected Column[] _columns;
    protected JTable _table;
    protected JButton _addColumn;
    protected JButton _copy;
    protected JButton _delete;
    protected ObjectPanel _opanel;

    @Override
    public int getRowCount() {
        return this.getLength();
    }

    @Override
    public int getColumnCount() {
        return this._columns.length;
    }

    @Override
    public String getColumnName(int column) {
        return this._columns[column].getName();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this._columns[column].getColumnClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this._columns[column].isEditable();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this._columns[column].getColumnValue(row);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this._columns[column].setColumnValue(row, value);
        this.fireTableChanged(row, row, column, 0);
        this.fireStateChanged(true);
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this.listenerList.add(TableModelListener.class, listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.listenerList.add(TableModelListener.class, listener);
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.updateSelected();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        int row = this._table.getSelectedRow();
        this.setValue(row, this._opanel.getValue());
        this.fireTableChanged(row, row, -1, 0);
        this.fireStateChanged(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._add && this.is2DArray()) {
            Class<?> cctype = this._property.getComponentType().getComponentType();
            Object value = Array.newInstance(cctype, this._columns.length);
            int ii = 0;
            while (ii < this._columns.length) {
                Array.set(value, ii, TableArrayListEditor.getDefaultInstance(cctype, this._object));
                ++ii;
            }
            this.addValue(value);
        } else if (source == this._addColumn) {
            this.addColumn();
        } else if (source == this._copy) {
            IntTuple selection = this.getSelection();
            if (selection.right == -1) {
                this.copyValue(selection.left);
            } else {
                this.copyColumn(selection.right);
            }
        } else if (source == this._delete) {
            IntTuple selection = this.getSelection();
            if (selection.right == -1) {
                this.removeValue(selection.left);
            } else {
                this.removeColumn(selection.right);
            }
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void update() {
        int min = 0;
        int max = Integer.MAX_VALUE;
        if (this.is2DArray()) {
            this.createArrayColumns();
            max = -1;
            min = -1;
        }
        this.fireTableChanged(min, max, -1, 0);
        if (min == -1) {
            this.updateColumnWidths();
        }
        if (this._opanel != null) {
            this._opanel.setOuter(this._object);
        }
        this.updateSelected();
    }

    @Override
    public void makeVisible(int idx) {
        this.setSelection(idx, -1);
    }

    @Override
    protected void didInit() {
        super.didInit();
        final Class<?> ctype = this._property.getComponentType();
        boolean showHeader = true;
        if (this.is2DArray()) {
            this._columns = new Column[0];
        } else if (TableArrayListEditor.isTableCellType(ctype)) {
            this._columns = new Column[]{new Column(this){

                @Override
                public String getName() {
                    return null;
                }

                @Override
                public String getPathComponent() {
                    return "";
                }

                @Override
                public Class<?> getColumnClass() {
                    return ClassUtil.objectEquivalentOf((Class)ctype);
                }

                @Override
                public Object getColumnValue(int row) {
                    return this.getValue(row);
                }

                @Override
                public void setColumnValue(int row, Object value) {
                    this.setValue(row, value);
                }

                @Override
                public int getWidth() {
                    return _property.getAnnotation().width();
                }
            }};
            showHeader = false;
        } else {
            int ncols;
            Property[] properties = Introspector.getProperties(ctype);
            if (!this._property.getAnnotation().nullable()) {
                ArrayList<2> columns = new ArrayList<2>();
                final MessageBundle msgs = this._msgmgr.getBundle(Introspector.getMessageBundle(ctype));
                Property[] propertyArray = properties;
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    final Property property = propertyArray[n2];
                    if (property.getAnnotation().column()) {
                        columns.add(new Column(this){

                            @Override
                            public String getName() {
                                return this.getLabel(property.getName(), msgs);
                            }

                            @Override
                            public String getPathComponent() {
                                return "." + property.getName();
                            }

                            @Override
                            public Class<?> getColumnClass() {
                                return ClassUtil.objectEquivalentOf(property.getType());
                            }

                            @Override
                            public Object getColumnValue(int row) {
                                return property.get(this.getValue(row));
                            }

                            @Override
                            public void setColumnValue(int row, Object value) {
                                property.set(this.getValue(row), value);
                            }

                            @Override
                            public int getWidth() {
                                return property.getAnnotation().width();
                            }
                        });
                    }
                    ++n2;
                }
                this._columns = columns.toArray(new Column[columns.size()]);
            }
            int n = ncols = this._columns == null ? 0 : this._columns.length;
            if (ncols == 0) {
                this._columns = new Column[]{new Column(this){

                    @Override
                    public String getName() {
                        return "";
                    }

                    @Override
                    public String getPathComponent() {
                        return "";
                    }

                    @Override
                    public Class<?> getColumnClass() {
                        return String.class;
                    }

                    @Override
                    public boolean isEditable() {
                        return false;
                    }

                    @Override
                    public Object getColumnValue(int row) {
                        Object value = this.getValue(row);
                        return this.getLabel(value == null ? null : value.getClass());
                    }

                    @Override
                    public void setColumnValue(int row, Object value) {
                    }

                    @Override
                    public int getWidth() {
                        return 20;
                    }
                }};
                showHeader = false;
            }
            Class<?>[] types = this._property.getComponentSubtypes();
            this._opanel = new ObjectPanel(this._ctx, this._property.getComponentTypeLabel(), types, this._lineage, this._object, ncols > 0);
            this._opanel.addChangeListener(this);
        }
        JPanel outer = new JPanel();
        outer.setBackground(null);
        this._content.add(outer);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(null);
        outer.add(panel);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._table = new JTable(this);
        if (showHeader) {
            this._table.getTableHeader().setReorderingAllowed(false);
            panel.add((Component)this._table.getTableHeader(), "North");
        }
        this.updateColumnWidths();
        panel.add((Component)this._table, "Center");
        if (this.is2DArray()) {
            this._table.setColumnSelectionAllowed(true);
            this._table.setSelectionMode(1);
        } else {
            this._table.setSelectionMode(0);
        }
        this._table.getSelectionModel().addListSelectionListener(this);
        this._table.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this._table.setDragEnabled(true);
        final DataFlavor cflavor = new DataFlavor(IntTuple.class, null);
        this._table.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent comp) {
                return 2;
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] flavors) {
                return ListUtil.containsRef((Object[])flavors, (Object)cflavor);
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                try {
                    IntTuple selection = (IntTuple)t.getTransferData(cflavor);
                    if (selection.left == -1) {
                        TableArrayListEditor.this.moveColumn(selection.right);
                    } else if (selection.right == -1) {
                        TableArrayListEditor.this.moveValue(selection.left);
                    } else {
                        TableArrayListEditor.this.moveCell(selection.left, selection.right);
                    }
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                final IntTuple selection = TableArrayListEditor.this.getSelection();
                if (selection == null) {
                    return null;
                }
                if (TableArrayListEditor.this.is2DArray()) {
                    if (selection.left == -1) {
                        TableArrayListEditor.this._table.setRowSelectionAllowed(false);
                    } else if (selection.right == -1) {
                        TableArrayListEditor.this._table.setColumnSelectionAllowed(false);
                    }
                }
                return new Transferable(){

                    @Override
                    public Object getTransferData(DataFlavor flavor) {
                        return selection;
                    }

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return new DataFlavor[]{cflavor};
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return flavor == cflavor;
                    }
                };
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
                if (TableArrayListEditor.this.is2DArray()) {
                    TableArrayListEditor.this._table.setCellSelectionEnabled(true);
                }
            }
        });
        JPanel bpanel = new JPanel();
        bpanel.setBackground(null);
        this._content.add(bpanel);
        this._add = new JButton(this.is2DArray() ? this.getActionLabel("new", "row") : this._msgs.get("m.new"));
        bpanel.add(this._add);
        this._add.addActionListener(this);
        if (this.is2DArray()) {
            this._addColumn = new JButton(this.getActionLabel("new", "column"));
            bpanel.add(this._addColumn);
            this._addColumn.addActionListener(this);
        }
        this._copy = new JButton(this._msgs.get("m.copy"));
        bpanel.add(this._copy);
        this._copy.addActionListener(this);
        this._delete = new JButton(this._msgs.get("m.delete"));
        bpanel.add(this._delete);
        this._delete.addActionListener(this);
        if (this._opanel != null) {
            this._content.add((Component)((Object)this._opanel));
        }
    }

    @Override
    public String getMousePath(Point pt) {
        Point cpt = SwingUtilities.convertPoint((Component)((Object)this), pt, this._content);
        if (this._content.getComponentAt(cpt) == this._opanel) {
            return "[" + this._table.getSelectedRow() + "]" + this._opanel.getMousePath(SwingUtilities.convertPoint((Component)((Object)this), pt, (Component)((Object)this._opanel)));
        }
        pt = SwingUtilities.convertPoint((Component)((Object)this), pt, this._table);
        int row = this._table.rowAtPoint(pt);
        int col = this._table.columnAtPoint(pt);
        return row == -1 || col == -1 ? "" : "[" + row + "]" + this._columns[col].getPathComponent();
    }

    @Override
    public String getComponentPath(Component comp, boolean mouse) {
        Point pt = this._table.getMousePosition();
        if (pt == null) {
            return super.getComponentPath(comp, mouse);
        }
        int row = this._table.rowAtPoint(pt);
        int col = this._table.columnAtPoint(pt);
        return String.valueOf(super.getComponentPath(comp, mouse)) + (row == -1 || col == -1 ? "" : "[" + row + "]" + this._columns[col].getPathComponent());
    }

    @Override
    protected void addValue(Object value) {
        super.addValue(value);
        int row = this.getLength() - 1;
        this.fireTableChanged(row, row, -1, 1);
        if (this._columns.length > 0) {
            this.setSelection(row, -1);
        }
    }

    @Override
    protected void copyValue(int idx) {
        super.copyValue(idx);
        int row = idx + 1;
        this.fireTableChanged(row, row, -1, 1);
        if (this._columns.length > 0) {
            this.setSelection(row, -1);
        }
    }

    @Override
    protected void removeValue(int idx) {
        super.removeValue(idx);
        this.fireTableChanged(idx, idx, -1, -1);
        this.setSelection(Math.min(idx, this.getLength() - 1), -1);
    }

    protected void addColumn() {
        this._columns = (Column[])ArrayUtil.append((Object[])this._columns, (Object)this.createArrayColumn(this._columns.length));
        Class<?> cctype = this._property.getComponentType().getComponentType();
        int ii = 0;
        int nn = this.getLength();
        while (ii < nn) {
            Object ovalue = this.getValue(ii);
            Object nvalue = Array.newInstance(cctype, this._columns.length);
            System.arraycopy(ovalue, 0, nvalue, 0, this._columns.length - 1);
            Array.set(nvalue, this._columns.length - 1, TableArrayListEditor.getDefaultInstance(cctype, this._object));
            this.setValue(ii, nvalue);
            ++ii;
        }
        this.fireStateChanged(true);
        this.fireTableChanged(-1, -1, this._columns.length - 1, 1);
        this.updateColumnWidths();
        if (this.getLength() > 0) {
            this.setSelection(-1, this._columns.length - 1);
        }
    }

    protected void copyColumn(int column) {
        this._columns = (Column[])ArrayUtil.append((Object[])this._columns, (Object)this.createArrayColumn(this._columns.length));
        int idx = column + 1;
        Class<?> cctype = this._property.getComponentType().getComponentType();
        int ii = 0;
        int nn = this.getLength();
        while (ii < nn) {
            Object ovalue = this.getValue(ii);
            Object nvalue = Array.newInstance(cctype, this._columns.length);
            System.arraycopy(ovalue, 0, nvalue, 0, idx);
            Array.set(nvalue, idx, DeepUtil.copy(Array.get(ovalue, column)));
            System.arraycopy(ovalue, idx, nvalue, idx + 1, this._columns.length - idx - 1);
            this.setValue(ii, nvalue);
            ++ii;
        }
        this.fireStateChanged(true);
        this.fireTableChanged(-1, -1, idx, 1);
        this.updateColumnWidths();
        if (this.getLength() > 0) {
            this.setSelection(-1, idx);
        }
    }

    protected void removeColumn(int column) {
        this._columns = (Column[])ArrayUtil.splice((Object[])this._columns, (int)(this._columns.length - 1));
        Class<?> cctype = this._property.getComponentType().getComponentType();
        int ii = 0;
        int nn = this.getLength();
        while (ii < nn) {
            Object ovalue = this.getValue(ii);
            Object nvalue = Array.newInstance(cctype, this._columns.length);
            System.arraycopy(ovalue, 0, nvalue, 0, column);
            System.arraycopy(ovalue, column + 1, nvalue, column, this._columns.length - column);
            this.setValue(ii, nvalue);
            ++ii;
        }
        this.fireStateChanged(true);
        this.fireTableChanged(-1, -1, -1, 0);
        this.updateColumnWidths();
        this.setSelection(-1, Math.min(column, this._columns.length - 1));
    }

    protected void updateColumnWidths() {
        int ii = 0;
        while (ii < this._columns.length) {
            this._table.getColumnModel().getColumn(ii).setPreferredWidth(this._columns[ii].getWidth() * 10);
            ++ii;
        }
    }

    protected boolean is2DArray() {
        Class<?> ctype = this._property.getComponentType();
        return ctype.isArray() && TableArrayListEditor.isTableCellType(ctype.getComponentType());
    }

    protected void createArrayColumns() {
        Object element = this.getLength() == 0 ? null : this.getValue(0);
        this._columns = new Column[element == null ? 0 : Array.getLength(element)];
        int ii = 0;
        while (ii < this._columns.length) {
            this._columns[ii] = this.createArrayColumn(ii);
            ++ii;
        }
    }

    protected Column createArrayColumn(final int column) {
        final Class<?> cctype = this._property.getComponentType().getComponentType();
        return new Column(this){

            @Override
            public String getName() {
                return Integer.toString(column);
            }

            @Override
            public String getPathComponent() {
                return "[" + column + "]";
            }

            @Override
            public Class<?> getColumnClass() {
                return ClassUtil.objectEquivalentOf((Class)cctype);
            }

            @Override
            public Object getColumnValue(int row) {
                return Array.get(this.getValue(row), column);
            }

            @Override
            public void setColumnValue(int row, Object value) {
                Array.set(this.getValue(row), column, value);
            }

            @Override
            public int getWidth() {
                return _property.getAnnotation().width();
            }
        };
    }

    protected void moveValue(int row) {
        int selected = this._table.getSelectedRow();
        if (selected == row) {
            return;
        }
        Object value = this.getValue(row);
        int dir = selected < row ? -1 : 1;
        int ii = row;
        while (ii != selected) {
            this.setValue(ii, this.getValue(ii + dir));
            ii += dir;
        }
        this.setValue(selected, value);
        this.fireTableChanged(Math.min(selected, row), Math.max(selected, row), -1, 0);
        this.fireStateChanged(true);
        this.setSelection(selected, -1);
        this.updateSelected();
    }

    protected void moveColumn(int column) {
        int selected = this._table.getSelectedColumn();
        if (selected == column) {
            return;
        }
        int ii = 0;
        int nn = this.getLength();
        while (ii < nn) {
            this.moveWithinArray(this.getValue(ii), column, selected);
            ++ii;
        }
        this.fireTableChanged(0, Integer.MAX_VALUE, -1, 0);
        this.fireStateChanged(true);
        this.setSelection(-1, selected);
        this.updateSelected();
    }

    protected void moveCell(int row, int col) {
        int scol;
        int srow = this._table.getSelectedRow();
        if (!(srow == row ^ (scol = this._table.getSelectedColumn()) == col)) {
            return;
        }
        if (srow == row) {
            this.moveWithinArray(this.getValue(row), col, scol);
            this.fireTableChanged(row, row, -1, 0);
        } else {
            Column column = this._columns[col];
            Object value = column.getColumnValue(row);
            int dir = srow < row ? -1 : 1;
            int ii = row;
            while (ii != srow) {
                column.setColumnValue(ii, column.getColumnValue(ii + dir));
                ii += dir;
            }
            column.setColumnValue(srow, value);
            this.fireTableChanged(Math.min(srow, row), Math.max(srow, row), col, 0);
        }
        this.fireStateChanged(true);
        this.updateSelected();
    }

    protected void moveWithinArray(Object array, int source, int dest) {
        Object value = Array.get(array, source);
        if (dest < source) {
            System.arraycopy(array, dest, array, dest + 1, source - dest);
        } else {
            System.arraycopy(array, source + 1, array, source, dest - source);
        }
        Array.set(array, dest, value);
    }

    protected void updateSelected() {
        IntTuple selection = this.getSelection();
        boolean row = false;
        boolean column = false;
        if (selection != null) {
            row = selection.right == -1;
            column = selection.left == -1;
        }
        this._delete.setEnabled(column || row && this.getLength() > this._min);
        this._copy.setEnabled(column || row && this.getLength() < this._max);
        if (this._opanel != null) {
            if (selection == null) {
                this._opanel.setVisible(false);
            } else {
                this._opanel.setVisible(true);
                this._opanel.setValue(this.getValue(selection.left));
            }
        }
    }

    protected IntTuple getSelection() {
        if (!this._table.getColumnSelectionAllowed()) {
            int row = this._table.getSelectedRow();
            return row == -1 ? null : new IntTuple(row, -1);
        }
        if (!this._table.getRowSelectionAllowed()) {
            int column = this._table.getSelectedColumn();
            return column == -1 ? null : new IntTuple(-1, column);
        }
        int[] rows = this._table.getSelectedRows();
        int[] cols = this._table.getSelectedColumns();
        if (rows.length == 1) {
            if (cols.length == 1) {
                return new IntTuple(rows[0], cols[0]);
            }
            if (cols.length == this._columns.length) {
                return new IntTuple(rows[0], -1);
            }
        } else if (cols.length == 1 && rows.length == this.getLength()) {
            return new IntTuple(-1, cols[0]);
        }
        return null;
    }

    protected void setSelection(int row, int column) {
        if (row == -1 && column == -1) {
            this._table.clearSelection();
            return;
        }
        if (row == -1) {
            this._table.setRowSelectionInterval(0, this.getLength() - 1);
        } else {
            this._table.setRowSelectionInterval(row, row);
        }
        if (!this.is2DArray()) {
            return;
        }
        if (column == -1) {
            this._table.setColumnSelectionInterval(0, this._columns.length - 1);
        } else {
            this._table.setColumnSelectionInterval(column, column);
        }
    }

    protected void fireTableChanged(int firstRow, int lastRow, int column, int type) {
        Object[] listeners = this.listenerList.getListenerList();
        TableModelEvent event = null;
        int ii = listeners.length - 2;
        while (ii >= 0) {
            if (listeners[ii] == TableModelListener.class) {
                if (event == null) {
                    event = new TableModelEvent(this, firstRow, lastRow, column, type);
                }
                ((TableModelListener)listeners[ii + 1]).tableChanged(event);
            }
            ii -= 2;
        }
    }

    protected abstract class Column {
        protected Column() {
        }

        public abstract String getName();

        public abstract String getPathComponent();

        public abstract Class<?> getColumnClass();

        public boolean isEditable() {
            return true;
        }

        public abstract Object getColumnValue(int var1);

        public abstract void setColumnValue(int var1, Object var2);

        public abstract int getWidth();
    }
}

