/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.tools;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.ClydeLog;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.config.ManagedConfig;
import com.threerings.config.ParameterizedConfig;
import com.threerings.config.tools.BaseConfigEditor;
import com.threerings.config.tools.ConfigEditor;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.editor.swing.TreeEditorPanel;
import com.threerings.editor.tools.BatchValidateDialog;
import com.threerings.editor.util.EditorContext;
import com.threerings.export.BinaryExporter;
import com.threerings.export.BinaryImporter;
import com.threerings.export.XMLExporter;
import com.threerings.export.XMLImporter;
import com.threerings.media.image.ColorPository;
import com.threerings.resource.ResourceManager;
import com.threerings.resource.file.FileResourceManager;
import com.threerings.util.ChangeBlock;
import com.threerings.util.MessageManager;
import com.threerings.util.ToolUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class ResourceEditor
extends BaseConfigEditor
implements ChangeListener,
ConfigUpdateListener<ManagedConfig> {
    protected JMenuItem _save;
    protected JMenuItem _saveAs;
    protected JMenuItem _revert;
    protected JMenuItem _export;
    protected JCheckBoxMenuItem _treeMode;
    protected JFileChooser _chooser;
    protected JFileChooser _exportChooser;
    protected BaseEditorPanel _epanel;
    protected File _file;
    protected ChangeBlock _block = new ChangeBlock();

    public static void main(String[] args) {
        FileResourceManager rsrcmgr = new FileResourceManager("rsrc/");
        MessageManager msgmgr = new MessageManager("rsrc.i18n");
        ConfigManager cfgmgr = new ConfigManager((ResourceManager)rsrcmgr, msgmgr, "config/");
        ColorPository colorpos = ColorPository.loadColorPository((ResourceManager)rsrcmgr);
        new ResourceEditor(msgmgr, cfgmgr, colorpos, args.length > 0 ? args[0] : null).setVisible(true);
    }

    public ResourceEditor(MessageManager msgmgr, ConfigManager cfgmgr, ColorPository colorpos) {
        this(msgmgr, cfgmgr, colorpos, null);
    }

    public ResourceEditor(MessageManager msgmgr, ConfigManager cfgmgr, ColorPository colorpos, String config) {
        super(msgmgr, cfgmgr, colorpos, "resource");
        this.setSize(550, 600);
        SwingUtil.centerWindow((Window)this);
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu file = this.createMenu("file", 70);
        menubar.add(file);
        JMenu nmenu = this.createMenu("new", 78);
        file.add(nmenu);
        nmenu.add(this.createMenuItem("window", 87, 78));
        nmenu.addSeparator();
        file.add(this.createMenuItem("open", 79, 79));
        file.addSeparator();
        this._save = this.createMenuItem("save", 83, 83);
        file.add(this._save);
        this._save.setEnabled(false);
        this._saveAs = this.createMenuItem("save_as", 65, 65);
        file.add(this._saveAs);
        this._saveAs.setEnabled(false);
        this._revert = this.createMenuItem("revert", 82, 82);
        file.add(this._revert);
        this._revert.setEnabled(false);
        file.addSeparator();
        file.add(this.createMenuItem("import", 73, -1));
        this._export = this.createMenuItem("export", 69, -1);
        file.add(this._export);
        this._export.setEnabled(false);
        file.addSeparator();
        file.add(this.createMenuItem("close", 67, 87));
        file.add(this.createMenuItem("quit", 81, 81));
        JMenu edit = this.createMenu("edit", 69);
        menubar.add(edit);
        edit.add(this.createMenuItem("update", 85, 85));
        this.addFindMenu(edit);
        edit.addSeparator();
        edit.add(this.createMenuItem("configs", 67, 71));
        edit.add(this.createMenuItem("preferences", 80, 80));
        JMenu view = this.createMenu("view", 86);
        menubar.add(view);
        this._treeMode = ToolUtil.createCheckBoxMenuItem(this, this._msgs, "tree_mode", 84, -1);
        view.add(this._treeMode);
        JMenu tools = this.createMenu("tools", 84);
        menubar.add(tools);
        tools.add(this.createMenuItem("batch_validate", 66, -1));
        HashSet mnems = Sets.newHashSet();
        mnems.add(Character.valueOf('w'));
        int idx = 0;
        Class<?>[] classArray = cfgmgr.getResourceClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Class<?> clazz = classArray[n2];
            String label = this.getLabel(clazz, ConfigGroup.getName(clazz));
            JMenuItem item = new JMenuItem(label);
            int ii = 0;
            int nn = label.length();
            while (ii < nn) {
                char c = Character.toLowerCase(label.charAt(ii));
                if (Character.isLetter(c) && mnems.add(Character.valueOf(c))) {
                    item.setMnemonic(c);
                    break;
                }
                ++ii;
            }
            if (++idx <= 9) {
                item.setAccelerator(KeyStroke.getKeyStroke((int)Character.forDigit(idx, 10), 2));
            }
            nmenu.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ResourceEditor.this.newConfig(clazz);
                }
            });
            ++n2;
        }
        String url = _prefs.get("config_dir", System.getProperty("resource_dir"));
        if (url != null) {
            File currentFile = new File(url);
            File resourceDir = new File(System.getProperty("resource_dir"));
            if (!currentFile.getAbsolutePath().startsWith(resourceDir.getAbsolutePath())) {
                url = resourceDir.getAbsolutePath();
            }
        }
        this._chooser = new JFileChooser(url);
        this._chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file != null && file.toString() != null && (file.isDirectory() || file.toString().toLowerCase().endsWith(".dat"));
            }

            @Override
            public String getDescription() {
                return ResourceEditor.this._msgs.get("m.config_files");
            }
        });
        this._exportChooser = new JFileChooser(_prefs.get("export_dir", null));
        this._exportChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null || file.toString() == null) {
                    return false;
                }
                return file.isDirectory() || file.toString().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return ResourceEditor.this._msgs.get("m.xml_files");
            }
        });
        this._epanel = new EditorPanel((EditorContext)this, EditorPanel.CategoryMode.TABS, null);
        this.add((Component)((Object)this._epanel), "Center");
        this._epanel.addChangeListener(this);
        if (config != null) {
            this.open(new File(config));
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (!this._block.enter()) {
            return;
        }
        try {
            ManagedConfig config = (ManagedConfig)this._epanel.getObject();
            config.updateFromSource(this, false);
            config.wasUpdated();
        }
        finally {
            this._block.leave();
        }
    }

    @Override
    public void configUpdated(ConfigEvent<ManagedConfig> event) {
        if (!this._block.enter()) {
            return;
        }
        try {
            this._epanel.update();
        }
        finally {
            this._block.leave();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals("window")) {
            this.showFrame(new ResourceEditor(this._msgmgr, this._cfgmgr, this._colorpos));
        } else if (action.equals("open")) {
            this.open();
        } else if (action.equals("save")) {
            if (this._file != null) {
                this.save(this._file);
            } else {
                this.save();
            }
        } else if (action.equals("save_as")) {
            this.save();
        } else if (action.equals("revert")) {
            if (this.showCantUndo()) {
                this.open(this._file);
            }
        } else if (action.equals("import")) {
            this.importConfig();
        } else if (action.equals("export")) {
            this.exportConfig();
        } else if (action.equals("update")) {
            ManagedConfig config = (ManagedConfig)this._epanel.getObject();
            config.updateFromSource(this, true);
            config.wasUpdated();
        } else if (action.equals("configs")) {
            this.showFrame(new ConfigEditor(this._msgmgr, this.getConfigManager(), this._colorpos));
        } else if (action.equals("tree_mode")) {
            BaseEditorPanel opanel = this._epanel;
            this.remove((Component)((Object)opanel));
            this._epanel = this._treeMode.isSelected() ? new TreeEditorPanel(this) : new EditorPanel(this, EditorPanel.CategoryMode.TABS);
            this.add((Component)((Object)this._epanel), "Center");
            this._epanel.addChangeListener(this);
            this._epanel.setObject(opanel.getObject());
            this._epanel.revalidate();
        } else if (action.equals("batch_validate")) {
            new BatchValidateDialog(this, this, _prefs){

                @Override
                protected boolean validate(String path, PrintStream out) {
                    ManagedConfig config = ResourceEditor.this._cfgmgr.getResourceConfig(path);
                    return config == null || config.validateReferences(path, out);
                }
            }.setVisible(true);
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.setConfig(null, null);
    }

    @Override
    public ConfigManager getConfigManager() {
        Object config = this._epanel.getObject();
        return config instanceof ParameterizedConfig ? ((ParameterizedConfig)config).getConfigManager() : this._cfgmgr;
    }

    protected void newConfig(Class<?> clazz) {
        try {
            ManagedConfig config = (ManagedConfig)clazz.newInstance();
            config.init(this._cfgmgr);
            this.setConfig(config, null);
        }
        catch (Exception e) {
            ClydeLog.log.warning((Object)"Error creating config.", new Object[]{"class", clazz, e});
        }
    }

    protected void open() {
        if (this._chooser.showOpenDialog(this) == 0) {
            this.open(this._chooser.getSelectedFile());
        }
        _prefs.put("config_dir", this._chooser.getCurrentDirectory().toString());
    }

    protected void open(File file) {
        ManagedConfig config;
        try {
            BinaryImporter in = new BinaryImporter(new FileInputStream(file));
            config = (ManagedConfig)in.readObject();
            config.init(this._cfgmgr);
            in.close();
        }
        catch (IOException e) {
            ClydeLog.log.warning((Object)("Failed to open config [file=" + file + "]."), new Object[]{e});
            return;
        }
        String path = this._rsrcmgr.getResourcePath(file);
        if (path != null) {
            config.setName(path);
            config = this._cfgmgr.updateResourceConfig(path, config);
        }
        this.setConfig(config, file);
    }

    protected void save() {
        if (this._chooser.showSaveDialog(this) == 0) {
            this.save(this._chooser.getSelectedFile());
        }
        _prefs.put("config_dir", this._chooser.getCurrentDirectory().toString());
    }

    protected void save(File file) {
        ManagedConfig config = (ManagedConfig)this._epanel.getObject();
        String oname = config.getName();
        config.setName(null);
        try {
            try {
                BinaryExporter out = new BinaryExporter(new FileOutputStream(file));
                out.writeObject(config);
                out.close();
            }
            catch (IOException e) {
                ClydeLog.log.warning((Object)("Failed to save config [file=" + file + "]."), new Object[]{e});
                config.setName(oname);
                return;
            }
        }
        finally {
            config.setName(oname);
        }
        String opath = this._file == null ? null : this._rsrcmgr.getResourcePath(this._file);
        String npath = this._rsrcmgr.getResourcePath(file);
        if (!Objects.equal((Object)opath, (Object)npath)) {
            if (opath != null) {
                config = (ManagedConfig)config.clone();
                config.init(this._cfgmgr);
            }
            if (npath != null) {
                config.setName(npath);
                config = this._cfgmgr.updateResourceConfig(npath, config);
            }
        }
        this.setConfig(config, file);
    }

    protected void importConfig() {
        if (this._exportChooser.showOpenDialog(this) == 0) {
            File file = this._exportChooser.getSelectedFile();
            try {
                XMLImporter in = new XMLImporter(new FileInputStream(file));
                ManagedConfig config = (ManagedConfig)in.readObject();
                config.init(this._cfgmgr);
                this.setConfig(config, null);
                in.close();
            }
            catch (IOException e) {
                ClydeLog.log.warning((Object)("Failed to import config [file=" + file + "]."), new Object[]{e});
            }
        }
        _prefs.put("export_dir", this._exportChooser.getCurrentDirectory().toString());
    }

    protected void exportConfig() {
        block6: {
            if (this._exportChooser.showSaveDialog(this) == 0) {
                File file = this._exportChooser.getSelectedFile();
                ManagedConfig config = (ManagedConfig)this._epanel.getObject();
                String oname = config.getName();
                config.setName(null);
                try {
                    try {
                        XMLExporter out = new XMLExporter(new FileOutputStream(file));
                        out.writeObject(config);
                        out.close();
                    }
                    catch (IOException e) {
                        ClydeLog.log.warning((Object)("Failed to export config [file=" + file + "]."), new Object[]{e});
                        config.setName(oname);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    config.setName(oname);
                    throw throwable;
                }
                config.setName(oname);
            }
        }
        _prefs.put("export_dir", this._exportChooser.getCurrentDirectory().toString());
    }

    protected void setConfig(ManagedConfig config, File file) {
        boolean enable;
        ManagedConfig oconfig = (ManagedConfig)this._epanel.getObject();
        if (oconfig != null) {
            oconfig.removeListener(this);
        }
        this._epanel.setObject(config);
        boolean bl = enable = config != null;
        if (enable) {
            config.addListener(this);
        }
        this._file = file;
        this._save.setEnabled(enable);
        this._saveAs.setEnabled(enable);
        this._revert.setEnabled(file != null);
        this._export.setEnabled(enable);
        this.setTitle(String.valueOf(this._msgs.get("m.title")) + (file == null ? "" : ": " + file));
    }

    protected boolean showCantUndo() {
        return JOptionPane.showConfirmDialog(this, this._msgs.get("m.cant_undo"), this._msgs.get("t.cant_undo"), 2, 2) == 0;
    }

    @Override
    protected BaseEditorPanel getFindEditorPanel() {
        return this._epanel;
    }
}

