/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.util.ArrayUtil;
import com.threerings.math.FloatMath;

public class NoiseUtil {
    protected static final int PERMUTATION_BITS = 8;
    protected static final int PERMUTATION_COUNT = 256;
    protected static final int PERMUTATION_MASK = 255;
    protected static final int GRADIENT_MASK = 15;
    protected static final int[] PERMUTATIONS = new int[512];

    static {
        int ii = 0;
        while (ii < 256) {
            NoiseUtil.PERMUTATIONS[ii] = ii;
            ++ii;
        }
        ArrayUtil.shuffle((int[])PERMUTATIONS, (int)0, (int)256);
        System.arraycopy(PERMUTATIONS, 0, PERMUTATIONS, 256, 256);
    }

    public static float getNoise(float x) {
        int x0 = FloatMath.ifloor(x);
        x -= (float)x0;
        return FloatMath.lerp(NoiseUtil.grad(PERMUTATIONS[x0 &= 0xFF], x), NoiseUtil.grad(PERMUTATIONS[x0 + 1], x - 1.0f), NoiseUtil.ease(x));
    }

    public static float getNoise(float x, int y) {
        int x0 = FloatMath.ifloor(x);
        x -= (float)x0;
        return FloatMath.lerp(NoiseUtil.grad(PERMUTATIONS[PERMUTATIONS[x0 &= 0xFF] + (y &= 0xFF)], x), NoiseUtil.grad(PERMUTATIONS[PERMUTATIONS[x0 + 1] + y], x - 1.0f), NoiseUtil.ease(x));
    }

    public static float getNoise(float x, float y) {
        int x0 = FloatMath.ifloor(x);
        int y0 = FloatMath.ifloor(y);
        x -= (float)x0;
        y -= (float)y0;
        int y1 = (y0 &= 0xFF) + 1;
        int p0 = PERMUTATIONS[x0 &= 0xFF];
        int p1 = PERMUTATIONS[x0 + 1];
        float xm1 = x - 1.0f;
        float ym1 = y - 1.0f;
        float s = NoiseUtil.ease(x);
        return FloatMath.lerp(FloatMath.lerp(NoiseUtil.grad(PERMUTATIONS[p0 + y0], x, y), NoiseUtil.grad(PERMUTATIONS[p1 + y0], xm1, y), s), FloatMath.lerp(NoiseUtil.grad(PERMUTATIONS[p0 + y1], x, ym1), NoiseUtil.grad(PERMUTATIONS[p1 + y1], xm1, ym1), s), NoiseUtil.ease(y));
    }

    public static float getNoise(float x, float y, int z) {
        int x0 = FloatMath.ifloor(x);
        int y0 = FloatMath.ifloor(y);
        x -= (float)x0;
        y -= (float)y0;
        z &= 0xFF;
        int y1 = (y0 &= 0xFF) + 1;
        int p0 = PERMUTATIONS[x0 &= 0xFF];
        int p1 = PERMUTATIONS[x0 + 1];
        float xm1 = x - 1.0f;
        float ym1 = y - 1.0f;
        float s = NoiseUtil.ease(x);
        return FloatMath.lerp(FloatMath.lerp(NoiseUtil.grad(PERMUTATIONS[PERMUTATIONS[p0 + y0] + z], x, y), NoiseUtil.grad(PERMUTATIONS[PERMUTATIONS[p1 + y0] + z], xm1, y), s), FloatMath.lerp(NoiseUtil.grad(PERMUTATIONS[PERMUTATIONS[p0 + y1] + z], x, ym1), NoiseUtil.grad(PERMUTATIONS[PERMUTATIONS[p1 + y1] + z], xm1, ym1), s), NoiseUtil.ease(y));
    }

    public static float getNoise(float x, float y, float z) {
        int x0 = FloatMath.ifloor(x);
        int y0 = FloatMath.ifloor(y);
        int z0 = FloatMath.ifloor(z);
        x -= (float)x0;
        y -= (float)y0;
        z -= (float)z0;
        int y1 = (y0 &= 0xFF) + 1;
        int z1 = (z0 &= 0xFF) + 1;
        int p0 = PERMUTATIONS[x0 &= 0xFF];
        int p1 = PERMUTATIONS[x0 + 1];
        int p00 = PERMUTATIONS[p0 + y0];
        int p10 = PERMUTATIONS[p1 + y0];
        int p01 = PERMUTATIONS[p0 + y1];
        int p11 = PERMUTATIONS[p1 + y1];
        float xm1 = x - 1.0f;
        float ym1 = y - 1.0f;
        float zm1 = z - 1.0f;
        float s = NoiseUtil.ease(x);
        float t = NoiseUtil.ease(y);
        return FloatMath.lerp(FloatMath.lerp(FloatMath.lerp(NoiseUtil.grad(PERMUTATIONS[p00 + z0], x, y, z), NoiseUtil.grad(PERMUTATIONS[p10 + z0], xm1, y, z), s), FloatMath.lerp(NoiseUtil.grad(PERMUTATIONS[p01 + z0], x, ym1, z), NoiseUtil.grad(PERMUTATIONS[p11 + z0], xm1, ym1, z), s), t), FloatMath.lerp(FloatMath.lerp(NoiseUtil.grad(PERMUTATIONS[p00 + z1], x, y, zm1), NoiseUtil.grad(PERMUTATIONS[p10 + z1], xm1, y, zm1), s), FloatMath.lerp(NoiseUtil.grad(PERMUTATIONS[p01 + z1], x, ym1, zm1), NoiseUtil.grad(PERMUTATIONS[p11 + z1], xm1, ym1, zm1), s), t), NoiseUtil.ease(z));
    }

    protected static float grad(int hash, float x) {
        switch (hash & 0xF) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 12: {
                return x;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: {
                return -x;
            }
        }
        return 0.0f;
    }

    protected static float grad(int hash, float x, float y) {
        switch (hash & 0xF) {
            case 0: 
            case 12: {
                return x + y;
            }
            case 1: 
            case 13: {
                return y - x;
            }
            case 2: {
                return x - y;
            }
            case 3: {
                return -x - y;
            }
            case 4: 
            case 6: {
                return x;
            }
            case 5: 
            case 7: {
                return -x;
            }
            case 8: 
            case 10: {
                return y;
            }
            case 9: 
            case 11: 
            case 14: 
            case 15: {
                return -y;
            }
        }
        return 0.0f;
    }

    protected static float grad(int hash, float x, float y, float z) {
        switch (hash & 0xF) {
            case 0: 
            case 12: {
                return x + y;
            }
            case 1: 
            case 13: {
                return y - x;
            }
            case 2: {
                return x - y;
            }
            case 3: {
                return -x - y;
            }
            case 4: {
                return x + z;
            }
            case 5: {
                return z - x;
            }
            case 6: {
                return x - z;
            }
            case 7: {
                return -x - z;
            }
            case 8: {
                return y + z;
            }
            case 9: 
            case 14: {
                return z - y;
            }
            case 10: {
                return y - z;
            }
            case 11: 
            case 15: {
                return -y - z;
            }
        }
        return 0.0f;
    }

    protected static float ease(float t) {
        return t * t * t * (t * (6.0f * t - 15.0f) + 10.0f);
    }
}

