/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.threerings.tudey.data.InputFrame;
import com.threerings.tudey.server.ClientLiaison;
import com.threerings.tudey.server.logic.ActiveLogic;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.PawnAdvancer;
import com.threerings.util.ArrayDeque;

public class PawnLogic
extends ActiveLogic {
    protected PawnAdvancer _advancer;
    protected ClientLiaison _client;
    protected ArrayDeque<InputFrame> _input = new ArrayDeque(4);

    public void bodyEntered(ClientLiaison client) {
        this._client = client;
    }

    public void enqueueInput(InputFrame frame) {
        this._input.addLast(frame);
    }

    public int getControlDelta() {
        return this._client == null ? 0 : this._client.getControlDelta();
    }

    public ClientLiaison getClient() {
        return this._client;
    }

    public boolean isPlayer() {
        return this._client != null;
    }

    @Override
    public int getActivityAdvance() {
        return this.getControlDelta() / 2;
    }

    @Override
    public boolean tick(int timestamp) {
        boolean newInput = false;
        while (!this._input.isEmpty() && this._input.peekFirst().getTimestamp() <= timestamp) {
            InputFrame frame = this._input.pollFirst();
            if (frame.getTargetPoint() != null) {
                frame.setPath(this._scenemgr.getPathfinder().getPath(this, 1000.0f, frame.getTargetPoint().x, frame.getTargetPoint().y, true, true));
            }
            this._advancer.advance(frame);
            newInput = true;
        }
        if (!newInput && !this._advancer.inputFrameCompeleted()) {
            this._advancer.advance(timestamp);
        }
        return super.tick(timestamp);
    }

    @Override
    protected ActorAdvancer createAdvancer() {
        this._advancer = (PawnAdvancer)this._actor.createAdvancer(this, this._actor.getCreated());
        return this._advancer;
    }
}

