/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.threerings.crowd.data.BodyObject;
import com.threerings.presents.server.InvocationManager;
import com.threerings.tudey.server.TudeySceneRegistry;
import com.threerings.tudey.server.TudeyZoneMoveHandler;
import com.threerings.whirled.zone.client.ZoneService;
import com.threerings.whirled.zone.data.ZonedBodyObject;
import com.threerings.whirled.zone.server.ZoneManager;
import com.threerings.whirled.zone.server.ZoneMoveHandler;
import com.threerings.whirled.zone.server.ZoneRegistry;

@Singleton
public class TudeyZoneRegistry
extends ZoneRegistry {
    @Inject
    protected TudeySceneRegistry _tscreg;

    @Inject
    public TudeyZoneRegistry(InvocationManager invmgr) {
        super(invmgr);
    }

    public String moveBody(ZonedBodyObject source, int zoneId, int sceneId, Object portalKey) {
        this._tscreg.addPortalMapping((BodyObject)source, sceneId, portalKey);
        return this.moveBody(source, zoneId, sceneId);
    }

    protected ZoneMoveHandler createZoneMoveHandler(ZoneManager zmgr, BodyObject body, int sceneId, int sceneVer, ZoneService.ZoneMoveListener listener) {
        Object portalKey = this._tscreg.removePortalMapping(body, sceneId);
        return this.createZoneMoveHandler(zmgr, body, sceneId, sceneVer, portalKey, listener);
    }

    protected ZoneMoveHandler createZoneMoveHandler(ZoneManager zmgr, BodyObject body, int sceneId, int sceneVer, Object portalKey, ZoneService.ZoneMoveListener listener) {
        return new TudeyZoneMoveHandler(this._locman, zmgr, this._screg, body, sceneId, sceneVer, portalKey, listener);
    }
}

