/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.samskivert.util.RandomUtil;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.BooleanExpression;
import com.threerings.expr.Executor;
import com.threerings.expr.Function;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.FloatMath;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.openal.Sounder;
import com.threerings.openal.config.SounderConfig;
import com.threerings.openal.util.AlContext;
import com.threerings.opengl.camera.CameraHandler;
import com.threerings.opengl.model.Articulated;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;

@EditorTypes(value={CallFunction.class, SpawnTransient.class, PlaySound.class, ShakeCamera.class, Conditional.class, Compound.class, Random.class})
public abstract class ActionConfig
extends DeepObject
implements Exportable {
    public abstract Executor createExecutor(GlContext var1, Scope var2);

    public static class CallFunction
    extends ActionConfig {
        @Editable
        public String name = "";

        @Override
        public Executor createExecutor(GlContext ctx, Scope scope) {
            final Function fn = ScopeUtil.resolve(scope, this.name, Function.NULL);
            return new Executor(){

                @Override
                public void execute() {
                    fn.call(new Object[0]);
                }
            };
        }
    }

    public static class Case
    extends DeepObject
    implements Exportable {
        @Editable
        public BooleanExpression condition = new BooleanExpression.Constant(true);
        @Editable
        public ActionConfig action = new CallFunction();
    }

    public static class Compound
    extends ActionConfig {
        @Editable
        public ActionConfig[] actions = new ActionConfig[0];

        @Override
        public Executor createExecutor(GlContext ctx, Scope scope) {
            final Executor[] executors = new Executor[this.actions.length];
            int ii = 0;
            while (ii < this.actions.length) {
                executors[ii] = this.actions[ii].createExecutor(ctx, scope);
                ++ii;
            }
            return new Executor(){

                @Override
                public void execute() {
                    Executor[] executorArray = executors;
                    int n = executors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Executor executor = executorArray[n2];
                        executor.execute();
                        ++n2;
                    }
                }
            };
        }
    }

    public static class Conditional
    extends ActionConfig {
        @Editable
        public Case[] cases = new Case[0];
        @Editable
        public ActionConfig defaultAction = new CallFunction();

        @Override
        public Executor createExecutor(GlContext ctx, Scope scope) {
            final BooleanExpression.Evaluator[] evaluators = new BooleanExpression.Evaluator[this.cases.length];
            final Executor[] executors = new Executor[this.cases.length];
            int ii = 0;
            while (ii < this.cases.length) {
                Case caze = this.cases[ii];
                evaluators[ii] = caze.condition.createEvaluator(scope);
                executors[ii] = caze.action.createExecutor(ctx, scope);
                ++ii;
            }
            final Executor defaultExecutor = this.defaultAction.createExecutor(ctx, scope);
            return new Executor(){

                @Override
                public void execute() {
                    int ii = 0;
                    while (ii < Conditional.this.cases.length) {
                        if (evaluators[ii].evaluate()) {
                            executors[ii].execute();
                            return;
                        }
                        ++ii;
                    }
                    defaultExecutor.execute();
                }
            };
        }
    }

    public static class PlaySound
    extends ActionConfig {
        @Editable(nullable=true)
        public ConfigReference<SounderConfig> sounder;
        @Editable
        public String node = "";
        @Editable(step=0.01)
        public Transform3D transform = new Transform3D();

        @Override
        public Executor createExecutor(GlContext ctx, Scope scope) {
            Articulated.Node node = (Articulated.Node)ScopeUtil.call(scope, "getNode", this.node);
            final Transform3D parent = node == null ? ScopeUtil.resolve(scope, "worldTransform", new Transform3D()) : node.getWorldTransform();
            final Transform3D world = new Transform3D();
            final Sounder sounder = new Sounder((AlContext)ctx, scope, world, this.sounder);
            return new Executor(){

                @Override
                public void execute() {
                    parent.compose(PlaySound.this.transform, world);
                    sounder.start();
                }
            };
        }
    }

    public static class Random
    extends ActionConfig {
        @Editable
        public WeightedAction[] actions = new WeightedAction[0];

        @Override
        public Executor createExecutor(GlContext ctx, Scope scope) {
            final float[] weights = new float[this.actions.length];
            final Executor[] executors = new Executor[this.actions.length];
            int ii = 0;
            while (ii < this.actions.length) {
                WeightedAction waction = this.actions[ii];
                weights[ii] = waction.weight;
                executors[ii] = waction.action.createExecutor(ctx, scope);
                ++ii;
            }
            return new Executor(){

                @Override
                public void execute() {
                    executors[RandomUtil.getWeightedIndex((float[])weights)].execute();
                }
            };
        }
    }

    public static class ShakeCamera
    extends ActionConfig {
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float frequency = 50.0f;
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float falloff = 30.0f;
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float duration = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="r")
        public float innerRadius = 10.0f;
        @Editable(min=0.0, step=0.01, hgroup="r")
        public float outerRadius = 100.0f;
        @Editable(step=0.01)
        public Vector3f amplitude = new Vector3f(Vector3f.UNIT_Z);

        @Override
        public Executor createExecutor(final GlContext ctx, Scope scope) {
            final Transform3D transform = ScopeUtil.resolve(scope, "worldTransform", new Transform3D());
            return new Executor(){
                protected Vector3f _translation = new Vector3f();

                @Override
                public void execute() {
                    transform.extractTranslation(this._translation);
                    CameraHandler camhand = ctx.getCameraHandler();
                    float dist = camhand.getViewerTranslation().distance(this._translation);
                    if (dist <= ShakeCamera.this.outerRadius) {
                        float scale = dist <= ShakeCamera.this.innerRadius ? 1.0f : 1.0f - (dist - ShakeCamera.this.innerRadius) / (ShakeCamera.this.outerRadius - ShakeCamera.this.innerRadius);
                        camhand.addOffset(ShakeCamera.this.createOffset(scale));
                    }
                }
            };
        }

        protected CameraHandler.Offset createOffset(final float scale) {
            return new CameraHandler.Offset(){
                protected long _start = System.currentTimeMillis();

                @Override
                public boolean apply(Transform3D transform) {
                    float elapsed = (float)(System.currentTimeMillis() - this._start) / 1000.0f;
                    transform.getTranslation().addScaledLocal(ShakeCamera.this.amplitude, scale * FloatMath.exp(-ShakeCamera.this.falloff * elapsed) * FloatMath.sin(ShakeCamera.this.frequency * elapsed));
                    return elapsed < ShakeCamera.this.duration;
                }
            };
        }
    }

    public static class SpawnTransient
    extends ActionConfig {
        @Editable
        public boolean moveWithOrigin;
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
        @Editable
        public String node = "";
        @Editable(step=0.01)
        public Transform3D transform = new Transform3D();

        @Override
        public Executor createExecutor(GlContext ctx, Scope scope) {
            Model instance = (Model)ScopeUtil.call(scope, "getFromTransientPool", this.model);
            ScopeUtil.call(scope, "returnToTransientPool", instance);
            final Function spawnTransient = ScopeUtil.resolve(scope, "spawnTransient", Function.NULL);
            Articulated.Node node = (Articulated.Node)ScopeUtil.call(scope, "getNode", this.node);
            final Transform3D parent = node == null ? ScopeUtil.resolve(scope, "worldTransform", new Transform3D()) : node.getWorldTransform();
            return new Executor(instance){
                protected Transform3D _world = new Transform3D();
                protected Model _instance;
                {
                    this._instance = model;
                }

                @Override
                public void execute() {
                    final Scene.Transient spawned = (Scene.Transient)spawnTransient.call(SpawnTransient.this.model, parent.compose(SpawnTransient.this.transform, this._world));
                    if (SpawnTransient.this.moveWithOrigin && spawned != null) {
                        spawned.setUpdater(new Updater(){

                            @Override
                            public void update() {
                                spawned.setLocalTransform(parent.compose((this).SpawnTransient.this.transform, _world));
                            }
                        });
                    }
                }
            };
        }
    }

    public static class WeightedAction
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float weight = 1.0f;
        @Editable
        public ActionConfig action = new CallFunction();
    }
}

