/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.math.Matrix3f;
import com.threerings.math.Quaternion;
import com.threerings.math.Vector3f;
import com.threerings.opengl.effect.BaseParticleSystem;
import com.threerings.opengl.effect.Influence;
import com.threerings.opengl.effect.Particle;
import com.threerings.util.DeepObject;
import com.threerings.util.NoiseUtil;

@EditorTypes(value={Gravity.class, Wind.class, LinearDrag.class, QuadraticDrag.class, CylindricalVortex.class, ToroidalVortex.class, Wander.class, Jitter.class, AngularAcceleration.class})
public abstract class InfluenceConfig
extends DeepObject
implements Exportable {
    public abstract Influence createInfluence(BaseParticleSystem.Layer var1);

    public static class AngularAcceleration
    extends InfluenceConfig {
        @Editable(scale=0.017453292519943295)
        public Vector3f acceleration = new Vector3f();

        @Override
        public Influence createInfluence(BaseParticleSystem.Layer layer) {
            return new Influence(){
                protected Vector3f _delta = new Vector3f();

                @Override
                public void tick(float elapsed) {
                    AngularAcceleration.this.acceleration.mult(elapsed, this._delta);
                }

                @Override
                public void apply(Particle particle) {
                    particle.getAngularVelocity().addLocal(this._delta);
                }
            };
        }
    }

    public static class CylindricalVortex
    extends InfluenceConfig {
        @Editable(mode="normalized")
        public Vector3f axis = new Vector3f(0.0f, 0.0f, 1.0f);
        @Editable(step=0.01)
        public float strength = 2.0f;
        @Editable(min=-90.0, max=90.0, scale=0.017453292519943295)
        public float divergence;
        @Editable
        public boolean rotateWithEmitter;

        @Override
        public Influence createInfluence(final BaseParticleSystem.Layer layer) {
            return new Influence(){
                protected float _delta;
                protected Vector3f _torigin = new Vector3f();
                protected Vector3f _taxis = new Vector3f();
                protected Vector3f _vector = new Vector3f();
                protected Matrix3f _rotation = new Matrix3f();

                @Override
                public void tick(float elapsed) {
                    this._delta = CylindricalVortex.this.strength * elapsed;
                    layer.pointToLayer(this._torigin.set(Vector3f.ZERO), true);
                    layer.vectorToLayer(this._taxis.set(CylindricalVortex.this.axis), CylindricalVortex.this.rotateWithEmitter);
                    this._rotation.setToRotation(-CylindricalVortex.this.divergence, this._taxis);
                }

                @Override
                public void apply(Particle particle) {
                    this._taxis.cross(particle.getPosition().subtract(this._torigin, this._vector), this._vector);
                    float length = this._vector.length();
                    if (length < 1.0E-6f) {
                        return;
                    }
                    particle.getVelocity().addLocal(this._rotation.transformLocal(this._vector.multLocal(this._delta / length)));
                }
            };
        }
    }

    public static class Gravity
    extends InfluenceConfig {
        @Editable(step=0.1)
        public Vector3f acceleration = new Vector3f(0.0f, 0.0f, -1.0f);
        @Editable
        public boolean rotateWithEmitter;

        @Override
        public Influence createInfluence(final BaseParticleSystem.Layer layer) {
            return new Influence(){
                protected Vector3f _delta = new Vector3f();

                @Override
                public void tick(float elapsed) {
                    layer.vectorToLayer(Gravity.this.acceleration.mult(elapsed, this._delta), Gravity.this.rotateWithEmitter);
                }

                @Override
                public void apply(Particle particle) {
                    particle.getVelocity().addLocal(this._delta);
                }
            };
        }
    }

    public static class Jitter
    extends InfluenceConfig {
        @Editable(min=0.0, step=0.01)
        public float frequency = 5.0f;
        @Editable(min=0.0, step=0.01)
        public float strength = 0.02f;

        @Override
        public Influence createInfluence(BaseParticleSystem.Layer layer) {
            return new Influence(){
                protected float _time;
                protected float _sstrength;

                @Override
                public void tick(float elapsed) {
                    this._time += elapsed * Jitter.this.frequency;
                    this._sstrength = Jitter.this.strength * elapsed * 60.0f;
                }

                @Override
                public void apply(Particle particle) {
                    int pid = System.identityHashCode(particle);
                    float time = this._time + (float)(pid & 0xFF) / 256.0f;
                    particle.getPosition().addLocal(NoiseUtil.getNoise(time, pid) * this._sstrength, NoiseUtil.getNoise(time, pid + 1) * this._sstrength, NoiseUtil.getNoise(time, pid + 2) * this._sstrength);
                }
            };
        }
    }

    public static class LinearDrag
    extends InfluenceConfig {
        @Editable(min=0.0, step=0.01)
        public float amount = 1.0f;

        @Override
        public Influence createInfluence(BaseParticleSystem.Layer layer) {
            return new Influence(){
                protected float _drag;

                @Override
                public void tick(float elapsed) {
                    this._drag = Math.max(0.0f, 1.0f - LinearDrag.this.amount * elapsed);
                }

                @Override
                public void apply(Particle particle) {
                    particle.getVelocity().multLocal(this._drag);
                }
            };
        }
    }

    public static class QuadraticDrag
    extends InfluenceConfig {
        @Editable(min=0.0, step=0.01)
        public float amount = 1.0f;

        @Override
        public Influence createInfluence(BaseParticleSystem.Layer layer) {
            return new Influence(){
                protected float _drag;

                @Override
                public void tick(float elapsed) {
                    this._drag = QuadraticDrag.this.amount * elapsed;
                }

                @Override
                public void apply(Particle particle) {
                    Vector3f velocity = particle.getVelocity();
                    velocity.multLocal(Math.max(0.0f, 1.0f - this._drag * velocity.length()));
                }
            };
        }
    }

    public static class ToroidalVortex
    extends InfluenceConfig {
        @Editable(mode="normalized")
        public Vector3f axis = new Vector3f(0.0f, 0.0f, 1.0f);
        @Editable(step=0.01)
        public float height = 1.0f;
        @Editable(min=0.0, step=0.01)
        public float radius = 1.0f;
        @Editable(step=0.01)
        public float strength = 2.0f;
        @Editable(min=-90.0, max=90.0, scale=0.017453292519943295)
        public float divergence;
        @Editable
        public boolean rotateWithEmitter;

        @Override
        public Influence createInfluence(final BaseParticleSystem.Layer layer) {
            return new Influence(){
                protected float _delta;
                protected Vector3f _torigin = new Vector3f();
                protected Vector3f _taxis = new Vector3f();
                protected Vector3f _position = new Vector3f();
                protected Vector3f _tangent = new Vector3f();
                protected Vector3f _vector = new Vector3f();
                protected Quaternion _rotation = new Quaternion();

                @Override
                public void tick(float elapsed) {
                    this._delta = ToroidalVortex.this.strength * elapsed;
                    layer.pointToLayer(this._torigin.set(Vector3f.ZERO), true);
                    layer.vectorToLayer(this._taxis.set(ToroidalVortex.this.axis), ToroidalVortex.this.rotateWithEmitter);
                }

                @Override
                public void apply(Particle particle) {
                    particle.getPosition().subtract(this._torigin, this._position);
                    this._taxis.cross(this._position, this._tangent);
                    float length = this._tangent.length();
                    if (length < 1.0E-6f) {
                        return;
                    }
                    this._tangent.multLocal(1.0f / length);
                    this._tangent.cross(this._taxis, this._vector);
                    this._vector.multLocal(ToroidalVortex.this.radius).addScaledLocal(this._taxis, ToroidalVortex.this.height).subtractLocal(this._position);
                    length = this._vector.length();
                    if (length < 1.0E-6f) {
                        return;
                    }
                    this._vector.multLocal(1.0f / length);
                    this._rotation.fromAngleAxis(-ToroidalVortex.this.divergence, this._tangent);
                    particle.getVelocity().addLocal(this._rotation.transformLocal(this._vector.crossLocal(this._tangent).multLocal(this._delta)));
                }
            };
        }
    }

    public static class Wander
    extends InfluenceConfig {
        @Editable(min=0.0, step=0.01)
        public float frequency = 2.0f;
        @Editable(min=0.0, step=0.01)
        public float strength = 0.05f;

        @Override
        public Influence createInfluence(BaseParticleSystem.Layer layer) {
            return new Influence(){
                protected float _time;
                protected float _sstrength;

                @Override
                public void tick(float elapsed) {
                    this._time += elapsed * Wander.this.frequency;
                    this._sstrength = Wander.this.strength * elapsed * 60.0f;
                }

                @Override
                public void apply(Particle particle) {
                    int pid = System.identityHashCode(particle);
                    float time = this._time + (float)(pid & 0xFF) / 256.0f;
                    particle.getVelocity().addLocal(NoiseUtil.getNoise(time, pid) * this._sstrength, NoiseUtil.getNoise(time, pid + 1) * this._sstrength, NoiseUtil.getNoise(time, pid + 2) * this._sstrength);
                }
            };
        }
    }

    public static class Wind
    extends InfluenceConfig {
        @Editable(mode="normalized")
        public Vector3f direction = new Vector3f(1.0f, 0.0f, 0.0f);
        @Editable(min=0.0, step=0.01)
        public float strength = 2.0f;
        @Editable
        public boolean rotateWithEmitter;

        @Override
        public Influence createInfluence(final BaseParticleSystem.Layer layer) {
            return new Influence(){
                protected Vector3f _delta = new Vector3f();

                @Override
                public void tick(float elapsed) {
                    layer.vectorToLayer(Wind.this.direction.mult(Wind.this.strength * elapsed, this._delta), Wind.this.rotateWithEmitter);
                }

                @Override
                public void apply(Particle particle) {
                    particle.getVelocity().addLocal(this._delta);
                }
            };
        }
    }
}

