/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util.function;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;

public interface Consumer<T> {
    public void accept(T var1);

    public static class Common {
        private Common() {
        }

        public static <T> Consumer<T> adapt(final Collection<? super T> collection) {
            return new Consumer<T>(){

                @Override
                public void accept(T t) {
                    collection.add(t);
                }
            };
        }

        public static <T, A> Consumer<T> transform(Consumer<A> consumer, final Function<? super T, ? extends A> func) {
            return new Consumer<T>(){

                @Override
                public void accept(T t) {
                    Consumer.this.accept(func.apply(t));
                }
            };
        }

        public static <T> Consumer<T> filter(final Consumer<T> consumer, final Predicate<? super T> pred) {
            return new Consumer<T>(){

                @Override
                public void accept(T t) {
                    if (pred.apply(t)) {
                        consumer.accept(t);
                    }
                }
            };
        }
    }
}

