/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.compositor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.ComparableArrayList;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMaps;
import com.threerings.opengl.compositor.config.RenderQueueConfig;
import com.threerings.opengl.renderer.Batch;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RenderQueue
implements Comparable<RenderQueue> {
    public static final String OPAQUE = "Opaque";
    public static final String TRANSPARENT = "Transparent";
    public static final String OVERLAY = "Overlay";
    public static final String NORMAL_TYPE = "normal";
    protected GlContext _ctx;
    protected RenderQueueConfig _config;
    protected HashIntMap<PriorityList> _priorities = IntMaps.newHashIntMap();
    protected ComparableArrayList<PriorityList> _lists = new ComparableArrayList();
    protected HashIntMap<GroupBatch> _groups = IntMaps.newHashIntMap();
    protected ArrayList<GroupBatch> _batches = Lists.newArrayList();

    public RenderQueue(GlContext ctx, String name) {
        this._ctx = ctx;
        this._config = ctx.getConfigManager().getConfig(RenderQueueConfig.class, name);
        if (this._config == null) {
            this._config = new RenderQueueConfig();
        }
    }

    public void add(Batch batch) {
        this.add(batch, 0);
    }

    public void add(Batch batch, int priority) {
        PriorityList list = (PriorityList)this._priorities.get(priority);
        if (list == null) {
            list = new PriorityList(priority);
            this._priorities.put(priority, (Object)list);
            this._lists.insertSorted((Comparable)list);
        }
        list.add(batch);
    }

    public Group getGroup(int group) {
        GroupBatch batch = (GroupBatch)this._groups.get(group);
        if (batch == null) {
            batch = new GroupBatch(this._ctx);
            this._groups.put(group, (Object)batch);
            this._batches.add(batch);
        }
        return batch.group;
    }

    public void sort() {
        int ii = 0;
        int nn = this._batches.size();
        while (ii < nn) {
            GroupBatch batch = this._batches.get(ii);
            if (batch.update()) {
                this.add(batch);
            }
            ++ii;
        }
        ii = 0;
        nn = this._lists.size();
        while (ii < nn) {
            this._config.sortMode.sort((List)this._lists.get(ii));
            ++ii;
        }
    }

    public boolean isEmpty() {
        int ii = 0;
        int nn = this._lists.size();
        while (ii < nn) {
            if (!((PriorityList)this._lists.get(ii)).isEmpty()) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public void render() {
        this._config.renderMode.render(this._ctx, this);
    }

    public void clear() {
        int ii = 0;
        int nn = this._lists.size();
        while (ii < nn) {
            ((PriorityList)this._lists.get(ii)).clear();
            ++ii;
        }
        ii = 0;
        nn = this._batches.size();
        while (ii < nn) {
            this._batches.get((int)ii).group.clearQueues();
            ++ii;
        }
    }

    public void renderLists(Renderer renderer) {
        int ii = 0;
        int nn = this._lists.size();
        while (ii < nn) {
            renderer.render((List)this._lists.get(ii));
            ++ii;
        }
    }

    @Override
    public int compareTo(RenderQueue other) {
        return this._config.priority - other._config.priority;
    }

    public static class Group {
        protected GlContext _ctx;
        protected HashMap<String, RenderQueue> _queuesByName = Maps.newHashMap();
        protected ComparableArrayList<RenderQueue> _queues = new ComparableArrayList();

        public Group(GlContext ctx) {
            this._ctx = ctx;
        }

        public RenderQueue getQueue(String name) {
            RenderQueue queue = this._queuesByName.get(name);
            if (queue == null) {
                queue = new RenderQueue(this._ctx, name);
                this._queuesByName.put(name, queue);
                this._queues.insertSorted((Comparable)queue);
            }
            return queue;
        }

        public void sortQueues() {
            int ii = 0;
            int nn = this._queues.size();
            while (ii < nn) {
                ((RenderQueue)this._queues.get(ii)).sort();
                ++ii;
            }
        }

        public void renderQueues() {
            int ii = 0;
            int nn = this._queues.size();
            while (ii < nn) {
                ((RenderQueue)this._queues.get(ii)).render();
                ++ii;
            }
        }

        public void renderQueues(String type) {
            int ii = 0;
            int nn = this._queues.size();
            while (ii < nn) {
                RenderQueue queue = (RenderQueue)this._queues.get(ii);
                if (queue._config.type.equals(type)) {
                    queue.render();
                }
                ++ii;
            }
        }

        public void renderQueues(String type, int minPriority, int maxPriority) {
            int ii = 0;
            int nn = this._queues.size();
            while (ii < nn) {
                RenderQueue queue = (RenderQueue)this._queues.get(ii);
                RenderQueueConfig config = queue._config;
                if (config.type.equals(type) && config.priority >= minPriority && config.priority <= maxPriority) {
                    queue.render();
                }
                ++ii;
            }
        }

        public void clearQueues() {
            int ii = 0;
            int nn = this._queues.size();
            while (ii < nn) {
                ((RenderQueue)this._queues.get(ii)).clear();
                ++ii;
            }
        }

        public static class State {
            protected ArrayList<com.threerings.opengl.compositor.RenderQueue$State> _qstates = Lists.newArrayList();

            public void swap(Group group) {
                ComparableArrayList<RenderQueue> queues = group._queues;
                int nqueues = queues.size();
                int ii = nqueues - this._qstates.size();
                while (ii > 0) {
                    this._qstates.add(new com.threerings.opengl.compositor.RenderQueue$State());
                    --ii;
                }
                ii = 0;
                while (ii < nqueues) {
                    this._qstates.get(ii).swap((RenderQueue)queues.get(ii));
                    ++ii;
                }
            }
        }
    }

    protected static class GroupBatch
    extends Batch {
        public Group group;

        public GroupBatch(GlContext ctx) {
            this.group = new Group(ctx);
        }

        public boolean update() {
            int total = 0;
            this.depth = 0.0f;
            this.key = null;
            this.group.sortQueues();
            ComparableArrayList<RenderQueue> queues = this.group._queues;
            int ii = 0;
            int nn = queues.size();
            while (ii < nn) {
                ComparableArrayList<PriorityList> lists = ((RenderQueue)queues.get((int)ii))._lists;
                int jj = 0;
                int mm = lists.size();
                while (jj < mm) {
                    PriorityList list = (PriorityList)lists.get(jj);
                    int kk = 0;
                    int ll = list.size();
                    while (kk < ll) {
                        Batch batch = (Batch)list.get(kk);
                        this.depth += batch.depth;
                        this.key = batch.key == null ? this.key : batch.key;
                        ++total;
                        ++kk;
                    }
                    ++jj;
                }
                ++ii;
            }
            if (total > 0) {
                this.depth /= (float)total;
                return true;
            }
            return false;
        }

        @Override
        public boolean draw(Renderer renderer) {
            this.group.renderQueues();
            return false;
        }

        public static class State {
            protected float _depth;
            protected int[] _key;
            protected Group.State _gstate = new Group.State();

            public void swap(GroupBatch batch) {
                float odepth = this._depth;
                this._depth = batch.depth;
                batch.depth = odepth;
                int[] okey = this._key;
                this._key = batch.key;
                batch.key = okey;
                this._gstate.swap(batch.group);
            }
        }
    }

    protected static class PriorityList
    extends ArrayList<Batch>
    implements Comparable<PriorityList> {
        protected int _priority;

        public PriorityList(int priority) {
            this._priority = priority;
        }

        @Override
        public int compareTo(PriorityList other) {
            return this._priority - other._priority;
        }
    }

    protected static class State {
        protected HashIntMap<PriorityList> _priorities = IntMaps.newHashIntMap();
        protected ComparableArrayList<PriorityList> _lists = new ComparableArrayList();
        protected ArrayList<GroupBatch.State> _bstates = Lists.newArrayList();

        protected State() {
        }

        public void swap(RenderQueue queue) {
            HashIntMap<PriorityList> opriorities = this._priorities;
            this._priorities = queue._priorities;
            queue._priorities = opriorities;
            ComparableArrayList<PriorityList> olists = this._lists;
            this._lists = queue._lists;
            queue._lists = olists;
            ArrayList<GroupBatch> batches = queue._batches;
            int nbatches = batches.size();
            int ii = nbatches - this._bstates.size();
            while (ii > 0) {
                this._bstates.add(new GroupBatch.State());
                --ii;
            }
            ii = 0;
            while (ii < nbatches) {
                this._bstates.get(ii).swap(batches.get(ii));
                ++ii;
            }
        }
    }
}

