/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.ListUtil;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigReference;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Introspector;
import com.threerings.editor.Log;
import com.threerings.editor.Property;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.swing.BasePropertyEditor;
import com.threerings.editor.swing.ObjectPanel;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.editor.swing.editors.ObjectPanelArrayListEditor;
import com.threerings.editor.util.EditorContext;
import com.threerings.export.ObjectMarshaller;
import com.threerings.export.XMLExporter;
import com.threerings.export.XMLImporter;
import com.threerings.export.util.SerializableWrapper;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform2D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.media.image.ColorPository;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.util.DeepUtil;
import com.threerings.util.ToolUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TreeEditorPanel
extends BaseEditorPanel
implements ClipboardOwner,
FlavorListener,
ChangeListener {
    protected JTree _tree = new JTree(new DefaultMutableTreeNode(new NodeObject(null, null, null, null)), true);
    protected JPanel _panel;
    protected Action _import;
    protected Action _export;
    protected Action _cut;
    protected Action _copy;
    protected Action _paste;
    protected Action _delete;
    protected static final DataFlavor LOCAL_NODE_TRANSFER_FLAVOR = ToolUtil.createLocalFlavor(NodeTransfer.class);
    protected static final DataFlavor[] NODE_TRANSFER_FLAVORS = new DataFlavor[]{LOCAL_NODE_TRANSFER_FLAVOR, ToolUtil.SERIALIZED_WRAPPED_FLAVOR};

    public TreeEditorPanel(EditorContext ctx) {
        this(ctx, null, false);
    }

    public TreeEditorPanel(EditorContext ctx, Property[] ancestors, boolean omitColumns) {
        super(ctx, ancestors, omitColumns);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._panel = GroupLayout.makeVStretchBox((int)5);
        if (this.isEmbedded()) {
            this.add(this._tree);
            this.add(this._panel);
        } else {
            JScrollPane ppane = new JScrollPane(this._panel);
            ppane.setMinimumSize(new Dimension(1, 80));
            JSplitPane split = new JSplitPane(0, true, new JScrollPane(this._tree), ppane);
            this.add(split);
            split.setResizeWeight(1.0);
        }
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                boolean selected = TreeEditorPanel.this.getSelectedNode() != null;
                TreeEditorPanel.this._import.setEnabled(selected);
                TreeEditorPanel.this._export.setEnabled(selected);
                TreeEditorPanel.this._cut.setEnabled(selected);
                TreeEditorPanel.this._copy.setEnabled(selected);
                TreeEditorPanel.this._paste.setEnabled(TreeEditorPanel.this.shouldEnablePaste());
                TreeEditorPanel.this._delete.setEnabled(selected);
                TreeEditorPanel.this.updateNodeEditor();
            }
        });
        this._tree.setDragEnabled(true);
        this._tree.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] flavors) {
                return ListUtil.contains((Object[])flavors, (Object)ToolUtil.SERIALIZED_WRAPPED_FLAVOR);
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                int idx;
                DefaultMutableTreeNode dnode;
                NodeObject dnobj;
                Object value;
                Object data;
                if (!this.canImport(comp, t.getTransferDataFlavors())) {
                    return false;
                }
                boolean local = t.isDataFlavorSupported(LOCAL_NODE_TRANSFER_FLAVOR);
                try {
                    data = t.getTransferData(local ? LOCAL_NODE_TRANSFER_FLAVOR : ToolUtil.SERIALIZED_WRAPPED_FLAVOR);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Failure importing data.", new Object[]{e});
                    return false;
                }
                DefaultMutableTreeNode node = null;
                if (local) {
                    NodeTransfer transfer = (NodeTransfer)data;
                    node = transfer.node;
                    value = transfer.value;
                } else {
                    value = ((SerializableWrapper)data).getObject();
                }
                DefaultMutableTreeNode snode = TreeEditorPanel.this.getSelectedNode();
                if (node == snode) {
                    return false;
                }
                value = DeepUtil.copy(value);
                NodeObject snobj = (NodeObject)snode.getUserObject();
                if (snobj.property != null && snobj.property.isLegalValue(value)) {
                    TreeEditorPanel.this.setNodeValue(snode, value);
                    TreeEditorPanel.this.populateNode(snode, TreeEditorPanel.this.getLabel(snobj.property), value, snobj.property.getSubtypes(), snobj.property, snobj.comp);
                    TreeEditorPanel.this.reload(snode);
                    TreeEditorPanel.this.updateNodeEditor();
                    TreeEditorPanel.this.fireStateChanged();
                    return true;
                }
                DefaultMutableTreeNode pnode = (DefaultMutableTreeNode)snode.getParent();
                NodeObject pnobj = (NodeObject)pnode.getUserObject();
                if (snobj.comp instanceof Integer && pnobj.property != null && pnobj.property.isLegalComponentValue(value)) {
                    dnobj = pnobj;
                    dnode = pnode;
                    idx = (Integer)snobj.comp;
                } else if (snobj.property != null && snobj.property.getComponentType() != null && snobj.property.isLegalComponentValue(value)) {
                    dnobj = snobj;
                    dnode = snode;
                    idx = Integer.MAX_VALUE;
                } else {
                    return false;
                }
                int oidx = -1;
                DefaultMutableTreeNode defaultMutableTreeNode = pnode = node == null ? null : (DefaultMutableTreeNode)node.getParent();
                if (pnode != null) {
                    pnobj = (NodeObject)pnode.getUserObject();
                    if (pnobj.value == dnobj.value) {
                        NodeObject nobj = (NodeObject)node.getUserObject();
                        if (nobj.comp instanceof Integer) {
                            oidx = (Integer)nobj.comp;
                        }
                    }
                }
                if (dnobj.value instanceof List) {
                    List list = (List)dnobj.value;
                    idx = Math.min(idx, list.size());
                    if (oidx != -1) {
                        if (idx == oidx) {
                            return false;
                        }
                        list.remove(oidx);
                    }
                    list.add(idx, value);
                } else {
                    int len = Array.getLength(dnobj.value);
                    idx = Math.min(idx, len);
                    if (oidx != -1) {
                        if (idx == oidx) {
                            return false;
                        }
                        Object tmp = Array.get(dnobj.value, oidx);
                        if (oidx < idx) {
                            System.arraycopy(dnobj.value, oidx + 1, dnobj.value, oidx, idx - oidx);
                        } else {
                            System.arraycopy(dnobj.value, idx, dnobj.value, idx + 1, oidx - idx);
                        }
                        Array.set(dnobj.value, idx, value);
                    } else {
                        Object narray = Array.newInstance(dnobj.value.getClass().getComponentType(), len + 1);
                        System.arraycopy(dnobj.value, 0, narray, 0, idx);
                        Array.set(narray, idx, value);
                        System.arraycopy(dnobj.value, idx, narray, idx + 1, len - idx);
                        TreeEditorPanel.this.setNodeValue(dnode, narray);
                    }
                }
                TreeEditorPanel.this.populateNode(dnode, TreeEditorPanel.this.getLabel(dnobj.property), dnobj.value, dnobj.property.getSubtypes(), dnobj.property, dnobj.comp);
                TreeEditorPanel.this.reload(dnode);
                TreeEditorPanel.this._tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)dnode.getChildAt(idx)).getPath()));
                TreeEditorPanel.this.fireStateChanged();
                return true;
            }

            @Override
            public int getSourceActions(JComponent comp) {
                return 3;
            }

            @Override
            protected Transferable createTransferable(JComponent comp) {
                DefaultMutableTreeNode node = TreeEditorPanel.this.getSelectedNode();
                return node == null ? null : new NodeTransfer(node, false);
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
                if (action == 2) {
                    TreeEditorPanel.this.deleteNode(((NodeTransfer)data).node, false);
                }
            }
        });
        JPopupMenu popup = new JPopupMenu();
        this._tree.setComponentPopupMenu(popup);
        this._import = this.createAction("import", 73, -1);
        popup.add(new JMenuItem(this._import));
        this._export = this.createAction("export", 69, -1);
        popup.add(new JMenuItem(this._export));
        popup.addSeparator();
        this._cut = this.createAction("cut", 84, 88);
        popup.add(new JMenuItem(this._cut));
        this._copy = this.createAction("copy", 67, 67);
        popup.add(new JMenuItem(this._copy));
        this._paste = this.createAction("paste", 80, 86);
        popup.add(new JMenuItem(this._paste));
        this._delete = this.createAction("delete", 68, 127, 0);
        popup.add(new JMenuItem(this._delete));
    }

    public Action getCutAction() {
        return this._cut;
    }

    public Action getCopyAction() {
        return this._copy;
    }

    public Action getPasteAction() {
        return this._paste;
    }

    public Action getDeleteAction() {
        return this._delete;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void flavorsChanged(FlavorEvent event) {
        this._paste.setEnabled(this.shouldEnablePaste());
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        DefaultMutableTreeNode node = this.getSelectedNode();
        NodeObject nodeobj = (NodeObject)node.getUserObject();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        NodeObject pnobj = (NodeObject)parent.getUserObject();
        if (nodeobj.property != null) {
            Object object = pnobj.value;
            if (nodeobj.comp instanceof String) {
                object = ((ConfigReference)pnobj.value).getArguments();
            }
            this.populateNode(node, this.getLabel(nodeobj.property), nodeobj.property.get(object), nodeobj.property.getSubtypes(), nodeobj.property, nodeobj.comp);
        } else {
            nodeobj.value = ((ObjectPanel)((Object)this._panel.getComponent(0))).getValue();
            if (pnobj.value instanceof List) {
                List list = (List)pnobj.value;
                list.set((Integer)nodeobj.comp, nodeobj.value);
            } else {
                Array.set(pnobj.value, (Integer)nodeobj.comp, nodeobj.value);
            }
            this.populateNode(node, String.valueOf(nodeobj.comp), nodeobj.value, pnobj.property.getComponentSubtypes(), null, nodeobj.comp);
        }
        this.reload(node);
        this.fireStateChanged();
    }

    public void addNotify() {
        super.addNotify();
        this._tree.getToolkit().getSystemClipboard().addFlavorListener(this);
    }

    public void removeNotify() {
        this._tree.getToolkit().getSystemClipboard().removeFlavorListener(this);
        super.removeNotify();
    }

    @Override
    public void setObject(Object object) {
        if (object == this._object) {
            return;
        }
        super.setObject(object);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._tree.getModel().getRoot();
        ((NodeObject)root.getUserObject()).value = this._object;
        this.update();
    }

    @Override
    public void update() {
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        if (this._object != null) {
            this.updatePropertyNodes(root, this._object);
        } else {
            root.setAllowsChildren(false);
        }
        this.reload(root);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if ("import".equals(action)) {
            JFileChooser chooser = this.createFileChooser();
            if (chooser.showOpenDialog(this._tree) == 0) {
                Object value;
                File file = chooser.getSelectedFile();
                DefaultMutableTreeNode snode = this.getSelectedNode();
                NodeObject snobj = (NodeObject)snode.getUserObject();
                try {
                    XMLImporter in = new XMLImporter(new FileInputStream(file));
                    value = in.readObject();
                    in.close();
                }
                catch (IOException e) {
                    Log.log.warning((Object)"Failed to import value.", new Object[]{e});
                    return;
                }
                this._tree.getTransferHandler().importData(this._tree, new NodeTransfer(value));
            }
        } else if ("export".equals(action)) {
            JFileChooser chooser = this.createFileChooser();
            if (chooser.showSaveDialog(this._tree) == 0) {
                File file = chooser.getSelectedFile();
                NodeObject nodeobj = (NodeObject)this.getSelectedNode().getUserObject();
                try {
                    XMLExporter out = new XMLExporter(new FileOutputStream(file));
                    out.writeObject(nodeobj.value);
                    out.close();
                }
                catch (IOException e) {
                    Log.log.warning((Object)"Failed to export value.", new Object[]{"value", e});
                }
            }
        } else if ("cut".equals(action)) {
            this.copySelectedNode();
            this.deleteNode(this.getSelectedNode(), true);
        } else if ("copy".equals(action)) {
            this.copySelectedNode();
        } else if ("paste".equals(action)) {
            this._tree.getTransferHandler().importData(this._tree, this._tree.getToolkit().getSystemClipboard().getContents(this));
        } else if ("delete".equals(action)) {
            this.deleteNode(this.getSelectedNode(), true);
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public String getMousePath(Point pt) {
        TreePath path = null;
        Point treePt = this._tree.getMousePosition();
        path = treePt != null ? this._tree.getPathForLocation(treePt.x, treePt.y) : this._tree.getSelectionPath();
        if (path == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int ii = 1;
        int nn = path.getPathCount();
        while (ii < nn) {
            NodeObject obj = (NodeObject)((DefaultMutableTreeNode)path.getPathComponent(ii)).getUserObject();
            if (obj.comp instanceof Integer) {
                buf.append('[').append(obj.comp).append(']');
            } else if (obj.comp instanceof String) {
                buf.append("[\"").append(((String)obj.comp).replace("\"", "\\\"")).append("\"]");
            } else {
                buf.append('.').append(obj.property.getName());
            }
            ++ii;
        }
        if (treePt == null) {
            Container cont = this._panel;
            while (cont != null) {
                Component comp = cont.getComponentAt(pt);
                if (comp == cont || !(comp instanceof Container)) break;
                if (comp instanceof PropertyEditor) {
                    PropertyEditor editor = (PropertyEditor)((Object)comp);
                    String subElement = editor.getMousePath(SwingUtilities.convertPoint((Component)((Object)this), pt, comp));
                    if (subElement.isEmpty()) break;
                    buf.append('.').append(subElement);
                    break;
                }
                cont = (Container)comp;
                pt = cont.getMousePosition();
            }
        }
        return buf.toString();
    }

    @Override
    public String getComponentPath(Component comp, boolean mouse) {
        String subElement;
        TreePath path = this._tree.getSelectionPath();
        if (path == null) {
            return "";
        }
        StringBuilder buf = this.convertTreePath(path);
        BasePropertyEditor editor = this.getNextChildComponent(BasePropertyEditor.class, comp);
        if (editor != null && !(subElement = editor.getComponentPath(comp, mouse)).isEmpty()) {
            if (!subElement.startsWith(".")) {
                buf.append('.');
            }
            buf.append(subElement);
        }
        return buf.toString();
    }

    protected StringBuilder convertTreePath(TreePath path) {
        StringBuilder buf = new StringBuilder();
        int ii = 1;
        int nn = path.getPathCount();
        while (ii < nn) {
            NodeObject obj = (NodeObject)((DefaultMutableTreeNode)path.getPathComponent(ii)).getUserObject();
            if (obj.comp instanceof Integer) {
                buf.append('[').append(obj.comp).append(']');
            } else if (obj.comp instanceof String) {
                buf.append("[\"").append(((String)obj.comp).replace("\"", "\\\"")).append("\"]");
            } else {
                buf.append('.').append(obj.property.getName());
            }
            ++ii;
        }
        return buf;
    }

    protected Action createAction(String command, int mnemonic, int accelerator) {
        return this.createAction(command, mnemonic, accelerator, 2);
    }

    protected Action createAction(String command, int mnemonic, int accelerator, int modifiers) {
        Action action = ToolUtil.createAction(this, this._msgs, command, mnemonic, accelerator, modifiers);
        this._tree.getActionMap().put(command, action);
        if (accelerator != -1) {
            this._tree.getInputMap().put(KeyStroke.getKeyStroke(accelerator, modifiers), command);
        }
        action.setEnabled(false);
        return action;
    }

    protected JFileChooser createFileChooser() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.toString().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return TreeEditorPanel.this._msgs.get("m.xml_files");
            }
        });
        return chooser;
    }

    protected void copySelectedNode() {
        Clipboard clipboard = this._tree.getToolkit().getSystemClipboard();
        clipboard.setContents(new NodeTransfer(this.getSelectedNode(), true), this);
    }

    protected void deleteNode(DefaultMutableTreeNode node, boolean revertToDefaults) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (parent == null) {
            return;
        }
        NodeObject nodeobj = (NodeObject)node.getUserObject();
        NodeObject pnobj = (NodeObject)parent.getUserObject();
        if (!(nodeobj.comp instanceof Integer)) {
            if (!revertToDefaults) {
                return;
            }
            if (nodeobj.comp instanceof String) {
                ArgumentMap args = ((ConfigReference)pnobj.value).getArguments();
                args.remove((String)nodeobj.comp);
                nodeobj.value = nodeobj.property.get(args);
            } else {
                nodeobj.value = nodeobj.property.get(ObjectMarshaller.getObjectMarshaller(pnobj.value.getClass()).getPrototype());
                nodeobj.property.set(pnobj.value, nodeobj.value);
            }
            this.populateNode(node, this.getLabel(nodeobj.property), nodeobj.value, nodeobj.property.getSubtypes(), nodeobj.property, nodeobj.comp);
            this.reload(node);
            this.updateNodeEditor();
            this.fireStateChanged();
            return;
        }
        int idx = (Integer)nodeobj.comp;
        if (pnobj.value instanceof List) {
            ((List)pnobj.value).remove(idx);
        } else {
            int len = Array.getLength(pnobj.value);
            Object narray = Array.newInstance(pnobj.value.getClass().getComponentType(), len - 1);
            System.arraycopy(pnobj.value, 0, narray, 0, idx);
            System.arraycopy(pnobj.value, idx + 1, narray, idx, len - 1 - idx);
            this.setNodeValue(parent, narray);
        }
        boolean selected = node == this.getSelectedNode();
        this.populateNode(parent, this.getLabel(pnobj.property), pnobj.value, pnobj.property.getSubtypes(), pnobj.property, pnobj.comp);
        this.reload(parent);
        if (selected) {
            int ccount = parent.getChildCount();
            DefaultMutableTreeNode snode = ccount > 0 ? (DefaultMutableTreeNode)parent.getChildAt(Math.min(idx, ccount - 1)) : parent;
            this._tree.setSelectionPath(new TreePath(snode.getPath()));
        }
        this.fireStateChanged();
    }

    protected void setNodeValue(DefaultMutableTreeNode node, Object value) {
        NodeObject nodeobj = (NodeObject)node.getUserObject();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        NodeObject pnobj = (NodeObject)parent.getUserObject();
        Object object = pnobj.value;
        if (nodeobj.comp instanceof String) {
            object = ((ConfigReference)object).getArguments();
        }
        nodeobj.value = value;
        nodeobj.property.set(object, nodeobj.value);
    }

    protected void reload(DefaultMutableTreeNode node) {
        TreePath valid;
        Enumeration<TreePath> eenum = this._tree.getExpandedDescendants(new TreePath(node.getPath()));
        ArrayList expanded = eenum == null ? null : Lists.newArrayList((Iterator)Iterators.forEnumeration(eenum));
        TreePath selected = this._tree.getSelectionPath();
        ((DefaultTreeModel)this._tree.getModel()).reload(node);
        if (expanded != null) {
            for (TreePath path : expanded) {
                TreePath valid2 = this.getValidPrefix(path);
                if (valid2 == null) continue;
                this._tree.expandPath(valid2);
            }
        }
        if (selected != null && (valid = this.getValidPrefix(selected)) != null) {
            this._tree.setSelectionPath(valid);
        }
    }

    protected TreePath getValidPrefix(TreePath path) {
        int ii = 1;
        int nn = path.getPathCount();
        while (ii < nn) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(ii);
            if (node.getParent() == null) {
                return ii == 1 ? null : new TreePath(((DefaultMutableTreeNode)path.getPathComponent(ii - 1)).getPath());
            }
            ++ii;
        }
        return path;
    }

    protected boolean shouldEnablePaste() {
        return this.getSelectedNode() != null && this._tree.getToolkit().getSystemClipboard().isDataFlavorAvailable(ToolUtil.SERIALIZED_WRAPPED_FLAVOR);
    }

    protected void updateNodeEditor() {
        this._panel.removeAll();
        SwingUtil.refresh((JComponent)this._panel);
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        TreePath path = this._tree.getSelectionPath();
        ArrayList alist = Lists.newArrayList((Object[])(this._ancestors == null ? new Property[]{} : this._ancestors));
        int ii = 0;
        int nn = path.getPathCount() - 1;
        while (ii < nn) {
            DefaultMutableTreeNode comp = (DefaultMutableTreeNode)path.getPathComponent(ii);
            NodeObject cnobj = (NodeObject)comp.getUserObject();
            if (cnobj.property != null) {
                alist.add(cnobj.property);
            }
            ++ii;
        }
        Property[] ancestors = alist.toArray(new Property[alist.size()]);
        NodeObject nodeobj = (NodeObject)node.getUserObject();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        NodeObject pnobj = (NodeObject)parent.getUserObject();
        if (nodeobj.property != null) {
            PropertyEditor editor = PropertyEditor.createEditor(this._ctx, nodeobj.property, ancestors);
            if (nodeobj.comp instanceof String) {
                editor.setObject(((ConfigReference)pnobj.value).getArguments());
            } else {
                editor.setObject(pnobj.value);
            }
            editor.addChangeListener(this);
            this._panel.add((Component)((Object)editor));
            return;
        }
        if (pnobj.property == null || PropertyEditor.getArrayListEditorType(pnobj.property) != ObjectPanelArrayListEditor.class) {
            return;
        }
        ObjectPanel editor = new ObjectPanel(this._ctx, pnobj.property.getComponentTypeLabel(), pnobj.property.getComponentSubtypes(), ancestors, pnobj.value);
        editor.setValue(nodeobj.value);
        editor.addChangeListener(this);
        this._panel.add((Component)((Object)editor));
    }

    protected DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this._tree.getSelectionPath();
        return path == null ? null : (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    protected void updatePropertyNodes(DefaultMutableTreeNode parent, Object object) {
        Property[] properties = Introspector.getProperties(object);
        if (properties.length == 0) {
            parent.setAllowsChildren(false);
            return;
        }
        parent.setAllowsChildren(true);
        int ccount = parent.getChildCount();
        int ii = 0;
        while (ii < properties.length) {
            Property property = properties[ii];
            DefaultMutableTreeNode child = new DefaultMutableTreeNode();
            if (ii < ccount) {
                DefaultMutableTreeNode onode = (DefaultMutableTreeNode)parent.getChildAt(ii);
                NodeObject onobj = (NodeObject)onode.getUserObject();
                if (onobj.property == property) {
                    child = onode;
                }
                parent.remove(ii);
            }
            parent.insert(child, ii);
            this.populateNode(child, this.getLabel(property), property.get(object), property.getSubtypes(), property, null);
            ++ii;
        }
        ii = properties.length;
        while (ii < ccount) {
            parent.remove(properties.length);
            ++ii;
        }
    }

    protected void addNode(DefaultMutableTreeNode parent, String label, Object value, Class<?>[] subtypes, Property property, Object comp) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode();
        this.populateNode(child, label, value, subtypes, property, comp);
        parent.add(child);
    }

    protected void populateNode(DefaultMutableTreeNode node, String label, Object value, Class<?>[] subtypes, Property property, Object comp) {
        if (value == null || value instanceof Boolean || value instanceof Number || value instanceof Color4f || value instanceof File || value instanceof Quaternion || value instanceof String || value instanceof Transform2D || value instanceof Transform3D || value instanceof Vector2f || value instanceof Vector3f || value instanceof Enum) {
            Object dval = value;
            if (value == null) {
                dval = this._msgs.get("m.null_value");
            } else if (value instanceof String) {
                dval = "\"" + value + "\"";
            } else if (value instanceof Enum) {
                Enum eval = (Enum)value;
                dval = this.getLabel(eval, this._msgmgr.getBundle(Introspector.getMessageBundle(eval.getDeclaringClass())));
            } else if (value instanceof Integer && property.getAnnotation().editor().equals("colorization")) {
                int ival = (Integer)value;
                String mode = property.getAnnotation().mode();
                if (mode.equals("class")) {
                    ColorPository.ClassRecord crec = this._ctx.getColorPository().getClassRecord(ival);
                    dval = crec == null ? dval : crec.name;
                } else if (mode.length() > 0) {
                    ColorPository.ColorRecord crec = this._ctx.getColorPository().getColorRecord(ival >> 8, ival & 0xFF);
                } else {
                    ColorPository.ColorRecord crec = this._ctx.getColorPository().getColorRecord(ival >> 8, ival & 0xFF);
                    dval = crec == null ? dval : String.valueOf(mode.length() > 0 ? "" : String.valueOf(crec.cclass.name) + "/") + crec.name;
                }
            }
            node.setUserObject(new NodeObject(String.valueOf(label) + ": " + dval, value, property, comp));
            node.setAllowsChildren(false);
        } else if (value instanceof ConfigReference) {
            ConfigReference ref = (ConfigReference)value;
            String name = ref.getName();
            node.setUserObject(new NodeObject(String.valueOf(label) + ": " + name, value, property, comp));
            node.setAllowsChildren(true);
            int ccount = node.getChildCount();
            int idx = 0;
            if (property != null) {
                Class<?> clazz = property.getArgumentType(ConfigReference.class);
                Object config = this._ctx.getConfigManager().getConfig(clazz, name);
                if (config instanceof ParameterizedConfig) {
                    ParameterizedConfig pconfig = (ParameterizedConfig)config;
                    if (pconfig.parameters.length > 0) {
                        Parameter[] parameterArray = pconfig.parameters;
                        int n = pconfig.parameters.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Parameter param = parameterArray[n2];
                            Property aprop = param.getArgumentProperty(pconfig);
                            if (aprop != null) {
                                DefaultMutableTreeNode child = new DefaultMutableTreeNode();
                                if (idx < ccount) {
                                    DefaultMutableTreeNode ochild = (DefaultMutableTreeNode)node.getChildAt(idx);
                                    NodeObject onobj = (NodeObject)ochild.getUserObject();
                                    if (onobj.property == aprop) {
                                        child = ochild;
                                    }
                                    node.remove(idx);
                                }
                                node.insert(child, idx++);
                                this.populateNode(child, param.name, aprop.get(ref.getArguments()), aprop.getSubtypes(), aprop, param.name);
                            }
                            ++n2;
                        }
                    }
                }
            }
            int ii = idx;
            while (ii < ccount) {
                node.remove(idx);
                ++ii;
            }
            if (node.getChildCount() == 0) {
                node.setAllowsChildren(false);
            }
        } else if (value instanceof List || value.getClass().isArray()) {
            node.setUserObject(new NodeObject(label, value, property, comp));
            node.setAllowsChildren(true);
            Class<?>[] componentSubtypes = property != null ? property.getComponentSubtypes() : new Class[]{};
            int ccount = node.getChildCount();
            int length = value instanceof List ? ((List)value).size() : Array.getLength(value);
            int ii = 0;
            while (ii < length) {
                DefaultMutableTreeNode child;
                if (ii < ccount) {
                    child = (DefaultMutableTreeNode)node.getChildAt(ii);
                } else {
                    child = new DefaultMutableTreeNode();
                    node.insert(child, ii);
                }
                this.populateNode(child, String.valueOf(ii), value instanceof List ? ((List)value).get(ii) : Array.get(value, ii), componentSubtypes, null, ii);
                ++ii;
            }
            ii = length;
            while (ii < ccount) {
                node.remove(length);
                ++ii;
            }
        } else {
            if (subtypes.length > 1) {
                label = String.valueOf(label) + ": " + this.getLabel(value.getClass());
            }
            node.setUserObject(new NodeObject(label, value, property, comp));
            this.updatePropertyNodes(node, value);
        }
    }

    protected static class NodeObject {
        public final String label;
        public Object value;
        public final Property property;
        public final Object comp;

        public NodeObject(String label, Object value, Property property, Object comp) {
            this.label = label;
            this.value = value;
            this.property = property;
            this.comp = comp;
        }

        public String toString() {
            return this.label;
        }
    }

    protected static class NodeTransfer
    implements Transferable {
        public DefaultMutableTreeNode node;
        public Object value;

        public NodeTransfer(DefaultMutableTreeNode node, boolean clipboard) {
            this.node = clipboard ? null : node;
            this.value = DeepUtil.copy(((NodeObject)node.getUserObject()).value);
        }

        public NodeTransfer(Object value) {
            this.value = value;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return NODE_TRANSFER_FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ListUtil.contains((Object[])NODE_TRANSFER_FLAVORS, (Object)flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return flavor.equals(LOCAL_NODE_TRANSFER_FLAVOR) ? this : new SerializableWrapper(this.value);
        }
    }
}

