/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.swing;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.swing.event.DocumentAdapter;
import com.threerings.config.ManagedConfig;
import com.threerings.config.swing.ConfigTree;
import com.threerings.util.MessageManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;

public class ConfigTreeFilterPanel
extends JPanel {
    protected ConfigTree _tree;
    protected JTextField _input;
    protected Action _clearAction = new AbstractAction("", UIManager.getIcon("InternalFrame.closeIcon")){
        {
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ConfigTreeFilterPanel.this.clearFilter();
        }
    };
    protected Predicate<ManagedConfig> _filter = null;
    protected List<Predicate<? super ManagedConfig>> _predicates;
    protected DocumentAdapter _inputListener = new DocumentAdapter(){

        public void documentChanged() {
            final String text = ConfigTreeFilterPanel.this._input.getText().trim().toLowerCase();
            ConfigTreeFilterPanel.this._filter = "".equals(text) ? null : new Predicate<ManagedConfig>(){

                public boolean apply(ManagedConfig cfg) {
                    return cfg.getName().toLowerCase().contains(text);
                }
            };
            ConfigTreeFilterPanel.this.setFilter();
            ConfigTreeFilterPanel.this._clearAction.setEnabled(ConfigTreeFilterPanel.this._filter != null);
        }
    };

    public ConfigTreeFilterPanel(MessageManager msgmgr) {
        super((LayoutManager)new VGroupLayout());
        ((VGroupLayout)this.getLayout()).setOffAxisPolicy(GroupLayout.STRETCH);
        this._input = new JTextField();
        this._input.getDocument().addDocumentListener((DocumentListener)this._inputListener);
        JPanel box = GroupLayout.makeHBox((GroupLayout.Policy)HGroupLayout.STRETCH);
        box.add((Component)new JLabel(msgmgr.getBundle("config").get("l.filter_config")), HGroupLayout.FIXED);
        box.add(this._input);
        box.add((Component)new JButton(this._clearAction), HGroupLayout.FIXED);
        this.add(box);
    }

    public ConfigTreeFilterPanel addConstraint(String description, final Predicate<? super ManagedConfig> filter, boolean removable) {
        if (this._predicates == null) {
            this._predicates = Lists.newArrayList();
        }
        this._predicates.add(filter);
        final JPanel box = GroupLayout.makeHBox((GroupLayout.Policy)HGroupLayout.STRETCH);
        AbstractAction clear = new AbstractAction("", UIManager.getIcon("InternalFrame.closeIcon")){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConfigTreeFilterPanel.this.remove(box);
                ConfigTreeFilterPanel.this._predicates.remove(filter);
                ConfigTreeFilterPanel.this.setFilter();
            }
        };
        clear.setEnabled(removable);
        box.add(new JLabel(description));
        box.add((Component)new JButton(clear), HGroupLayout.FIXED);
        this.add((Component)box, this.getComponentCount() - 1);
        return this;
    }

    public void clearFilter() {
        this._input.setText("");
    }

    public void setTree(ConfigTree tree) {
        this._tree = tree;
        this.setFilter();
    }

    protected void setFilter() {
        if (this._tree != null) {
            this._tree.setFilter(this.createFilter());
        }
    }

    protected Predicate<? super ManagedConfig> createFilter() {
        if (this._predicates == null) {
            return this._filter;
        }
        Predicate combined = Predicates.and(this._predicates);
        if (this._filter != null) {
            combined = Predicates.and(this._filter, (Predicate)combined);
        }
        return combined;
    }
}

