/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.util.Coord;
import com.threerings.util.DeepObject;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class EntryEdit
extends AbstractUndoableEdit {
    protected TudeySceneModel _scene;
    protected int _id;
    protected int _layer;
    protected Map<Object, TudeySceneModel.Entry> _added = Maps.newHashMap();
    protected Map<Object, TudeySceneModel.Entry> _updated = Maps.newHashMap();
    protected Map<Object, TudeySceneModel.Entry> _removed = Maps.newHashMap();
    protected Map<Coord, TudeySceneModel.Paint> _paint = Maps.newHashMap();

    public EntryEdit(TudeySceneModel scene, int id, int layer, TudeySceneModel.Entry[] add, TudeySceneModel.Entry[] update, Object[] remove) {
        this._scene = scene;
        this._id = id;
        this._layer = layer;
        for (TudeySceneModel.Entry entry : add) {
            if (!this._scene.addEntry(entry)) continue;
            int expectLayer = TudeySceneModel.ConstantLayer.getLayer(entry);
            if (layer >= TudeySceneModel.ConstantLayer.LAYERS.length) {
                this._scene.setLayer(entry.getKey(), layer);
            } else {
                this._scene.setLayer(entry.getKey(), expectLayer);
            }
            this._added.put(entry.getKey(), null);
        }
        for (TudeySceneModel.Entry entry : update) {
            TudeySceneModel.Entry oentry = this._scene.updateEntry(entry);
            this._scene.setLayer(entry.getKey(), layer);
            if (oentry == null) continue;
            this._updated.put(entry.getKey(), oentry);
        }
        for (Object key : remove) {
            TudeySceneModel.Entry oentry = this._scene.removeEntry(key);
            if (oentry == null) continue;
            this._removed.put(key, oentry);
        }
    }

    public EntryEdit(TudeySceneModel scene, int id, int layer, Rectangle region, TudeySceneModel.Paint paint) {
        int yy;
        this._scene = scene;
        this._id = id;
        this._layer = layer;
        int yymax = yy + region.height;
        for (yy = region.y; yy < yymax; ++yy) {
            int xx;
            int xxmax = xx + region.width;
            for (xx = region.x; xx < xxmax; ++xx) {
                TudeySceneModel.Paint opaint = this._scene.setPaint(xx, yy, paint);
                if (Objects.equal((Object)opaint, (Object)paint)) continue;
                this._paint.put(new Coord(xx, yy), opaint);
            }
        }
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        Object key;
        if (!(edit instanceof EntryEdit)) {
            return false;
        }
        EntryEdit oedit = (EntryEdit)edit;
        if (oedit._id != this._id || oedit._layer != this._layer) {
            return false;
        }
        for (Object object : oedit._added.keySet()) {
            TudeySceneModel.Entry oentry = this._removed.remove(object);
            if (oentry == null) {
                this._added.put(object, null);
                continue;
            }
            this._updated.put(object, oentry);
        }
        for (TudeySceneModel.Entry entry : oedit._updated.values()) {
            key = entry.getKey();
            if (this._added.containsKey(key) || this._updated.containsKey(key)) continue;
            this._updated.put(key, entry);
        }
        for (TudeySceneModel.Entry entry : oedit._removed.values()) {
            key = entry.getKey();
            if (this._added.containsKey(key)) {
                this._added.remove(key);
                continue;
            }
            TudeySceneModel.Entry oentry = this._updated.remove(key);
            this._removed.put(key, oentry == null ? entry : oentry);
        }
        for (Map.Entry entry : oedit._paint.entrySet()) {
            Coord coord = (Coord)entry.getKey();
            if (this._paint.containsKey(coord)) continue;
            this._paint.put(coord, (TudeySceneModel.Paint)entry.getValue());
        }
        return true;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.swap(this._removed, this._added);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.swap(this._added, this._removed);
    }

    protected void swap(Map<Object, TudeySceneModel.Entry> removed, Map<Object, TudeySceneModel.Entry> added) {
        for (Map.Entry<Object, TudeySceneModel.Entry> entry : removed.entrySet()) {
            this._scene.addEntry(entry.getValue(), false);
            this._scene.setLayer(entry.getValue().getKey(), this._layer);
            entry.setValue(null);
        }
        for (Map.Entry<Object, TudeySceneModel.Entry> entry : this._updated.entrySet()) {
            entry.setValue(this._scene.updateEntry(entry.getValue()));
        }
        for (Map.Entry<Object, TudeySceneModel.Entry> entry : added.entrySet()) {
            entry.setValue(this._scene.removeEntry(entry.getKey()));
        }
        for (Map.Entry<Object, DeepObject> entry : this._paint.entrySet()) {
            Coord coord = (Coord)entry.getKey();
            entry.setValue(this._scene.setPaint(coord.x, coord.y, (TudeySceneModel.Paint)entry.getValue()));
        }
    }
}

