/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;

public class MetaStreams {
    public static InputStream input(InputStream source) throws IOException {
        long length = MetaStreams.readLength(source);
        if (length == -1L) {
            return null;
        }
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Next stream is too long! [length=" + length + "]");
        }
        byte[] bytes = new byte[(int)length];
        ByteStreams.readFully((InputStream)source, (byte[])bytes);
        return new ByteArrayInputStream(bytes);
    }

    public static OutputStream output(final OutputStream dest) {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                MetaStreams.writeLength(dest, this.size());
                this.writeTo(dest);
                dest.flush();
                this.reset();
            }
        };
    }

    public static void writeLength(OutputStream out, long length) throws IOException {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        while (true) {
            int bite = (int)(length & 0x7FL);
            if ((length >>= 7) == 0L) {
                out.write(bite);
                return;
            }
            out.write(bite | 0x80);
        }
    }

    public static long readLength(InputStream in) throws IOException {
        long ret = 0L;
        for (int shift = 0; shift < 63; shift += 7) {
            int bite = in.read();
            if (bite == -1) {
                if (shift != 0) break;
                return -1L;
            }
            ret |= (long)(bite & 0x7F) << shift;
            if ((bite & 0x80) != 0) continue;
            if (shift > 0 && (bite & 0x7F) == 0) break;
            return ret;
        }
        throw new StreamCorruptedException();
    }
}

