/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.editor.Log;
import com.threerings.editor.util.PropertyUtil;
import com.threerings.resource.ResourceManager;
import com.threerings.util.MessageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PatternSet;

public class ConfigResourcesTask
extends Task {
    protected String _id;
    protected File _configfile;
    protected File _resourcefile;

    public void setId(String id) {
        this._id = id;
    }

    public void setConfigfile(File file) {
        this._configfile = file;
    }

    public void setResourcefile(File file) {
        this._resourcefile = file;
    }

    public void execute() throws BuildException {
        ResourceManager rsrcmgr = new ResourceManager("rsrc/");
        MessageManager msgmgr = new MessageManager("rsrc.i18n");
        rsrcmgr.initResourceDir("rsrc/");
        ConfigManager cfgmgr = new ConfigManager(rsrcmgr, msgmgr, "config/");
        cfgmgr.init();
        HashSet resources = Sets.newHashSet();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this._configfile));
            ConfigGroup group = null;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    String name = line.substring(1, line.length() - 1);
                    group = cfgmgr.getGroup(name);
                    if (group != null) continue;
                    Log.log.warning((Object)"Invalid config group name.", new Object[]{"name", name});
                    continue;
                }
                if (group == null) continue;
                this.getResources(cfgmgr, group, line, resources);
            }
        }
        catch (IOException e) {
            Log.log.warning((Object)"Error reading config list.", new Object[]{"file", this._configfile, e});
        }
        ArrayList includes = Lists.newArrayList();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this._resourcefile));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                includes.add(line);
            }
        }
        catch (IOException e) {
            Log.log.warning((Object)"Failed to read resource list.", new Object[]{"file", this._resourcefile, e});
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir("rsrc");
        scanner.setIncludes(includes.toArray(new String[includes.size()]));
        scanner.scan();
        for (String file : scanner.getIncludedFiles()) {
            if (!file.endsWith(".dat")) continue;
            PropertyUtil.getResources(cfgmgr, cfgmgr.getResourceConfig(file), resources);
        }
        PatternSet set = (PatternSet)this.getProject().createDataType("patternset");
        for (String resource : resources) {
            set.createInclude().setName(resource);
        }
        this.getProject().addReference(this._id, (Object)set);
    }

    protected void getResources(ConfigManager cfgmgr, ConfigGroup group, String line, Set<String> paths) {
        PropertyUtil.getResources(cfgmgr, group.getConfig(line), paths);
    }
}

