/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.threerings.math.Rect;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.tudey.client.cursor.SelectionCursor;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.EditorTool;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.tudey.util.TudeySceneMetrics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;

public abstract class BaseMover
extends EditorTool {
    protected SelectionCursor _cursor;
    protected TudeySceneModel.Entry[] _entries = new TudeySceneModel.Entry[0];
    protected TudeySceneModel.Entry[] _tentries;
    protected boolean _tiles;
    protected Vector2f _center = new Vector2f();
    protected int _elevation;
    protected Transform3D _transform = new Transform3D(1);
    protected boolean _cursorVisible;
    protected float _angle;
    protected Vector3f _isect = new Vector3f();
    protected ArrayList<TudeySceneModel.Entry> _underneath = new ArrayList();

    public BaseMover(SceneEditor editor) {
        super(editor);
    }

    public void clear() {
        this.move(new TudeySceneModel.Entry[0]);
    }

    public void move(TudeySceneModel.Entry ... entries) {
        this._entries = new TudeySceneModel.Entry[entries.length];
        if (entries.length == 0) {
            return;
        }
        Rect bounds = new Rect();
        Rect ebounds = new Rect();
        int minElevation = Integer.MAX_VALUE;
        int maxElevation = Integer.MIN_VALUE;
        this._tiles = false;
        int ii = 0;
        while (ii < entries.length) {
            TudeySceneModel.Entry entry = this._entries[ii] = (TudeySceneModel.Entry)entries[ii].clone();
            this._tiles |= entry instanceof TudeySceneModel.TileEntry;
            entry.getBounds(this._editor.getConfigManager(), ebounds);
            bounds.addLocal(ebounds);
            int elevation = entry.getElevation();
            if (elevation != Integer.MIN_VALUE) {
                minElevation = Math.min(minElevation, elevation);
                maxElevation = Math.max(maxElevation, elevation);
            }
            ++ii;
        }
        bounds.getCenter(this._center);
        this.calculateElevation(minElevation, maxElevation);
        this._angle = 0.0f;
    }

    @Override
    public void init() {
        this._cursor = new SelectionCursor(this._editor, this._editor.getView());
    }

    @Override
    public void tick(float elapsed) {
        this.updateCursor();
        if (this._cursorVisible) {
            this._cursor.tick(elapsed);
        }
    }

    @Override
    public void composite() {
        if (this._cursorVisible) {
            this._cursor.composite();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this._cursorVisible && event.getButton() == 1 && !this._editor.isSpecialDown()) {
            this.placeEntries();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this._cursorVisible) {
            float increment = this._tiles || !event.isShiftDown() ? 1.5707964f : FINE_ROTATION_INCREMENT;
            this._angle = (float)(Math.round(this._angle / increment) + event.getWheelRotation()) * increment;
        }
    }

    protected void updateCursor() {
        this._cursorVisible = this._entries.length > 0 && this.getMousePlaneIntersection(this._isect) && !this._editor.isSpecialDown();
        if (!this._cursorVisible) {
            return;
        }
        Vector2f rcenter = this._center.rotate(this._angle);
        this._isect.x -= rcenter.x;
        this._isect.y -= rcenter.y;
        if (this._tiles || !this._editor.isShiftDown()) {
            this._isect.x = Math.round(this._isect.x);
            this._isect.y = Math.round(this._isect.y);
        }
        this._transform.getTranslation().set(this._isect.x, this._isect.y, TudeySceneMetrics.getTileZ(this._editor.getGrid().getElevation() - this._elevation));
        this._transform.getRotation().fromAngleAxis(this._angle, Vector3f.UNIT_Z);
        this._tentries = this.transform(this._entries, this._transform);
        this._cursor.update(this._tentries);
        if (this._editor.isThirdButtonDown()) {
            this._scene.getEntries(this._cursor.getShape(), this._editor.getLayerPredicate(), this._underneath);
            this._editor.removeEntries(this._underneath);
            this._underneath.clear();
        }
    }

    protected TudeySceneModel.Entry[] placeEntries() {
        TudeySceneModel.Entry[] placed = new TudeySceneModel.Entry[this._tentries.length];
        int ii = 0;
        int nn = this._tentries.length;
        while (ii < nn) {
            placed[ii] = (TudeySceneModel.Entry)this._tentries[ii].clone();
            ++ii;
        }
        this._editor.overwriteEntries(placed);
        return placed;
    }

    protected TudeySceneModel.Entry[] transform(TudeySceneModel.Entry[] entries, Transform3D transform) {
        TudeySceneModel.Entry[] tentries = new TudeySceneModel.Entry[entries.length];
        int ii = 0;
        int nn = entries.length;
        while (ii < nn) {
            TudeySceneModel.Entry tentry = tentries[ii] = (TudeySceneModel.Entry)entries[ii].clone();
            tentry.transform(this._editor.getConfigManager(), transform);
            ++ii;
        }
        return tentries;
    }

    public void calculateElevation(int minElevation, int maxElevation) {
        this._elevation = minElevation < maxElevation ? (minElevation + maxElevation) / 2 : 0;
        this._elevation += this._editor.getGrid().getElevation();
    }
}

