/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.samskivert.util.HashIntSet;
import com.samskivert.util.Interator;
import com.samskivert.util.ObserverList;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.util.PropertyUtil;
import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import com.threerings.export.util.ExportUtil;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.math.FloatMath;
import com.threerings.math.Matrix4f;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.Log;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.cursor.AreaCursor;
import com.threerings.tudey.client.cursor.EntryCursor;
import com.threerings.tudey.client.cursor.PathCursor;
import com.threerings.tudey.client.cursor.PlaceableCursor;
import com.threerings.tudey.client.cursor.TileCursor;
import com.threerings.tudey.client.sprite.AreaSprite;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.client.sprite.GlobalSprite;
import com.threerings.tudey.client.sprite.PathSprite;
import com.threerings.tudey.client.sprite.PlaceableSprite;
import com.threerings.tudey.client.sprite.TileSprite;
import com.threerings.tudey.config.AreaConfig;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.tudey.config.PaintableConfig;
import com.threerings.tudey.config.PathConfig;
import com.threerings.tudey.config.PlaceableConfig;
import com.threerings.tudey.config.SceneGlobalConfig;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.TudeySceneConfig;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.shape.Compound;
import com.threerings.tudey.shape.Point;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.ShapeElement;
import com.threerings.tudey.space.HashSpace;
import com.threerings.tudey.space.Space;
import com.threerings.tudey.space.SpaceElement;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.CoordIntMap;
import com.threerings.tudey.util.DirectionUtil;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.tudey.util.TudeySceneMetrics;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import com.threerings.util.DeepUtil;
import com.threerings.whirled.data.AuxModel;
import com.threerings.whirled.data.SceneModel;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class TudeySceneModel
extends SceneModel
implements ActorAdvancer.Environment,
Exportable {
    protected String _notes = "";
    protected TudeySceneConfig _placeConfig = new TudeySceneConfig();
    @DeepOmit
    protected ConfigManager _cfgmgr = new ConfigManager();
    @DeepOmit
    protected CoordIntMap _tiles = new CoordIntMap();
    @DeepOmit
    protected transient ArrayList<TileConfigMapping> _tileConfigs = Lists.newArrayList();
    @DeepOmit
    protected transient Map<ConfigReference<TileConfig>, Integer> _tileConfigIds = Maps.newHashMap();
    @DeepOmit
    protected HashMap<Object, Entry> _entries = Maps.newHashMap();
    @DeepOmit
    protected CoordIntMap _paint = new CoordIntMap();
    @DeepOmit
    protected ArrayList<PaintConfigMapping> _paintConfigs = Lists.newArrayList();
    @DeepOmit
    protected transient boolean _exportLayers = true;
    @DeepOmit
    protected transient List<String> _layers = Lists.newArrayList();
    @DeepOmit
    protected transient List<String> _layerNamesView = new AbstractList<String>(){

        @Override
        public int size() {
            return 1 + TudeySceneModel.this._layers.size();
        }

        @Override
        public String get(int index) {
            return index == 0 ? "<Base Layer>" : TudeySceneModel.this._layers.get(index - 1);
        }
    };
    @DeepOmit
    protected transient Map<Integer, Integer> _layerMap = Maps.newHashMap();
    @DeepOmit
    protected transient Map<ConfigReference<? extends PaintableConfig>, Integer> _paintConfigIds = Maps.newHashMap();
    @DeepOmit
    protected transient Map<String, List<Entry>> _tagged = Maps.newHashMap();
    protected transient int _lastEntryId;
    @DeepOmit
    protected transient WeakHashMap<ConfigReference, ConfigReference> _references = new WeakHashMap();
    @DeepOmit
    protected transient CoordIntMap _tileCoords = new CoordIntMap(3, Coord.EMPTY);
    @DeepOmit
    protected transient CoordIntMap _collisionFlags = new CoordIntMap(3, 0);
    @DeepOmit
    protected transient CoordIntMap _directionFlags = new CoordIntMap(3, 0);
    @DeepOmit
    protected transient HashSpace _space = new HashSpace(64.0f, 6);
    @DeepOmit
    protected transient HashMap<Object, SpaceElement> _elements = Maps.newHashMap();
    @DeepOmit
    protected transient ObserverList<Observer> _observers = ObserverList.newFastUnsafe();
    @DeepOmit
    protected transient SoftReference<byte[]> _data;
    @DeepOmit
    protected transient boolean _dirty;
    @DeepOmit
    protected transient Rectangle _region = new Rectangle();
    @DeepOmit
    protected transient Rect _rect = new Rect();
    @DeepOmit
    protected transient Polygon _quad = new Polygon(4);
    @DeepOmit
    protected transient ArrayList<SpaceElement> _intersecting = Lists.newArrayList();
    @DeepOmit
    protected transient Vector2f _penetration = new Vector2f();
    @DeepOmit
    protected transient Point _point = new Point();
    @DeepOmit
    protected transient FloorPlaceableFilter _floorPlaceableFilter = new FloorPlaceableFilter();

    public TudeySceneModel() {
        this.name = "";
        this.version = 1;
        if (this._layers.size() == 0) {
            this._layers = Lists.newArrayList((Object[])new String[]{ConstantLayer.PLACEABLE.name, ConstantLayer.AREA.name, ConstantLayer.PATH.name, ConstantLayer.GLOBAL.name});
        }
    }

    public void init(ConfigManager cfgmgr) {
        if (this._cfgmgr.isInitialized()) {
            return;
        }
        this._cfgmgr.init("scene", cfgmgr);
        for (CoordIntMap.CoordIntEntry coordIntEntry : this._tiles.coordIntEntrySet()) {
            TileEntry tentry = this.decodeTileEntry(coordIntEntry.getKey(), coordIntEntry.getIntValue());
            this.createShadow(tentry);
        }
        for (Entry entry : this._entries.values()) {
            this.addElement(entry);
        }
    }

    @Override
    public ConfigManager getConfigManager() {
        return this._cfgmgr;
    }

    public void addObserver(Observer observer) {
        this._observers.add((Object)observer);
    }

    public void removeObserver(Observer observer) {
        this._observers.remove((Object)observer);
    }

    public void setName(String name) {
        this.name = name;
        this.invalidate();
    }

    public void setNotes(String notes) {
        this._notes = notes;
        this.invalidate();
    }

    public String getNotes() {
        return this._notes;
    }

    public void setPlaceConfig(TudeySceneConfig config) {
        this._placeConfig = config;
        this.invalidate();
    }

    public TudeySceneConfig getPlaceConfig() {
        return this._placeConfig;
    }

    public CoordIntMap getCollisionFlags() {
        return this._collisionFlags;
    }

    public CoordIntMap getDirectionFlags() {
        return this._directionFlags;
    }

    public Space getSpace() {
        return this._space;
    }

    public Map<Object, SpaceElement> getElements() {
        return this._elements;
    }

    public boolean addEntry(Entry entry) {
        return this.addEntry(entry, true);
    }

    public boolean addEntry(final Entry entry, boolean assignId) {
        Entry oentry;
        if (assignId && entry instanceof IdEntry) {
            ((IdEntry)entry).setId(++this._lastEntryId);
        }
        if ((oentry = this.add(entry)) != null) {
            Log.log.warning((Object)"Attempted to replace existing entry.", new Object[]{"oentry", oentry, "nentry", entry});
            return false;
        }
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<Observer>(){

            public boolean apply(Observer observer) {
                observer.entryAdded(entry);
                return true;
            }
        });
        return true;
    }

    public Entry updateEntry(final Entry nentry) {
        final Entry oentry = this.update(nentry);
        if (oentry == null) {
            Log.log.warning((Object)"Attempted to update nonexistent entry.", new Object[]{"entry", nentry});
            return null;
        }
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<Observer>(){

            public boolean apply(Observer observer) {
                observer.entryUpdated(oentry, nentry);
                return true;
            }
        });
        return oentry;
    }

    public Entry removeEntry(Object key) {
        final Entry oentry = this.remove(key);
        if (oentry == null) {
            Log.log.warning((Object)"Missing entry to remove.", new Object[]{"key", key});
            return null;
        }
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<Observer>(){

            public boolean apply(Observer observer) {
                observer.entryRemoved(oentry);
                return true;
            }
        });
        return oentry;
    }

    public boolean containsEntry(Object key) {
        if (!(key instanceof Coord)) {
            return this._entries.containsKey(key);
        }
        Coord coord = (Coord)key;
        return this._tiles.containsKey(coord.x, coord.y);
    }

    public Entry getEntry(Object key) {
        if (!(key instanceof Coord)) {
            return this._entries.get(key);
        }
        Coord coord = (Coord)key;
        int value = this._tiles.get(coord.x, coord.y);
        return value == -1 ? null : this.decodeTileEntry(coord, value);
    }

    public Entry getTaggedEntry(String tag) {
        List<Entry> entries = this.getTaggedEntries(tag);
        return entries.isEmpty() ? null : entries.get(0);
    }

    public List<Entry> getTaggedEntries(String tag) {
        List<Entry> list = this._tagged.get(tag);
        return list == null ? ImmutableList.of() : list;
    }

    public Collection<Entry> getEntries() {
        return new AbstractCollection<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return new Iterator<Entry>(){
                    protected Iterator<CoordIntMap.CoordIntEntry> _tit;
                    protected Iterator<Entry> _eit;
                    {
                        this._tit = (this).TudeySceneModel.this._tiles.coordIntEntrySet().iterator();
                        this._eit = (this).TudeySceneModel.this._entries.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this._tit.hasNext() || this._eit.hasNext();
                    }

                    @Override
                    public Entry next() {
                        if (this._tit.hasNext()) {
                            CoordIntMap.CoordIntEntry entry = this._tit.next();
                            return TudeySceneModel.this.decodeTileEntry(entry.getKey(), entry.getIntValue());
                        }
                        return this._eit.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return TudeySceneModel.this._tiles.size() + TudeySceneModel.this._entries.size();
            }
        };
    }

    public void getEntries(Shape shape, Collection<Entry> results) {
        this.getEntries(shape, (Predicate<? super Entry>)Predicates.alwaysTrue(), results);
    }

    public void getEntries(Shape shape, Predicate<? super Entry> pred, Collection<Entry> results) {
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        HashIntSet pairs = new HashIntSet(8, Coord.EMPTY);
        int yy = miny;
        while (yy <= maxy) {
            int xx = minx;
            while (xx <= maxx) {
                int pair = this._tileCoords.get(xx, yy);
                if (pair != Coord.EMPTY) {
                    this._rect.getMinimumExtent().set(xx, yy);
                    this._rect.getMaximumExtent().set((float)xx + 1.0f, (float)yy + 1.0f);
                    if (shape.getIntersectionType(this._rect) != Shape.IntersectionType.NONE) {
                        pairs.add(pair);
                    }
                }
                ++xx;
            }
            ++yy;
        }
        Interator it = pairs.interator();
        while (it.hasNext()) {
            TileEntry entry = this.getTileEntry(it.nextInt());
            if (entry == null || !pred.apply((Object)entry)) continue;
            results.add(entry);
        }
        ArrayList intersecting = Lists.newArrayList();
        this._space.getIntersecting(shape, intersecting);
        int ii = 0;
        int nn = intersecting.size();
        while (ii < nn) {
            Entry entry = (Entry)((SpaceElement)intersecting.get(ii)).getUserObject();
            if (pred.apply((Object)entry)) {
                results.add(entry);
            }
            ++ii;
        }
    }

    public void getTileEntries(Rectangle region, Collection<TileEntry> results) {
        HashIntSet pairs = new HashIntSet(8, Coord.EMPTY);
        int yy = region.y;
        int yymax = yy + region.height;
        while (yy < yymax) {
            int xx = region.x;
            int xxmax = xx + region.width;
            while (xx < xxmax) {
                int pair = this._tileCoords.get(xx, yy);
                if (pair != Coord.EMPTY) {
                    pairs.add(pair);
                }
                ++xx;
            }
            ++yy;
        }
        Interator it = pairs.interator();
        while (it.hasNext()) {
            TileEntry entry = this.getTileEntry(it.nextInt());
            if (entry == null) continue;
            results.add(entry);
        }
    }

    public TileEntry getTileEntry(int x, int y) {
        int pair = this._tileCoords.get(x, y);
        return pair == Coord.EMPTY ? null : this.getTileEntry(pair);
    }

    public int getTileElevation(int x, int y) {
        int pair = this._tileCoords.get(x, y);
        if (pair == Coord.EMPTY) {
            return Integer.MIN_VALUE;
        }
        int value = this.getTileValue(pair);
        return value == -1 ? Integer.MIN_VALUE : TudeySceneModel.getElevation(value);
    }

    public float getFloorZ(float x, float y, float defvalue) {
        int elevation = this.getTileElevation(FloatMath.ifloor(x), FloatMath.ifloor(y));
        if (elevation == Integer.MIN_VALUE) {
            this._point.getLocation().set(x, y);
            this._point.updateBounds();
            this._space.getIntersecting(this._point, this._floorPlaceableFilter, this._intersecting);
            for (SpaceElement element : this._intersecting) {
                elevation = Math.max(elevation, ((PlaceableEntry)element.getUserObject()).getElevation());
            }
            this._intersecting.clear();
        }
        return elevation == Integer.MIN_VALUE ? defvalue : TudeySceneMetrics.getTileZ(elevation);
    }

    public int addLayer(String name, int position) {
        Preconditions.checkNotNull((Object)name);
        this._layers.add(position - 1, name);
        return position;
    }

    public void renameLayer(int layer, String name) {
        Preconditions.checkArgument((this.validateLayer(layer) != 0 ? 1 : 0) != 0, (Object)"Cannot rename layer 0");
        Preconditions.checkArgument((layer <= 4 ? 1 : 0) != 0, (Object)"Cannot rename constant layers ");
        Preconditions.checkNotNull((Object)name);
        this._layers.set(layer - 1, name);
    }

    public List<String> getLayers() {
        return this._layerNamesView;
    }

    public boolean isLayerEmpty(int layer) {
        this.validateLayer(layer);
        return layer != 0 && !this._layerMap.containsValue(layer);
    }

    public void removeLayer(int layer) {
        Preconditions.checkArgument((this.validateLayer(layer) != 0 ? 1 : 0) != 0, (Object)"Cannot remove layer 0");
        this._layers.remove(layer - 1);
        Iterator<Map.Entry<Integer, Integer>> itr = this._layerMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Integer, Integer> entry = itr.next();
            int entryLayer = entry.getValue();
            if (entryLayer == layer) {
                itr.remove();
                final Integer key = entry.getKey();
                this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<Observer>(){

                    public boolean apply(Observer observer) {
                        if (observer instanceof LayerObserver) {
                            ((LayerObserver)observer).entryLayerWasSet(key, 0);
                        }
                        return true;
                    }
                });
                continue;
            }
            if (entryLayer <= layer) continue;
            entry.setValue(entryLayer - 1);
        }
    }

    public int getLayer(Object key) {
        if (!(key instanceof Integer)) {
            return 0;
        }
        Integer val = this._layerMap.get(key);
        return val == null ? 0 : val;
    }

    public void setLayer(final Object key, final int layer) {
        this.validateLayer(layer);
        if (layer == 0) {
            this._layerMap.remove(key);
        } else {
            Preconditions.checkArgument((boolean)(key instanceof Integer), (Object)"Tiles may only be placed on layer 0");
            this._layerMap.put((Integer)key, layer);
        }
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<Observer>(){

            public boolean apply(Observer observer) {
                if (observer instanceof LayerObserver) {
                    ((LayerObserver)observer).entryLayerWasSet(key, layer);
                }
                return true;
            }
        });
    }

    public Paint setPaint(int x, int y, Paint paint) {
        int ovalue;
        if (paint == null) {
            ovalue = this._paint.remove(x, y);
        } else {
            int idx = this.addPaintConfig(paint.paintable);
            ovalue = this._paint.put(x, y, paint.encode(idx));
        }
        this.invalidate();
        if (ovalue == -1) {
            return null;
        }
        Paint opaint = this.decodePaint(ovalue);
        this.removePaintConfig(TudeySceneModel.getConfigIndex(ovalue));
        return opaint;
    }

    public Paint getPaint(int x, int y) {
        int value = this._paint.get(x, y);
        return value == -1 ? null : this.decodePaint(value);
    }

    public void clearPaint() {
        this._paint.clear();
        this._paintConfigs.clear();
        this._paintConfigIds.clear();
        this.invalidate();
    }

    public void getPreloads(PreloadableSet preloads) {
        for (Entry entry : this.getEntries()) {
            entry.getPreloads(this._cfgmgr, preloads);
        }
    }

    public void getResources(Set<String> paths) {
        for (Entry entry : this.getEntries()) {
            PropertyUtil.getResources(this._cfgmgr, entry, paths);
        }
    }

    public boolean validateReferences(String where, PrintStream out) {
        boolean valid = true;
        HashSet configs = Sets.newHashSet();
        HashSet resources = Sets.newHashSet();
        for (Entry entry : this.getEntries()) {
            PropertyUtil.getReferences(this._cfgmgr, entry, configs, resources);
        }
        boolean bl = valid = PropertyUtil.validateReferences(where, this._cfgmgr, configs, resources, out) && valid;
        return this._cfgmgr.validateReferences(String.valueOf(where) + ":", out) && valid;
    }

    public void writeFields(Exporter out) throws IOException {
        out.write("sceneId", this.sceneId, 0);
        out.write("name", this.name, "");
        out.write("version", this.version, 1);
        out.write("auxModels", this.auxModels, new AuxModel[0], AuxModel[].class);
        out.write("placeConfig", this._placeConfig);
        out.write("tiles", this._tiles);
        out.write("tileConfigs", this._tileConfigs.toArray(new TileConfigMapping[this._tileConfigs.size()]), new TileConfigMapping[0], TileConfigMapping[].class);
        out.write("paint", this._paint, new CoordIntMap());
        out.write("paintConfigs", this._paintConfigs.toArray(new PaintConfigMapping[this._paintConfigs.size()]), new PaintConfigMapping[0], PaintConfigMapping[].class);
        out.write("entries", this._entries.values().toArray(new Entry[this._entries.size()]), new Entry[0], Entry[].class);
        if (this._exportLayers) {
            int layerCount = this._layers.size();
            out.write("layers", this._layers.toArray(new String[layerCount]), new String[0], String[].class);
            ArrayList layers = Lists.newArrayList();
            int ii = 0;
            while (ii < layerCount) {
                layers.add(Lists.newArrayList());
                ++ii;
            }
            for (Map.Entry<Integer, Integer> entry : this._layerMap.entrySet()) {
                ((List)layers.get(entry.getValue() - 1)).add(entry.getKey());
            }
            int[] DEFAULT = new int[]{};
            int ii2 = 0;
            while (ii2 < layerCount) {
                out.write("layer" + (ii2 + 1), Ints.toArray((Collection)((Collection)layers.get(ii2))), DEFAULT);
                ++ii2;
            }
        }
    }

    public void readFields(Importer in) throws IOException {
        int idx;
        this.sceneId = in.read("sceneId", 0);
        this.name = in.read("name", "");
        this.version = in.read("version", 1);
        this.auxModels = in.read("auxModels", new AuxModel[0], AuxModel[].class);
        this._placeConfig = in.read("placeConfig", new TudeySceneConfig(), TudeySceneConfig.class);
        this._tiles = in.read("tiles", new CoordIntMap(), CoordIntMap.class);
        this._tileConfigs = Lists.newArrayList((Object[])in.read("tileConfigs", new TileConfigMapping[0], TileConfigMapping[].class));
        this._paint = in.read("paint", new CoordIntMap(), CoordIntMap.class);
        this._paintConfigs = Lists.newArrayList((Object[])in.read("paintConfigs", new PaintConfigMapping[0], PaintConfigMapping[].class));
        for (CoordIntMap.CoordIntEntry entry : this._tiles.coordIntEntrySet()) {
            idx = TudeySceneModel.getConfigIndex(entry.getIntValue());
            ++this._tileConfigs.get((int)idx).count;
        }
        int ii = 0;
        int nn = this._tileConfigs.size();
        while (ii < nn) {
            TileConfigMapping mapping = this._tileConfigs.get(ii);
            if (mapping != null) {
                this._tileConfigIds.put(mapping.tile, ii);
            }
            ++ii;
        }
        for (CoordIntMap.CoordIntEntry entry : this._paint.coordIntEntrySet()) {
            idx = TudeySceneModel.getConfigIndex(entry.getIntValue());
            ++this._paintConfigs.get((int)idx).count;
        }
        ii = 0;
        nn = this._paintConfigs.size();
        while (ii < nn) {
            PaintConfigMapping mapping = this._paintConfigs.get(ii);
            if (mapping != null) {
                this._paintConfigIds.put(mapping.paintable, ii);
            }
            ++ii;
        }
        Entry[] entryArray = in.read("entries", new Entry[0], Entry[].class);
        int mapping = entryArray.length;
        nn = 0;
        while (nn < mapping) {
            Entry entry = entryArray[nn];
            this._entries.put(entry.getKey(), entry);
            this._references.put(entry.getReference(), entry.getReference());
            if (entry instanceof IdEntry) {
                this._lastEntryId = Math.max(this._lastEntryId, ((IdEntry)entry).getId());
            }
            ++nn;
        }
        this._layers = Lists.newArrayList((Object[])in.read("layers", new String[0], String[].class));
        this._layerMap = Maps.newHashMap();
        int[] DEFAULT = new int[]{};
        if (this._layers.size() == 0) {
            this._layers = Lists.newArrayList((Object[])new String[]{ConstantLayer.PLACEABLE.name, ConstantLayer.AREA.name, ConstantLayer.PATH.name, ConstantLayer.GLOBAL.name});
            for (Entry entry : this._entries.values()) {
                if (entry instanceof TileEntry) continue;
                Object key = entry.getKey();
                Integer id = key instanceof Integer ? (Integer)key : 0;
                Integer layer = 0;
                if (entry instanceof PlaceableEntry) {
                    layer = ConstantLayer.PLACEABLE.index;
                } else if (entry instanceof AreaEntry) {
                    layer = ConstantLayer.AREA.index;
                } else if (entry instanceof PathEntry) {
                    layer = ConstantLayer.PATH.index;
                } else if (entry instanceof GlobalEntry) {
                    layer = ConstantLayer.GLOBAL.index;
                }
                this._layerMap.put(id, layer);
            }
        } else {
            int ii2 = 0;
            int nn2 = this._layers.size();
            while (ii2 < nn2) {
                Integer layer = ii2 + 1;
                int[] nArray = in.read("layer" + layer, DEFAULT);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int key = nArray[n2];
                    this._layerMap.put(key, layer);
                    ++n2;
                }
                ++ii2;
            }
        }
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        byte[] data = this.getData();
        out.writeInt(data.length);
        out.write(data);
    }

    public void readObject(ObjectInputStream in) throws IOException {
        byte[] data = new byte[in.readInt()];
        in.read(data);
        TudeySceneModel nmodel = (TudeySceneModel)ExportUtil.fromBytes(data);
        DeepUtil.copy(nmodel, this);
        this._tiles = nmodel._tiles;
        this._tileConfigs = nmodel._tileConfigs;
        this._tileConfigIds = nmodel._tileConfigIds;
        this._paint = nmodel._paint;
        this._paintConfigs = nmodel._paintConfigs;
        this._paintConfigIds = nmodel._paintConfigIds;
        this._entries = nmodel._entries;
        this._references = nmodel._references;
        this._layers = nmodel._layers;
        this._layerMap = nmodel._layerMap;
        this._data = new SoftReference<byte[]>(data);
    }

    public byte[] getData() {
        byte[] data;
        byte[] byArray = data = this._data == null ? null : this._data.get();
        if (data == null) {
            try {
                this._exportLayers = false;
                data = ExportUtil.toBytes(this);
                this._data = new SoftReference<byte[]>(data);
            }
            finally {
                this._exportLayers = true;
            }
        }
        return data;
    }

    public void invalidate() {
        this._data = null;
        this._dirty = true;
    }

    public void setDirty(boolean dirty) {
        this._dirty = dirty;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    public boolean collides(Actor actor, Shape shape) {
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        int yy = miny;
        while (yy <= maxy) {
            int xx = minx;
            while (xx <= maxx) {
                if (actor.canCollide(this._collisionFlags.get(xx, yy))) {
                    float lx = xx;
                    float ly = yy;
                    float ux = lx + 1.0f;
                    float uy = ly + 1.0f;
                    this._quad.getVertex(0).set(lx, ly);
                    this._quad.getVertex(1).set(ux, ly);
                    this._quad.getVertex(2).set(ux, uy);
                    this._quad.getVertex(3).set(lx, uy);
                    this._quad.getBounds().getMinimumExtent().set(lx, ly);
                    this._quad.getBounds().getMaximumExtent().set(ux, uy);
                    if (this._quad.intersects(shape)) {
                        return true;
                    }
                }
                ++xx;
            }
            ++yy;
        }
        this._space.getIntersecting(shape, this._intersecting);
        try {
            int ii = 0;
            int nn = this._intersecting.size();
            while (ii < nn) {
                SpaceElement element = this._intersecting.get(ii);
                Entry entry = (Entry)element.getUserObject();
                if (actor.canCollide(entry.getCollisionFlags(this._cfgmgr))) {
                    return true;
                }
                ++ii;
            }
        }
        finally {
            this._intersecting.clear();
        }
        return false;
    }

    public boolean collides(int mask, Shape shape) {
        if (mask == 0) {
            return false;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        int yy = miny;
        while (yy <= maxy) {
            int xx = minx;
            while (xx <= maxx) {
                if ((this._collisionFlags.get(xx, yy) & mask) != 0) {
                    float lx = xx;
                    float ly = yy;
                    float ux = lx + 1.0f;
                    float uy = ly + 1.0f;
                    this._quad.getVertex(0).set(lx, ly);
                    this._quad.getVertex(1).set(ux, ly);
                    this._quad.getVertex(2).set(ux, uy);
                    this._quad.getVertex(3).set(lx, uy);
                    this._quad.getBounds().getMinimumExtent().set(lx, ly);
                    this._quad.getBounds().getMaximumExtent().set(ux, uy);
                    if (this._quad.intersects(shape)) {
                        return true;
                    }
                }
                ++xx;
            }
            ++yy;
        }
        this._space.getIntersecting(shape, this._intersecting);
        try {
            int ii = 0;
            int nn = this._intersecting.size();
            while (ii < nn) {
                SpaceElement element = this._intersecting.get(ii);
                Entry entry = (Entry)element.getUserObject();
                if ((entry.getCollisionFlags(this._cfgmgr) & mask) != 0) {
                    return true;
                }
                ++ii;
            }
        }
        finally {
            this._intersecting.clear();
        }
        return false;
    }

    public boolean getNearestPoint(Shape shape, int mask, Vector2f origin, Vector2f nearPoint) {
        if (mask == 0) {
            return false;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        Vector2f result = new Vector2f();
        float resultDist = Float.POSITIVE_INFINITY;
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        int yy = miny;
        while (yy <= maxy) {
            int xx = minx;
            while (xx <= maxx) {
                if ((this._collisionFlags.get(xx, yy) & mask) != 0) {
                    float lx = xx;
                    float ly = yy;
                    float ux = lx + 1.0f;
                    float uy = ly + 1.0f;
                    this._quad.getVertex(0).set(lx, ly);
                    this._quad.getVertex(1).set(ux, ly);
                    this._quad.getVertex(2).set(ux, uy);
                    this._quad.getVertex(3).set(lx, uy);
                    this._quad.getBounds().getMinimumExtent().set(lx, ly);
                    this._quad.getBounds().getMaximumExtent().set(ux, uy);
                    if (this._quad.intersects(shape)) {
                        this._quad.getNearestPoint(origin, result);
                        float dist = result.distanceSquared(origin);
                        if (resultDist > dist) {
                            nearPoint.set(result);
                            resultDist = dist;
                        }
                    }
                }
                ++xx;
            }
            ++yy;
        }
        this._space.getIntersecting(shape, this._intersecting);
        try {
            int ii = 0;
            int nn = this._intersecting.size();
            while (ii < nn) {
                SpaceElement element = this._intersecting.get(ii);
                Entry entry = (Entry)element.getUserObject();
                if ((entry.getCollisionFlags(this._cfgmgr) & mask) != 0) {
                    element.getNearestPoint(origin, result);
                    float dist = result.distanceSquared(origin);
                    if (resultDist > dist) {
                        nearPoint.set(result);
                        resultDist = dist;
                    }
                }
                ++ii;
            }
        }
        finally {
            this._intersecting.clear();
        }
        return resultDist != Float.POSITIVE_INFINITY;
    }

    public boolean getIntersection(Ray2D ray, float length, int mask, Vector2f intersection) {
        if (mask == 0) {
            return false;
        }
        Segment seg = new Segment(ray.getOrigin(), ray.getOrigin().add(ray.getDirection().mult(length)));
        Rect bounds = seg.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        Vector2f result = new Vector2f();
        float resultDist = length * length;
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        int yy = miny;
        while (yy <= maxy) {
            int xx = minx;
            while (xx <= maxx) {
                if ((this._collisionFlags.get(xx, yy) & mask) != 0) {
                    float dist;
                    float lx = xx;
                    float ly = yy;
                    float ux = lx + 1.0f;
                    float uy = ly + 1.0f;
                    this._quad.getVertex(0).set(lx, ly);
                    this._quad.getVertex(1).set(ux, ly);
                    this._quad.getVertex(2).set(ux, uy);
                    this._quad.getVertex(3).set(lx, uy);
                    this._quad.getBounds().getMinimumExtent().set(lx, ly);
                    this._quad.getBounds().getMaximumExtent().set(ux, uy);
                    if (this._quad.getIntersection(ray, result) && resultDist > (dist = result.distanceSquared(ray.getOrigin()))) {
                        intersection.set(result);
                        resultDist = dist;
                    }
                }
                ++xx;
            }
            ++yy;
        }
        this._space.getIntersecting(seg, this._intersecting);
        try {
            int ii = 0;
            int nn = this._intersecting.size();
            while (ii < nn) {
                float dist;
                SpaceElement element = this._intersecting.get(ii);
                Entry entry = (Entry)element.getUserObject();
                if ((entry.getCollisionFlags(this._cfgmgr) & mask) != 0 && element.getIntersection(ray, result) && resultDist > (dist = result.distanceSquared(ray.getOrigin()))) {
                    intersection.set(result);
                    resultDist = dist;
                }
                ++ii;
            }
        }
        finally {
            this._intersecting.clear();
        }
        return resultDist < length * length;
    }

    @Override
    public TudeySceneModel getSceneModel() {
        return this;
    }

    @Override
    public boolean getPenetration(Actor actor, Shape shape, Vector2f result) {
        result.set(Vector2f.ZERO);
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        int yy = miny;
        while (yy <= maxy) {
            int xx = minx;
            while (xx <= maxx) {
                if (actor.canCollide(this._collisionFlags.get(xx, yy))) {
                    float lx = xx;
                    float ly = yy;
                    float ux = lx + 1.0f;
                    float uy = ly + 1.0f;
                    this._quad.getVertex(0).set(lx, ly);
                    this._quad.getVertex(1).set(ux, ly);
                    this._quad.getVertex(2).set(ux, uy);
                    this._quad.getVertex(3).set(lx, uy);
                    this._quad.getBounds().getMinimumExtent().set(lx, ly);
                    this._quad.getBounds().getMaximumExtent().set(ux, uy);
                    if (this._quad.intersects(shape)) {
                        this._quad.getPenetration(shape, this._penetration);
                        if (this._penetration.lengthSquared() > result.lengthSquared()) {
                            result.set(this._penetration);
                        }
                    }
                }
                ++xx;
            }
            ++yy;
        }
        this._space.getIntersecting(shape, this._intersecting);
        int ii = 0;
        int nn = this._intersecting.size();
        while (ii < nn) {
            SpaceElement element = this._intersecting.get(ii);
            Entry entry = (Entry)element.getUserObject();
            if (actor.canCollide(entry.getCollisionFlags(this._cfgmgr))) {
                ((ShapeElement)element).getWorldShape().getPenetration(shape, this._penetration);
                if (this._penetration.lengthSquared() > result.lengthSquared()) {
                    result.set(this._penetration);
                }
            }
            ++ii;
        }
        this._intersecting.clear();
        return !result.equals(Vector2f.ZERO);
    }

    @Override
    public int getDirections(Actor actor, Shape shape) {
        if (!actor.directionAffected()) {
            return 0;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int direction = 0;
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        int yy = miny;
        while (yy <= maxy) {
            int xx = minx;
            while (xx <= maxx) {
                direction |= this._directionFlags.get(xx, yy);
                ++xx;
            }
            ++yy;
        }
        this._space.getIntersecting(shape, this._intersecting);
        int ii = 0;
        int nn = this._intersecting.size();
        while (ii < nn) {
            SpaceElement element = this._intersecting.get(ii);
            Entry entry = (Entry)element.getUserObject();
            direction |= entry.getDirectionFlags(this._cfgmgr);
            ++ii;
        }
        this._intersecting.clear();
        return direction;
    }

    public TudeySceneModel clone() {
        DeepObject mapping;
        TudeySceneModel model = DeepUtil.copy(this, null);
        model._tiles.putAll(this._tiles);
        int ii = 0;
        int nn = this._tileConfigs.size();
        while (ii < nn) {
            mapping = DeepUtil.copy(this._tileConfigs.get(ii), null);
            model._tileConfigs.add((TileConfigMapping)mapping);
            if (mapping != null) {
                model._tileConfigIds.put(mapping.tile, ii);
            }
            ++ii;
        }
        model._paint.putAll(this._paint);
        ii = 0;
        nn = this._paintConfigs.size();
        while (ii < nn) {
            mapping = DeepUtil.copy(this._paintConfigs.get(ii), null);
            model._paintConfigs.add((PaintConfigMapping)mapping);
            if (mapping != null) {
                model._paintConfigIds.put(((PaintConfigMapping)mapping).paintable, ii);
            }
            ++ii;
        }
        for (Entry entry : this._entries.values()) {
            entry = DeepUtil.copy(entry, null);
            model.canonicalizeReference(entry);
            model._entries.put(entry.getKey(), entry);
        }
        model._layers = Lists.newArrayList(this._layers);
        model._layerMap = Maps.newHashMap(this._layerMap);
        return model;
    }

    protected Entry add(Entry entry) {
        if (!(entry instanceof TileEntry)) {
            Entry oentry = this._entries.put(entry.getKey(), entry);
            if (oentry == null) {
                this.canonicalizeReference(entry);
                this.addElement(entry);
                this.invalidate();
            } else {
                this._entries.put(entry.getKey(), oentry);
            }
            return oentry;
        }
        TileEntry tentry = (TileEntry)entry;
        Coord coord = tentry.getLocation();
        int idx = this.addTileConfig(tentry.tile);
        int ovalue = this._tiles.put(coord.x, coord.y, tentry.encode(idx));
        if (ovalue != -1) {
            this._tiles.put(coord.x, coord.y, ovalue);
            this.removeTileConfig(idx);
            return this.decodeTileEntry(coord, ovalue);
        }
        this.createShadow(tentry);
        this.invalidate();
        return null;
    }

    protected Entry update(Entry nentry) {
        if (!(nentry instanceof TileEntry)) {
            Entry oentry = this._entries.put(nentry.getKey(), nentry);
            if (oentry == null) {
                this._entries.remove(nentry.getKey());
            } else {
                this.canonicalizeReference(nentry);
                this.removeElement(oentry);
                this.addElement(nentry);
                this.invalidate();
            }
            return oentry;
        }
        TileEntry tentry = (TileEntry)nentry;
        Coord coord = tentry.getLocation();
        int idx = this.addTileConfig(tentry.tile);
        int ovalue = this._tiles.put(coord.x, coord.y, tentry.encode(idx));
        if (ovalue == -1) {
            this._tiles.remove(coord.x, coord.y);
            this.removeTileConfig(idx);
            return null;
        }
        TileEntry oentry = this.decodeTileEntry(coord, ovalue);
        this.removeTileConfig(TudeySceneModel.getConfigIndex(ovalue));
        this.deleteShadow(oentry);
        this.createShadow(tentry);
        this.invalidate();
        return oentry;
    }

    protected Entry remove(Object key) {
        if (!(key instanceof Coord)) {
            this._layerMap.remove(key);
            Entry oentry = this._entries.remove(key);
            if (oentry != null) {
                this.removeElement(oentry);
                this.invalidate();
            }
            return oentry;
        }
        Coord coord = (Coord)key;
        int ovalue = this._tiles.remove(coord.x, coord.y);
        if (ovalue == -1) {
            return null;
        }
        TileEntry oentry = this.decodeTileEntry(coord, ovalue);
        this.removeTileConfig(TudeySceneModel.getConfigIndex(ovalue));
        this.deleteShadow(oentry);
        this.invalidate();
        return oentry;
    }

    protected void addElement(Entry entry) {
        SpaceElement element = entry.createElement(this._cfgmgr);
        if (element != null) {
            this._space.add(element);
            this._elements.put(entry.getKey(), element);
        }
        this.mapEntry(entry);
    }

    protected void removeElement(Entry entry) {
        SpaceElement element = this._elements.remove(entry.getKey());
        if (element != null) {
            this._space.remove(element);
        }
        this.unmapEntry(entry);
    }

    protected void createShadow(TileEntry entry) {
        int pair = entry.getLocation().encode();
        TileConfig.Original config = entry.getConfig(this._cfgmgr);
        entry.getRegion(config, this._region);
        int yy = this._region.y;
        int yymax = yy + this._region.height;
        while (yy < yymax) {
            int xx = this._region.x;
            int xxmax = xx + this._region.width;
            while (xx < xxmax) {
                this._tileCoords.put(xx, yy, pair);
                int flags = entry.getCollisionFlags(config, xx, yy);
                if (flags != 0) {
                    this._collisionFlags.put(xx, yy, flags);
                }
                if ((flags = entry.getDirectionFlags(config, xx, yy)) != 0) {
                    this._directionFlags.put(xx, yy, flags);
                }
                ++xx;
            }
            ++yy;
        }
        this.mapEntry(entry);
    }

    protected void deleteShadow(TileEntry entry) {
        entry.getRegion(entry.getConfig(this._cfgmgr), this._region);
        int yy = this._region.y;
        int yymax = yy + this._region.height;
        while (yy < yymax) {
            int xx = this._region.x;
            int xxmax = xx + this._region.width;
            while (xx < xxmax) {
                this._tileCoords.remove(xx, yy);
                this._collisionFlags.remove(xx, yy);
                this._directionFlags.remove(xx, yy);
                ++xx;
            }
            ++yy;
        }
        this.unmapEntry(entry);
    }

    protected void mapEntry(Entry entry) {
        String[] stringArray = entry.getTags(this._cfgmgr);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            ArrayList list = this._tagged.get(tag);
            if (list == null) {
                list = Lists.newArrayList();
                this._tagged.put(tag, list);
            }
            list.add((Entry)entry);
            ++n2;
        }
    }

    protected void unmapEntry(Entry entry) {
        String[] stringArray = entry.getTags(this._cfgmgr);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            List<Entry> list = this._tagged.get(tag);
            if (list != null) {
                list.remove(entry);
                if (list.isEmpty()) {
                    this._tagged.remove(tag);
                }
            }
            ++n2;
        }
    }

    protected TileEntry getTileEntry(int pair) {
        int y;
        int x = Coord.decodeX(pair);
        int value = this._tiles.get(x, y = Coord.decodeY(pair));
        if (value == -1) {
            Log.log.warning((Object)"Tile shadow points to nonexistent tile.", new Object[]{"x", x, "y", y});
            return null;
        }
        return this.decodeTileEntry(x, y, value);
    }

    protected int getTileValue(int pair) {
        int y;
        int x = Coord.decodeX(pair);
        int value = this._tiles.get(x, y = Coord.decodeY(pair));
        if (value == -1) {
            Log.log.warning((Object)"Tile shadow points to nonexistent tile.", new Object[]{"x", x, "y", y});
        }
        return value;
    }

    protected void canonicalizeReference(Entry entry) {
        ConfigReference eref = entry.getReference();
        if (eref == null) {
            return;
        }
        ConfigReference cref = this._references.get(eref);
        if (cref == null) {
            this._references.put(eref, eref);
        } else {
            entry.setReference(cref);
        }
    }

    protected int addTileConfig(ConfigReference<TileConfig> tile) {
        TileConfigMapping mapping;
        Integer idx = this._tileConfigIds.get(tile);
        if (idx == null) {
            mapping = new TileConfigMapping(tile);
            int ii = 0;
            int nn = this._tileConfigs.size();
            while (ii < nn) {
                if (this._tileConfigs.get(ii) == null) {
                    idx = ii;
                    this._tileConfigs.set(ii, mapping);
                    break;
                }
                ++ii;
            }
            if (idx == null) {
                idx = this._tileConfigs.size();
                this._tileConfigs.add(mapping);
            }
            this._tileConfigIds.put(tile, idx);
        } else {
            mapping = this._tileConfigs.get(idx);
        }
        ++mapping.count;
        return idx;
    }

    protected void removeTileConfig(int idx) {
        TileConfigMapping mapping = this._tileConfigs.get(idx);
        if (--mapping.count == 0) {
            this._tileConfigs.set(idx, null);
            this._tileConfigIds.remove(mapping.tile);
            if (idx == this._tileConfigs.size() - 1) {
                int ii = idx;
                while (ii >= 0 && this._tileConfigs.get(ii) == null) {
                    this._tileConfigs.remove(ii);
                    --ii;
                }
            }
        }
    }

    protected TileEntry decodeTileEntry(Coord coord, int value) {
        return this.decodeTileEntry(coord.x, coord.y, value);
    }

    protected TileEntry decodeTileEntry(int x, int y, int value) {
        TileEntry entry = new TileEntry();
        entry.getLocation().set(x, y);
        entry.tile = this._tileConfigs.get((int)TudeySceneModel.getConfigIndex((int)value)).tile;
        entry.elevation = TudeySceneModel.getElevation(value);
        entry.rotation = value & 3;
        return entry;
    }

    protected int addPaintConfig(ConfigReference<? extends PaintableConfig> paintable) {
        PaintConfigMapping mapping;
        Integer idx = this._paintConfigIds.get(paintable);
        if (idx == null) {
            mapping = new PaintConfigMapping(paintable);
            int ii = 0;
            int nn = this._paintConfigs.size();
            while (ii < nn) {
                if (this._paintConfigs.get(ii) == null) {
                    idx = ii;
                    this._paintConfigs.set(ii, mapping);
                    break;
                }
                ++ii;
            }
            if (idx == null) {
                idx = this._paintConfigs.size();
                this._paintConfigs.add(mapping);
            }
            this._paintConfigIds.put(paintable, idx);
        } else {
            mapping = this._paintConfigs.get(idx);
        }
        ++mapping.count;
        return idx;
    }

    protected void removePaintConfig(int idx) {
        PaintConfigMapping mapping = this._paintConfigs.get(idx);
        if (--mapping.count == 0) {
            this._paintConfigs.set(idx, null);
            this._paintConfigIds.remove(mapping.paintable);
            if (idx == this._paintConfigs.size() - 1) {
                int ii = idx;
                while (ii >= 0 && this._paintConfigs.get(ii) == null) {
                    this._paintConfigs.remove(ii);
                    --ii;
                }
            }
        }
    }

    protected Paint decodePaint(int value) {
        Paint paint = new Paint();
        paint.paintable = this._paintConfigs.get((int)TudeySceneModel.getConfigIndex((int)value)).paintable;
        paint.type = Paint.Type.values()[value & 3];
        paint.elevation = TudeySceneModel.getElevation(value);
        return paint;
    }

    protected int validateLayer(int layer) {
        return Preconditions.checkElementIndex((int)layer, (int)(this._layers.size() + 1));
    }

    protected static int getConfigIndex(int value) {
        return value >>> 16;
    }

    protected static int getElevation(int value) {
        return value << 16 >> 18;
    }

    public static class AreaEntry
    extends IdEntry {
        @Editable(nullable=true)
        public ConfigReference<AreaConfig> area;
        @Editable
        public Vertex[] vertices = new Vertex[0];

        public AreaConfig.Original getConfig(ConfigManager cfgmgr) {
            AreaConfig config = cfgmgr.getConfig(AreaConfig.class, this.area);
            AreaConfig.Original original = config == null ? null : config.getOriginal(cfgmgr);
            return original == null ? AreaConfig.NULL_ORIGINAL : original;
        }

        @Override
        public void setReference(ConfigReference reference) {
            ConfigReference ref;
            this.area = ref = reference;
        }

        @Override
        public ConfigReference getReference() {
            return this.area;
        }

        @Override
        public boolean isValid(ConfigManager cfgmgr) {
            return this.getConfig(cfgmgr) != AreaConfig.NULL_ORIGINAL;
        }

        @Override
        public void getBounds(ConfigManager cfgmgr, Rect result) {
            result.setToEmpty();
            Vertex[] vertexArray = this.vertices;
            int n = this.vertices.length;
            int n2 = 0;
            while (n2 < n) {
                Vertex vertex = vertexArray[n2];
                result.addLocal(vertex.createVector());
                ++n2;
            }
        }

        @Override
        public String getLogicClassName(ConfigManager cfgmgr) {
            return this.getConfig(cfgmgr).getLogicClassName();
        }

        @Override
        public String[] getTags(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).tags.getTags();
        }

        @Override
        public HandlerConfig[] getHandlers(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).handlers;
        }

        @Override
        public boolean isDefaultEntrance(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).defaultEntrance;
        }

        @Override
        public Vector2f getTranslation(ConfigManager cfgmgr) {
            if (this.vertices.length == 0) {
                return Vector2f.ZERO;
            }
            Vector2f result = new Vector2f();
            Vertex[] vertexArray = this.vertices;
            int n = this.vertices.length;
            int n2 = 0;
            while (n2 < n) {
                Vertex vertex = vertexArray[n2];
                result.addLocal(vertex.x, vertex.y);
                ++n2;
            }
            return result.multLocal(1.0f / (float)this.vertices.length);
        }

        @Override
        public Shape createShape(ConfigManager cfgmgr) {
            switch (this.vertices.length) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new Point(this.vertices[0].createVector());
                }
                case 2: {
                    return new Segment(this.vertices[0].createVector(), this.vertices[1].createVector());
                }
            }
            Vector2f[] vectors = new Vector2f[this.vertices.length];
            boolean reversed = this.isReversed();
            int ii = 0;
            while (ii < vectors.length) {
                int idx = reversed ? vectors.length - ii - 1 : ii;
                vectors[ii] = this.vertices[idx].createVector();
                ++ii;
            }
            return new Polygon(vectors);
        }

        @Override
        public void transform(ConfigManager cfgmgr, Transform3D xform) {
            Matrix4f matrix = xform.update(3).getMatrix();
            Vertex[] vertexArray = this.vertices;
            int n = this.vertices.length;
            int n2 = 0;
            while (n2 < n) {
                Vertex vertex = vertexArray[n2];
                vertex.transform(matrix);
                ++n2;
            }
        }

        @Override
        public SpaceElement createElement(ConfigManager cfgmgr) {
            Shape shape = this.createShape(cfgmgr);
            if (shape == null) {
                return null;
            }
            ShapeElement element = new ShapeElement(shape);
            element.setUserObject(this);
            return element;
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            if (preloads.add(new Preloadable.Config(AreaConfig.class, this.area))) {
                this.getConfig(cfgmgr).getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public EntryCursor createCursor(TudeyContext ctx, TudeySceneView view) {
            return new AreaCursor(ctx, view, this);
        }

        @Override
        public EntrySprite createSprite(TudeyContext ctx, TudeySceneView view) {
            return new AreaSprite(ctx, view, this);
        }

        protected boolean isReversed() {
            int cw = 0;
            int ccw = 0;
            int ii = 0;
            while (ii < this.vertices.length) {
                Vertex v0 = this.vertices[ii];
                Vertex v1 = this.vertices[(ii + 1) % this.vertices.length];
                Vertex v2 = this.vertices[(ii + 2) % this.vertices.length];
                float x1 = v1.x - v0.x;
                float y2 = v2.y - v1.y;
                float y1 = v1.y - v0.y;
                float x2 = v2.x - v1.x;
                if (x1 * y2 - y1 * x2 < 0.0f) {
                    ++cw;
                } else {
                    ++ccw;
                }
                ++ii;
            }
            return cw > ccw;
        }
    }

    public static enum ConstantLayer {
        TILE(TileEntry.class, "Tile", 0),
        PLACEABLE(PlaceableEntry.class, "Placeable", 1),
        AREA(AreaEntry.class, "Area", 2),
        PATH(PathEntry.class, "Path", 3),
        GLOBAL(GlobalEntry.class, "Global", 4);

        public static Map<Class<? extends Entry>, Integer> ConstantLayerMap;
        private Class<? extends Entry> type;
        private String name;
        private Integer index;

        static {
            ConstantLayerMap = new HashMap<Class<? extends Entry>, Integer>();
            ConstantLayerMap.put(ConstantLayer.TILE.type, ConstantLayer.TILE.index);
            ConstantLayerMap.put(ConstantLayer.PLACEABLE.type, ConstantLayer.PLACEABLE.index);
            ConstantLayerMap.put(ConstantLayer.AREA.type, ConstantLayer.AREA.index);
            ConstantLayerMap.put(ConstantLayer.PATH.type, ConstantLayer.PATH.index);
            ConstantLayerMap.put(ConstantLayer.GLOBAL.type, ConstantLayer.GLOBAL.index);
        }

        private ConstantLayer(Class<? extends Entry> type, String name, Integer index) {
            this.type = type;
            this.name = name;
            this.index = index;
        }
    }

    public static abstract class Entry
    extends DeepObject
    implements Exportable {
        public static final int WARP = 1;
        public static final int LAST_FLAG = 1;
        @DeepOmit
        protected int _flags;

        public abstract Object getKey();

        public abstract void setReference(ConfigReference var1);

        public abstract ConfigReference getReference();

        public abstract boolean isValid(ConfigManager var1);

        public int getElevation() {
            return Integer.MIN_VALUE;
        }

        public void getBounds(ConfigManager cfgmgr, Rect result) {
            result.setToEmpty();
        }

        public int getCollisionFlags(ConfigManager cfgmgr) {
            return 0;
        }

        public int getDirectionFlags(ConfigManager cfgmgr) {
            return 0;
        }

        public void setFlags(int flags) {
            this._flags = flags;
        }

        public int getFlags() {
            return this._flags;
        }

        public void set(int flag, boolean value) {
            this._flags = value ? this._flags | flag : this._flags & ~flag;
        }

        public void set(int flag) {
            this._flags |= flag;
        }

        public void clear(int flag) {
            this._flags &= ~flag;
        }

        public boolean isSet(int flag) {
            return (this._flags & flag) != 0;
        }

        public abstract String getLogicClassName(ConfigManager var1);

        public abstract String[] getTags(ConfigManager var1);

        public abstract HandlerConfig[] getHandlers(ConfigManager var1);

        public boolean isDefaultEntrance(ConfigManager cfgmgr) {
            return false;
        }

        public Vector2f getTranslation(ConfigManager cfgmgr) {
            return Vector2f.ZERO;
        }

        public float getRotation(ConfigManager cfgmgr) {
            return 0.0f;
        }

        public ConfigReference<ModelConfig> getModel(ConfigManager cfgmgr) {
            return null;
        }

        public Shape createShape(ConfigManager cfgmgr) {
            return null;
        }

        public Vector2f[] createPatrolPath(Shape shape) {
            return shape == null ? null : shape.getPerimeterPath();
        }

        public void transform(ConfigManager cfgmgr, Transform3D xform) {
        }

        public abstract void getPreloads(ConfigManager var1, PreloadableSet var2);

        public SpaceElement createElement(ConfigManager cfgmgr) {
            return null;
        }

        public EntryCursor createCursor(TudeyContext ctx, TudeySceneView view) {
            return null;
        }

        public abstract EntrySprite createSprite(TudeyContext var1, TudeySceneView var2);
    }

    protected static class FloorPlaceableFilter
    implements Exportable,
    Predicate<SpaceElement> {
        protected FloorPlaceableFilter() {
        }

        public boolean apply(SpaceElement element) {
            return element instanceof PlaceableElement;
        }
    }

    public static class GlobalEntry
    extends IdEntry {
        @Editable(nullable=true)
        public ConfigReference<SceneGlobalConfig> sceneGlobal;

        public SceneGlobalConfig.Original getConfig(ConfigManager cfgmgr) {
            SceneGlobalConfig config = cfgmgr.getConfig(SceneGlobalConfig.class, this.sceneGlobal);
            SceneGlobalConfig.Original original = config == null ? null : config.getOriginal(cfgmgr);
            return original == null ? SceneGlobalConfig.NULL_ORIGINAL : original;
        }

        @Override
        public void setReference(ConfigReference reference) {
            ConfigReference ref;
            this.sceneGlobal = ref = reference;
        }

        @Override
        public ConfigReference getReference() {
            return this.sceneGlobal;
        }

        @Override
        public boolean isValid(ConfigManager cfgmgr) {
            return this.getConfig(cfgmgr) != SceneGlobalConfig.NULL_ORIGINAL;
        }

        @Override
        public String getLogicClassName(ConfigManager cfgmgr) {
            return this.getConfig(cfgmgr).getLogicClassName();
        }

        @Override
        public String[] getTags(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).tags.getTags();
        }

        @Override
        public HandlerConfig[] getHandlers(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).handlers;
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            if (preloads.add(new Preloadable.Config(SceneGlobalConfig.class, this.sceneGlobal))) {
                this.getConfig(cfgmgr).getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public EntrySprite createSprite(TudeyContext ctx, TudeySceneView view) {
            return new GlobalSprite(ctx, view, this);
        }
    }

    public static abstract class IdEntry
    extends Entry
    implements Comparable<IdEntry> {
        protected int _id;

        public void setId(int id) {
            this._id = id;
        }

        public int getId() {
            return this._id;
        }

        @Override
        public int compareTo(IdEntry other) {
            return this._id - other._id;
        }

        @Override
        public Object getKey() {
            return this._id;
        }
    }

    public static interface LayerObserver
    extends Observer {
        public void entryLayerWasSet(Object var1, int var2);
    }

    public static interface Observer {
        public void entryAdded(Entry var1);

        public void entryUpdated(Entry var1, Entry var2);

        public void entryRemoved(Entry var1);
    }

    public static class Paint
    extends DeepObject
    implements Exportable {
        public Type type;
        public ConfigReference<? extends PaintableConfig> paintable;
        public int elevation;

        public Paint(Type type, ConfigReference<? extends PaintableConfig> paintable, int elevation) {
            this.type = type;
            this.paintable = paintable;
            this.elevation = elevation;
        }

        public Paint() {
        }

        public <T extends PaintableConfig> T getConfig(ConfigManager cfgmgr, Class<T> clazz) {
            ConfigReference<? extends PaintableConfig> ref = this.paintable;
            return (T)cfgmgr.getConfig(clazz, ref);
        }

        public int encode(int idx) {
            return idx << 16 | (this.elevation & 0x3FFF) << 2 | this.type.ordinal();
        }

        public static enum Type {
            FLOOR,
            EDGE,
            WALL;

        }
    }

    protected static class PaintConfigMapping
    extends DeepObject
    implements Exportable {
        public ConfigReference<? extends PaintableConfig> paintable;
        public transient int count;

        public PaintConfigMapping(ConfigReference<? extends PaintableConfig> paintable) {
            this.paintable = paintable;
        }

        public PaintConfigMapping() {
        }
    }

    public static class PathEntry
    extends IdEntry {
        @Editable(nullable=true)
        public ConfigReference<PathConfig> path;
        @Editable
        public Vertex[] vertices = new Vertex[0];

        public PathConfig.Original getConfig(ConfigManager cfgmgr) {
            PathConfig config = cfgmgr.getConfig(PathConfig.class, this.path);
            PathConfig.Original original = config == null ? null : config.getOriginal(cfgmgr);
            return original == null ? PathConfig.NULL_ORIGINAL : original;
        }

        @Override
        public void setReference(ConfigReference reference) {
            ConfigReference ref;
            this.path = ref = reference;
        }

        @Override
        public ConfigReference getReference() {
            return this.path;
        }

        @Override
        public boolean isValid(ConfigManager cfgmgr) {
            return this.getConfig(cfgmgr) != PathConfig.NULL_ORIGINAL;
        }

        @Override
        public void getBounds(ConfigManager cfgmgr, Rect result) {
            result.setToEmpty();
            Vertex[] vertexArray = this.vertices;
            int n = this.vertices.length;
            int n2 = 0;
            while (n2 < n) {
                Vertex vertex = vertexArray[n2];
                result.addLocal(vertex.createVector());
                ++n2;
            }
        }

        @Override
        public String getLogicClassName(ConfigManager cfgmgr) {
            return this.getConfig(cfgmgr).getLogicClassName();
        }

        @Override
        public String[] getTags(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).tags.getTags();
        }

        @Override
        public HandlerConfig[] getHandlers(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).handlers;
        }

        @Override
        public boolean isDefaultEntrance(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).defaultEntrance;
        }

        @Override
        public Vector2f getTranslation(ConfigManager cfgmgr) {
            return this.vertices.length == 0 ? Vector2f.ZERO : this.vertices[0].createVector();
        }

        @Override
        public float getRotation(ConfigManager cfgmgr) {
            return this.vertices.length < 2 ? 0.0f : FloatMath.atan2(this.vertices[1].y - this.vertices[0].y, this.vertices[1].x - this.vertices[0].x);
        }

        @Override
        public Shape createShape(ConfigManager cfgmgr) {
            switch (this.vertices.length) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new Point(this.vertices[0].createVector());
                }
            }
            return this.createShape(0, this.vertices.length - 1);
        }

        @Override
        public Vector2f[] createPatrolPath(Shape shape) {
            if (this.vertices.length == 0) {
                return null;
            }
            Vector2f[] path = new Vector2f[this.vertices.length];
            int ii = 0;
            while (ii < this.vertices.length) {
                path[ii] = this.vertices[ii].createVector();
                ++ii;
            }
            return path;
        }

        @Override
        public void transform(ConfigManager cfgmgr, Transform3D xform) {
            Matrix4f matrix = xform.update(3).getMatrix();
            Vertex[] vertexArray = this.vertices;
            int n = this.vertices.length;
            int n2 = 0;
            while (n2 < n) {
                Vertex vertex = vertexArray[n2];
                vertex.transform(matrix);
                ++n2;
            }
        }

        @Override
        public SpaceElement createElement(ConfigManager cfgmgr) {
            Shape shape = this.createShape(cfgmgr);
            if (shape == null) {
                return null;
            }
            ShapeElement element = new ShapeElement(shape);
            element.setUserObject(this);
            return element;
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            if (preloads.add(new Preloadable.Config(PathConfig.class, this.path))) {
                this.getConfig(cfgmgr).getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public EntryCursor createCursor(TudeyContext ctx, TudeySceneView view) {
            return new PathCursor(ctx, view, this);
        }

        @Override
        public EntrySprite createSprite(TudeyContext ctx, TudeySceneView view) {
            return new PathSprite(ctx, view, this);
        }

        protected Shape createShape(int idx0, int idx1) {
            if (idx1 - idx0 == 1) {
                return new Segment(this.vertices[idx0].createVector(), this.vertices[idx1].createVector());
            }
            int mid = (idx0 + idx1) / 2;
            return new Compound(this.createShape(idx0, mid), this.createShape(mid, idx1));
        }
    }

    public static class PlaceableElement
    extends ShapeElement {
        public PlaceableElement(PlaceableConfig.Original config) {
            super(config.shape);
        }
    }

    public static class PlaceableEntry
    extends IdEntry {
        @Editable(nullable=true)
        public ConfigReference<PlaceableConfig> placeable;
        @Editable(step=0.01)
        public Transform3D transform = new Transform3D();
        protected transient int _collisionFlags = -1;
        protected transient int _directionFlags = -1;

        public PlaceableConfig.Original getConfig(ConfigManager cfgmgr) {
            PlaceableConfig config = cfgmgr.getConfig(PlaceableConfig.class, this.placeable);
            PlaceableConfig.Original original = config == null ? null : config.getOriginal(cfgmgr);
            return original == null ? PlaceableConfig.NULL_ORIGINAL : original;
        }

        @Override
        public void setReference(ConfigReference reference) {
            ConfigReference ref;
            this.placeable = ref = reference;
        }

        @Override
        public ConfigReference getReference() {
            return this.placeable;
        }

        @Override
        public boolean isValid(ConfigManager cfgmgr) {
            return this.getConfig(cfgmgr) != PlaceableConfig.NULL_ORIGINAL;
        }

        @Override
        public int getElevation() {
            this.transform.update(1);
            return TudeySceneMetrics.getTileElevation(this.transform.getTranslation().z);
        }

        @Override
        public void getBounds(ConfigManager cfgmgr, Rect result) {
            Shape shape = this.getConfig((ConfigManager)cfgmgr).shape.getShape().transform(new Transform2D(this.transform));
            result.set(shape.getBounds());
        }

        @Override
        public int getCollisionFlags(ConfigManager cfgmgr) {
            if (this._collisionFlags == -1) {
                this._collisionFlags = this.getConfig(cfgmgr).getCollisionFlags();
            }
            return this._collisionFlags;
        }

        @Override
        public int getDirectionFlags(ConfigManager cfgmgr) {
            if (this._directionFlags == -1) {
                this._directionFlags = this.getConfig(cfgmgr).getDirectionFlags();
                if (this.transform.getRotation() != null) {
                    float z = this.transform.getRotation().getRotationZ();
                    this._directionFlags = DirectionUtil.rotateDirections(this._directionFlags, z);
                }
            }
            return this._directionFlags;
        }

        @Override
        public String getLogicClassName(ConfigManager cfgmgr) {
            return this.getConfig(cfgmgr).getLogicClassName();
        }

        @Override
        public String[] getTags(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).tags.getTags();
        }

        @Override
        public HandlerConfig[] getHandlers(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).handlers;
        }

        @Override
        public boolean isDefaultEntrance(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).defaultEntrance;
        }

        @Override
        public Vector2f getTranslation(ConfigManager cfgmgr) {
            this.transform.update(1);
            Vector3f translation = this.transform.getTranslation();
            return new Vector2f(translation.x, translation.y);
        }

        @Override
        public float getRotation(ConfigManager cfgmgr) {
            this.transform.update(1);
            return FloatMath.normalizeAngle(this.transform.getRotation().getRotationZ() - 1.5707964f);
        }

        @Override
        public ConfigReference<ModelConfig> getModel(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).model;
        }

        @Override
        public Shape createShape(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).shape.getShape().transform(new Transform2D(this.transform));
        }

        @Override
        public void transform(ConfigManager cfgmgr, Transform3D xform) {
            xform.compose(this.transform, this.transform);
        }

        @Override
        public SpaceElement createElement(ConfigManager cfgmgr) {
            PlaceableConfig.Original config = this.getConfig(cfgmgr);
            ShapeElement element = config.floorTile ? new PlaceableElement(config) : new ShapeElement(config.shape);
            element.getTransform().set(this.transform);
            element.updateBounds();
            element.setUserObject(this);
            return element;
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            if (preloads.add(new Preloadable.Config(PlaceableConfig.class, this.placeable))) {
                this.getConfig(cfgmgr).getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public EntryCursor createCursor(TudeyContext ctx, TudeySceneView view) {
            return new PlaceableCursor(ctx, view, this);
        }

        @Override
        public EntrySprite createSprite(TudeyContext ctx, TudeySceneView view) {
            return new PlaceableSprite(ctx, view, this);
        }
    }

    protected static class TileConfigMapping
    extends DeepObject
    implements Exportable {
        public ConfigReference<TileConfig> tile;
        public transient int count;

        public TileConfigMapping(ConfigReference<TileConfig> tile) {
            this.tile = tile;
        }

        public TileConfigMapping() {
        }
    }

    public static class TileEntry
    extends Entry {
        @Editable(nullable=true)
        public ConfigReference<TileConfig> tile;
        @Editable
        public int elevation;
        @Editable(min=0.0, max=3.0)
        public int rotation;
        protected Coord _location = new Coord();

        public Coord getLocation() {
            return this._location;
        }

        public int encode(int idx) {
            return idx << 16 | (this.elevation & 0x3FFF) << 2 | this.rotation;
        }

        public TileConfig.Original getConfig(ConfigManager cfgmgr) {
            TileConfig config = cfgmgr.getConfig(TileConfig.class, this.tile);
            TileConfig.Original original = config == null ? null : config.getOriginal(cfgmgr);
            return original == null ? TileConfig.NULL_ORIGINAL : original;
        }

        public void getTransform(TileConfig.Original config, Transform3D result) {
            config.getTransform(this._location.x, this._location.y, this.elevation, this.rotation, result);
        }

        public void getRegion(TileConfig.Original config, Rectangle result) {
            config.getRegion(this._location.x, this._location.y, this.rotation, result);
        }

        public int getWidth(TileConfig.Original config) {
            return config.getWidth(this.rotation);
        }

        public int getHeight(TileConfig.Original config) {
            return config.getHeight(this.rotation);
        }

        public int getCollisionFlags(TileConfig.Original config, int x, int y) {
            return config.getCollisionFlags(this._location.x, this._location.y, this.rotation, x, y);
        }

        public int getDirectionFlags(TileConfig.Original config, int x, int y) {
            return config.getDirectionFlags(this._location.x, this._location.y, this.rotation, x, y);
        }

        @Override
        public Object getKey() {
            return this._location;
        }

        @Override
        public void setReference(ConfigReference reference) {
            ConfigReference ref;
            this.tile = ref = reference;
        }

        @Override
        public ConfigReference getReference() {
            return this.tile;
        }

        @Override
        public boolean isValid(ConfigManager cfgmgr) {
            return this.getConfig(cfgmgr) != TileConfig.NULL_ORIGINAL;
        }

        @Override
        public int getElevation() {
            return this.elevation;
        }

        @Override
        public void getBounds(ConfigManager cfgmgr, Rect result) {
            TileConfig.Original config = this.getConfig(cfgmgr);
            result.getMinimumExtent().set(this._location.x, this._location.y);
            result.getMaximumExtent().set(this._location.x + this.getWidth(config), this._location.y + this.getHeight(config));
        }

        @Override
        public String getLogicClassName(ConfigManager cfgmgr) {
            return this.getConfig(cfgmgr).getLogicClassName();
        }

        @Override
        public String[] getTags(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).tags.getTags();
        }

        @Override
        public HandlerConfig[] getHandlers(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).handlers;
        }

        @Override
        public boolean isDefaultEntrance(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).defaultEntrance;
        }

        @Override
        public Vector2f getTranslation(ConfigManager cfgmgr) {
            TileConfig.Original config = this.getConfig(cfgmgr);
            return new Vector2f((float)this._location.x + (float)this.getWidth(config) * 0.5f, (float)this._location.y + (float)this.getHeight(config) * 0.5f);
        }

        @Override
        public float getRotation(ConfigManager cfgmgr) {
            return FloatMath.normalizeAngle((float)(this.rotation - 1) * 1.5707964f);
        }

        @Override
        public ConfigReference<ModelConfig> getModel(ConfigManager cfgmgr) {
            return this.getConfig((ConfigManager)cfgmgr).model;
        }

        @Override
        public Shape createShape(ConfigManager cfgmgr) {
            TileConfig.Original config = this.getConfig(cfgmgr);
            float lx = this._location.x;
            float ly = this._location.y;
            float ux = lx + (float)this.getWidth(config);
            float uy = ly + (float)this.getHeight(config);
            return new Polygon(new Vector2f(lx, ly), new Vector2f(ux, ly), new Vector2f(ux, uy), new Vector2f(lx, uy));
        }

        @Override
        public void transform(ConfigManager cfgmgr, Transform3D xform) {
            xform.update(1);
            this.elevation += TudeySceneMetrics.getTileElevation(xform.getTranslation().z);
            TileConfig.Original config = this.getConfig(cfgmgr);
            Vector3f center = xform.transformPointLocal(new Vector3f((float)this._location.x + (float)this.getWidth(config) * 0.5f, (float)this._location.y + (float)this.getHeight(config) * 0.5f, 0.0f));
            int irot = Math.round(xform.getRotation().getRotationZ() / 1.5707964f);
            this.rotation = this.rotation + irot & 3;
            this._location.set(Math.round(center.x - (float)this.getWidth(config) * 0.5f), Math.round(center.y - (float)this.getHeight(config) * 0.5f));
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            if (preloads.add(new Preloadable.Config(TileConfig.class, this.tile))) {
                this.getConfig(cfgmgr).getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public EntryCursor createCursor(TudeyContext ctx, TudeySceneView view) {
            return new TileCursor(ctx, view, this);
        }

        @Override
        public EntrySprite createSprite(TudeyContext ctx, TudeySceneView view) {
            return new TileSprite(ctx, view, this);
        }
    }

    public static class Vertex
    extends DeepObject
    implements Exportable {
        @Editable(step=0.01, hgroup="c")
        public float x;
        @Editable(step=0.01, hgroup="c")
        public float y;
        @Editable(step=0.01, hgroup="c")
        public float z;

        public void set(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vector2f createVector() {
            return new Vector2f(this.x, this.y);
        }

        public void transform(Matrix4f matrix) {
            float ox = this.x;
            float oy = this.y;
            float oz = this.z;
            this.x = ox * matrix.m00 + oy * matrix.m10 + oz * matrix.m20 + matrix.m30;
            this.y = ox * matrix.m01 + oy * matrix.m11 + oz * matrix.m21 + matrix.m31;
            this.z = ox * matrix.m02 + oy * matrix.m12 + oz * matrix.m22 + matrix.m32;
        }
    }
}

