/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.scene.config;

import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Color4fExpression;
import com.threerings.expr.MutableLong;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.openal.Sounder;
import com.threerings.openal.config.SounderConfig;
import com.threerings.openal.util.AlContext;
import com.threerings.opengl.camera.CameraHandler;
import com.threerings.opengl.compositor.config.RenderEffectConfig;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.LightState;
import com.threerings.opengl.scene.BackgroundColorEffect;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.ViewerEffect;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.config.TudeyViewerEffectConfig;
import com.threerings.util.DeepObject;

@EditorTypes(value={Sound.class, BackgroundColor.class, Skybox.class, Particles.class, RenderEffect.class, AmbientLightOffset.class, TudeyViewerEffectConfig.class})
public abstract class ViewerEffectConfig
extends DeepObject
implements Exportable {
    public abstract ViewerEffect getViewerEffect(GlContext var1, Scope var2, ViewerEffect var3);

    public void invalidate() {
    }

    protected static ViewerEffect getNoopEffect(ViewerEffect effect) {
        class NoopEffect
        extends ViewerEffect {
            NoopEffect() {
            }
        }
        return effect instanceof NoopEffect ? effect : new NoopEffect();
    }

    public static class AmbientLightOffset
    extends ViewerEffectConfig {
        @Editable(min=0.0, step=0.01)
        public float duration;
        @Editable(min=0.0, step=0.01, hgroup="r")
        public float innerRadius = 10.0f;
        @Editable(min=0.0, step=0.01, hgroup="r")
        public float outerRadius = 100.0f;
        @Editable
        public Color4fExpression amount = new Color4fExpression.Constant();

        @Override
        public ViewerEffect getViewerEffect(final GlContext ctx, Scope scope, ViewerEffect effect) {
            final LightState lightState = ScopeUtil.resolve(scope, "lightState", null, LightState.class);
            if (lightState == null || lightState.getLights() == null) {
                return AmbientLightOffset.getNoopEffect(effect);
            }
            final MutableLong epoch = ScopeUtil.resolve(scope, "epoch", new MutableLong(System.currentTimeMillis()));
            final MutableLong now = ScopeUtil.resolve(scope, "now", new MutableLong(System.currentTimeMillis()));
            final Transform3D transform = ScopeUtil.resolve(scope, "worldTransform", new Transform3D());
            final ObjectExpression.Evaluator evaluator = this.amount.createEvaluator(scope);
            return new ViewerEffect(){
                protected Color4f _lastAmount = new Color4f();
                protected Color4f _lastGlobalAmbient;
                protected boolean _completed;
                protected Vector3f _translation = new Vector3f();

                @Override
                public void activate(Scene scene) {
                    this.addCurrent();
                }

                @Override
                public void deactivate() {
                    this.subtractLast();
                }

                @Override
                public void update() {
                    if (this._completed) {
                        return;
                    }
                    this.subtractLast();
                    this._completed = AmbientLightOffset.this.duration > 0.0f && (float)(now.value - epoch.value) / 1000.0f >= AmbientLightOffset.this.duration;
                    if (!this._completed) {
                        this.addCurrent();
                    }
                }

                @Override
                public boolean hasCompleted() {
                    return this._completed;
                }

                @Override
                public void reset() {
                    this._completed = false;
                }

                protected void subtractLast() {
                    if (this._lastGlobalAmbient != null) {
                        this._lastGlobalAmbient.r -= this._lastAmount.r;
                        this._lastGlobalAmbient.g -= this._lastAmount.g;
                        this._lastGlobalAmbient.b -= this._lastAmount.b;
                        this._lastGlobalAmbient = null;
                    }
                }

                protected void addCurrent() {
                    transform.extractTranslation(this._translation);
                    CameraHandler camhand = ctx.getCameraHandler();
                    float dist = camhand.getViewerTranslation().distance(this._translation);
                    if (dist > AmbientLightOffset.this.outerRadius) {
                        return;
                    }
                    float scale = dist <= AmbientLightOffset.this.innerRadius ? 1.0f : 1.0f - (dist - AmbientLightOffset.this.innerRadius) / (AmbientLightOffset.this.outerRadius - AmbientLightOffset.this.innerRadius);
                    this._lastGlobalAmbient = lightState.getGlobalAmbient();
                    this._lastAmount.set((Color4f)evaluator.evaluate()).multLocal(scale);
                    this._lastGlobalAmbient.r += this._lastAmount.r;
                    this._lastGlobalAmbient.g += this._lastAmount.g;
                    this._lastGlobalAmbient.b += this._lastAmount.b;
                }
            };
        }

        @Override
        public void invalidate() {
            this.amount.invalidate();
        }
    }

    public static class BackgroundColor
    extends ViewerEffectConfig {
        @Editable
        public Color4f color = new Color4f(0.0f, 0.0f, 0.0f, 1.0f);

        @Override
        public ViewerEffect getViewerEffect(GlContext ctx, Scope scope, ViewerEffect effect) {
            if (effect instanceof BackgroundColorEffect) {
                ((BackgroundColorEffect)effect).getBackgroundColor().set(this.color);
            } else {
                effect = new BackgroundColorEffect(this.color);
            }
            return effect;
        }
    }

    public static class Particles
    extends ViewerEffectConfig {
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;

        @Override
        public ViewerEffect getViewerEffect(GlContext ctx, Scope scope, ViewerEffect effect) {
            class ParticlesEffect
            extends ViewerEffect {
                public Model model;
                protected Transform3D _transform;
                protected Scene _scene;

                ParticlesEffect(GlContext glContext, final Scope scope) {
                    this.model = new Model(glContext, Particles.this.model){

                        @Override
                        public void completed(Model.Implementation impl) {
                            super.completed(impl);
                            ((Model)scope.getParentScope()).completed((Model.Implementation)scope);
                        }
                    };
                    this._transform = glContext.getCompositor().getCamera().getWorldTransform();
                }

                @Override
                public void activate(Scene scene) {
                    this._scene = scene;
                    this._scene.add(this.model);
                }

                @Override
                public void deactivate() {
                    this._scene.remove(this.model);
                    this._scene = null;
                }

                @Override
                public void update() {
                    this.model.setLocalTransform(this._transform);
                }

                @Override
                public boolean hasCompleted() {
                    return this.model.hasCompleted();
                }

                @Override
                public void reset() {
                    this.model.reset();
                }

                public String toString() {
                    return "Particles:" + Particles.this.model;
                }
            }
            if (effect instanceof ParticlesEffect) {
                ((ParticlesEffect)effect).model.setConfig(this.model);
            } else {
                effect = new ParticlesEffect(ctx, scope);
            }
            return effect;
        }
    }

    public static class RenderEffect
    extends ViewerEffectConfig {
        @Editable(nullable=true)
        public ConfigReference<RenderEffectConfig> renderEffect;

        @Override
        public ViewerEffect getViewerEffect(GlContext ctx, Scope scope, ViewerEffect effect) {
            class RenderEffectEffect
            extends ViewerEffect {
                public com.threerings.opengl.compositor.RenderEffect reffect;
                private final /* synthetic */ GlContext val$ctx;

                RenderEffectEffect(GlContext glContext, Scope scope) {
                    this.val$ctx = glContext;
                    this.reffect = new com.threerings.opengl.compositor.RenderEffect(glContext, scope, RenderEffect.this.renderEffect);
                }

                @Override
                public void activate(Scene scene) {
                    this.val$ctx.getCompositor().addEffect(this.reffect);
                }

                @Override
                public void deactivate() {
                    this.val$ctx.getCompositor().removeEffect(this.reffect);
                }

                public String toString() {
                    return "RenderEffect:" + RenderEffect.this.renderEffect;
                }
            }
            if (effect instanceof RenderEffectEffect) {
                ((RenderEffectEffect)effect).reffect.setConfig(this.renderEffect);
            } else {
                effect = new RenderEffectEffect(ctx, scope);
            }
            return effect;
        }
    }

    public static class Skybox
    extends ViewerEffectConfig {
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
        @Editable(step=0.001, hgroup="t")
        public Vector3f translationScale = new Vector3f();
        @Editable(step=0.01, hgroup="t")
        public Vector3f translationOrigin = new Vector3f();

        @Override
        public ViewerEffect getViewerEffect(GlContext ctx, Scope scope, ViewerEffect effect) {
            class SkyboxEffect
            extends ViewerEffect {
                public Model model;
                protected Vector3f _translation;
                protected Scene _scene;

                SkyboxEffect(GlContext glContext, final Scope scope) {
                    this.model = new Model(glContext, Skybox.this.model){

                        @Override
                        public void completed(Model.Implementation impl) {
                            super.completed(impl);
                            ((Model)scope.getParentScope()).completed((Model.Implementation)scope);
                        }
                    };
                    this._translation = glContext.getCompositor().getCamera().getWorldTransform().getTranslation();
                }

                @Override
                public void activate(Scene scene) {
                    this._scene = scene;
                    this._scene.add(this.model);
                }

                @Override
                public void deactivate() {
                    this._scene.remove(this.model);
                    this._scene = null;
                }

                @Override
                public void update() {
                    Vector3f trans = this.model.getLocalTransform().getTranslation();
                    Skybox.this.translationOrigin.subtract(this._translation, trans).multLocal(Skybox.this.translationScale);
                    trans.addLocal(this._translation);
                    this.model.updateBounds();
                }

                @Override
                public boolean hasCompleted() {
                    return this.model.hasCompleted();
                }

                @Override
                public void reset() {
                    this.model.reset();
                }

                public String toString() {
                    return "Skybox:" + Skybox.this.model;
                }
            }
            if (effect instanceof SkyboxEffect) {
                ((SkyboxEffect)effect).model.setConfig(this.model);
            } else {
                effect = new SkyboxEffect(ctx, scope);
            }
            return effect;
        }
    }

    public static class Sound
    extends ViewerEffectConfig {
        @Editable(nullable=true)
        public ConfigReference<SounderConfig> sounder;

        @Override
        public ViewerEffect getViewerEffect(GlContext ctx, Scope scope, ViewerEffect effect) {
            if (!ScopeUtil.resolve(scope, "soundEnabled", true).booleanValue()) {
                return Sound.getNoopEffect(effect);
            }
            class SoundEffect
            extends ViewerEffect {
                public Sounder sounder;
                protected boolean _activated;
                protected boolean _completed;
                private final /* synthetic */ Scope val$scope;

                SoundEffect(GlContext glContext, Scope scope) {
                    this.val$scope = scope;
                    this.sounder = new Sounder((AlContext)glContext, scope, ScopeUtil.resolve(scope, "worldTransform", new Transform3D()), Sound.this.sounder);
                }

                @Override
                public void activate(Scene scene) {
                    this._activated = true;
                    this.sounder.start();
                }

                @Override
                public void deactivate() {
                    this.sounder.stop();
                    this._activated = false;
                }

                @Override
                public boolean hasCompleted() {
                    return this._completed;
                }

                @Override
                public void update() {
                    this.sounder.update();
                    if (!this._completed && !this.sounder.isPlaying()) {
                        this._completed = true;
                        ((Model)this.val$scope.getParentScope()).completed((Model.Implementation)this.val$scope);
                    }
                }

                @Override
                public void reset() {
                    if (this._activated) {
                        this.sounder.start();
                    }
                    this._completed = false;
                }

                @Override
                public boolean omitWhileLoading() {
                    return true;
                }

                public String toString() {
                    return "Sound:" + Sound.this.sounder;
                }
            }
            if (effect instanceof SoundEffect) {
                ((SoundEffect)effect).sounder.setConfig(this.sounder);
            } else {
                effect = new SoundEffect(ctx, scope);
            }
            return effect;
        }
    }
}

