/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.geometry.util;

import com.samskivert.util.HashIntMap;
import com.threerings.opengl.geometry.config.PassDescriptor;
import com.threerings.opengl.renderer.BufferObject;
import com.threerings.opengl.renderer.ClientArray;
import com.threerings.opengl.renderer.state.ArrayState;
import com.threerings.opengl.util.GlUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class GeometryUtil {
    public static ArrayList<ClientArray> createList(HashMap<String, ClientArray> vertexAttribArrays, HashIntMap<ClientArray> texCoordArrays, ClientArray colorArray, ClientArray normalArray, ClientArray vertexArray) {
        ArrayList<ClientArray> list = new ArrayList<ClientArray>();
        list.addAll(vertexAttribArrays.values());
        list.addAll(texCoordArrays.values());
        if (colorArray != null) {
            list.add(colorArray);
        }
        if (normalArray != null) {
            list.add(normalArray);
        }
        list.add(vertexArray);
        return list;
    }

    public static int updateOffsetsAndStride(ArrayList<ClientArray> arrays) {
        int offset = 0;
        for (ClientArray array : arrays) {
            array.offset = offset;
            offset += array.getElementBytes();
        }
        int stride = GlUtil.nextPowerOfTwo(offset);
        for (ClientArray array : arrays) {
            array.stride = stride;
        }
        return stride;
    }

    public static ArrayState[] createArrayStates(HashMap<String, ClientArray> vertexAttribArrays, HashIntMap<ClientArray> texCoordArrays, ClientArray colorArray, ClientArray normalArray, ClientArray vertexArray, BufferObject elementArrayBuffer, PassDescriptor[] passes) {
        ArrayState[] states = new ArrayState[passes.length];
        int ii = 0;
        while (ii < passes.length) {
            PassDescriptor pass = passes[ii];
            ClientArray[] attribArrays = new ClientArray[pass.vertexAttribs.length];
            int jj = 0;
            while (jj < attribArrays.length) {
                attribArrays[jj] = vertexAttribArrays.get(pass.vertexAttribs[jj]);
                ++jj;
            }
            ClientArray[] coordArrays = new ClientArray[pass.texCoordSets.length];
            int jj2 = 0;
            while (jj2 < coordArrays.length) {
                coordArrays[jj2] = (ClientArray)texCoordArrays.get(pass.texCoordSets[jj2]);
                ++jj2;
            }
            states[ii] = new ArrayState(pass.firstVertexAttribIndex, attribArrays, coordArrays, pass.colors ? colorArray : null, pass.normals ? normalArray : null, vertexArray, elementArrayBuffer);
            ++ii;
        }
        return states;
    }
}

