/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.camera;

import com.google.common.collect.Lists;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.camera.Camera;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import java.util.List;

public abstract class CameraHandler
implements Renderer.Observer {
    protected GlContext _ctx;
    protected Camera _camera;
    protected boolean _matchRenderSurface;
    protected float _fovy = 1.0471976f;
    protected float _near = 1.0f;
    protected float _far = 100.0f;
    protected List<Offset> _offsets = Lists.newArrayList();

    public CameraHandler(GlContext ctx) {
        this(ctx, ctx.getCompositor().getCamera(), true);
    }

    public CameraHandler(GlContext ctx, Camera camera, boolean matchRenderSurface) {
        this._ctx = ctx;
        this._camera = camera;
        this._matchRenderSurface = matchRenderSurface;
    }

    public void setPerspective(float fovy, float near, float far) {
        this._fovy = fovy;
        this._near = near;
        this._far = far;
        this.updatePerspective();
    }

    public float getFieldOfView() {
        return this._fovy;
    }

    public float getNear() {
        return this._near;
    }

    public float getFar() {
        return this._far;
    }

    public void addOffset(Offset offset) {
        this._offsets.add(offset);
    }

    public Vector3f getViewerTranslation() {
        return this._camera.getWorldTransform().getTranslation();
    }

    public Quaternion getViewerRotation() {
        return this._camera.getWorldTransform().getRotation();
    }

    public boolean isAdded() {
        return this._ctx.getCameraHandler() == this;
    }

    public void wasAdded() {
        if (this._matchRenderSurface) {
            Renderer renderer = this._ctx.getRenderer();
            this.sizeChanged(renderer.getWidth(), renderer.getHeight());
            renderer.addObserver(this);
        }
    }

    public void wasRemoved() {
        if (this._matchRenderSurface) {
            this._ctx.getRenderer().removeObserver(this);
        }
    }

    public void updatePerspective() {
        Rectangle viewport = this._camera.getViewport();
        this._camera.setPerspective(this._fovy, (float)viewport.width / (float)viewport.height, this._near, this._far);
    }

    public void updatePosition() {
        Transform3D transform = this._camera.getWorldTransform();
        this.getTransform(transform);
        int ii = this._offsets.size() - 1;
        while (ii >= 0) {
            if (!this._offsets.get(ii).apply(transform)) {
                this._offsets.remove(ii);
            }
            --ii;
        }
        this._camera.updateTransform();
    }

    @Override
    public void sizeChanged(int width, int height) {
        this._camera.getViewport().set(0, 0, width, height);
        this.updatePerspective();
    }

    protected abstract void getTransform(Transform3D var1);

    public static interface Offset {
        public boolean apply(Transform3D var1);
    }
}

