/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.samskivert.util.StringUtil;
import com.threerings.export.Encodable;
import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector3f;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Quaternion
implements Encodable,
Streamable {
    public static final Quaternion IDENTITY = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public Quaternion(float[] values) {
        this.set(values);
    }

    public Quaternion(Quaternion other) {
        this.set(other);
    }

    public Quaternion() {
        this.set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Quaternion fromVectors(Vector3f from, Vector3f to) {
        float angle = from.angle(to);
        if (angle < 1.0E-6f) {
            return this.set(IDENTITY);
        }
        if (angle <= 3.1415918f) {
            return this.fromAngleAxis(angle, from.cross(to).normalizeLocal());
        }
        Vector3f axis = new Vector3f(0.0f, from.z, -from.y);
        float length = axis.length();
        return this.fromAngleAxis((float)Math.PI, length < 1.0E-6f ? axis.set(-from.z, 0.0f, from.x).normalizeLocal() : axis.multLocal(1.0f / length));
    }

    public Quaternion fromVectorFromNegativeZ(Vector3f to) {
        return this.fromVectorFromNegativeZ(to.x, to.y, to.z);
    }

    public Quaternion fromVectorFromNegativeZ(float tx, float ty, float tz) {
        float angle = FloatMath.acos(-tz);
        if (angle < 1.0E-6f) {
            return this.set(IDENTITY);
        }
        if (angle > 3.1415918f) {
            return this.set(0.0f, 1.0f, 0.0f, 0.0f);
        }
        float len = FloatMath.hypot(tx, ty);
        return this.fromAngleAxis(angle, ty / len, -tx / len, 0.0f);
    }

    public Quaternion fromAxes(Vector3f nx, Vector3f ny, Vector3f nz) {
        float x2 = (1.0f + nx.x - ny.y - nz.z) / 4.0f;
        float y2 = (1.0f - nx.x + ny.y - nz.z) / 4.0f;
        float z2 = (1.0f - nx.x - ny.y + nz.z) / 4.0f;
        float w2 = 1.0f - x2 - y2 - z2;
        return this.set(FloatMath.sqrt(x2) * (ny.z >= nz.y ? 1.0f : -1.0f), FloatMath.sqrt(y2) * (nz.x >= nx.z ? 1.0f : -1.0f), FloatMath.sqrt(z2) * (nx.y >= ny.x ? 1.0f : -1.0f), FloatMath.sqrt(w2));
    }

    public Quaternion fromAngleAxis(float angle, Vector3f axis) {
        return this.fromAngleAxis(angle, axis.x, axis.y, axis.z);
    }

    public Quaternion fromAngleAxis(float angle, float x, float y, float z) {
        float sina = FloatMath.sin(angle / 2.0f);
        return this.set(x * sina, y * sina, z * sina, FloatMath.cos(angle / 2.0f));
    }

    public Quaternion randomize() {
        return this.fromAngles(FloatMath.random((float)(-Math.PI), (float)Math.PI), FloatMath.asin(FloatMath.random(-1.0f, 1.0f)), FloatMath.random((float)(-Math.PI), (float)Math.PI));
    }

    public Quaternion fromAnglesXZ(float x, float z) {
        float hx = x * 0.5f;
        float hz = z * 0.5f;
        float sx = FloatMath.sin(hx);
        float cx = FloatMath.cos(hx);
        float sz = FloatMath.sin(hz);
        float cz = FloatMath.cos(hz);
        return this.set(cz * sx, sz * sx, sz * cx, cz * cx);
    }

    public Quaternion fromAnglesXY(float x, float y) {
        float hx = x * 0.5f;
        float hy = y * 0.5f;
        float sx = FloatMath.sin(hx);
        float cx = FloatMath.cos(hx);
        float sy = FloatMath.sin(hy);
        float cy = FloatMath.cos(hy);
        return this.set(cy * sx, sy * cx, -sy * sx, cy * cx);
    }

    public Quaternion fromAngles(Vector3f angles) {
        return this.fromAngles(angles.x, angles.y, angles.z);
    }

    public Quaternion fromAngles(float x, float y, float z) {
        float hx = x * 0.5f;
        float hy = y * 0.5f;
        float hz = z * 0.5f;
        float sz = FloatMath.sin(hz);
        float cz = FloatMath.cos(hz);
        float sy = FloatMath.sin(hy);
        float cy = FloatMath.cos(hy);
        float sx = FloatMath.sin(hx);
        float cx = FloatMath.cos(hx);
        float szsy = sz * sy;
        float czsy = cz * sy;
        float szcy = sz * cy;
        float czcy = cz * cy;
        return this.set(czcy * sx - szsy * cx, czsy * cx + szcy * sx, szcy * cx - czsy * sx, czcy * cx + szsy * sx);
    }

    public Vector3f toAngles(Vector3f result) {
        float sy = 2.0f * (this.y * this.w - this.x * this.z);
        if (sy < 0.999999f) {
            if (sy > -0.999999f) {
                return result.set(FloatMath.atan2(this.y * this.z + this.x * this.w, 0.5f - (this.x * this.x + this.y * this.y)), FloatMath.asin(sy), FloatMath.atan2(this.x * this.y + this.z * this.w, 0.5f - (this.y * this.y + this.z * this.z)));
            }
            return result.set(0.0f, -1.5707964f, FloatMath.atan2(this.x * this.w - this.y * this.z, 0.5f - (this.x * this.x + this.z * this.z)));
        }
        return result.set(0.0f, 1.5707964f, -FloatMath.atan2(this.x * this.w - this.y * this.z, 0.5f - (this.x * this.x + this.z * this.z)));
    }

    public Vector3f toAngles() {
        return this.toAngles(new Vector3f());
    }

    public Quaternion normalizeLocal() {
        return this.normalize(this);
    }

    public Quaternion normalize() {
        return this.normalize(new Quaternion());
    }

    public Quaternion normalize(Quaternion result) {
        float rlen = 1.0f / FloatMath.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        return result.set(this.x * rlen, this.y * rlen, this.z * rlen, this.w * rlen);
    }

    public Quaternion invertLocal() {
        return this.invert(this);
    }

    public Quaternion invert() {
        return this.invert(new Quaternion());
    }

    public Quaternion invert(Quaternion result) {
        return result.set(-this.x, -this.y, -this.z, this.w);
    }

    public Quaternion multLocal(Quaternion other) {
        return this.mult(other, this);
    }

    public Quaternion mult(Quaternion other) {
        return this.mult(other, new Quaternion());
    }

    public Quaternion mult(Quaternion other, Quaternion result) {
        return result.set(this.w * other.x + this.x * other.w + this.y * other.z - this.z * other.y, this.w * other.y + this.y * other.w + this.z * other.x - this.x * other.z, this.w * other.z + this.z * other.w + this.x * other.y - this.y * other.x, this.w * other.w - this.x * other.x - this.y * other.y - this.z * other.z);
    }

    public Quaternion slerpLocal(Quaternion other, float t) {
        return this.slerp(other, t, this);
    }

    public Quaternion slerp(Quaternion other, float t) {
        return this.slerp(other, t, new Quaternion());
    }

    public Quaternion slerp(Quaternion other, float t, Quaternion result) {
        float s1;
        float s0;
        float cosa = this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
        float ox = other.x;
        float oy = other.y;
        float oz = other.z;
        float ow = other.w;
        if (cosa < 0.0f) {
            cosa = -cosa;
            ox = -ox;
            oy = -oy;
            oz = -oz;
            ow = -ow;
        }
        if (1.0f - cosa > 1.0E-6f) {
            float angle = FloatMath.acos(cosa);
            float sina = FloatMath.sin(angle);
            s0 = FloatMath.sin((1.0f - t) * angle) / sina;
            s1 = FloatMath.sin(t * angle) / sina;
        } else {
            s0 = 1.0f - t;
            s1 = t;
        }
        return result.set(s0 * this.x + s1 * ox, s0 * this.y + s1 * oy, s0 * this.z + s1 * oz, s0 * this.w + s1 * ow);
    }

    public Vector3f transformLocal(Vector3f vector) {
        return this.transform(vector, vector);
    }

    public Vector3f transform(Vector3f vector) {
        return this.transform(vector, new Vector3f());
    }

    public Vector3f transform(Vector3f vector, Vector3f result) {
        float xx = this.x * this.x;
        float yy = this.y * this.y;
        float zz = this.z * this.z;
        float xy = this.x * this.y;
        float xz = this.x * this.z;
        float xw = this.x * this.w;
        float yz = this.y * this.z;
        float yw = this.y * this.w;
        float zw = this.z * this.w;
        float vx2 = vector.x * 2.0f;
        float vy2 = vector.y * 2.0f;
        float vz2 = vector.z * 2.0f;
        return result.set(vector.x + vy2 * (xy - zw) + vz2 * (xz + yw) - vx2 * (yy + zz), vector.y + vx2 * (xy + zw) + vz2 * (yz - xw) - vy2 * (xx + zz), vector.z + vx2 * (xz - yw) + vy2 * (yz + xw) - vz2 * (xx + yy));
    }

    public Vector3f transformUnitX(Vector3f result) {
        return result.set(1.0f - 2.0f * (this.y * this.y + this.z * this.z), 2.0f * (this.x * this.y + this.z * this.w), 2.0f * (this.x * this.z - this.y * this.w));
    }

    public Vector3f transformUnitY(Vector3f result) {
        return result.set(2.0f * (this.x * this.y - this.z * this.w), 1.0f - 2.0f * (this.x * this.x + this.z * this.z), 2.0f * (this.y * this.z + this.x * this.w));
    }

    public Vector3f transformUnitZ(Vector3f result) {
        return result.set(2.0f * (this.x * this.z + this.y * this.w), 2.0f * (this.y * this.z - this.x * this.w), 1.0f - 2.0f * (this.x * this.x + this.y * this.y));
    }

    public Vector3f transformAndAdd(Vector3f vector, Vector3f add, Vector3f result) {
        float xx = this.x * this.x;
        float yy = this.y * this.y;
        float zz = this.z * this.z;
        float xy = this.x * this.y;
        float xz = this.x * this.z;
        float xw = this.x * this.w;
        float yz = this.y * this.z;
        float yw = this.y * this.w;
        float zw = this.z * this.w;
        float vx2 = vector.x * 2.0f;
        float vy2 = vector.y * 2.0f;
        float vz2 = vector.z * 2.0f;
        return result.set(vector.x + add.x + vy2 * (xy - zw) + vz2 * (xz + yw) - vx2 * (yy + zz), vector.y + add.y + vx2 * (xy + zw) + vz2 * (yz - xw) - vy2 * (xx + zz), vector.z + add.z + vx2 * (xz - yw) + vy2 * (yz + xw) - vz2 * (xx + yy));
    }

    public Vector3f transformScaleAndAdd(Vector3f vector, float scale, Vector3f add, Vector3f result) {
        float xx = this.x * this.x;
        float yy = this.y * this.y;
        float zz = this.z * this.z;
        float xy = this.x * this.y;
        float xz = this.x * this.z;
        float xw = this.x * this.w;
        float yz = this.y * this.z;
        float yw = this.y * this.w;
        float zw = this.z * this.w;
        float vx2 = vector.x * 2.0f;
        float vy2 = vector.y * 2.0f;
        float vz2 = vector.z * 2.0f;
        return result.set((vector.x + vy2 * (xy - zw) + vz2 * (xz + yw) - vx2 * (yy + zz)) * scale + add.x, (vector.y + vx2 * (xy + zw) + vz2 * (yz - xw) - vy2 * (xx + zz)) * scale + add.y, (vector.z + vx2 * (xz - yw) + vy2 * (yz + xw) - vz2 * (xx + yy)) * scale + add.z);
    }

    public float transformZ(Vector3f vector) {
        return vector.z + vector.x * 2.0f * (this.x * this.z - this.y * this.w) + vector.y * 2.0f * (this.y * this.z + this.x * this.w) - vector.z * 2.0f * (this.x * this.x + this.y * this.y);
    }

    public float getRotationZ() {
        return FloatMath.atan2(2.0f * (this.x * this.y + this.z * this.w), 1.0f - 2.0f * (this.y * this.y + this.z * this.z));
    }

    public Quaternion integrateLocal(Vector3f velocity, float t) {
        return this.integrate(velocity, t, this);
    }

    public Quaternion integrate(Vector3f velocity, float t) {
        return this.integrate(velocity, t, new Quaternion());
    }

    public Quaternion integrate(Vector3f velocity, float t, Quaternion result) {
        float qx = 0.5f * velocity.x;
        float qy = 0.5f * velocity.y;
        float qz = 0.5f * velocity.z;
        return result.set(this.x + t * (qx * this.w + qy * this.z - qz * this.y), this.y + t * (qy * this.w + qz * this.x - qx * this.z), this.z + t * (qz * this.w + qx * this.y - qy * this.x), this.w + t * (-qx * this.x - qy * this.y - qz * this.z)).normalizeLocal();
    }

    public Quaternion set(Quaternion other) {
        return this.set(other.x, other.y, other.z, other.w);
    }

    public Quaternion set(float[] values) {
        return this.set(values[0], values[1], values[2], values[3]);
    }

    public Quaternion set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public void get(float[] values) {
        values[0] = this.x;
        values[1] = this.y;
        values[2] = this.z;
        values[3] = this.w;
    }

    public boolean hasNaN() {
        return Float.isNaN(this.x) || Float.isNaN(this.y) || Float.isNaN(this.z) || Float.isNaN(this.w);
    }

    @Override
    public String encodeToString() {
        return String.valueOf(this.x) + ", " + this.y + ", " + this.z + ", " + this.w;
    }

    @Override
    public void decodeFromString(String string) throws Exception {
        this.set(StringUtil.parseFloatArray((String)string));
    }

    @Override
    public void encodeToStream(DataOutputStream out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
        out.writeFloat(this.w);
    }

    @Override
    public void decodeFromStream(DataInputStream in) throws IOException {
        this.set(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
    }

    public int hashCode() {
        return Float.floatToIntBits(this.x) ^ Float.floatToIntBits(this.y) ^ Float.floatToIntBits(this.z) ^ Float.floatToIntBits(this.w);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Quaternion)) {
            return false;
        }
        Quaternion oquat = (Quaternion)other;
        return this.x == oquat.x && this.y == oquat.y && this.z == oquat.z && this.w == oquat.w || this.x == -oquat.x && this.y == -oquat.y && this.z == -oquat.z && this.w == -oquat.x;
    }
}

