/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.MutableInteger;
import com.threerings.expr.Scope;
import com.threerings.expr.Variable;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.util.DeepObject;

@EditorTypes(value={Constant.class, Reference.class})
public abstract class IntegerExpression
extends DeepObject
implements Exportable {
    public abstract Evaluator createEvaluator(Scope var1);

    public void invalidate() {
    }

    public static class Constant
    extends IntegerExpression {
        @Editable
        public int value;

        public Constant(int value) {
            this.value = value;
        }

        public Constant() {
        }

        @Override
        public Evaluator createEvaluator(Scope scope) {
            return new Evaluator(){

                @Override
                public int evaluate() {
                    return Constant.this.value;
                }
            };
        }
    }

    public static abstract class Evaluator {
        public abstract int evaluate();
    }

    public static class Reference
    extends IntegerExpression {
        @Editable
        public String name = "";
        @Editable
        public int defvalue;

        @Override
        public Evaluator createEvaluator(Scope scope) {
            final MutableInteger reference = ScopeUtil.resolve(scope, this.name, null);
            if (reference != null) {
                return new Evaluator(){

                    @Override
                    public int evaluate() {
                        return reference.value;
                    }
                };
            }
            final Variable variable = ScopeUtil.resolve(scope, this.name, Variable.newInstance(this.defvalue));
            return new Evaluator(){

                @Override
                public int evaluate() {
                    return variable.getInt();
                }
            };
        }
    }
}

