/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.config.ManagedConfig;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.config.swing.ConfigChooser;
import com.threerings.config.tools.BaseConfigEditor;
import com.threerings.editor.Property;
import com.threerings.editor.swing.PropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConfigReferenceEditor
extends PropertyEditor
implements ActionListener,
ChangeListener,
ConfigUpdateListener<ManagedConfig> {
    protected JButton _config;
    protected JButton _edit;
    protected JButton _clear;
    protected JPanel _arguments;
    protected ConfigChooser _chooser;
    protected ParameterizedConfig _listenee;

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            ConfigReference nvalue;
            ConfigReference ovalue = (ConfigReference)this._property.get(this._object);
            Object source = event.getSource();
            if (source == this._config) {
                if (this._chooser == null) {
                    this._chooser = ConfigChooser.createInstance(this._msgmgr, this._ctx.getConfigManager(), this._property.getArgumentType(ConfigReference.class));
                }
                String oldConfig = ovalue == null ? null : ovalue.getName();
                this._chooser.setListener(new ConfigChooser.ChoseListener(oldConfig){

                    @Override
                    public void onChange(String config) {
                        ConfigReference nvalue = config == null ? null : new ConfigReference(config);
                        ConfigReferenceEditor.this._property.set(ConfigReferenceEditor.this._object, nvalue);
                        ConfigReferenceEditor.this.update(nvalue, true);
                        ConfigReferenceEditor.this.fireStateChanged();
                    }
                });
                this._chooser.setSelectedConfig(oldConfig);
                if (!this._chooser.showDialog((Component)((Object)this))) {
                    return;
                }
                String config = this._chooser.getSelectedConfig();
                nvalue = config == null ? null : new ConfigReference(config);
            } else {
                if (source == this._edit) {
                    BaseConfigEditor editor = BaseConfigEditor.createEditor(this._ctx, this._property.getArgumentType(ConfigReference.class), ovalue.getName());
                    editor.setLocationRelativeTo((Component)((Object)this));
                    editor.setVisible(true);
                    return;
                }
                if (source == this._clear) {
                    nvalue = null;
                } else {
                    super.actionPerformed(event);
                    return;
                }
            }
            this._property.set(this._object, nvalue);
            this.update(nvalue, true);
            this.fireStateChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireStateChanged();
    }

    @Override
    public void configUpdated(ConfigEvent<ManagedConfig> event) {
        this.update();
    }

    public void addNotify() {
        super.addNotify();
        if (this._listenee != null) {
            this.update();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._listenee != null) {
            this._listenee.removeListener(this);
        }
    }

    @Override
    public void update() {
        this.update((ConfigReference)this._property.get(this._object), false);
    }

    @Override
    protected void didInit() {
        this.makeCollapsible(this._ctx, this.getPropertyLabel(), false);
        JPanel cpanel = new JPanel();
        this._content.add(cpanel);
        cpanel.add(new JLabel(String.valueOf(this._msgs.get("m.config")) + ":"));
        this._config = new JButton(" ");
        cpanel.add(this._config);
        cpanel.setBackground(null);
        this._config.addActionListener(this);
        if (!this.getMode().equals("compact")) {
            this._edit = new JButton(this._msgs.get("m.edit"));
            cpanel.add(this._edit);
            this._edit.addActionListener(this);
        }
        if (this._property.getAnnotation().nullable()) {
            this._clear = new JButton(this._msgs.get("m.clear"));
            cpanel.add(this._clear);
            this._clear.addActionListener(this);
        }
        this._arguments = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.TOP, (GroupLayout.Policy)GroupLayout.STRETCH);
        this._content.add(this._arguments);
        this._arguments.setBackground(null);
    }

    @Override
    public String getMousePath(Point pt) {
        Component comp = this._arguments.getComponentAt(SwingUtilities.convertPoint((Component)((Object)this), pt, this._arguments));
        String arg = comp instanceof PropertyEditor ? ((PropertyEditor)((Object)comp)).getProperty().getName() : null;
        return arg == null ? "" : "[\"" + arg.replace("\"", "\\\"") + "\"]" + ((PropertyEditor)((Object)comp)).getMousePath(SwingUtilities.convertPoint((Component)((Object)this), pt, comp));
    }

    public void update(ConfigReference value, boolean transfer) {
        boolean enable;
        if (this._listenee != null) {
            this._listenee.removeListener(this);
            this._listenee = null;
        }
        boolean bl = enable = value != null;
        if (this._edit != null) {
            this._edit.setEnabled(enable);
        }
        if (this._clear != null) {
            this._clear.setEnabled(enable);
        }
        if (!enable) {
            this._config.setText(this._msgs.get("m.null_value"));
            this._arguments.removeAll();
            return;
        }
        String name = value.getName();
        this._config.setText(name.substring(name.lastIndexOf(47) + 1));
        Class<?> clazz = this._property.getArgumentType(ConfigReference.class);
        Object config = this._ctx.getConfigManager().getConfig(clazz, name);
        if (!(config instanceof ParameterizedConfig)) {
            this._arguments.removeAll();
            value.getArguments().clear();
            if (config == null) {
                this._config.setForeground(Color.red);
            }
            return;
        }
        this._config.setForeground(this._content.getForeground());
        int ocount = this._arguments.getComponentCount();
        HashMap<String, PropertyEditor> oeditors = new HashMap<String, PropertyEditor>();
        if (transfer) {
            int ii = 0;
            while (ii < ocount) {
                PropertyEditor editor = (PropertyEditor)((Object)this._arguments.getComponent(ii));
                oeditors.put(editor.getProperty().getName(), editor);
                ++ii;
            }
        }
        int idx = 0;
        ArgumentMap nargs = value.getArguments();
        ParameterizedConfig pconfig = (ParameterizedConfig)config;
        Parameter[] parameterArray = pconfig.parameters;
        int n = pconfig.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            Property property = parameter.getArgumentProperty(pconfig);
            if (property != null) {
                PropertyEditor oeditor;
                PropertyEditor editor = null;
                if (idx < ocount) {
                    oeditor = (PropertyEditor)((Object)this._arguments.getComponent(idx));
                    if (oeditor.getProperty().equals(property)) {
                        if (transfer) {
                            property.set(nargs, property.get(oeditor.getObject()));
                        }
                        editor = oeditor;
                    } else {
                        this._arguments.remove(idx);
                    }
                }
                if (editor == null) {
                    editor = PropertyEditor.createEditor(this._ctx, property, this._lineage);
                    editor.addChangeListener(this);
                    this._arguments.add((Component)((Object)editor), idx);
                    oeditor = (PropertyEditor)oeditors.get(parameter.name);
                    if (oeditor != null) {
                        Object ovalue;
                        Property oproperty = oeditor.getProperty();
                        if (property.getGenericType().equals(oproperty.getGenericType()) && property.isLegalValue(ovalue = oproperty.get(oeditor.getObject()))) {
                            property.set(nargs, ovalue);
                        }
                    }
                }
                editor.setObject(nargs);
                ++idx;
            }
            ++n2;
        }
        while (ocount > idx) {
            this._arguments.remove(--ocount);
        }
        SwingUtil.refresh((JComponent)this._arguments);
        Iterator it = value.getArguments().keySet().iterator();
        while (it.hasNext()) {
            if (pconfig.getParameter((String)it.next()) != null) continue;
            it.remove();
        }
        this._listenee = pconfig;
        this._listenee.addListener(this);
    }
}

