/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.common.collect.Lists;
import com.samskivert.swing.GroupLayout;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.EditorTool;
import com.threerings.tudey.tools.LayerTableModel;
import com.threerings.tudey.tools.SceneEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class Layers
extends EditorTool {
    protected JTable _table;
    protected LayerTableModel _tableModel;
    protected Action _addLayerAction = new AbstractAction("+"){
        {
            this.putValue("ShortDescription", "Add a new layer");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int newLayer = Layers.this._scene.getLayers().size();
            Layers.this.setSelectedLayer(Layers.this._tableModel.addLayer("Layer " + newLayer, newLayer));
        }
    };
    protected Action _removeLayerAction = new AbstractAction("-"){
        {
            this.putValue("ShortDescription", "Remove the selected layer");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int layer = Layers.this.getSelectedLayer();
            if (Layers.this._scene.isLayerEmpty(layer) || Layers.this.confirm("Layer is not empty!", "This layer has stuff on it.\nContinue anyway and move the stuff to the base layer?")) {
                if (Layers.this.getSelectedLayer() == layer) {
                    Layers.this.setSelectedLayer(layer - 1);
                }
                Layers.this._tableModel.removeLayer(layer);
            }
        }
    };
    protected Action _mergeVisibleLayersAction = new AbstractAction("Merge visible"){
        {
            this.putValue("ShortDescription", "Merge visible layers into the lowest visible");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Layers.this.confirm("Merge layers...", "This cannot be un-done.\nAre you sure you want to merge the visible layers?")) {
                Layers.this.mergeVisible();
            }
        }
    };

    public Layers(SceneEditor editor) {
        super(editor);
        ((GroupLayout)this.getLayout()).setGap(0);
        this._tableModel = new LayerTableModel(editor);
        this._table = this._tableModel.getTable();
        this._table.setPreferredScrollableViewportSize(new Dimension(100, 64));
        this._table.setSelectionMode(0);
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    Layers.this.layerWasSelected(Layers.this.getSelectedLayer());
                }
            }
        });
        this._tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                Layers.this._mergeVisibleLayersAction.setEnabled(2 <= Collections.frequency(Layers.this.getLayerVisibility(), true));
            }
        });
        this._removeLayerAction.setEnabled(false);
        this._mergeVisibleLayersAction.setEnabled(false);
        this.add((Component)GroupLayout.makeButtonBox((Component[])new Component[]{new JLabel("Layers"), new JButton(this._addLayerAction), new JButton(this._removeLayerAction), new JButton(this._mergeVisibleLayersAction)}), GroupLayout.FIXED);
        this.add(new JScrollPane(this._table));
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public int getSelectedLayer() {
        return this._table.getSelectedRow();
    }

    public void setSelectedLayer(int layer) {
        this._table.setRowSelectionInterval(layer, layer);
        int rowHeight = this._table.getRowHeight();
        this._table.scrollRectToVisible(new Rectangle(0, rowHeight * layer, 1, rowHeight));
    }

    public void selectLayer(boolean next) {
        int layerCount = this._table.getRowCount();
        int layer = (this.getSelectedLayer() + (next ? 1 : layerCount - 1)) % layerCount;
        this._tableModel.setVisibilities(0, layer);
        this.setSelectedLayer(layer);
    }

    public List<Boolean> getLayerVisibility() {
        return this._tableModel.getLayerVisibility();
    }

    public List<Integer> getVisibleLayers() {
        ArrayList visible = Lists.newArrayList();
        List<Boolean> visibility = this.getLayerVisibility();
        int layer = 0;
        int nn = visibility.size();
        while (layer < nn) {
            if (visibility.get(layer).booleanValue()) {
                visible.add(layer);
            }
            ++layer;
        }
        return visible;
    }

    @Override
    public void sceneChanged(TudeySceneModel scene) {
        super.sceneChanged(scene);
        this._tableModel.setScene(scene);
        this.setSelectedLayer(0);
    }

    protected void layerWasSelected(int layer) {
        this._removeLayerAction.setEnabled(layer != 0);
        this.fireStateChanged();
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = null;
        int ii = listeners.length - 2;
        while (ii >= 0) {
            if (listeners[ii] == ChangeListener.class) {
                if (event == null) {
                    event = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[ii + 1]).stateChanged(event);
            }
            ii -= 2;
        }
    }

    protected void mergeVisible() {
        List<Integer> visible = this.getVisibleLayers();
        int mergeTo = visible.remove(0);
        for (TudeySceneModel.Entry entry : this._scene.getEntries()) {
            Object key = entry.getKey();
            if (!visible.contains(this._scene.getLayer(key))) continue;
            this._scene.setLayer(key, mergeTo);
        }
        for (Integer layer : Lists.reverse(visible)) {
            this._tableModel.removeLayer(layer);
        }
        this.fireStateChanged();
    }

    protected boolean confirm(String title, String message) {
        return JOptionPane.showConfirmDialog(this, message, title, 2, 2) == 0;
    }
}

