/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.util;

import com.google.common.collect.Lists;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.threerings.config.ConfigManager;
import com.threerings.math.FloatMath;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.media.util.AStarPathUtil;
import com.threerings.media.util.MathUtil;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.space.SpaceElement;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.CoordIntMap;
import java.awt.Point;
import java.util.List;

public class Pathfinder
implements TudeySceneModel.Observer,
TudeySceneManager.ActorObserver,
Logic.ShapeObserver,
ActorLogic.CollisionFlagObserver {
    protected TudeySceneManager _scenemgr;
    protected CoordIntMap _entryFlags = new CoordIntMap(3, 0);
    protected CoordIntMap _actorFlags = new CoordIntMap(3, 0);
    protected IntMap<List<Integer>> _actorFlagLists = IntMaps.newHashIntMap();
    protected Polygon _quad = new Polygon(4);
    protected List<SpaceElement> _elements = Lists.newArrayList();
    protected List<Vector2f> _waypoints = Lists.newArrayList();
    protected Rectangle _region = new Rectangle();
    protected Transform2D _transform = new Transform2D();
    protected Shape _worldShape;
    protected Vector2f _translation = new Vector2f();
    protected Shape _sweptShape;
    protected static final int SUBDIVISION = 2;

    public Pathfinder(TudeySceneManager scenemgr) {
        this._scenemgr = scenemgr;
        TudeySceneModel model = (TudeySceneModel)this._scenemgr.getScene().getSceneModel();
        for (TudeySceneModel.Entry entry : model.getEntries()) {
            this.addFlags(entry);
        }
        model.addObserver(this);
        this._scenemgr.addActorObserver(this);
    }

    public void shutdown() {
        ((TudeySceneModel)this._scenemgr.getScene().getSceneModel()).removeObserver(this);
        this._scenemgr.removeActorObserver(this);
    }

    public Vector2f[] getEntryPath(ActorLogic actor, float longest, float bx, float by, boolean partial, boolean shortcut) {
        Vector2f translation = actor.getTranslation();
        return this.getEntryPath(actor, longest, translation.x, translation.y, bx, by, partial, shortcut);
    }

    public Vector2f[] getEntryPath(ActorLogic actor, float longest, float ax, float ay, float bx, float by, boolean partial, boolean shortcut) {
        return this.getPath(false, actor, longest, ax, ay, bx, by, partial, shortcut);
    }

    public Vector2f[] getPath(ActorLogic actor, float longest, float bx, float by, boolean partial, boolean shortcut) {
        Vector2f translation = actor.getTranslation();
        return this.getPath(actor, longest, translation.x, translation.y, bx, by, partial, shortcut);
    }

    public Vector2f[] getPath(ActorLogic actor, float longest, float ax, float ay, float bx, float by, boolean partial, boolean shortcut) {
        return this.getPath(true, actor, longest, ax, ay, bx, by, partial, shortcut);
    }

    @Override
    public void entryAdded(TudeySceneModel.Entry entry) {
        this.addFlags(entry);
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        this.removeFlags(oentry);
        this.addFlags(nentry);
    }

    @Override
    public void entryRemoved(TudeySceneModel.Entry oentry) {
        this.removeFlags(oentry);
    }

    @Override
    public void actorAdded(ActorLogic logic) {
        this.addFlags(logic);
        logic.addShapeObserver(this);
        logic.addCollisionFlagObserver(this);
    }

    @Override
    public void actorRemoved(ActorLogic logic) {
        this.removeFlags(logic);
        logic.removeShapeObserver(this);
        logic.removeCollisionFlagObserver(this);
    }

    @Override
    public void shapeWillChange(Logic logic) {
        this.removeFlags((ActorLogic)logic);
    }

    @Override
    public void shapeDidChange(Logic logic) {
        this.addFlags((ActorLogic)logic);
    }

    @Override
    public void collisionFlagsChanged(ActorLogic logic, int oflags) {
        int nflags = logic.getCollisionFlags();
        Shape shape = logic.getShape();
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        int yy = miny;
        while (yy <= maxy) {
            int xx = minx;
            while (xx <= maxx) {
                int ys = 0;
                while (ys < 2) {
                    int xs = 0;
                    while (xs < 2) {
                        this.updateQuadSubdivision(xx, yy, xs, ys);
                        if (shape.intersects(this._quad)) {
                            int sx = xx * 2 + xs;
                            int sy = yy * 2 + ys;
                            int coord = Coord.encode(sx, sy);
                            List list = (List)this._actorFlagLists.get(coord);
                            if (oflags != 0 && list != null) {
                                list.remove((Object)oflags);
                            }
                            if (nflags != 0) {
                                if (list == null) {
                                    list = Lists.newArrayListWithCapacity((int)1);
                                    this._actorFlagLists.put(coord, (Object)list);
                                }
                                list.add(nflags);
                            }
                            if (list != null) {
                                int nsize = list.size();
                                if (nsize == 0) {
                                    this._actorFlagLists.remove(coord);
                                    this._actorFlags.remove(sx, sy);
                                } else {
                                    int combined = 0;
                                    int ii = 0;
                                    while (ii < nsize) {
                                        combined |= ((Integer)list.get(ii)).intValue();
                                        ++ii;
                                    }
                                    this._actorFlags.put(sx, sy, combined);
                                }
                            }
                        }
                        ++xs;
                    }
                    ++ys;
                }
                ++xx;
            }
            ++yy;
        }
    }

    protected Vector2f[] getPath(boolean collideActor, ActorLogic logic, float longest, float ax, float ay, float bx, float by, boolean partial, boolean shortcut) {
        boolean remove;
        Object pred;
        Vector2f start = new Vector2f(ax, ay);
        if (ax == bx && ay == by) {
            return new Vector2f[]{start};
        }
        Vector2f end = new Vector2f(bx, by);
        if (!this.sweptShapeCollides(collideActor, logic, start, end)) {
            return new Vector2f[]{start, end};
        }
        Rect bounds = logic.getShape().getBounds();
        int width = Math.max(1, FloatMath.iceil(bounds.getWidth() * 2.0f));
        int height = Math.max(1, FloatMath.iceil(bounds.getHeight() * 2.0f));
        Actor actor = logic.getActor();
        final int collisionMask = actor.getCollisionMask();
        if (width == 1 && height == 1) {
            pred = collideActor ? new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    return (collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)x, (int)2), MathUtil.floorDiv((int)y, (int)2))) == 0 && (collisionMask & Pathfinder.this._actorFlags.get(x, y)) == 0;
                }
            } : new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    return (collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)x, (int)2), MathUtil.floorDiv((int)y, (int)2))) == 0;
                }
            };
        } else {
            final int left = width / 2;
            final int right = (width - 1) / 2;
            final int bottom = height / 2;
            final int top = (height - 1) / 2;
            pred = collideActor ? new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    int yy = y - bottom;
                    int yymax = y + top;
                    while (yy <= yymax) {
                        int xx = x - left;
                        int xxmax = x + right;
                        while (xx <= xxmax) {
                            if ((collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)xx, (int)2), MathUtil.floorDiv((int)yy, (int)2))) != 0 || (collisionMask & Pathfinder.this._actorFlags.get(xx, yy)) != 0) {
                                return false;
                            }
                            ++xx;
                        }
                        ++yy;
                    }
                    return true;
                }
            } : new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    int yy = y - bottom;
                    int yymax = y + top;
                    while (yy <= yymax) {
                        int xx = x - left;
                        int xxmax = x + right;
                        while (xx <= xxmax) {
                            if ((collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)xx, (int)2), MathUtil.floorDiv((int)yy, (int)2))) != 0) {
                                return false;
                            }
                            ++xx;
                        }
                        ++yy;
                    }
                    return true;
                }
            };
        }
        float xoff = (float)(width % 2) * 0.5f / 2.0f;
        float yoff = (float)(height % 2) * 0.5f / 2.0f;
        ax *= 2.0f;
        ay *= 2.0f;
        bx *= 2.0f;
        by *= 2.0f;
        boolean bl = remove = !logic.isRemoved() && collideActor && actor.canCollide(logic.getCollisionFlags());
        if (remove) {
            this.removeFlags(logic);
        }
        List path = AStarPathUtil.getPath((AStarPathUtil.TraversalPred)pred, (Object)actor, (int)((int)longest), (int)Math.round(ax - xoff), (int)Math.round(ay - yoff), (int)Math.round(bx - xoff), (int)Math.round(by - yoff), (boolean)partial);
        if (remove) {
            this.addFlags(logic);
        }
        if (path == null) {
            return null;
        }
        Vector2f[] waypoints = new Vector2f[path.size()];
        int ii = 0;
        while (ii < waypoints.length) {
            Point pt = (Point)path.get(ii);
            waypoints[ii] = new Vector2f(((float)pt.x + xoff) / 2.0f, ((float)pt.y + yoff) / 2.0f);
            ++ii;
        }
        if (!shortcut) {
            return waypoints;
        }
        Vector2f current = start;
        int ii2 = 0;
        block1: while (ii2 < waypoints.length) {
            int jj = waypoints.length - 1;
            while (jj >= ii2) {
                Vector2f waypoint = waypoints[jj];
                if (jj == ii2 || !this.sweptShapeCollides(collideActor, logic, current, waypoint)) {
                    current = waypoint;
                    this._waypoints.add(current);
                    ii2 = jj + 1;
                    continue block1;
                }
                --jj;
            }
        }
        waypoints = this._waypoints.toArray(new Vector2f[this._waypoints.size()]);
        this._waypoints.clear();
        return waypoints;
    }

    protected boolean sweptShapeCollides(boolean collideActor, ActorLogic logic, Vector2f start, Vector2f end) {
        this._worldShape = logic.getShapeElement().getLocalShape().transform(this._transform.set(start, logic.getRotation()), this._worldShape);
        this._sweptShape = this._worldShape.sweep(end.subtract(start, this._translation), this._sweptShape);
        if (!collideActor) {
            return ((TudeySceneModel)this._scenemgr.getScene().getSceneModel()).collides(logic.getActor(), this._sweptShape);
        }
        return this._scenemgr.collides(logic, this._sweptShape);
    }

    protected void addFlags(TudeySceneModel.Entry entry) {
        if (!(entry instanceof TudeySceneModel.TileEntry)) {
            ConfigManager cfgmgr = this._scenemgr.getConfigManager();
            Shape shape = entry.createShape(cfgmgr);
            if (shape != null) {
                this.addFlags(shape, entry.getCollisionFlags(cfgmgr), true);
            }
            return;
        }
        TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
        TileConfig.Original config = tentry.getConfig(this._scenemgr.getConfigManager());
        tentry.getRegion(config, this._region);
        int yy = this._region.y;
        int yymax = yy + this._region.height;
        while (yy < yymax) {
            int xx = this._region.x;
            int xxmax = xx + this._region.width;
            while (xx < xxmax) {
                int flags = tentry.getCollisionFlags(config, xx, yy);
                if (flags != 0) {
                    this._entryFlags.setBits(xx, yy, flags);
                }
                ++xx;
            }
            ++yy;
        }
    }

    protected void removeFlags(TudeySceneModel.Entry entry) {
        if (!(entry instanceof TudeySceneModel.TileEntry)) {
            ConfigManager cfgmgr = this._scenemgr.getConfigManager();
            Shape shape = entry.createShape(cfgmgr);
            if (shape != null) {
                this.removeFlags(shape, entry.getCollisionFlags(cfgmgr), true, null);
            }
            return;
        }
        TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
        TileConfig.Original config = tentry.getConfig(this._scenemgr.getConfigManager());
        tentry.getRegion(config, this._region);
        int yy = this._region.y;
        int yymax = yy + this._region.height;
        while (yy < yymax) {
            int xx = this._region.x;
            int xxmax = xx + this._region.width;
            while (xx < xxmax) {
                int flags = tentry.getCollisionFlags(config, xx, yy);
                if (flags != 0) {
                    this.updateQuad(xx, yy);
                    this.updateEntryFlags(xx, yy, null);
                }
                ++xx;
            }
            ++yy;
        }
    }

    protected void addFlags(ActorLogic logic) {
        this.addFlags(logic.getShape(), logic.getCollisionFlags(), false);
    }

    protected void removeFlags(ActorLogic logic) {
        this.removeFlags(logic.getShape(), logic.getCollisionFlags(), false, logic.getShapeElement());
    }

    protected void addFlags(Shape shape, int flags, boolean entry) {
        if (flags == 0) {
            return;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        int yy = miny;
        while (yy <= maxy) {
            int xx = minx;
            while (xx <= maxx) {
                if (entry) {
                    this.updateQuad(xx, yy);
                    if (shape.intersects(this._quad)) {
                        this._entryFlags.setBits(xx, yy, flags);
                    }
                } else {
                    int ys = 0;
                    while (ys < 2) {
                        int xs = 0;
                        while (xs < 2) {
                            this.updateQuadSubdivision(xx, yy, xs, ys);
                            if (shape.intersects(this._quad)) {
                                int sx = xx * 2 + xs;
                                int sy = yy * 2 + ys;
                                this._actorFlags.setBits(sx, sy, flags);
                                int coord = Coord.encode(sx, sy);
                                List list = (List)this._actorFlagLists.get(coord);
                                if (list == null) {
                                    list = Lists.newArrayListWithCapacity((int)1);
                                    this._actorFlagLists.put(coord, (Object)list);
                                }
                                list.add(flags);
                            }
                            ++xs;
                        }
                        ++ys;
                    }
                }
                ++xx;
            }
            ++yy;
        }
    }

    protected void removeFlags(Shape shape, int flags, boolean entry, SpaceElement skip) {
        if (flags == 0) {
            return;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        int yy = miny;
        while (yy <= maxy) {
            int xx = minx;
            while (xx <= maxx) {
                if (entry) {
                    this.updateQuad(xx, yy);
                    if (shape.intersects(this._quad)) {
                        this.updateEntryFlags(xx, yy, skip);
                    }
                } else {
                    int ys = 0;
                    while (ys < 2) {
                        int xs = 0;
                        while (xs < 2) {
                            int sy;
                            int sx;
                            int coord;
                            List list;
                            this.updateQuadSubdivision(xx, yy, xs, ys);
                            if (shape.intersects(this._quad) && (list = (List)this._actorFlagLists.get(coord = Coord.encode(sx = xx * 2 + xs, sy = yy * 2 + ys))) != null) {
                                list.remove((Object)flags);
                                int nsize = list.size();
                                if (nsize == 0) {
                                    this._actorFlagLists.remove(coord);
                                    this._actorFlags.remove(sx, sy);
                                } else {
                                    int combined = 0;
                                    int ii = 0;
                                    while (ii < nsize) {
                                        combined |= ((Integer)list.get(ii)).intValue();
                                        ++ii;
                                    }
                                    this._actorFlags.put(sx, sy, combined);
                                }
                            }
                            ++xs;
                        }
                        ++ys;
                    }
                }
                ++xx;
            }
            ++yy;
        }
    }

    protected void updateQuad(int x, int y) {
        this.updateQuad(x, y, x + 1, y + 1);
    }

    protected void updateQuadSubdivision(int x, int y, int xs, int ys) {
        this.updateQuad((float)x + (float)xs / 2.0f, (float)y + (float)ys / 2.0f, (float)x + (float)(xs + 1) / 2.0f, (float)y + (float)(ys + 1) / 2.0f);
    }

    protected void updateQuad(float lx, float ly, float ux, float uy) {
        this._quad.getVertex(0).set(lx += 2.0E-6f, ly += 2.0E-6f);
        this._quad.getVertex(1).set(ux -= 2.0E-6f, ly);
        this._quad.getVertex(2).set(ux, uy -= 2.0E-6f);
        this._quad.getVertex(3).set(lx, uy);
        this._quad.getBounds().getMinimumExtent().set(lx, ly);
        this._quad.getBounds().getMaximumExtent().set(ux, uy);
    }

    protected void updateEntryFlags(int x, int y, SpaceElement skip) {
        TudeySceneModel model = (TudeySceneModel)this._scenemgr.getScene().getSceneModel();
        int flags = model.getCollisionFlags().get(x, y);
        model.getSpace().getIntersecting(this._quad, this._elements);
        ConfigManager cfgmgr = this._scenemgr.getConfigManager();
        int ii = 0;
        int nn = this._elements.size();
        while (ii < nn) {
            SpaceElement element = this._elements.get(ii);
            if (element != skip) {
                flags |= ((TudeySceneModel.Entry)element.getUserObject()).getCollisionFlags(cfgmgr);
            }
            ++ii;
        }
        this._elements.clear();
        this._entryFlags.put(x, y, flags);
    }
}

