/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.QuaternionExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.Vector3fExpression;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Matrix4f;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;

@EditorTypes(value={Constant.class, Reference.class, Uniform.class, NonUniform.class, TextureFrame.class})
public abstract class Transform3DExpression
extends ObjectExpression<Transform3D> {

    public static class Constant
    extends Transform3DExpression {
        @Editable(step=0.01)
        public Transform3D value = new Transform3D();

        @Override
        public ObjectExpression.Evaluator<Transform3D> createEvaluator(Scope scope) {
            return new ObjectExpression.Evaluator<Transform3D>(){

                @Override
                public Transform3D evaluate() {
                    return Constant.this.value;
                }
            };
        }
    }

    public static class NonUniform
    extends Transform3DExpression {
        @Editable
        public Vector3fExpression translation = new Vector3fExpression.Constant();
        @Editable
        public QuaternionExpression rotation = new QuaternionExpression.Constant();
        @Editable
        public Vector3fExpression scale = new Vector3fExpression.Constant(Vector3f.UNIT_XYZ);

        @Override
        public ObjectExpression.Evaluator<Transform3D> createEvaluator(Scope scope) {
            final ObjectExpression.Evaluator teval = this.translation.createEvaluator(scope);
            final ObjectExpression.Evaluator reval = this.rotation.createEvaluator(scope);
            final ObjectExpression.Evaluator seval = this.scale.createEvaluator(scope);
            return new ObjectExpression.Evaluator<Transform3D>(){
                protected Transform3D _result = new Transform3D();

                @Override
                public Transform3D evaluate() {
                    return this._result.set((Vector3f)teval.evaluate(), (Quaternion)reval.evaluate(), (Vector3f)seval.evaluate());
                }
            };
        }

        @Override
        public void invalidate() {
            this.translation.invalidate();
            this.rotation.invalidate();
            this.scale.invalidate();
        }
    }

    public static class Reference
    extends Transform3DExpression {
        @Editable
        public String name = "";
        @Editable(step=0.01)
        public Transform3D defvalue = new Transform3D();

        @Override
        public ObjectExpression.Evaluator<Transform3D> createEvaluator(Scope scope) {
            final Transform3D value = ScopeUtil.resolve(scope, this.name, this.defvalue);
            return new ObjectExpression.Evaluator<Transform3D>(){

                @Override
                public Transform3D evaluate() {
                    return value;
                }
            };
        }
    }

    public static class TextureFrame
    extends Transform3DExpression {
        @Editable(min=1.0, hgroup="d")
        public int divisionsS = 1;
        @Editable(min=1.0, hgroup="d")
        public int divisionsT = 1;
        @Editable
        public FloatExpression frame = new FloatExpression.Constant(0.0f);

        @Override
        public ObjectExpression.Evaluator<Transform3D> createEvaluator(Scope scope) {
            final FloatExpression.Evaluator feval = this.frame.createEvaluator(scope);
            final int udivs = this.divisionsS;
            final float uscale = 1.0f / (float)this.divisionsS;
            final float vscale = 1.0f / (float)this.divisionsT;
            final Transform3D result = new Transform3D(3);
            final Matrix4f matrix = result.getMatrix();
            matrix.m00 = uscale;
            matrix.m11 = vscale;
            return new ObjectExpression.Evaluator<Transform3D>(){

                @Override
                public Transform3D evaluate() {
                    int frame = Math.round(feval.evaluate());
                    matrix.m30 = (float)(frame % udivs) * uscale;
                    matrix.m31 = (float)(frame / udivs) * vscale;
                    return result;
                }
            };
        }

        @Override
        public void invalidate() {
            this.frame.invalidate();
        }
    }

    public static class Uniform
    extends Transform3DExpression {
        @Editable
        public Vector3fExpression translation = new Vector3fExpression.Constant();
        @Editable
        public QuaternionExpression rotation = new QuaternionExpression.Constant();
        @Editable
        public FloatExpression scale = new FloatExpression.Constant(1.0f);

        @Override
        public ObjectExpression.Evaluator<Transform3D> createEvaluator(Scope scope) {
            final ObjectExpression.Evaluator teval = this.translation.createEvaluator(scope);
            final ObjectExpression.Evaluator reval = this.rotation.createEvaluator(scope);
            final FloatExpression.Evaluator seval = this.scale.createEvaluator(scope);
            return new ObjectExpression.Evaluator<Transform3D>(){
                protected Transform3D _result = new Transform3D();

                @Override
                public Transform3D evaluate() {
                    return this._result.set((Vector3f)teval.evaluate(), (Quaternion)reval.evaluate(), seval.evaluate());
                }
            };
        }

        @Override
        public void invalidate() {
            this.translation.invalidate();
            this.rotation.invalidate();
            this.scale.invalidate();
        }
    }
}

