/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor;

import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.threerings.editor.DynamicallyEditable;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorMessageBundle;
import com.threerings.editor.FieldProperty;
import com.threerings.editor.Log;
import com.threerings.editor.MethodProperty;
import com.threerings.editor.Property;
import com.threerings.editor.PropertyOrder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class Introspector {
    protected static HashMap<Class<?>, String[]> _categories = new HashMap();
    protected static HashMap<Class<?>, Property[]> _properties = new HashMap();
    protected static HashMap<Class<?>, String> _bundles = new HashMap();
    protected static final Comparator<Property> WEIGHT_COMP = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            return Double.compare(p1.getAnnotation().weight(), p2.getAnnotation().weight());
        }
    };

    public static String[] getCategories(Class<?> clazz) {
        Object[] categories = _categories.get(clazz);
        if (categories == null) {
            categories = new String[]{};
            Property[] propertyArray = Introspector.getProperties(clazz);
            int n = propertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property prop = propertyArray[n2];
                String category = prop.getAnnotation().category();
                if (!ListUtil.contains((Object[])categories, (Object)category)) {
                    categories = (String[])ArrayUtil.append((Object[])categories, (Object)category);
                }
                ++n2;
            }
            if (DynamicallyEditable.class.isAssignableFrom(clazz) && !ListUtil.contains((Object[])categories, (Object)"")) {
                categories = (String[])ArrayUtil.append((Object[])categories, (Object)"");
            }
            _categories.put(clazz, (String[])categories);
        }
        return categories;
    }

    public static Property[] getProperties(Object object) {
        Object[] sprops = Introspector.getProperties(object.getClass());
        if (!(object instanceof DynamicallyEditable)) {
            return sprops;
        }
        Object[] dprops = ((DynamicallyEditable)object).getDynamicProperties();
        if (sprops.length == 0) {
            return dprops;
        }
        if (dprops.length == 0) {
            return sprops;
        }
        return (Property[])ArrayUtil.concatenate((Object[])sprops, (Object[])dprops);
    }

    public static Property[] getProperties(Class<?> clazz) {
        Property[] properties = _properties.get(clazz);
        if (properties == null) {
            properties = Introspector.createProperties(clazz);
            _properties.put(clazz, properties);
        }
        return properties;
    }

    public static String getMessageBundle(Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            return "editor.default";
        }
        String bundle = _bundles.get(clazz);
        if (bundle == null) {
            bundle = Introspector.findMessageBundle(clazz);
            _bundles.put(clazz, bundle);
        }
        return bundle;
    }

    protected static String findMessageBundle(Class<?> clazz) {
        int idx;
        EditorMessageBundle annotation = clazz.getAnnotation(EditorMessageBundle.class);
        if (annotation != null) {
            return annotation.value();
        }
        Class<?> eclazz = clazz.getEnclosingClass();
        if (eclazz != null) {
            return Introspector.getMessageBundle(eclazz);
        }
        String name = clazz.getName();
        while ((idx = name.lastIndexOf(46)) != -1) {
            Package pkg = Package.getPackage(name = name.substring(0, idx));
            if (pkg == null || (annotation = pkg.getAnnotation(EditorMessageBundle.class)) == null) continue;
            return annotation.value();
        }
        return "editor.default";
    }

    protected static Property[] createProperties(Class<?> clazz) {
        ArrayList<Property> properties = new ArrayList<Property>();
        Introspector.createProperties(clazz, properties);
        Collections.sort(properties, WEIGHT_COMP);
        PropertyOrder order = clazz.getAnnotation(PropertyOrder.class);
        if (order != null) {
            int index = 0;
            String[] stringArray = order.value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                int oindex = index;
                int ii = index;
                int nn = properties.size();
                while (ii < nn) {
                    Property property = properties.get(ii);
                    if (property.getName().equals(name)) {
                        properties.remove(ii);
                        properties.add(index++, property);
                        break;
                    }
                    ++ii;
                }
                if (index == oindex) {
                    Log.log.warning((Object)("Missing property in order annotation [class=" + clazz.getName() + ", property=" + name + "]."), new Object[0]);
                }
                ++n2;
            }
        }
        return properties.toArray(new Property[properties.size()]);
    }

    /*
     * Unable to fully structure code
     */
    protected static void createProperties(Class<?> clazz, ArrayList<Property> properties) {
        sclazz = clazz.getSuperclass();
        if (sclazz != null) {
            Collections.addAll(properties, Introspector.getProperties(sclazz));
        }
        unpaired = new HashMap<String, Method>();
        var7_4 = clazz.getDeclaredMethods();
        var6_5 = var7_4.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block11: {
                block13: {
                    block12: {
                        method = var7_4[var5_6];
                        if (!method.isAnnotationPresent(Editable.class)) break block11;
                        name = method.getName();
                        if (!name.startsWith("set")) break block12;
                        name = name.substring(3);
                        getter = false;
                        ** GOTO lbl27
                    }
                    if (!name.startsWith("get")) break block13;
                    name = name.substring(3);
                    ** GOTO lbl26
                }
                if (!name.startsWith("is")) {
                    Log.log.warning((Object)("Invalid method name for editable property [class=" + clazz + ", name=" + name + "]."), new Object[0]);
                } else {
                    name = name.substring(2);
lbl26:
                    // 2 sources

                    getter = true;
lbl27:
                    // 2 sources

                    omethod = (Method)unpaired.remove(name);
                    if (omethod != null) {
                        gmethod = getter != false ? method : omethod;
                        smethod = getter != false ? omethod : method;
                        rtype = gmethod.getReturnType();
                        ptypes = smethod.getParameterTypes();
                        if (ptypes.length != 1 || ptypes[0] != rtype) {
                            Log.log.warning((Object)("Mismatched types on getter/setter [class=" + clazz + ", getter=" + gmethod + ", setter=" + smethod + "]."), new Object[0]);
                        } else {
                            properties.add(new MethodProperty(gmethod, smethod));
                        }
                    } else {
                        unpaired.put(name, method);
                    }
                }
            }
            ++var5_6;
        }
        if (!unpaired.isEmpty()) {
            Log.log.warning((Object)("Found unmatched getters/setters [class=" + clazz + ", methods=" + unpaired.values() + "]."), new Object[0]);
        }
        var7_4 = clazz.getDeclaredFields();
        var6_5 = var7_4.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            field = var7_4[var5_6];
            if (field.isAnnotationPresent(Editable.class)) {
                properties.add(new FieldProperty((Field)field));
            }
            ++var5_6;
        }
    }
}

