/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.samskivert.util.Interval;
import com.samskivert.util.RandomUtil;
import com.samskivert.util.Randoms;
import com.threerings.config.ConfigReference;
import com.threerings.crowd.data.BodyObject;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.presents.dobj.OidList;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.tudey.Log;
import com.threerings.tudey.config.ActionConfig;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.config.ClientActionConfig;
import com.threerings.tudey.config.EffectConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.TudeyOccupantInfo;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.data.TudeySceneObject;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.Mobile;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.TudeySceneRegistry;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.ConditionLogic;
import com.threerings.tudey.server.logic.EntryLogic;
import com.threerings.tudey.server.logic.ExpressionLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.PawnLogic;
import com.threerings.tudey.server.logic.TargetLogic;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class ActionLogic
extends Logic {
    protected ActionConfig _config;
    protected Logic _source;
    protected ArrayList<Logic> _targets = Lists.newArrayList();

    public void init(TudeySceneManager scenemgr, ActionConfig config, Logic source) {
        super.init(scenemgr);
        this._config = config;
        this._source = source;
        this.didInit();
    }

    public void removed() {
        this.wasRemoved();
    }

    public boolean shouldExecute(Logic activator) {
        return true;
    }

    public abstract boolean execute(int var1, Logic var2);

    @Override
    public boolean isActive() {
        return this._source.isActive();
    }

    @Override
    public EntityKey getEntityKey() {
        return this._source.getEntityKey();
    }

    @Override
    public Vector2f getTranslation() {
        return this._source.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._source.getRotation();
    }

    protected void didInit() {
    }

    protected void wasRemoved() {
    }

    public static class ServerLog
    extends ActionLogic {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            ActionConfig.ServerLog config = (ActionConfig.ServerLog)this._config;
            switch (config.level) {
                case DEBUG: {
                    Log.log.debug((Object)config.message, new Object[0]);
                    break;
                }
                case INFO: {
                    Log.log.info((Object)config.message, new Object[0]);
                    break;
                }
                case WARN: {
                    Log.log.warning((Object)config.message, new Object[0]);
                    break;
                }
                case ERROR: {
                    Log.log.error((Object)config.message, new Object[0]);
                }
            }
            return true;
        }
    }

    public static class TargetedAction
    extends Targeted {
        protected ActionLogic _action;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            this._target.resolve(activator, this._targets);
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                this._action.execute(timestamp, (Logic)this._targets.get(ii));
            }
            this._targets.clear();
            return true;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.TargetedAction)this._config).target, this._source);
            this._action = this.createAction(((ActionConfig.TargetedAction)this._config).action, this._source);
        }

        @Override
        protected void wasRemoved() {
            this._action.removed();
        }
    }

    public static class ForceClientAction
    extends Targeted {
        @Inject
        protected PresentsDObjectMgr _omgr;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            ClientActionConfig action = ((ActionConfig.ForceClientAction)this._config).action;
            this._target.resolve(activator, this._targets);
            boolean success = false;
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic target = (Logic)this._targets.get(ii);
                if (!(target instanceof PawnLogic)) continue;
                int pawnId = ((PawnLogic)target).getActor().getId();
                TudeyOccupantInfo info = ((TudeySceneObject)this._scenemgr.getPlaceObject()).getOccupantInfo(pawnId);
                if (info == null) continue;
                this._omgr.getObject(info.getBodyOid()).postMessage("forceClientAction", new Object[]{action, this._source.getEntityKey()});
                success = true;
            }
            this._targets.clear();
            return success;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.ForceClientAction)this._config).target, this._source);
        }
    }

    public static class SetFlag
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            ActionConfig.SetFlag config = (ActionConfig.SetFlag)this._config;
            this._target.resolve(activator, this._targets);
            boolean ret = false;
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Field flag;
                Logic target = (Logic)this._targets.get(ii);
                if (target instanceof ActorLogic) {
                    Actor actor = ((ActorLogic)target).getActor();
                    try {
                        flag = actor.getClass().getField(config.flag);
                        actor.set(flag.getInt(actor), config.on);
                        ret = true;
                    }
                    catch (NoSuchFieldException e) {
                    }
                    catch (IllegalAccessException e) {
                        Log.log.warning((Object)"Cannot access flag field for Set Flag Action.", new Object[]{e});
                    }
                    continue;
                }
                if (!(target instanceof EntryLogic)) continue;
                TudeySceneModel.Entry entry = ((EntryLogic)target)._entry;
                try {
                    flag = entry.getClass().getField(config.flag);
                    entry.set(flag.getInt(entry), config.on);
                    ret = true;
                    continue;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    Log.log.warning((Object)"Cannot access flag field for Set Flag Action.", new Object[]{e});
                }
            }
            this._targets.clear();
            return ret;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.SetFlag)this._config).target, this._source);
        }
    }

    public static class SetVariable
    extends Targeted {
        protected ExpressionLogic _value;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            String name = ((ActionConfig.SetVariable)this._config).name;
            this._target.resolve(activator, this._targets);
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic target = (Logic)this._targets.get(ii);
                target.setVariable(timestamp, this._source, name, this._value.evaluate(activator, target.getVariable(name)));
            }
            this._targets.clear();
            return true;
        }

        @Override
        protected void didInit() {
            ActionConfig.SetVariable config = (ActionConfig.SetVariable)this._config;
            this._target = this.createTarget(config.target, this._source);
            this._value = this.createExpression(config.value, this._source);
        }
    }

    public static class Delayed
    extends ActionLogic {
        protected ActionLogic _action;
        protected List<Interval> _intervals = Lists.newArrayList();

        @Override
        public boolean execute(int timestamp, final Logic activator) {
            if (!this._scenemgr.isRunning()) {
                Log.log.warning((Object)"Attempting to execute Delayed action on shutdown SceneManager", new Object[0]);
                Thread.dumpStack();
                return false;
            }
            Interval interval = new Interval(this._scenemgr){

                public void expired() {
                    Delayed.this._intervals.remove((Object)this);
                    Delayed.this._action.execute(Delayed.this._scenemgr.getTimestamp(), activator);
                }
            };
            this._intervals.add(interval);
            ActionConfig.Delayed config = (ActionConfig.Delayed)this._config;
            int delay = config.variance == 0 ? config.delay : Math.max(0, config.delay + Randoms.RAND.getInt(config.variance * 2) - config.variance);
            interval.schedule((long)delay);
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._action.transfer(((Delayed)source)._action, refs);
        }

        @Override
        protected void didInit() {
            this._action = this.createAction(((ActionConfig.Delayed)this._config).action, this._source);
        }

        @Override
        protected void wasRemoved() {
            this._action.removed();
            int nn = this._intervals.size();
            for (int ii = 0; ii < nn; ++ii) {
                this._intervals.get(ii).cancel();
            }
            this._intervals.clear();
        }
    }

    public static class Random
    extends ActionLogic {
        protected float[] _weights;
        protected ActionLogic[] _actions;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            int idx = RandomUtil.getWeightedIndex((float[])this._weights);
            if (idx >= 0) {
                return this._actions[idx].execute(timestamp, activator);
            }
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            ActionLogic[] sactions = ((Random)source)._actions;
            for (int ii = 0; ii < this._actions.length; ++ii) {
                this._actions[ii].transfer(sactions[ii], refs);
            }
        }

        @Override
        protected void didInit() {
            ActionConfig.WeightedAction[] wactions = ((ActionConfig.Random)this._config).actions;
            this._weights = new float[wactions.length];
            this._actions = new ActionLogic[wactions.length];
            for (int ii = 0; ii < this._actions.length; ++ii) {
                ActionConfig.WeightedAction waction = wactions[ii];
                this._weights[ii] = waction.weight;
                this._actions[ii] = this.createAction(waction.action, this._source);
            }
        }

        @Override
        protected void wasRemoved() {
            for (ActionLogic action : this._actions) {
                action.removed();
            }
        }
    }

    public static class Compound
    extends ActionLogic {
        protected ActionLogic[] _actions;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            for (ActionLogic action : this._actions) {
                success = action.execute(timestamp, activator) | success;
                if (!((ActionConfig.Compound)this._config).stopOnFailure || success) continue;
                return false;
            }
            return success;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            ActionLogic[] sactions = ((Compound)source)._actions;
            for (int ii = 0; ii < this._actions.length; ++ii) {
                this._actions[ii].transfer(sactions[ii], refs);
            }
        }

        @Override
        protected void didInit() {
            ArrayList<ActionLogic> actions = new ArrayList<ActionLogic>();
            for (ActionConfig config : ((ActionConfig.Compound)this._config).actions) {
                ActionLogic action = this.createAction(config, this._source);
                if (action == null) continue;
                actions.add(action);
            }
            this._actions = actions.toArray(new ActionLogic[actions.size()]);
        }

        @Override
        protected void wasRemoved() {
            for (ActionLogic action : this._actions) {
                action.removed();
            }
        }
    }

    public static class ExpressionSwitch
    extends ActionLogic {
        protected ExpressionLogic _value;
        protected ExpressionLogic[] _caseValues;
        protected ActionLogic[] _actions;
        protected ActionLogic _defaultAction;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            Object value = this._value.evaluate(activator, null);
            for (int ii = 0; ii < this._caseValues.length; ++ii) {
                if (!Objects.equal((Object)value, (Object)this._caseValues[ii].evaluate(activator, null))) continue;
                return this._actions[ii].execute(timestamp, activator);
            }
            if (this._defaultAction != null) {
                return this._defaultAction.execute(timestamp, activator);
            }
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            ExpressionSwitch esource = (ExpressionSwitch)source;
            for (int ii = 0; ii < this._actions.length; ++ii) {
                this._actions[ii].transfer(esource._actions[ii], refs);
            }
            if (this._defaultAction != null) {
                this._defaultAction.transfer(esource._defaultAction, refs);
            }
        }

        @Override
        protected void didInit() {
            ActionConfig.ExpressionSwitch config = (ActionConfig.ExpressionSwitch)this._config;
            this._value = this.createExpression(config.value, this._source);
            this._caseValues = new ExpressionLogic[config.cases.length];
            this._actions = new ActionLogic[config.cases.length];
            for (int ii = 0; ii < config.cases.length; ++ii) {
                this._caseValues[ii] = this.createExpression(config.cases[ii].value, this._source);
                this._actions[ii] = this.createAction(config.cases[ii].action, this._source);
            }
            if (config.defaultAction != null) {
                this._defaultAction = this.createAction(config.defaultAction, this._source);
            }
        }

        @Override
        protected void wasRemoved() {
            for (ActionLogic action : this._actions) {
                action.removed();
            }
            if (this._defaultAction != null) {
                this._defaultAction.removed();
            }
        }
    }

    public static class Switch
    extends ActionLogic {
        protected ConditionLogic[] _conditions;
        protected ActionLogic[] _actions;
        protected ActionLogic _defaultAction;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            for (int ii = 0; ii < this._conditions.length; ++ii) {
                if (!this._conditions[ii].isSatisfied(activator)) continue;
                return this._actions[ii].execute(timestamp, activator);
            }
            if (this._defaultAction != null) {
                return this._defaultAction.execute(timestamp, activator);
            }
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Switch ssource = (Switch)source;
            for (int ii = 0; ii < this._conditions.length; ++ii) {
                this._conditions[ii].transfer(ssource._conditions[ii], refs);
                this._actions[ii].transfer(ssource._actions[ii], refs);
            }
            if (this._defaultAction != null) {
                this._defaultAction.transfer(ssource._defaultAction, refs);
            }
        }

        @Override
        protected void didInit() {
            ActionConfig.Switch config = (ActionConfig.Switch)this._config;
            this._conditions = new ConditionLogic[config.cases.length];
            this._actions = new ActionLogic[config.cases.length];
            for (int ii = 0; ii < config.cases.length; ++ii) {
                this._conditions[ii] = this.createCondition(config.cases[ii].condition, this._source);
                this._actions[ii] = this.createAction(config.cases[ii].action, this._source);
            }
            if (config.defaultAction != null) {
                this._defaultAction = this.createAction(config.defaultAction, this._source);
            }
        }

        @Override
        protected void wasRemoved() {
            for (ActionLogic action : this._actions) {
                action.removed();
            }
            if (this._defaultAction != null) {
                this._defaultAction.removed();
            }
        }
    }

    public static class Conditional
    extends ActionLogic {
        protected ConditionLogic _condition;
        protected ActionLogic _action;
        protected ActionLogic _elseAction;

        @Override
        public boolean shouldExecute(Logic activator) {
            return this._elseAction != null || this._condition.isSatisfied(activator);
        }

        @Override
        public boolean execute(int timestamp, Logic activator) {
            if (this._condition.isSatisfied(activator)) {
                return this._action.execute(timestamp, activator);
            }
            if (this._elseAction != null) {
                return this._elseAction.execute(timestamp, activator);
            }
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Conditional csource = (Conditional)source;
            this._condition.transfer(csource._condition, refs);
            this._action.transfer(csource._action, refs);
            if (this._elseAction != null) {
                this._elseAction.transfer(csource._elseAction, refs);
            }
        }

        @Override
        protected void didInit() {
            ActionConfig.Conditional config = (ActionConfig.Conditional)this._config;
            this._condition = this.createCondition(config.condition, this._source);
            this._action = this.createAction(config.action, this._source);
            if (config.elseAction != null) {
                this._elseAction = this.createAction(config.elseAction, this._source);
            }
        }

        @Override
        protected void wasRemoved() {
            if (this._action != null) {
                this._action.removed();
            }
            if (this._elseAction != null) {
                this._elseAction.removed();
            }
        }
    }

    public static class MoveAll
    extends AbstractMove {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            OidList occupants = this._scenemgr.getPlaceObject().occupants;
            int nn = occupants.size();
            for (int ii = 0; ii < nn; ++ii) {
                this.moveBody(occupants.get(ii));
            }
            return true;
        }
    }

    public static class MoveBody
    extends AbstractMove {
        protected TargetLogic _target;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic target = (Logic)this._targets.get(ii);
                if (!(target instanceof PawnLogic)) continue;
                int pawnId = ((PawnLogic)target).getActor().getId();
                TudeyOccupantInfo info = ((TudeySceneObject)this._scenemgr.getPlaceObject()).getOccupantInfo(pawnId);
                if (info == null) continue;
                this.moveBody(info.getBodyOid());
                success = true;
            }
            if (!success && activator instanceof PawnLogic) {
                int pawnId = ((PawnLogic)activator).getActor().getId();
                TudeyOccupantInfo info = ((TudeySceneObject)this._scenemgr.getPlaceObject()).getOccupantInfo(pawnId);
                if (info != null) {
                    this.moveBody(info.getBodyOid());
                    success = true;
                }
            }
            this._targets.clear();
            return success;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((MoveBody)source)._target, refs);
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.MoveBody)this._config).target, this._source);
        }
    }

    public static abstract class AbstractMove
    extends ActionLogic {
        @Inject
        protected PresentsDObjectMgr _omgr;
        @Inject
        protected TudeySceneRegistry _screg;

        protected void moveBody(int bodyOid) {
            BodyObject body = (BodyObject)this._omgr.getObject(bodyOid);
            ActionConfig.MoveBody mconfig = (ActionConfig.MoveBody)this._config;
            this._screg.moveBody(body, mconfig.sceneId, mconfig.portal.getKey());
        }
    }

    public static class Signal
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            String name = ((ActionConfig.Signal)this._config).name;
            this._target.resolve(activator, this._targets);
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                ((Logic)this._targets.get(ii)).signal(timestamp, this._source, name);
            }
            this._targets.clear();
            return true;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.Signal)this._config).target, this._source);
        }
    }

    public static class FireEffect
    extends ActionLogic {
        protected TargetLogic _location;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            ConfigReference<EffectConfig> effect = ((ActionConfig.FireEffect)this._config).effect;
            if (effect == null) {
                return true;
            }
            this._location.resolve(activator, this._targets);
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic target = (Logic)this._targets.get(ii);
                this._scenemgr.fireEffect(timestamp, target, null, 0.0f, effect);
            }
            this._targets.clear();
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._location.transfer(((FireEffect)source)._location, refs);
        }

        @Override
        protected void didInit() {
            this._location = this.createTarget(((ActionConfig.FireEffect)this._config).location, this._source);
        }
    }

    public static class WarpTransformedActor
    extends WarpActor {
        @Override
        protected void warp(ActorLogic target, Logic location) {
            ActionConfig.WarpTransformedActor config = (ActionConfig.WarpTransformedActor)this._config;
            float rotation = config.rotation + location.getRotation();
            Vector2f translation = new Vector2f();
            Vector2f ltrans = location.getTranslation();
            if (config.rotatedTranslation) {
                config.translation.rotateAndAdd(rotation, ltrans, translation);
            } else {
                translation.addLocal(ltrans);
            }
            target.warp(translation.x, translation.y, rotation, ltrans.x, ltrans.y, true, config.maxWarpPath);
        }
    }

    public static class WarpActor
    extends Targeted {
        protected TargetLogic _location;
        protected ArrayList<Logic> _locations = Lists.newArrayList();

        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic target = (Logic)this._targets.get(ii);
                if (!(target instanceof ActorLogic)) continue;
                this._location.resolve(activator, this._locations);
                if (this._locations.isEmpty()) continue;
                Logic location = (Logic)RandomUtil.pickRandom(this._locations);
                this._locations.clear();
                this.warp((ActorLogic)target, location);
                success = true;
            }
            this._targets.clear();
            return success;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._location.transfer(((WarpActor)source)._location, refs);
        }

        protected void warp(ActorLogic target, Logic location) {
            Vector2f translation = location.getTranslation();
            target.warp(translation.x, translation.y, location.getRotation(), translation.x, translation.y, true, ((ActionConfig.WarpActor)this._config).maxWarpPath);
        }

        @Override
        protected void didInit() {
            ActionConfig.WarpActor config = (ActionConfig.WarpActor)this._config;
            this._target = this.createTarget(config.target, this._source);
            this._location = this.createTarget(config.location, this._source);
        }
    }

    public static class RotateActor
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic target = (Logic)this._targets.get(ii);
                if (!(target instanceof ActorLogic)) continue;
                ActorLogic logic = (ActorLogic)target;
                Actor actor = logic.getActor();
                Vector2f translation = actor.getTranslation();
                float rotation = ((ActionConfig.RotateActor)this._config).rotation.getValue();
                logic.move(translation.x, translation.y, FloatMath.normalizeAngle(actor.getRotation() + rotation));
                if (actor instanceof Mobile) {
                    Mobile mobile = (Mobile)actor;
                    mobile.setDirection(FloatMath.normalizeAngle(mobile.getDirection() + rotation));
                }
                success = true;
            }
            this._targets.clear();
            return success;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.RotateActor)this._config).target, this._source);
        }
    }

    public static class RemoveEntry
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic target = (Logic)this._targets.get(ii);
                if (!(target instanceof EntryLogic)) continue;
                EntryLogic logic = (EntryLogic)target;
                logic.getSceneManager().entryRemoved(logic.getEntry());
                success = true;
            }
            this._targets.clear();
            return success;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.RemoveEntry)this._config).target, this._source);
        }
    }

    public static class DestroyActor
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic target = (Logic)this._targets.get(ii);
                if (!(target instanceof ActorLogic)) continue;
                ((ActorLogic)target).destroy(timestamp, activator);
                success = true;
            }
            this._targets.clear();
            return success;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.DestroyActor)this._config).target, this._source);
        }
    }

    public static class SpawnRandomTranslatedActor
    extends SpawnActor {
        protected TargetLogic _cs;
        protected static final int COLLISION_ATTEMPTS = 3;

        @Override
        protected boolean spawnActor(int timestamp, ConfigReference<ActorConfig> actor, Logic target, Logic activator) {
            ActionConfig.SpawnRandomTranslatedActor config = (ActionConfig.SpawnRandomTranslatedActor)this._config;
            HashSet locations = Sets.newHashSet();
            int steps = config.steps;
            boolean success = false;
            Vector2f translation = null;
            if (config.collisionMask != 0) {
                ArrayList cTargets = Lists.newArrayList();
                this._cs.resolve(activator, cTargets);
                if (cTargets.size() > 0) {
                    translation = this.getTranslation((Logic)cTargets.get(0));
                }
            }
            block0: for (int ii = 0; ii < config.count; ++ii) {
                for (int jj = 0; jj < 3; ++jj) {
                    Vector2f location = this.getTranslation(target).add((float)RandomUtil.getInRange((int)(-steps), (int)(steps + 1)) * config.stepSize, (float)RandomUtil.getInRange((int)(-steps), (int)(steps + 1)) * config.stepSize);
                    if (!locations.add(location) || translation != null && this._scenemgr.collides(config.collisionMask, (Shape)new Segment(translation, location))) continue;
                    ActorLogic logic = this._scenemgr.spawnActor(timestamp, location, this.getRotation(target), actor);
                    this.initLogic(logic, activator);
                    success = true;
                    continue block0;
                }
            }
            return success;
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._cs = this.createTarget(((ActionConfig.SpawnRandomTranslatedActor)this._config).collisionSource, this._source);
        }
    }

    public static class SpawnTransformedActor
    extends SpawnRotatedActor {
        @Override
        protected Vector2f getTranslation(Logic target) {
            return ((ActionConfig.SpawnTransformedActor)this._config).translation.rotateAndAdd(target.getRotation(), target.getTranslation(), new Vector2f());
        }
    }

    public static class SpawnRotatedActor
    extends SpawnActor {
        @Override
        protected float getRotation(Logic target) {
            ActionConfig.SpawnRotatedActor config = (ActionConfig.SpawnRotatedActor)this._config;
            float rotation = config.rotation;
            if (config.rotationVariance > 0.0f) {
                rotation += config.rotationVariance * (FloatMath.random() - 0.5f);
            }
            return FloatMath.normalizeAngle((config.relative ? target.getRotation() : 0.0f) + rotation);
        }
    }

    public static class SpawnLimitedActor
    extends SpawnRandomTranslatedActor {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            ActionConfig.SpawnLimitedActor config = (ActionConfig.SpawnLimitedActor)this._config;
            int currentSize = this._scenemgr.taggedCount(config.actor.getName());
            if (currentSize >= config.limit) {
                return true;
            }
            ConfigReference<ActorConfig> actor = this.getActorConfig(activator);
            if (actor == null) {
                return true;
            }
            this._location.resolve(activator, this._targets);
            boolean success = false;
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic target = (Logic)this._targets.get(ii);
                success = this.spawnActor(timestamp, actor, target, activator) | success;
                if (currentSize++ >= config.limit) break;
            }
            this._targets.clear();
            return success;
        }
    }

    public static class SpawnActor
    extends ActionLogic {
        protected TargetLogic _location;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            ConfigReference<ActorConfig> actor = this.getActorConfig(activator);
            if (actor == null) {
                return true;
            }
            this._location.resolve(activator, this._targets);
            boolean success = false;
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic target = (Logic)this._targets.get(ii);
                success = this.spawnActor(timestamp, actor, target, activator) | success;
            }
            this._targets.clear();
            return success;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._location.transfer(((SpawnActor)source)._location, refs);
        }

        @Override
        protected void didInit() {
            this._location = this.createTarget(((ActionConfig.SpawnActor)this._config).location, this._source);
        }

        public ConfigReference<ActorConfig> getActorConfig(Logic activator) {
            return ((ActionConfig.SpawnActor)this._config).actor;
        }

        protected boolean spawnActor(int timestamp, ConfigReference<ActorConfig> actor, Logic target, Logic activator) {
            ActorLogic logic = this._scenemgr.spawnActor(timestamp, this.getTranslation(target), this.getRotation(target), actor);
            this.initLogic(logic, activator);
            return true;
        }

        protected void initLogic(ActorLogic logic, Logic activator) {
            if (logic != null) {
                logic.setSource(this._source);
                logic.setActivator(activator);
            }
        }

        protected float getRotation(Logic target) {
            return target.getRotation();
        }

        protected Vector2f getTranslation(Logic target) {
            return target.getTranslation();
        }
    }

    public static abstract class Targeted
    extends ActionLogic {
        protected TargetLogic _target;

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((Targeted)source)._target, refs);
        }
    }
}

