/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.material.config;

import com.samskivert.util.ArrayUtil;
import com.threerings.config.ConfigManager;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.ExpressionBinding;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Vector4f;
import com.threerings.opengl.material.config.PassConfig;
import com.threerings.opengl.material.config.TechniqueConfig;
import com.threerings.opengl.renderer.TextureUnit;
import com.threerings.opengl.renderer.config.AlphaStateConfig;
import com.threerings.opengl.renderer.config.DepthStateConfig;
import com.threerings.opengl.renderer.config.TextureCoordGenConfig;
import com.threerings.opengl.renderer.config.TextureStateConfig;
import com.threerings.opengl.renderer.config.TextureUnitConfig;
import com.threerings.opengl.renderer.state.TextureState;
import com.threerings.util.DeepObject;

@EditorTypes(value={DepthOnly.class, Translucent.class, Projection.class})
public abstract class MaterialRewriter
extends DeepObject
implements Exportable {
    public TechniqueConfig rewrite(TechniqueConfig technique) {
        TechniqueConfig rewritten = (TechniqueConfig)technique.clone();
        rewritten.enqueuer = rewritten.enqueuer.rewrite(this);
        return rewritten;
    }

    protected TechniqueConfig.Enqueuer rewrite(TechniqueConfig.NormalEnqueuer enqueuer) {
        PassConfig[] passes = enqueuer.passes;
        for (int ii = 0; ii < passes.length; ++ii) {
            passes[ii] = this.rewrite(passes[ii]);
        }
        return enqueuer;
    }

    protected TechniqueConfig.Enqueuer rewrite(TechniqueConfig.CompoundEnqueuer enqueuer) {
        TechniqueConfig.Enqueuer[] enqueuers = enqueuer.enqueuers;
        for (int ii = 0; ii < enqueuers.length; ++ii) {
            enqueuers[ii] = enqueuers[ii].rewrite(this);
        }
        return enqueuer;
    }

    protected TechniqueConfig.Enqueuer rewrite(TechniqueConfig.GroupedEnqueuer enqueuer) {
        return this.rewrite((TechniqueConfig.CompoundEnqueuer)enqueuer);
    }

    protected PassConfig rewrite(PassConfig pass) {
        pass.alphaState = this.rewrite(pass.alphaState);
        pass.depthState = this.rewrite(pass.depthState);
        pass.textureState = this.rewrite(pass.textureState);
        return pass;
    }

    protected AlphaStateConfig rewrite(AlphaStateConfig alphaState) {
        return alphaState;
    }

    protected DepthStateConfig rewrite(DepthStateConfig depthState) {
        return depthState;
    }

    protected TextureStateConfig rewrite(TextureStateConfig textureState) {
        TextureUnitConfig[] units = textureState.units;
        for (int ii = 0; ii < units.length; ++ii) {
            units[ii] = this.rewrite(units[ii]);
        }
        return textureState;
    }

    protected TextureUnitConfig rewrite(TextureUnitConfig textureUnit) {
        return textureUnit;
    }

    public static class Projection
    extends MaterialRewriter {
        @Editable(hgroup="t")
        public boolean s;
        @Editable(hgroup="t")
        public boolean t;
        @Editable(hgroup="t")
        public boolean r;
        @Editable(hgroup="t")
        public boolean q;

        @Override
        protected PassConfig rewrite(PassConfig pass) {
            pass = super.rewrite(pass);
            int nunits = pass.textureState.units.length;
            if (nunits == 0 || !this.s && !this.t && !this.r && !this.q) {
                return pass;
            }
            ExpressionBinding sbinding = new ExpressionBinding(){

                @Override
                public Updater createUpdater(ConfigManager cfgmgr, Scope scope, Object object) {
                    final TextureState tstate = (TextureState)((TechniqueConfig.StateContainer)object).states[14];
                    final Vector4f genPlaneS = Projection.this.s ? ScopeUtil.resolve(scope, "genPlaneS", null, Vector4f.class) : null;
                    final Vector4f genPlaneT = Projection.this.t ? ScopeUtil.resolve(scope, "genPlaneT", null, Vector4f.class) : null;
                    final Vector4f genPlaneR = Projection.this.r ? ScopeUtil.resolve(scope, "genPlaneR", null, Vector4f.class) : null;
                    final Vector4f genPlaneQ = Projection.this.q ? ScopeUtil.resolve(scope, "genPlaneQ", null, Vector4f.class) : null;
                    return new Updater(){

                        @Override
                        public void update() {
                            for (TextureUnit unit : tstate.getUnits()) {
                                unit.genPlaneS = genPlaneS == null ? unit.genPlaneS : genPlaneS;
                                unit.genPlaneT = genPlaneT == null ? unit.genPlaneT : genPlaneT;
                                unit.genPlaneR = genPlaneR == null ? unit.genPlaneR : genPlaneR;
                                unit.genPlaneQ = genPlaneQ == null ? unit.genPlaneQ : genPlaneQ;
                            }
                        }
                    };
                }
            };
            pass.staticBindings = (ExpressionBinding[])ArrayUtil.append((Object[])pass.staticBindings, (Object)sbinding);
            ExpressionBinding dbinding = new ExpressionBinding(){

                @Override
                public Updater createUpdater(ConfigManager cfgmgr, Scope scope, Object object) {
                    final TextureState tstate = (TextureState)((TechniqueConfig.StateContainer)object).states[14];
                    return new Updater(){

                        @Override
                        public void update() {
                            for (TextureUnit unit : tstate.getUnits()) {
                                unit.dirty = true;
                            }
                            tstate.setDirty(true);
                        }
                    };
                }
            };
            pass.dynamicBindings = (ExpressionBinding[])ArrayUtil.append((Object[])pass.dynamicBindings, (Object)dbinding);
            return pass;
        }

        @Override
        protected TextureStateConfig rewrite(TextureStateConfig textureState) {
            textureState = super.rewrite(textureState);
            textureState.uniqueInstance = true;
            return textureState;
        }

        @Override
        protected TextureUnitConfig rewrite(TextureUnitConfig textureUnit) {
            textureUnit.coordGenS = this.s ? new TextureCoordGenConfig.EyeLinear() : textureUnit.coordGenS;
            textureUnit.coordGenT = this.t ? new TextureCoordGenConfig.EyeLinear() : textureUnit.coordGenT;
            textureUnit.coordGenR = this.r ? new TextureCoordGenConfig.EyeLinear() : textureUnit.coordGenR;
            textureUnit.coordGenQ = this.q ? new TextureCoordGenConfig.EyeLinear() : textureUnit.coordGenQ;
            return textureUnit;
        }
    }

    public static class Translucent
    extends MaterialRewriter {
        @Override
        protected TechniqueConfig.Enqueuer rewrite(TechniqueConfig.NormalEnqueuer enqueuer) {
            enqueuer = (TechniqueConfig.NormalEnqueuer)super.rewrite(enqueuer);
            enqueuer.queue = this.rewriteQueue(enqueuer.queue);
            return enqueuer;
        }

        @Override
        protected TechniqueConfig.Enqueuer rewrite(TechniqueConfig.GroupedEnqueuer enqueuer) {
            enqueuer = (TechniqueConfig.GroupedEnqueuer)super.rewrite(enqueuer);
            enqueuer.queue = this.rewriteQueue(enqueuer.queue);
            return enqueuer;
        }

        @Override
        protected AlphaStateConfig rewrite(AlphaStateConfig alphaState) {
            alphaState.testFunc = AlphaStateConfig.TestFunc.ALWAYS;
            if (alphaState.destBlendFactor == AlphaStateConfig.DestBlendFactor.ZERO) {
                alphaState.destBlendFactor = AlphaStateConfig.DestBlendFactor.ONE_MINUS_SRC_ALPHA;
            }
            return alphaState;
        }

        @Override
        protected DepthStateConfig rewrite(DepthStateConfig depthState) {
            depthState.mask = false;
            return depthState;
        }

        protected String rewriteQueue(String queue) {
            return "Opaque".equals(queue) ? "Transparent" : queue;
        }
    }

    public static class DepthOnly
    extends MaterialRewriter {
    }
}

