/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.text;

import com.google.common.collect.Maps;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntTuple;
import com.samskivert.util.Triple;
import com.threerings.opengl.gui.UIConstants;
import com.threerings.opengl.gui.text.Text;
import com.threerings.opengl.gui.text.TextFactory;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.renderer.TextureUnit;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.opengl.GL11;

public class CharacterTextFactory
extends TextFactory
implements UIConstants {
    protected Font _font;
    protected BufferedImage _scratch;
    protected Graphics2D _graphics;
    protected FontMetrics _metrics;
    protected HashIntMap<Glyph> _glyphs = new HashIntMap();
    protected GlyphTexture _texture;
    protected int _descentOffset;
    protected static HashMap<Triple<Font, Boolean, Float>, CharacterTextFactory> _instances = Maps.newHashMap();
    protected static final int TEXTURE_SIZE = 256;

    public static CharacterTextFactory getInstance(Font font, boolean antialias, float descentModifier) {
        Triple key = Triple.newTriple((Object)font, (Object)antialias, (Object)Float.valueOf(descentModifier));
        CharacterTextFactory factory = _instances.get(key);
        if (factory == null) {
            factory = new CharacterTextFactory(font, antialias, descentModifier);
            _instances.put((Triple<Font, Boolean, Float>)key, factory);
        }
        return factory;
    }

    public CharacterTextFactory(Font font, boolean antialias, float descentModifier) {
        this._font = font;
        this._scratch = new BufferedImage(1, 1, 2);
        this._graphics = this._scratch.createGraphics();
        this._metrics = this._graphics.getFontMetrics(font);
        this._descentOffset = Math.round((float)this._metrics.getHeight() * descentModifier);
        FontRenderContext ctx = this._graphics.getFontRenderContext();
        GlyphVector vector = this._font.createGlyphVector(ctx, "J");
        java.awt.Rectangle bounds = vector.getPixelBounds(ctx, 0.0f, 0.0f);
        this._scratch = new BufferedImage(bounds.width * 4, bounds.height * 4, 2);
        this._graphics.dispose();
        this._graphics = this._scratch.createGraphics();
        this._graphics.setFont(font);
        this._graphics.setBackground(new Color(0, true));
        this._graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this._graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
    }

    public void render(Renderer renderer, String text, int x, int y, Color4f color) {
        int nn = text.length();
        for (int ii = 0; ii < nn; ++ii) {
            Glyph glyph = this.getGlyph(text.charAt(ii));
            glyph.render(renderer, x, y);
            x += glyph.width;
        }
    }

    @Override
    public int getHeight() {
        return this._metrics.getHeight();
    }

    @Override
    public Text createText(String text, final Color4f color, final int effect, final int effectSize, final Color4f effectColor, boolean useAdvance) {
        Glyph[] outlines;
        final Glyph[] glyphs = new Glyph[text.length()];
        int width = 0;
        for (int ii = 0; ii < glyphs.length; ++ii) {
            glyphs[ii] = this.getGlyph(text.charAt(ii));
            width += glyphs[ii].width;
        }
        final Dimension size = new Dimension(width, this._metrics.getHeight());
        Glyph[] glyphArray = outlines = effect == 1 ? new Glyph[text.length()] : null;
        if (effect == 1) {
            for (int ii = 0; ii < outlines.length; ++ii) {
                outlines[ii] = this.getGlyph(text.charAt(ii), 1, effectSize);
            }
        }
        return new Text(){

            @Override
            public int getLength() {
                return glyphs.length;
            }

            @Override
            public Dimension getSize() {
                return size;
            }

            @Override
            public int getHitPos(int x, int y) {
                int tx = 0;
                for (int ii = 0; ii < glyphs.length; ++ii) {
                    int hwidth = glyphs[ii].width / 2;
                    if (x < (tx += hwidth)) {
                        return ii;
                    }
                    tx += glyphs[ii].width - hwidth;
                }
                return glyphs.length;
            }

            @Override
            public int getCursorPos(int index) {
                int x = 0;
                int nn = Math.min(index, glyphs.length);
                for (int ii = 0; ii < nn; ++ii) {
                    x += glyphs[ii].width;
                }
                return x;
            }

            @Override
            public void render(Renderer renderer, int x, int y, float alpha) {
                y += CharacterTextFactory.this._metrics.getDescent() + CharacterTextFactory.this._descentOffset;
                if (outlines != null && effectSize > 1) {
                    this.renderGlyphs(renderer, outlines, effectColor, x, y, alpha);
                }
                if (effect == 2) {
                    this.renderGlyphs(renderer, glyphs, effectColor, x + effectSize - 1, y - effectSize, alpha);
                    ++x;
                }
                this.renderGlyphs(renderer, glyphs, color, x, y, alpha);
                if (outlines != null && effectSize == 1) {
                    this.renderGlyphs(renderer, outlines, effectColor, x, y, alpha);
                }
            }

            protected void renderGlyphs(Renderer renderer, Glyph[] glyphs2, Color4f color2, int x, int y, float alpha) {
                float a = color2.a * alpha;
                renderer.setColorState(color2.r * a, color2.g * a, color2.b * a, a);
                for (Glyph glyph : glyphs2) {
                    glyph.render(renderer, x, y);
                    x += glyph.width;
                }
            }
        };
    }

    @Override
    public Text[] wrapText(String text, Color4f color, int effect, int effectSize, Color4f effectColor, int maxWidth) {
        ArrayList<Text> lines = new ArrayList<Text>();
        StringBuilder line = new StringBuilder();
        int width = 0;
        int nn = text.length();
        for (int ii = 0; ii < nn; ++ii) {
            char c = text.charAt(ii);
            Glyph glyph = this.getGlyph(c);
            if (c == '\n' || width + glyph.width > maxWidth) {
                String extra = "";
                if (c != '\n') {
                    line.append(c);
                    IntTuple bspan = this.getBreakSpan(line);
                    if (bspan != null) {
                        extra = line.substring(bspan.right, line.length());
                        line.delete(bspan.left, line.length());
                    } else {
                        extra = String.valueOf(c);
                        line.deleteCharAt(line.length() - 1);
                    }
                }
                lines.add(this.createText(line.toString(), color, effect, effectSize, effectColor, true));
                line.setLength(0);
                line.append(extra);
                width = 0;
                int ll = extra.length();
                for (int jj = 0; jj < ll; ++jj) {
                    width += this.getGlyph((char)extra.charAt((int)jj)).width;
                }
                continue;
            }
            line.append(c);
            width += glyph.width;
        }
        lines.add(this.createText(line.toString(), color, effect, effectSize, effectColor, true));
        return lines.toArray(new Text[lines.size()]);
    }

    protected Glyph getGlyph(char c) {
        return this.getGlyph(c, 0, 0);
    }

    protected Glyph getGlyph(char c, int effect, int size) {
        int key = size << 20 | effect << 16 | c;
        Glyph glyph = (Glyph)this._glyphs.get(key);
        if (glyph == null) {
            glyph = new Glyph(c, effect, size);
            this._glyphs.put(key, (Object)glyph);
        }
        return glyph;
    }

    protected IntTuple getBreakSpan(StringBuilder buf) {
        for (int ii = buf.length() - 2; ii > 0; --ii) {
            char c = buf.charAt(ii);
            if (Character.isWhitespace(c)) {
                for (int jj = ii - 1; jj >= 0; --jj) {
                    if (Character.isWhitespace(buf.charAt(jj))) continue;
                    return new IntTuple(jj + 1, ii + 1);
                }
                return null;
            }
            if (!this.isBreakChar(c) || Character.isWhitespace(buf.charAt(ii - 1))) continue;
            return new IntTuple(ii + 1, ii + 1);
        }
        return null;
    }

    protected boolean isBreakChar(char c) {
        return '-' == c || c >= '\u4e00' && c <= '\u9fff';
    }

    protected TextureUnit[] addGlyphToTexture(Renderer renderer, int width, int height, float[] tcoords) {
        TextureUnit[] units;
        width = Math.min(Math.max(width, 0), this._scratch.getWidth());
        height = Math.min(Math.max(height, 0), this._scratch.getHeight());
        TextureUnit[] textureUnitArray = units = this._texture == null ? null : this._texture.add(width, height, tcoords);
        if (units == null) {
            this._texture = new GlyphTexture(renderer);
            units = this._texture.add(width, height, tcoords);
        }
        return units;
    }

    protected class GlyphTexture {
        protected TextureUnit[] _units;
        protected Texture2D _texture;
        protected int _x;
        protected int _y;
        protected int _height;

        public GlyphTexture(Renderer renderer) {
            this._texture = new Texture2D(renderer);
            this._texture.setImage(6408, 256, 256, false, false);
            this._texture.setFilters(9729, 9728);
            this._units = new TextureUnit[]{new TextureUnit(this._texture)};
        }

        public TextureUnit[] add(int width, int height, float[] tcoords) {
            if (this._x + width > 256) {
                this._y += this._height;
                this._x = 0;
                this._height = 0;
            }
            if (this._y + height > 256) {
                return null;
            }
            this._texture.setSubimage(CharacterTextFactory.this._scratch.getSubimage(0, 0, width, height), true, this._x, this._y, width, height);
            tcoords[0] = (float)this._x / 256.0f;
            tcoords[1] = (float)this._y / 256.0f;
            tcoords[2] = (float)(this._x + width) / 256.0f;
            tcoords[3] = (float)(this._y + height) / 256.0f;
            this._x += width;
            this._height = Math.max(this._height, height);
            return this._units;
        }
    }

    protected class Glyph {
        public int width;
        protected char _c;
        protected int _effect;
        protected int _size;
        protected GlyphVector _vector;
        protected Rectangle _bounds;
        protected TextureUnit[] _units;
        protected float _s1;
        protected float _t1;
        protected float _s2;
        protected float _t2;

        public Glyph(char c, int effect, int size) {
            this._c = c;
            this.width = CharacterTextFactory.this._metrics.charWidth(this._c);
            this._effect = effect;
            this._size = size;
            FontRenderContext ctx = CharacterTextFactory.this._graphics.getFontRenderContext();
            this._vector = CharacterTextFactory.this._font.createGlyphVector(ctx, Character.toString(c));
            java.awt.Rectangle bounds = this._vector.getPixelBounds(ctx, 0.0f, 0.0f);
            if (bounds.width > 0 && bounds.height > 0) {
                this._bounds = new Rectangle(bounds.x, -bounds.y - bounds.height, bounds.width, bounds.height);
                int grow = 1 + (this._effect == 1 ? Math.round((float)size / 2.0f) : 0);
                this._bounds.grow(grow, grow);
            }
        }

        public void render(Renderer renderer, int x, int y) {
            if (this._units == null) {
                if (this._bounds == null) {
                    return;
                }
                CharacterTextFactory.this._graphics.clearRect(0, 0, CharacterTextFactory.this._scratch.getWidth(), CharacterTextFactory.this._scratch.getHeight());
                Shape outline = this._vector.getOutline(-this._bounds.x, this._bounds.y + this._bounds.height);
                if (this._effect == 1) {
                    CharacterTextFactory.this._graphics.setStroke(new BasicStroke(this._size, 2, 1));
                    CharacterTextFactory.this._graphics.draw(outline);
                } else {
                    CharacterTextFactory.this._graphics.fill(outline);
                }
                float[] tcoords = new float[4];
                this._units = CharacterTextFactory.this.addGlyphToTexture(renderer, this._bounds.width, this._bounds.height, tcoords);
                this._s1 = tcoords[0];
                this._t1 = tcoords[1];
                this._s2 = tcoords[2];
                this._t2 = tcoords[3];
                this._vector = null;
            }
            int lx = x + this._bounds.x;
            int ly = y + this._bounds.y;
            int ux = lx + this._bounds.width;
            int uy = ly + this._bounds.height;
            renderer.setTextureState(this._units);
            renderer.setMatrixMode(5888);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)this._s1, (float)this._t1);
            GL11.glVertex2f((float)lx, (float)ly);
            GL11.glTexCoord2f((float)this._s2, (float)this._t1);
            GL11.glVertex2f((float)ux, (float)ly);
            GL11.glTexCoord2f((float)this._s2, (float)this._t2);
            GL11.glVertex2f((float)ux, (float)uy);
            GL11.glTexCoord2f((float)this._s1, (float)this._t2);
            GL11.glVertex2f((float)lx, (float)uy);
            GL11.glEnd();
        }
    }
}

