/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.google.common.collect.Lists;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.DynamicScope;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Transform3D;
import com.threerings.opengl.camera.OrbitCameraHandler;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.EditableTextComponent;
import com.threerings.opengl.gui.Label;
import com.threerings.opengl.gui.config.BoundedRangeModelConfig;
import com.threerings.opengl.gui.config.DimensionConfig;
import com.threerings.opengl.gui.config.IconConfig;
import com.threerings.opengl.gui.config.LayoutConfig;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.config.UserInterfaceConfig;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import com.threerings.util.MessageBundle;
import java.util.ArrayList;

@EditorTypes(value={Button.class, ChatOverlay.class, CheckBox.class, ColorPicker.class, ComboBox.class, Container.class, FadeLabel.class, HTMLView.class, Label.class, List.class, PasswordField.class, RenderableView.class, ScrollBar.class, ScrollPane.class, Slider.class, Spacer.class, Spinner.class, StatusLabel.class, TabbedPane.class, TextArea.class, TextEditor.class, TextField.class, ToggleButton.class, UserInterface.class})
public abstract class ComponentConfig
extends DeepObject
implements Exportable {
    @Editable(weight=1.0, hgroup="f")
    public boolean enabled = true;
    @Editable(weight=1.0, hgroup="f")
    public boolean visible = true;
    @Editable(weight=1.0, hgroup="f")
    public boolean hoverable = true;
    @Editable(weight=1.0, hgroup="t")
    public String tooltipText = "";
    @Editable(weight=1.0, hgroup="t")
    public boolean tooltipRelativeToMouse;
    @Editable(min=0.0, max=1.0, step=0.01, weight=1.0, hgroup="a")
    public float alpha = 1.0f;
    @Editable(weight=1.0, hgroup="a")
    public String tag = "";
    @Editable(weight=1.0, nullable=true)
    public ConfigReference<StyleConfig> style;
    @Editable(weight=1.0, nullable=true)
    public DimensionConfig preferredSize;

    public Component getComponent(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
        comp = this.maybeRecreate(ctx, scope, msgs, comp);
        this.configure(ctx, scope, msgs, comp);
        if (!StringUtil.isBlank((String)this.tag)) {
            comp.setTag(this.tag);
            ScopeUtil.call(scope, "registerComponent", this.tag, comp);
        }
        return comp;
    }

    public void invalidate() {
    }

    protected abstract Component maybeRecreate(GlContext var1, Scope var2, MessageBundle var3, Component var4);

    protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
        comp.setAlpha(this.alpha);
        comp.setEnabled(this.enabled);
        comp.setVisible(this.visible);
        comp.setHoverable(this.hoverable);
        comp.setTooltipText(StringUtil.isBlank((String)this.tooltipText) ? null : ComponentConfig.getMessage(msgs, this.tooltipText));
        comp.setTooltipRelativeToMouse(this.tooltipRelativeToMouse);
        comp.setStyleConfig(this.style);
        if (this.preferredSize != null) {
            comp.setPreferredSize(this.preferredSize.createDimension());
        }
    }

    protected static Class<?> getClass(Object object) {
        return object == null ? null : object.getClass();
    }

    protected static String getMessage(MessageBundle msgs, String text) {
        return msgs.exists(text) ? msgs.get(text) : text;
    }

    public static class ViewModel
    extends DeepObject
    implements Exportable {
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
        @Editable(step=0.01)
        public Transform3D transform = new Transform3D();
    }

    public static class ChatOverlay
    extends ComponentConfig {
        @Editable
        public String bundle = "chat";
        @Editable(min=0.0, hgroup="p")
        public int preferredWidth;
        @Editable(hgroup="p")
        public Color4f infoColor = new Color4f(Color4f.YELLOW);
        @Editable(hgroup="i")
        public Color4f feedbackColor = new Color4f(Color4f.GREEN);
        @Editable(hgroup="i")
        public Color4f attentionColor = new Color4f(Color4f.RED);

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return ChatOverlay.getClass(comp) == com.threerings.opengl.gui.ChatOverlay.class ? comp : new com.threerings.opengl.gui.ChatOverlay(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.ChatOverlay overlay = (com.threerings.opengl.gui.ChatOverlay)comp;
            overlay.setBundle(StringUtil.isBlank((String)this.bundle) ? "global" : this.bundle);
            overlay.setPreferredWidth(this.preferredWidth);
            overlay.setSystemColors(this.infoColor, this.feedbackColor, this.attentionColor);
        }
    }

    public static class ColorPicker
    extends ComponentConfig {
        @Editable(hgroup="c")
        public String colorClass = "player";
        @Editable(hgroup="c")
        public boolean starters;
        @Editable(min=1.0, hgroup="s")
        public int swatchWidth = 9;
        @Editable(min=1.0, hgroup="s")
        public int swatchHeight = 9;
        @Editable(min=0.0)
        public int selected;

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return ColorPicker.getClass(comp) == com.threerings.opengl.gui.ColorPicker.class ? comp : new com.threerings.opengl.gui.ColorPicker(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.ColorPicker picker = (com.threerings.opengl.gui.ColorPicker)comp;
            picker.setColorClass(this.colorClass, this.starters);
            picker.setSwatchSize(this.swatchWidth, this.swatchHeight);
            picker.setSelectedIndex(this.selected);
        }
    }

    public static class RenderableView
    extends ComponentConfig {
        @Editable(hgroup="v")
        public boolean staticView;
        @Editable(hgroup="v")
        public String viewNode = "";
        @Editable(min=0.0, max=180.0, scale=0.017453292519943295, hgroup="f")
        public float fov = 1.0471976f;
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float near = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float far = 100.0f;
        @Editable(min=-180.0, max=180.0, scale=0.017453292519943295, hgroup="c")
        public float azimuth;
        @Editable(min=-90.0, max=90.0, scale=0.017453292519943295, hgroup="c")
        public float elevation = 0.7853982f;
        @Editable(min=0.0, step=0.01, hgroup="c")
        public float distance = 10.0f;
        @Editable
        public ViewModel[] models = new ViewModel[0];

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return RenderableView.getClass(comp) == com.threerings.opengl.gui.RenderableView.class ? comp : new com.threerings.opengl.gui.RenderableView(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            int ii;
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.RenderableView view = (com.threerings.opengl.gui.RenderableView)comp;
            DynamicScope vscope = view.getScope();
            vscope.setParentScope(scope);
            OrbitCameraHandler camhand = (OrbitCameraHandler)view.getCameraHandler();
            camhand.setPerspective(this.fov, this.near, this.far);
            camhand.getCoords().set(this.azimuth, this.elevation, this.distance);
            view.setViewNode(this.viewNode);
            view.setStatic(this.staticView);
            view.invalidate();
            Model[] omodels = view.getConfigModels();
            Model[] nmodels = new Model[this.models.length];
            view.setConfigModels(nmodels);
            for (ii = 0; ii < nmodels.length; ++ii) {
                Model model;
                nmodels[ii] = model = ii < omodels.length ? omodels[ii] : new Model(ctx);
                ViewModel vmodel = this.models[ii];
                model.setParentScope(vscope);
                model.setConfig(vmodel.model);
                model.getLocalTransform().set(vmodel.transform);
            }
            for (ii = nmodels.length; ii < omodels.length; ++ii) {
                omodels[ii].dispose();
            }
        }
    }

    public static class HTMLView
    extends ComponentConfig {
        @Editable
        public String stylesheet = "";
        @Editable
        public String contents = "";
        @Editable
        public boolean antialias = true;

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return HTMLView.getClass(comp) == com.threerings.opengl.gui.text.HTMLView.class ? comp : new com.threerings.opengl.gui.text.HTMLView(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.text.HTMLView view = (com.threerings.opengl.gui.text.HTMLView)comp;
            view.setAntialiased(this.antialias);
            view.setStyleSheet(this.stylesheet);
            view.setContents(this.contents);
        }
    }

    public static class UserInterface
    extends ComponentConfig {
        @Editable(nullable=true)
        public ConfigReference<UserInterfaceConfig> userInterface;

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return UserInterface.getClass(comp) == com.threerings.opengl.gui.UserInterface.class ? comp : new com.threerings.opengl.gui.UserInterface(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.UserInterface ui = (com.threerings.opengl.gui.UserInterface)comp;
            ui.getScope().setParentScope(scope);
            ui.setConfig(this.userInterface);
            ScopeUtil.call(scope, "registerComponents", ui.getTagged());
        }
    }

    public static class Container
    extends ComponentConfig {
        @Editable
        public LayoutConfig layout = new LayoutConfig.Absolute();

        @Override
        public void invalidate() {
            this.layout.invalidate();
        }

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return Container.getClass(comp) == com.threerings.opengl.gui.Container.class ? comp : new com.threerings.opengl.gui.Container(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            this.layout.configure(ctx, scope, msgs, (com.threerings.opengl.gui.Container)comp);
        }
    }

    public static class ScrollBar
    extends ComponentConfig {
        @Editable
        public Orientation orientation = Orientation.HORIZONTAL;
        @Editable
        public BoundedRangeModelConfig model = new BoundedRangeModelConfig();

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return new com.threerings.opengl.gui.ScrollBar(ctx, this.orientation.getConstant(), this.model.createBoundedRangeModel());
        }
    }

    public static class ScrollPane
    extends ComponentConfig {
        @Editable(hgroup="v")
        public boolean vertical = true;
        @Editable(hgroup="v")
        public boolean horizontal;
        @Editable(hgroup="v")
        public boolean buttons;
        @Editable(hgroup="s")
        public int snap;
        @Editable(hgroup="s")
        public boolean showScrollbarAlways = true;
        @Editable(nullable=true)
        public ConfigReference<StyleConfig> viewportStyle;
        @Editable
        public ComponentConfig child = new Spacer();
        @DeepOmit
        protected transient Component _ochild;

        @Override
        public void invalidate() {
            this.child.invalidate();
        }

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            Component component = this._ochild = comp instanceof com.threerings.opengl.gui.ScrollPane ? ((com.threerings.opengl.gui.ScrollPane)comp).getChild() : null;
            if (this._ochild != null) {
                this._ochild.getParent().remove(this._ochild);
            }
            return new com.threerings.opengl.gui.ScrollPane(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.ScrollPane pane = (com.threerings.opengl.gui.ScrollPane)comp;
            pane.init(this.child.getComponent(ctx, scope, msgs, this._ochild), this.vertical, this.horizontal, this.snap, this.buttons);
            pane.setShowScrollbarAlways(this.showScrollbarAlways);
            pane.setViewportStyleConfig(this.viewportStyle);
        }
    }

    public static class Slider
    extends ComponentConfig {
        @Editable
        public Orientation orientation = Orientation.HORIZONTAL;
        @Editable
        public BoundedRangeModelConfig model = new BoundedRangeModelConfig();

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return new com.threerings.opengl.gui.Slider(ctx, this.orientation.getConstant(), this.model.createBoundedRangeModel());
        }
    }

    public static class Spinner
    extends ComponentConfig {
        @Editable(nullable=true)
        public ConfigReference<StyleConfig> editorStyle;
        @Editable(nullable=true)
        public ConfigReference<StyleConfig> nextStyle;
        @Editable(nullable=true)
        public ConfigReference<StyleConfig> previousStyle;

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return Spinner.getClass(comp) == com.threerings.opengl.gui.Spinner.class ? comp : new com.threerings.opengl.gui.Spinner(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.Spinner spinner = (com.threerings.opengl.gui.Spinner)comp;
            spinner.setEditorStyleConfig(this.editorStyle);
            spinner.setNextStyleConfig(this.nextStyle);
            spinner.setPreviousStyleConfig(this.previousStyle);
        }
    }

    public static class Spacer
    extends ComponentConfig {
        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return Spacer.getClass(comp) == com.threerings.opengl.gui.Spacer.class ? comp : new com.threerings.opengl.gui.Spacer(ctx);
        }
    }

    public static class TabbedPane
    extends ComponentConfig {
        @Editable(hgroup="t")
        public LayoutConfig.Justification tabAlignment = LayoutConfig.Justification.LEFT;
        @Editable(hgroup="t")
        public int gap = 5;
        @Editable(min=0.0, hgroup="t")
        public int selected;
        @Editable(hgroup="t")
        public boolean resizeable;
        @Editable(nullable=true)
        public ConfigReference<StyleConfig> tabStyle;
        @Editable
        public Tab[] tabs = new Tab[0];

        @Override
        public void invalidate() {
            for (Tab tab : this.tabs) {
                tab.component.invalidate();
            }
        }

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return TabbedPane.getClass(comp) == com.threerings.opengl.gui.TabbedPane.class ? comp : new com.threerings.opengl.gui.TabbedPane(ctx, this.resizeable);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            int ii;
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.TabbedPane pane = (com.threerings.opengl.gui.TabbedPane)comp;
            Component[] otabs = new Component[pane.getTabCount()];
            for (ii = 0; ii < otabs.length; ++ii) {
                otabs[ii] = pane.getTab(ii);
            }
            pane.removeAllTabs();
            pane.setTabAlignment(this.tabAlignment.getJustification());
            pane.setGap(this.gap);
            for (ii = 0; ii < this.tabs.length; ++ii) {
                Tab tab = this.tabs[ii];
                Component tcomp = ii < otabs.length ? otabs[ii] : null;
                pane.addTab(TabbedPane.getMessage(msgs, tab.title), tab.component.getComponent(ctx, scope, msgs, tcomp), tab.hasClose, tab.styleOverride == null ? this.tabStyle : tab.styleOverride);
            }
            if (this.selected < this.tabs.length) {
                pane.setSelectedIndex(this.selected);
            }
        }

        public static class Tab
        extends DeepObject
        implements Exportable {
            @Editable(hgroup="t")
            public String title = "";
            @Editable(hgroup="t")
            public boolean hasClose;
            @Editable(nullable=true)
            public ConfigReference<StyleConfig> styleOverride;
            @Editable
            public ComponentConfig component = new Spacer();
        }
    }

    public static class TextArea
    extends ComponentConfig {
        @Editable(hgroup="t")
        public String text = "";
        @Editable(min=0.0, hgroup="t")
        public int preferredWidth;

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return TextArea.getClass(comp) == com.threerings.opengl.gui.TextArea.class ? comp : new com.threerings.opengl.gui.TextArea(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.TextArea area = (com.threerings.opengl.gui.TextArea)comp;
            area.setPreferredWidth(this.preferredWidth);
            area.setText(TextArea.getMessage(msgs, this.text));
        }
    }

    public static class PasswordField
    extends TextField {
        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return PasswordField.getClass(comp) == com.threerings.opengl.gui.PasswordField.class ? comp : new com.threerings.opengl.gui.PasswordField(ctx);
        }
    }

    public static class TextEditor
    extends TextField {
        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return TextEditor.getClass(comp) == com.threerings.opengl.gui.TextEditor.class ? comp : new com.threerings.opengl.gui.TextEditor(ctx);
        }
    }

    public static class TextField
    extends TextComponent {
        @Editable(min=0.0, hgroup="t")
        public int maxLength;
        @Editable(hgroup="t")
        public String placeholder = "";

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return TextField.getClass(comp) == com.threerings.opengl.gui.TextField.class ? comp : new com.threerings.opengl.gui.TextField(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            EditableTextComponent ecomp = (EditableTextComponent)comp;
            ecomp.setMaxLength(this.maxLength);
            ecomp.setPlaceholder(TextField.getMessage(msgs, this.placeholder));
            super.configure(ctx, scope, msgs, comp);
        }
    }

    public static abstract class TextComponent
    extends ComponentConfig {
        @Editable(hgroup="t")
        public String text = "";

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            ((com.threerings.opengl.gui.TextComponent)comp).setText(TextComponent.getMessage(msgs, this.text));
        }
    }

    public static class List
    extends ComponentConfig {
        @Editable
        public String[] items = ArrayUtil.EMPTY_STRING;
        @Editable(min=0.0)
        public int selected;

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return List.getClass(comp) == com.threerings.opengl.gui.List.class ? comp : new com.threerings.opengl.gui.List(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.List list = (com.threerings.opengl.gui.List)comp;
            Object[] values = new Object[this.items.length];
            for (int ii = 0; ii < this.items.length; ++ii) {
                values[ii] = List.getMessage(msgs, this.items[ii]);
            }
            list.setValues(values);
            list.setSelected(this.selected < values.length ? values[this.selected] : null);
        }
    }

    public static class ComboBox
    extends ComponentConfig {
        @Editable
        public Item[] items = new Item[0];
        @Editable(min=0.0, hgroup="s")
        public int rows = 8;
        @Editable(min=0.0, hgroup="s")
        public int columns = 1;
        @Editable(min=0.0, hgroup="s")
        public int selected;

        @Override
        public void invalidate() {
            for (Item item : this.items) {
                item.invalidate();
            }
        }

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return ComboBox.getClass(comp) == com.threerings.opengl.gui.ComboBox.class ? comp : new com.threerings.opengl.gui.ComboBox(ctx);
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.ComboBox box = (com.threerings.opengl.gui.ComboBox)comp;
            int nn = this.items.length;
            ArrayList objects = Lists.newArrayListWithCapacity((int)nn);
            for (int ii = 0; ii < nn; ++ii) {
                objects.add(this.items[ii].getObject(ctx, msgs));
            }
            box.setItems(objects);
            box.setPreferredDimensions(this.rows, this.columns);
            box.setSelectedIndex(this.selected);
        }

        public static class IconItem
        extends Item {
            @Editable(nullable=true)
            public IconConfig icon;

            @Override
            public Object getObject(GlContext ctx, MessageBundle msgs) {
                return this.icon == null ? null : this.icon.getIcon(ctx);
            }

            @Override
            public void invalidate() {
                if (this.icon != null) {
                    this.icon.invalidate();
                }
            }
        }

        public static class StringItem
        extends Item {
            @Editable
            public String text = "";

            @Override
            public Object getObject(GlContext ctx, MessageBundle msgs) {
                return ComponentConfig.getMessage(msgs, this.text);
            }
        }

        @EditorTypes(value={StringItem.class, IconItem.class})
        public static abstract class Item
        extends DeepObject
        implements Exportable {
            public abstract Object getObject(GlContext var1, MessageBundle var2);

            public void invalidate() {
            }
        }
    }

    public static class CheckBox
    extends ToggleButton {
        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return CheckBox.getClass(comp) == com.threerings.opengl.gui.CheckBox.class ? comp : new com.threerings.opengl.gui.CheckBox(ctx, "");
        }

        @Override
        protected boolean shouldSetIcon(GlContext ctx, Component comp) {
            return false;
        }
    }

    public static class ToggleButton
    extends Button {
        @Editable(hgroup="a")
        public boolean selected;

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return ToggleButton.getClass(comp) == com.threerings.opengl.gui.ToggleButton.class ? comp : new com.threerings.opengl.gui.ToggleButton(ctx, "");
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            ((com.threerings.opengl.gui.ToggleButton)comp).setSelected(this.selected);
        }
    }

    public static class Button
    extends Label {
        @Editable(hgroup="a")
        public String action = "";
        @Editable(hgroup="a", nullable=true)
        public Object argument;

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return Button.getClass(comp) == com.threerings.opengl.gui.Button.class ? comp : new com.threerings.opengl.gui.Button(ctx, "");
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            ((com.threerings.opengl.gui.Button)comp).setAction(this.action);
            ((com.threerings.opengl.gui.Button)comp).setArgument(this.argument);
        }

        @Override
        protected boolean shouldSetIcon(GlContext ctx, Component comp) {
            StyleConfig config = comp.getStyleConfigs()[0];
            StyleConfig.Original original = config == null ? null : config.getOriginal(ctx);
            return original == null || original.icon == null;
        }
    }

    public static class FadeLabel
    extends Label {
        @Editable(min=0.0)
        public int lineFadeTime;

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            ((com.threerings.opengl.gui.FadeLabel)comp).setLineFadeTime(this.lineFadeTime);
        }

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return FadeLabel.getClass(comp) == com.threerings.opengl.gui.FadeLabel.class ? comp : new com.threerings.opengl.gui.FadeLabel(ctx, 0);
        }
    }

    public static class StatusLabel
    extends Label {
        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return StatusLabel.getClass(comp) == com.threerings.opengl.gui.StatusLabel.class ? comp : new com.threerings.opengl.gui.StatusLabel(ctx);
        }
    }

    public static class Label
    extends ComponentConfig {
        @Editable(nullable=true)
        public IconConfig icon;
        @Editable(hgroup="t")
        public String text = "";
        @Editable(hgroup="t")
        public int iconTextGap = 3;
        @Editable(hgroup="t")
        public int textRotation;
        @Editable(hgroup="o")
        public Orientation orientation = Orientation.HORIZONTAL;
        @Editable(hgroup="o")
        public Label.Fit fit = Label.Fit.WRAP;
        @Editable(min=0.0, hgroup="o")
        public int preferredWidth;

        @Override
        public void invalidate() {
            if (this.icon != null) {
                this.icon.invalidate();
            }
        }

        @Override
        protected Component maybeRecreate(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            return Label.getClass(comp) == com.threerings.opengl.gui.Label.class ? comp : new com.threerings.opengl.gui.Label(ctx, "");
        }

        @Override
        protected void configure(GlContext ctx, Scope scope, MessageBundle msgs, Component comp) {
            super.configure(ctx, scope, msgs, comp);
            com.threerings.opengl.gui.Label label = (com.threerings.opengl.gui.Label)comp;
            if (this.shouldSetIcon(ctx, comp)) {
                label.setIcon(this.icon == null ? null : this.icon.getIcon(ctx));
            }
            label.setText(Label.getMessage(msgs, this.text));
            label.setIconTextGap(this.iconTextGap);
            label.setTextRotation(this.textRotation);
            label.setOrientation(this.orientation.getConstant());
            label.setFit(this.fit);
            label.setPreferredWidth(this.preferredWidth);
        }

        protected boolean shouldSetIcon(GlContext ctx, Component comp) {
            return true;
        }
    }

    public static enum Orientation {
        HORIZONTAL(0),
        VERTICAL(1);

        protected int _constant;

        public int getConstant() {
            return this._constant;
        }

        private Orientation(int constant) {
            this._constant = constant;
        }
    }
}

