/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.export.Exportable;
import com.threerings.expr.BooleanExpression;
import com.threerings.expr.DynamicScope;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.Function;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.Transform2DExpression;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.FloatMath;
import com.threerings.math.Transform2D;
import com.threerings.opengl.effect.Easing;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.RenderableView;
import com.threerings.opengl.gui.TextComponent;
import com.threerings.opengl.gui.ToggleButton;
import com.threerings.opengl.gui.UserInterface;
import com.threerings.opengl.gui.config.EventConfig;
import com.threerings.opengl.gui.config.InterfaceScriptConfig;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.config.UserInterfaceConfig;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.AnimationConfig;
import com.threerings.util.DeepObject;

@EditorTypes(value={CallFunction.class, PlaySound.class, SetEnabled.class, SetVisible.class, SetHoverable.class, SetAlpha.class, FadeAlpha.class, AnimateAlpha.class, SetOffset.class, MoveOffset.class, AnimateOffset.class, SetSelected.class, SetText.class, SetStyle.class, SetConfig.class, RunScript.class, RunInitScript.class, PlayAnimation.class, RequestFocus.class, Wait.class, AddHandler.class, Conditional.class, Compound.class})
public abstract class ActionConfig
extends DeepObject
implements Exportable {
    public abstract void execute(UserInterface var1, UserInterface.ConfigScript var2);

    public void invalidate() {
    }

    public static class Compound
    extends ActionConfig {
        @Editable
        public ActionConfig[] actions = new ActionConfig[0];

        @Override
        public void execute(UserInterface iface, UserInterface.ConfigScript script) {
            for (ActionConfig action : this.actions) {
                action.execute(iface, script);
            }
        }

        @Override
        public void invalidate() {
            for (ActionConfig action : this.actions) {
                action.invalidate();
            }
        }
    }

    public static class Case
    extends DeepObject
    implements Exportable {
        @Editable
        public BooleanExpression condition = new BooleanExpression.Constant(true);
        @Editable
        public ActionConfig action = new CallFunction();
    }

    public static class Conditional
    extends ActionConfig {
        @Editable
        public Case[] cases = new Case[0];
        @Editable
        public ActionConfig defaultAction = new CallFunction();

        @Override
        public void execute(UserInterface iface, UserInterface.ConfigScript script) {
            DynamicScope scope = iface.getScope();
            for (Case caze : this.cases) {
                if (!caze.condition.createEvaluator(scope).evaluate()) continue;
                caze.action.execute(iface, script);
                return;
            }
            this.defaultAction.execute(iface, script);
        }

        @Override
        public void invalidate() {
            for (Case caze : this.cases) {
                caze.condition.invalidate();
                caze.action.invalidate();
            }
        }
    }

    public static class AddHandler
    extends ActionConfig {
        @Editable
        public EventConfig event = new EventConfig.Action();
        @Editable
        public ActionConfig[] actions = new ActionConfig[0];

        @Override
        public void execute(final UserInterface iface, final UserInterface.ConfigScript script) {
            iface.addScript(this.event.addHandler(iface, new Runnable(){

                @Override
                public void run() {
                    for (ActionConfig action : AddHandler.this.actions) {
                        action.execute(iface, script);
                    }
                }
            }));
        }

        @Override
        public void invalidate() {
            for (ActionConfig action : this.actions) {
                action.invalidate();
            }
        }
    }

    public static class Wait
    extends ActionConfig {
        @Editable
        public EventConfig event = new EventConfig.Action();

        @Override
        public void execute(UserInterface iface, final UserInterface.ConfigScript script) {
            UserInterface.Script[] wscript;
            if (script == null) {
                Log.log.warning((Object)"Tried to perform wait action outside of script.", new Object[0]);
                return;
            }
            script.setPaused(true);
            wscript = new UserInterface.Script[]{this.event.addHandler(iface, new Runnable(){

                @Override
                public void run() {
                    wscript[0].remove();
                    script.setPaused(false);
                }
            })};
            iface.addScript(wscript[0]);
        }
    }

    public static class RequestFocus
    extends Targeted {
        @Override
        public void apply(UserInterface iface, Component comp) {
            comp.requestFocus();
        }
    }

    public static class PlayAnimation
    extends Targeted {
        @Editable(min=0.0, hgroup="t")
        public int index;
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> animation;

        @Override
        public void apply(UserInterface iface, Component comp) {
            Model[] models;
            if (comp instanceof RenderableView && this.index < (models = ((RenderableView)comp).getConfigModels()).length) {
                models[this.index].createAnimation(this.animation).start();
            }
        }
    }

    public static class RunInitScript
    extends Targeted {
        @Editable(nullable=true)
        public ConfigReference<InterfaceScriptConfig> interfaceScript;

        @Override
        public void apply(UserInterface iface, Component comp) {
            if (comp instanceof UserInterface) {
                ((UserInterface)comp).runInitScript(this.interfaceScript);
            }
        }
    }

    public static class RunScript
    extends Targeted {
        @Editable(nullable=true)
        public ConfigReference<InterfaceScriptConfig> interfaceScript;

        @Override
        public void apply(UserInterface iface, Component comp) {
            if (comp instanceof UserInterface && this.interfaceScript != null) {
                ((UserInterface)comp).runScript(this.interfaceScript);
            }
        }
    }

    public static class SetConfig
    extends Targeted {
        @Editable(nullable=true)
        public ConfigReference<UserInterfaceConfig> userInterface;

        @Override
        public void apply(UserInterface iface, Component comp) {
            if (comp instanceof UserInterface) {
                ((UserInterface)comp).setConfig(this.userInterface);
            }
        }
    }

    public static class SetStyle
    extends Targeted {
        @Editable(nullable=true)
        public ConfigReference<StyleConfig> style;

        @Override
        public void apply(UserInterface iface, Component comp) {
            comp.setStyleConfig(this.style);
        }
    }

    public static class SetText
    extends Targeted {
        @Editable(hgroup="t")
        public String text = "";

        @Override
        public void apply(UserInterface iface, Component comp) {
            if (comp instanceof TextComponent) {
                ((TextComponent)comp).setText(this.text);
            }
        }
    }

    public static class SetSelected
    extends Targeted {
        @Editable(hgroup="t")
        public boolean selected = true;

        @Override
        public void apply(UserInterface iface, Component comp) {
            if (comp instanceof ToggleButton) {
                ((ToggleButton)comp).setSelected(this.selected);
            }
        }
    }

    public static class AnimateOffset
    extends Targeted {
        @Editable(min=0.0, step=0.01, hgroup="t")
        public float duration;
        @Editable
        public Transform2DExpression value = new Transform2DExpression.Constant();

        @Override
        public void apply(UserInterface iface, final Component comp) {
            final ObjectExpression.Evaluator eval = this.value.createEvaluator(iface.getScope());
            UserInterface userInterface = iface;
            userInterface.getClass();
            iface.addScript(new UserInterface.TickableScript(userInterface){
                protected float _time;

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void tick(float elapsed) {
                    if (AnimateOffset.this.duration != 0.0f) {
                        float f;
                        this._time += elapsed;
                        if (!(f < AnimateOffset.this.duration)) {
                            this.remove();
                            return;
                        }
                    }
                    comp.setOffset((Transform2D)eval.evaluate());
                }
            });
        }

        @Override
        public void invalidate() {
            this.value.invalidate();
        }
    }

    public static class MoveOffset
    extends Targeted {
        @Editable(min=0.0, step=0.01, hgroup="t")
        public float interval = 1.0f;
        @Editable(step=0.01)
        public Transform2D start = new Transform2D();
        @Editable(step=0.01)
        public Transform2D end = new Transform2D();
        @Editable
        public Easing easing = new Easing.None();

        @Override
        public void apply(UserInterface iface, final Component comp) {
            UserInterface userInterface = iface;
            userInterface.getClass();
            iface.addScript(new UserInterface.TickableScript(userInterface){
                protected float _time;
                protected Transform2D _offset;
                {
                    super(x0);
                    this._offset = new Transform2D();
                }

                @Override
                public void tick(float elapsed) {
                    float f;
                    this._time += elapsed;
                    if (f < MoveOffset.this.interval) {
                        comp.setOffset(MoveOffset.this.start.lerp(MoveOffset.this.end, MoveOffset.this.easing.getTime(this._time / MoveOffset.this.interval), this._offset));
                    } else {
                        this.remove();
                    }
                }

                @Override
                public void cleanup() {
                    super.cleanup();
                    comp.setOffset(this._offset.set(MoveOffset.this.end));
                }
            });
        }
    }

    public static class SetOffset
    extends Targeted {
        @Editable(step=0.01)
        public Transform2D offset = new Transform2D();

        @Override
        public void apply(UserInterface iface, Component comp) {
            comp.setOffset(new Transform2D(this.offset));
        }
    }

    public static class AnimateAlpha
    extends Targeted {
        @Editable(min=0.0, step=0.01, hgroup="t")
        public float duration;
        @Editable
        public FloatExpression value = new FloatExpression.Constant();

        @Override
        public void apply(UserInterface iface, final Component comp) {
            final FloatExpression.Evaluator eval = this.value.createEvaluator(iface.getScope());
            UserInterface userInterface = iface;
            userInterface.getClass();
            iface.addScript(new UserInterface.TickableScript(userInterface){
                protected float _time;

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void tick(float elapsed) {
                    if (AnimateAlpha.this.duration != 0.0f) {
                        float f;
                        this._time += elapsed;
                        if (!(f < AnimateAlpha.this.duration)) {
                            this.remove();
                            return;
                        }
                    }
                    comp.setAlpha(eval.evaluate());
                }
            });
        }

        @Override
        public void invalidate() {
            this.value.invalidate();
        }
    }

    public static class FadeAlpha
    extends Targeted {
        @Editable(min=0.0, step=0.01, hgroup="t")
        public float interval = 1.0f;
        @Editable(min=0.0, max=1.0, step=0.01, hgroup="s")
        public float start;
        @Editable(min=0.0, max=1.0, step=0.01, hgroup="s")
        public float end = 1.0f;
        @Editable
        public Easing easing = new Easing.None();

        @Override
        public void apply(UserInterface iface, final Component comp) {
            UserInterface userInterface = iface;
            userInterface.getClass();
            iface.addScript(new UserInterface.TickableScript(userInterface){
                protected float _time;

                @Override
                public void tick(float elapsed) {
                    float f;
                    this._time += elapsed;
                    if (f < FadeAlpha.this.interval) {
                        comp.setAlpha(FloatMath.lerp(FadeAlpha.this.start, FadeAlpha.this.end, FadeAlpha.this.easing.getTime(this._time / FadeAlpha.this.interval)));
                    } else {
                        this.remove();
                    }
                }

                @Override
                public void cleanup() {
                    super.cleanup();
                    comp.setAlpha(FadeAlpha.this.end);
                }
            });
        }
    }

    public static class SetAlpha
    extends Targeted {
        @Editable(min=0.0, max=1.0, step=0.01, hgroup="t")
        public float alpha = 1.0f;

        @Override
        public void apply(UserInterface iface, Component comp) {
            comp.setAlpha(this.alpha);
        }
    }

    public static class SetHoverable
    extends Targeted {
        @Editable(hgroup="t")
        public boolean hoverable = true;

        @Override
        public void apply(UserInterface iface, Component comp) {
            comp.setHoverable(this.hoverable);
        }
    }

    public static class SetVisible
    extends Targeted {
        @Editable(hgroup="t")
        public boolean visible = true;

        @Override
        public void apply(UserInterface iface, Component comp) {
            comp.setVisible(this.visible);
        }
    }

    public static class SetEnabled
    extends Targeted {
        @Editable(hgroup="t")
        public boolean enabled = true;

        @Override
        public void apply(UserInterface iface, Component comp) {
            comp.setEnabled(this.enabled);
        }
    }

    public static abstract class Targeted
    extends ActionConfig {
        @Editable(hgroup="t")
        public String target = "";

        @Override
        public void execute(UserInterface iface, UserInterface.ConfigScript script) {
            for (Component comp : iface.getComponents(this.target)) {
                this.apply(iface, comp);
            }
        }

        public abstract void apply(UserInterface var1, Component var2);
    }

    public static class PlaySound
    extends ActionConfig {
        @Editable(editor="resource", nullable=true)
        @FileConstraints(description="m.sound_files_desc", extensions={".ogg"}, directory="sound_dir")
        public String sound;

        @Override
        public void execute(UserInterface iface, UserInterface.ConfigScript script) {
            if (this.sound != null) {
                iface.getRoot().playSound(this.sound);
            }
        }
    }

    public static class CallFunction
    extends ActionConfig {
        @Editable
        public String name = "";

        @Override
        public void execute(UserInterface iface, UserInterface.ConfigScript script) {
            ScopeUtil.resolve((Scope)iface.getScope(), this.name, Function.NULL).call(new Object[0]);
        }
    }
}

