/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.threerings.editor.Log;
import com.threerings.editor.swing.PropertyEditor;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DateTimeEditor
extends PropertyEditor
implements DocumentListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    protected JTextField _field;
    protected DateFormat _format;
    protected boolean _invalid;

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(null);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(null);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        String text = this._field.getText().trim();
        try {
            Date newVal;
            Object oldVal = this._property.get(this._object);
            if ("".equals(text) && this._property.getAnnotation().nullable()) {
                newVal = null;
            } else {
                Date d = this._format.parse(text);
                Comparable<Date> comparable = newVal = oldVal instanceof Date ? d : Long.valueOf(d.getTime());
            }
            if (!Objects.equal(newVal, (Object)oldVal)) {
                this._property.set(this._object, newVal);
                this.fireStateChanged();
            }
            this._invalid = false;
        }
        catch (Exception e) {
            this._invalid = true;
        }
        this.updateBorder();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!this._invalid) {
            this.update();
        }
    }

    @Override
    public void update() {
        this._field.getDocument().removeDocumentListener(this);
        Object prop = this._property.get(this._object);
        try {
            this._field.setText(prop == null ? "" : this._format.format(prop));
        }
        catch (IllegalArgumentException e) {
            this._field.setText("");
        }
        this._field.getDocument().addDocumentListener(this);
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(this.getPropertyLabel() + ":"));
        this._field = new JTextField(this._property.getAnnotation().width());
        this.add(this._field);
        this._field.getDocument().addDocumentListener(this);
        this._field.addFocusListener(this);
        this.addUnits((JPanel)((Object)this));
        this.configureFormat();
    }

    protected void configureFormat() {
        String mode = this._property.getAnnotation().mode();
        int style = 3;
        TimeZone timezone = TimeZone.getDefault();
        Locale locale = Locale.getDefault();
        String format = null;
        for (String attr : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)mode)) {
            int eq = attr.indexOf(61);
            if (eq == -1) {
                Log.log.warning((Object)("No '=' found in mode attribute: " + attr), new Object[0]);
                continue;
            }
            String kind = attr.substring(0, eq);
            String spec = attr.substring(eq + 1);
            if ("".equals(spec)) {
                Log.log.warning((Object)("Unspecified mode attribute: " + attr), new Object[0]);
                continue;
            }
            if ("style".equalsIgnoreCase(kind)) {
                if ("short".equalsIgnoreCase(spec)) {
                    style = 3;
                    continue;
                }
                if ("medium".equalsIgnoreCase(spec)) {
                    style = 2;
                    continue;
                }
                if ("long".equalsIgnoreCase(spec)) {
                    style = 1;
                    continue;
                }
                if ("full".equalsIgnoreCase(spec)) {
                    style = 0;
                    continue;
                }
                Log.log.warning((Object)("Unknown style mode: " + attr), new Object[0]);
                continue;
            }
            if ("timezone".equalsIgnoreCase(kind)) {
                timezone = TimeZone.getTimeZone(spec);
                continue;
            }
            if ("locale".equalsIgnoreCase(kind)) {
                String[] specs = (String[])Iterables.toArray((Iterable)Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().split((CharSequence)spec), String.class);
                switch (specs.length) {
                    case 1: {
                        locale = new Locale(specs[0]);
                        break;
                    }
                    case 2: {
                        locale = new Locale(specs[0], specs[1]);
                        break;
                    }
                    case 3: {
                        locale = new Locale(specs[0], specs[1], specs[2]);
                        break;
                    }
                    default: {
                        Log.log.warning((Object)("Too many arguments to locale: " + attr), new Object[0]);
                        break;
                    }
                }
                continue;
            }
            if ("format".equalsIgnoreCase(kind)) {
                format = spec;
                continue;
            }
            Log.log.warning((Object)("Unknown mode attribute: " + attr), new Object[0]);
        }
        this._format = format != null ? new SimpleDateFormat(format, locale) : this.createFormat(style, locale);
        this._format.setTimeZone(timezone);
    }

    protected DateFormat createFormat(int style, Locale locale) {
        return DateFormat.getDateTimeInstance(style, style, locale);
    }

    protected void updateBorder() {
        String title;
        Border b = this.getBorder();
        String string = title = b instanceof TitledBorder ? ((TitledBorder)b).getTitle() : null;
        if (!this._invalid && title != null) {
            this.updateBorder(title);
            return;
        }
        b = null;
        if (this._invalid) {
            b = BorderFactory.createLineBorder(Color.RED, this._highlighted ? 2 : 1);
            if (title != null) {
                b = BorderFactory.createTitledBorder(b, title);
            }
        }
        this.setBorder(b);
    }

    public static class TimeOnlyEditor
    extends DateTimeEditor {
        @Override
        protected DateFormat createFormat(int style, Locale locale) {
            return DateFormat.getTimeInstance(style, locale);
        }
    }

    public static class DateOnlyEditor
    extends DateTimeEditor {
        @Override
        protected DateFormat createFormat(int style, Locale locale) {
            return DateFormat.getDateInstance(style, locale);
        }
    }
}

