/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.MenuItem;
import com.threerings.opengl.gui.PopupWindow;
import com.threerings.opengl.gui.ScrollPane;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.Event;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.layout.GroupLayout;
import com.threerings.opengl.gui.layout.TableLayout;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.util.GlContext;
import java.util.ArrayList;

public class PopupMenu
extends PopupWindow {
    protected int _rows;
    protected int _columns;

    public PopupMenu(GlContext ctx, Window parent) {
        this(ctx, parent, false);
    }

    public PopupMenu(GlContext ctx, Window parent, boolean horizontal) {
        super(ctx, parent, null);
        this.setLayoutManager((horizontal ? GroupLayout.makeHStretch() : GroupLayout.makeVStretch()).setGap(0));
        this._columns = 1;
        this._modal = true;
    }

    public PopupMenu(GlContext ctx, Window parent, int rows, int columns) {
        super(ctx, parent, null);
        this.setPreferredDimensions(rows, columns);
        this._modal = true;
    }

    public void addMenuItem(MenuItem item) {
        this.getItemContainer().add(item, GroupLayout.FIXED);
    }

    public void setPreferredDimensions(int rows, int columns) {
        Container cont;
        columns = Math.max(1, columns);
        if (rows == this._rows && columns == this._columns) {
            return;
        }
        this._rows = rows;
        this._columns = columns;
        ArrayList children = new ArrayList(this._children);
        this.removeAll();
        if (this._rows == 0) {
            cont = this;
        } else {
            this.setLayoutManager(GroupLayout.makeVStretch());
            cont = new Container(this._ctx);
            ScrollPane pane = new ScrollPane(this._ctx, cont);
            this.add(pane);
            pane.setShowScrollbarAlways(false);
        }
        if (this._columns == 1) {
            cont.setLayoutManager(GroupLayout.makeVStretch().setGap(0));
        } else {
            cont.setLayoutManager(new TableLayout(this._columns, 0, 5));
        }
        for (Component child : children) {
            cont.add(child);
        }
    }

    @Override
    public boolean dispatchEvent(Event event) {
        MouseEvent mev;
        if (event instanceof MouseEvent && (mev = (MouseEvent)event).getType() == 0 && this.getHitComponent(mev.getX(), mev.getY()) == null) {
            this.dismiss();
            return true;
        }
        return super.dispatchEvent(event);
    }

    @Override
    protected String getDefaultStyleConfig() {
        return "Default/PopupMenu";
    }

    @Override
    protected void packAndFit(int x, int y, boolean above) {
        int ii;
        ScrollPane pane;
        Container cont;
        int width = this._root.getDisplayWidth();
        int height = this._root.getDisplayHeight();
        if (this._rows != 0 && (cont = (Container)(pane = (ScrollPane)this.getComponent(0)).getChild()).getComponentCount() > this._rows) {
            int theight = 0;
            for (ii = 0; ii < this._rows; ++ii) {
                theight += cont.getComponent((int)ii).getPreferredSize((int)-1, (int)-1).height;
            }
            pane.setPreferredSize(-1, theight);
        }
        ArrayList children = null;
        int columns = this._columns;
        do {
            Dimension d = this.getPreferredSize(-1, -1);
            if (d.height <= height || this._rows != 0) break;
            if (children == null) {
                children = new ArrayList(this._children);
            }
            this.removeAll();
            this.setLayoutManager(new TableLayout(++columns, 0, 5));
            for (ii = 0; ii < children.size(); ++ii) {
                this.add((Component)children.get(ii));
            }
        } while (columns < 4);
        this.pack();
        this.validate();
        this.pack();
        x = Math.min(width - this.getWidth(), x);
        y = above ? Math.min(height - this.getHeight(), y) : Math.max(0, y - this.getHeight());
        this.setLocation(x, y);
    }

    protected Container getItemContainer() {
        return this._rows == 0 ? this : (Container)((ScrollPane)this.getComponent(0)).getChild();
    }

    protected void itemSelected(MenuItem item, long when, int modifiers) {
        this.emitEvent(new ActionEvent(item, when, modifiers, item.getAction(), item.getArgument()));
        this.dismiss();
    }
}

